package jp.co.secioss.SeciossOTP;

import java.security.SecureRandom;
import java.util.Date;

import jp.co.secioss.lib.MD5;
import jp.co.secioss.lib.SeciossOTPCommon;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class SeciossOTPSecretEdit extends Activity {

	private static final int DIALOG_CREATE = 2;

	private SeciossOTPDbAdapter mDbHelper;
    private TextView mSecretLength;
    private EditText mTextAlais;
    private EditText mTextSecret;
    private Button confirmButton;

    private long mRowId;
    private String newSecret;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
    	super.onCreate(savedInstanceState);

        mDbHelper = new SeciossOTPDbAdapter(this);
        mDbHelper.open();

        setContentView(R.layout.seciossotp_secret_edit);

        mSecretLength = (TextView) findViewById(R.id.label_secret_length);
        mSecretLength.setText("0");

        confirmButton = (Button) findViewById(R.id.button_save);
        confirmButton.setEnabled(false);
        confirmButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {
            	newSecret();
            	showDialog(DIALOG_CREATE);
            }
        });

        mTextAlais = (EditText) findViewById(R.id.text_alais);
        mTextSecret = (EditText) findViewById(R.id.text_secret);

        mTextAlais.addTextChangedListener(new TextWatcher() {
			@Override
			public void onTextChanged(CharSequence s, int start, int before, int count) {
				String secret = mTextSecret.getText().toString();
				if(s.length() > 0 && secret.length() == 20){
					confirmButton.setEnabled(true);
				}
				else {
					confirmButton.setEnabled(false);
				}
			}
			@Override
			public void beforeTextChanged(CharSequence s, int start, int count, int after) {
			}
			@Override
			public void afterTextChanged(Editable s) {
			}
		});
        mTextSecret.addTextChangedListener(new TextWatcher() {
			@Override
			public void onTextChanged(CharSequence s, int start, int before, int count) {
				mSecretLength.setText(s.length() > 9 ? "" + s.length() : "0" + s.length());
				String alais = mTextAlais.getText().toString();
				if(alais.length() > 0 && s.length() == 20){
					confirmButton.setEnabled(true);
				}
				else {
					confirmButton.setEnabled(false);
				}
			}
			@Override
			public void beforeTextChanged(CharSequence s, int start, int count, int after) {
			}
			@Override
			public void afterTextChanged(Editable s) {
			}
		});

    	Bundle extras = getIntent().getExtras();
    	mRowId = extras != null ? extras.getLong(SeciossOTPDbAdapter.KEY_ROWID) : -1;
        if (mRowId == -1) {
        	setTitle(R.string.seciossotp_secret_title_new);
        }
        else {
        	setTitle(R.string.seciossotp_secret_title_reset);
        }

        populateFields();
    }

    @Override
    public Dialog onCreateDialog(int id) {
    	AlertDialog dialog = null;
    	AlertDialog.Builder builder = new AlertDialog.Builder(this);
    	switch(id) {
	    	case DIALOG_CREATE:
	    		String message = (String) getResources().getText(R.string.secret_confirm);
	        	builder.setMessage(message + newSecret)
	        	.setCancelable(false)
	        	.setPositiveButton("はい", new DialogInterface.OnClickListener() {
	        		public void onClick(DialogInterface dialog, int id) {
	        			saveState();
	                	setResult(RESULT_OK);
	                    finish();
	        		}
	        	});
	        	dialog = builder.create();
	        break;
    	}
    	return dialog;
    }

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
	}

	@Override
	protected void onPause() {
		super.onPause();
	}

	@Override
	protected void onResume() {
		super.onResume();
		populateFields();
	}

	/**
	 * 
	 */
	private void newSecret() {
		SharedPreferences sf = getSharedPreferences(SeciossOTPTimezone.PREFS_NAME, 0);
		int timez = -12-1 + sf.getInt("poistion", 1);
		String seed = mTextSecret.getText().toString();
		newSecret = "";
		char[] charset = "123456789abcdefhkmnprstuvwxyzABCDEFGHKMNPQRSTUVWXYZ=+[]&@#*!-?%:".toCharArray();
		SecureRandom rand = new SecureRandom();
		seed += ((((new Date()).getTime() / 10000) + ((timez - 12) * 360)) / 6);
		for(int i = 0; i < 100; i++) {
			seed += ""+(rand.nextInt() * 16384);
		}
		char[] vals = SeciossOTPCommon.hexToChar(new MD5(seed).asHex());
		for(int i = 0; i < 16; i++) {
			int j = vals[i] >> 2;
			while(j > 63){
				j -= 64;
			}
			newSecret += charset[j];
		}

		mTextSecret.setText(newSecret);
	}

	/**
	 * 
	 */
	private void saveState() {
		String alais = mTextAlais.getText().toString();
		String secret = mTextSecret.getText().toString();
		if (mRowId == -1) {
			long id = mDbHelper.createSecret(alais, secret);
			if (id > 0) {
				mRowId = id;
			}
		}
		else {
			mDbHelper.updateSecret(mRowId, alais, secret);
		}
	}

	/**
	 * 
	 */
	private void populateFields() {
		if (mRowId != -1) {
			Cursor c = mDbHelper.fetchSecret(mRowId);
			startManagingCursor(c);

			//String strRowid = c.getString(c.getColumnIndexOrThrow(SeciossOTPDbAdapter.KEY_ROWID))+":";
			mTextAlais.setText(c.getString(c.getColumnIndexOrThrow(SeciossOTPDbAdapter.KEY_ALIAS)));
			//mTextSecret.setText(c.getString(c.getColumnIndexOrThrow(SeciossOTPDbAdapter.KEY_SECRET)));
		}
	}

}
