package SeciossOTP;

import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.security.SecureRandom;

/**
 * Padding with random bytes. Note this padding cannot be removed since
 * there is no indication of its length. In practice, this means that any data
 * that gets encrypted and decrypted again using this padding is enlarged
 * to the cypher's block size with trailing garbage. It is useful if you want
 * not to have any indication of whether the decryption was successful
 * (i.e., the passphrase correct) though.
 */
public class RandomPadding implements BlockCipherPadding {
	
	protected SecureRandom rand;

	public void init(SecureRandom random) throws IllegalArgumentException {
		if(random == null)
			rand = new SecureRandom();
		else
			rand = random;
	}

	public String getPaddingName() {
		return "RandomPadding";
	}

	public int addPadding(byte[] in, int inOff) {
        byte code = (byte)(in.length - inOff);

        while (inOff < in.length)
        {
            in[inOff] = (byte) (rand.nextInt() & 0xff);
            inOff++;
        }

        return code;
	}

	public int padCount(byte[] in) throws InvalidCipherTextException {
		return 0;
	}

}
