package jp.co.secioss.SeciossOTP;

import java.util.Date;

import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;

public class SeciossOTPTimezone extends Activity {

	public static final String PREFS_NAME = "SeciossOTPTimezone";
	private Spinner mSpinner;
	private TextView mBodyText;
	private int position;

	@Override
    protected void onCreate(Bundle savedInstanceState) {
    	super.onCreate(savedInstanceState);

    	setContentView(R.layout.seciossotp_timezone);
        setTitle(R.string.seciossotp_timezone_title);

        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(
        		this, R.array.timezone_array, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        mSpinner = (Spinner) findViewById(R.id.spinner_timezone);
        mSpinner.setAdapter(adapter);
        mSpinner.setOnItemSelectedListener(new SeciossOTPTimezoneSelectedListener());

        mBodyText = (TextView) findViewById(R.id.seciossotp_timezone_body);

        Button button_confirm = (Button) findViewById(R.id.button_confirm);
        button_confirm.setOnClickListener(new View.OnClickListener() {
        	public void onClick(View view) {
                setResult(RESULT_OK);
                updateTextView();
                saveState();
            }
        });
	}

    /**
     * タイムゾーン選択リスナー内部クラス
     */
    public class SeciossOTPTimezoneSelectedListener implements OnItemSelectedListener {
    	public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
    		position = pos;
    	}
		public void onNothingSelected(AdapterView<?> parent) {
    		// Do nothing.
    	}
    }

    @Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
	}

	@Override
	protected void onPause() {
		super.onPause();
	}

	@Override
	protected void onResume() {
		super.onResume();
		populateFields();
	}

	/**
	 * 
	 */
	private void saveState() {
		SharedPreferences sf = getSharedPreferences(PREFS_NAME, 0);
		SharedPreferences.Editor editor = sf.edit();
		editor.putInt("poistion", position);
		editor.commit();
	}

	private void populateFields() {
		SharedPreferences sf = getSharedPreferences(PREFS_NAME, 0);
		position = sf.getInt("poistion", 0);
		mSpinner.setSelection(position);
		updateTextView();
	}

	private void updateTextView() {
		String strTimezone = mSpinner.getItemAtPosition(position).toString();
		int tz;
		if (!"+".equals(strTimezone.substring(4,5))) {
			tz = Integer.parseInt(strTimezone.substring(4));
		}
		else {
			tz = Integer.parseInt(strTimezone.substring(5));
		}
		Date now = new Date();
		String epoch = "エポック時間： ";
		epoch = epoch + (((now.getTime() / 10000) + ((tz - 12) * 360)) / 6);
		String strBodyText = "\n\n" + strTimezone + "\n\n" + epoch + "\n";
		mBodyText.setText(strBodyText);
	}

}
