#import "CreateSecret.h"
#import "NewSecret.h"
#import "SecretKey.h"
#import "UserData.h"
#import "NewSecretSwingPage.h"
#import "SecretController.h"
#import "OTPViewController.h"
#import <CommonCrypto/CommonDigest.h>

@implementation CreateSecret

/*
 // The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}
*/


// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
	self.navigationItem.title = @"新しいシークレット";
	//self.navigationItem.hidesBackButton = YES;
	/*UIBarButtonItem *cancelButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"メニュー" style:UIBarButtonItemStyleBordered target:self action:@selector(back)];
    self.navigationItem.leftBarButtonItem = cancelButtonItem;
    [cancelButtonItem release];*/
	UserData *userData = [UserData sharedManager];
	SecretKey *secretKey = nil;
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	BOOL reset = [defaults boolForKey:@"RESETED"];
	if (reset){
		self.title = @"リセットシークレット";
		self.navigationItem.hidesBackButton = YES;
		NSInteger resetedPickerRow = [defaults integerForKey:@"ResetPickerRow"];
		secretKey = [userData getSecretKey:resetedPickerRow];
		aliasText.text = secretKey.Alias;
		[aliasTextLength setText:[NSString stringWithFormat:@"%d",[aliasText.text length]]];
	}else {
		self.navigationItem.hidesBackButton = NO;
		/*UIBarButtonItem *cancelButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"戻る" style:UIBarButtonItemStyleBordered target:self action:@selector(back)];
		self.navigationItem.leftBarButtonItem = cancelButtonItem;
		[cancelButtonItem release];*/
	}

	keyText.delegate = self;
	aliasText.delegate = self;
}


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}

- (void)dealloc {
    [super dealloc];
}

- (IBAction)bAccessAction{	// 登録ボタン処理

	NSString *str1 = [self randomArray:keyText.text];
	//NSLog(@"shuffle: %@", str1);
	str1 = [ str1 substringWithRange:NSMakeRange(0, 16) ];

	keyText.text = str1;
	UserData *userData = [UserData sharedManager];
	SecretKey *secretKey = nil;
	int listCnt = [userData getSecretKeyCount];
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	BOOL reset = [defaults boolForKey:@"RESETED"];
	if ((listCnt == 0)||(reset)){
		stateErrosOrWarning = 1;
		NSString *msg = [[NSString alloc] initWithFormat:@"新しいシークレット\n（１回のみ表示）\n\n %@\n",str1];
		UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"" message:msg delegate:self cancelButtonTitle:@"はい" otherButtonTitles:nil];
		[alert show];     
		[alert release];
		[msg release];
	}else{
		int i = 0;
		do{
			secretKey = [userData getSecretKey:i];
			if(([aliasText.text compare:secretKey.Alias] == NSOrderedSame )&&(secretKey.Key!=@"")){
				compare = TRUE;
				break;
			}else {
				compare = FALSE;
				i++;
			}
		}while (i<listCnt);
		if (i<listCnt){
			stateErrosOrWarning = 0;
			NSString *msg = [[NSString alloc] initWithFormat:@"エイリアスは既に存在しています。"];
			UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"エイリアス入力エラー！" message:msg delegate:self cancelButtonTitle:@"はい" otherButtonTitles:nil];
			[alert show];     
			[alert release];
			[msg release];
		}else{
			stateErrosOrWarning = 1;
			NSString *msg = [[NSString alloc] initWithFormat:@"新しいシークレット\n（１回のみ表示）\n\n %@\n",str1];
			UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"" message:msg delegate:self cancelButtonTitle:@"はい" otherButtonTitles:nil];
			[alert show];     
			[alert release];
			[msg release];
		}
	}
}
- (void) alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
	//dbuttonIndex = [alertView
	SecretKey *secretKey = [SecretKey alloc];
	switch (stateErrosOrWarning) {
		case 0:
			break;
		case 1:// 登録ボタン後の問い合わせダイアログでの「はい」ボタン
			secretKey.Alias = aliasText.text;
			secretKey.Key = keyText.text;
			NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
			BOOL reset = [defaults boolForKey:@"RESETED"];
			UserData *userData = [UserData sharedManager];
			if (reset){
				[userData replaceSecretData:secretKey index:[defaults integerForKey:@"ResetPickerRow"]];
				[defaults setBool:FALSE forKey:@"RESETED"];
			}else{
				[userData addSecretData:secretKey];
				
			}
			[defaults setInteger:[userData getSecretKeyCount] forKey:@"ALIAS_NUMBER"];
			keyText.text = @"";
			aliasText.text = @"";
			//NewSecret *new = [[NewSecret alloc] initWithNibName:@"NewSecret" bundle:nil];
			//SecretController *secretController = [[SecretController alloc] initWithNibName:@"SecretController" bundle:nil];
			
			
			//NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
			[defaults setBool:TRUE forKey:@"NewSecretToBackPage"];
			OTPViewController *otpView = [[OTPViewController alloc] initWithNibName:@"OTPViewController" bundle:nil];
			[self.navigationController pushViewController:otpView animated:NO];
			
			
			/*NSInteger backPage = [defaults integerForKey:@"BackPage"];
			switch (backPage) {
				case 0:
					[self.navigationController pushViewController:new animated:NO];
					break;
				case 1:
					[self.navigationController pushViewController:secretController animated:NO];
					break;
				default:
					break;
			}*/
			break;
		default:
			break;
	}
}
/*- (void)back{
	NewSecret *new = [[NewSecret alloc] initWithNibName:@"NewSecret" bundle:nil];
	SecretController *secretController = [[SecretController alloc] initWithNibName:@"SecretController" bundle:nil];
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults]; 
	NSInteger backPage = [defaults integerForKey:@"BackPage"];
	switch (backPage) {
		case 0:
			[self.navigationController pushViewController:new animated:NO];
			break;
		case 1:
			[self.navigationController pushViewController:secretController animated:NO];
			break;
		default:
			break;
	}
}*/

- (void)enableAccessButton{
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	BOOL resetSelected = [defaults boolForKey:@"RESETED"];
	if (resetSelected){
		if (keyTextInput == TRUE){
			[accessButton setUserInteractionEnabled:YES];
			[accessButton setAlpha:1.0];
		}
	}else{
		if ((keyTextInput == FALSE)||(aliasTextInput == FALSE)){
			[accessButton setUserInteractionEnabled:NO];
			[accessButton setAlpha:0.5];
		}else {
			[accessButton setUserInteractionEnabled:YES];
			[accessButton setAlpha:1.0];
		}
	}
}
- (IBAction)inputtedKeyTextLength{
	[keyTextLength setText:[NSString stringWithFormat:@"%d",[keyText.text length]]];
	if ([keyText.text length] != 20){
		keyTextInput = FALSE;
	}else {
		keyTextInput = TRUE;
	}
	if ([keyText.text length] > 20){
		keyText.text = [keyText.text substringToIndex:20];
	}
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
	[textField resignFirstResponder];
	[self enableAccessButton];
	return YES;
}
- (IBAction)inputtedAliasTextLength{
	[aliasTextLength setText:[NSString stringWithFormat:@"%d",[aliasText.text length]]];
	if (([aliasText.text length] == 0) || ([aliasText.text length] > 12)){
		aliasTextInput = FALSE;
	}else {
		aliasTextInput = TRUE;
	}
	if ([aliasText.text length] > 12){
		
		aliasText.text = [aliasText.text substringToIndex:12];
	}
}

- (NSString *)replaceString:(NSString*)string:(NSInteger)atIndex:(NSString*)reString{
	if (atIndex == 0){
		string = [NSString stringWithFormat:@"%@%@",reString,[string substringFromIndex:atIndex+1]];
	}else 
	if (atIndex == 19){
		string = [NSString stringWithFormat:@"%@%@",[string substringToIndex:atIndex],reString];
	}else{
		string = [NSString stringWithFormat:@"%@%@%@",[string substringToIndex:atIndex],reString,[string substringFromIndex:atIndex+1]];
	}
	return string;
}

- (NSString *)replaceStringIndexToIndex:(NSString*)string:(NSInteger)atIndex:(NSInteger)toIndex{
	char cToIndex = [string characterAtIndex:toIndex];
	char cAtIndex = [string characterAtIndex:atIndex];
	NSString *sToIndex = [NSString stringWithFormat:@"%c",cToIndex];
	NSString *sAtIndex = [NSString stringWithFormat:@"%c",cAtIndex];
	string = [self replaceString:string :atIndex :sToIndex];
	string = [self replaceString:string :toIndex :sAtIndex];
	return string;
}
/*
- (NSString*)shuffleArray:(NSString*)string{
	for (NSInteger i = 0; i < 20; i++) {
		srand(time(nil));
		NSInteger j = rand()%(i+1);
		string = [self replaceStringIndexToIndex:string :i :j];
	}
	NSInteger j;
	NSInteger k;
	NSString * kString;
	NSMutableArray *randArray;
	srand(time(nil));

	randArray = [[NSMutableArray alloc]init];
 */
 /*	j = [self randWithArray:4 array:randArray];
	j = 1;
	[randArray addObject:[NSString stringWithFormat:@"%d",j]];
	j = [self randWithArray:4 array:randArray];
	j = 2;
	[randArray addObject:[NSString stringWithFormat:@"%d",j]];
	j = [self randWithArray:4 array:randArray];
	j = 3;
	[randArray addObject:[NSString stringWithFormat:@"%d",j]];
	j = [self randWithArray:4 array:randArray];
	j = 2;
	j = [self randWithArray:4 array:randArray];
	[randArray addObject:[NSString stringWithFormat:@"%d",j]];
*/	
/*	
	for (int i = 0; i < 5; i++){	
//		j = rand() % 20;
		j = [self randWithArray:20 array:randArray];
		[randArray addObject:[NSString stringWithFormat:@"%d",j]];
		k = rand() % 10;
		kString = [NSString stringWithFormat:@"%d",k];
		string = [self replaceString:string:j:kString];
	}
	[randArray release];
	return string;
}


-(NSInteger)randWithArray:(int)iParam array:(NSArray*)iArray{
	NSInteger j;
//	NSUInteger e;
	for(int i = 0; i < 20; i++){
		srand(time(nil));
		[NSThread sleepUntilDate:[[NSDate date] addTimeInterval:0.1]];	// sleep 0.1 sec
		j = rand() % iParam;
//		if(![self existData:j:iArray]){
//		e = [iArray indexOfObject:[NSString stringWithFormat:@"%d",j]];
		if([iArray indexOfObject:[NSString stringWithFormat:@"%d",j]] >= NSNotFound){
			return j;
		}
	}
	return j;
}
*/
 - (IBAction)keyTextFieldTouch{
	[accessButton setUserInteractionEnabled:NO];
	[accessButton setAlpha:0.5];
}

- (IBAction)aliasTextFieldTouch{
	[accessButton setUserInteractionEnabled:NO];
	[accessButton setAlpha:0.5];
}

- (NSString *)randomArray: (NSString *)string
{
	int i;
	NSString *kString;
	static const char *table[64] = {"1","2","3","4","5","6","7","8","9","a","b","c","d","e",
         "f","h","k","m","n","p","r","s","t","u","v","w","x","y","z","A","B","C","D","E","F",
		 "G","H","K","M","N","P","Q","R","S","T","U","V","W","X","Y","Z","=","+","[","]","&",
		 "@","#","*","!","-","?","%",":"};

//    static const char *table[9] = {"1","2","3","4","5","6","7","8","9"};
	NSString *res = @"";
	int rnd = arc4random() % 999999;
    srand(time(nil));
	int seed = rand() / 10000;
	for (i = 0; i < 100; i++) {
		seed = seed + (rnd + i) * 16384; 
	}
    NSString *seedstr = [NSString stringWithFormat:@"%u", seed];
	string = [NSString stringWithFormat:@"%@%@", string, seedstr];
	NSString *hash = [self MD5String: string];
	NSMutableArray *vals = [self hexToChar: hash];
	for (i = 0; i < 16; i++) {
		NSString *num = [vals objectAtIndex:i];

        int j = [num intValue];

        j = j % 64;
//		j = j % 9;
		kString = [NSString stringWithCString:table[j] encoding:NSUTF8StringEncoding];
		res = [res stringByAppendingString:kString];
    }

	return res;
}

- (NSMutableArray *)hexToChar: (NSString *)hex
{
	int length = hex.length / 2;
    unsigned int dec;
	NSMutableArray *raw = [NSMutableArray array];
	int i;	
	for (i = 0; i < length; i++)
	{
		NSString *hexString = [hex substringWithRange: NSMakeRange(i*2, 2)];
        NSScanner *scan = [NSScanner scannerWithString: hexString];
		if ([scan scanHexInt:&dec]) {
			NSString *decimalString = [NSString stringWithFormat:@"%d",dec];
			[raw insertObject:decimalString atIndex:i];
		}
	}

	return raw;
}
	
- (NSString *)MD5String: (NSString *)string
{
    const char *cStr = [string UTF8String];
    unsigned char md5_result[CC_MD5_DIGEST_LENGTH];
	CC_MD5( cStr, strlen(cStr), md5_result );
    
	NSString *hex_str = [NSString stringWithFormat: @"%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X",
						 md5_result[0], md5_result[1],
						 md5_result[2], md5_result[3],
						 md5_result[4], md5_result[5],
						 md5_result[6], md5_result[7],
						 md5_result[8], md5_result[9],
						 md5_result[10], md5_result[11],
						 md5_result[12], md5_result[13],
						 md5_result[14], md5_result[15]];
	
    return hex_str;
}

/*
- (NSString*)shuffleArray:(NSString*)string{
	for (NSInteger i = 0; i < 20; i++) {
		srand(time(nil));
		NSInteger j = rand()%(i+1);
		string = [self replaceStringIndexToIndex:string :i :j];
	}
	NSInteger j;
	NSInteger k;
	NSString * kString;
	srand(time(nil));
	for (int i = 0; i < 5; i++){	
		j = rand() % 20;
		k = rand() % 10;
		kString = [NSString stringWithFormat:@"%d",k];
		string = [self replaceString:string:j:kString];
	}
	return string;
}
*/


@end
