#import "OTPAlgorithm.h"
#import "Pin.h"
#import <CommonCrypto/CommonHMAC.h>


@implementation OTPAlgorithm

- (id) init
{
	self = [super init];
	return (self);
}

- (NSString*) generateOTP:(NSString*)secret codeDigits:(int)codeDigits
{
	const int DIGITS_POWER[] = {1,10,100,1000,10000,100000,1000000,10000000,100000000};
			
	time_t unixTimeMin = (time_t) [[NSDate date] timeIntervalSince1970];
	unixTimeMin = unixTimeMin / 60;
//	printf("time %d\n",unixTimeMin);

	unsigned char textstr[8];
	for ( int i = sizeof(textstr) - 1; i >= 0; i--){
		textstr[i] = ( unixTimeMin & 0xff );
		unixTimeMin
		>>= 8;
	}
    NSData *clearTextData = [NSData dataWithBytes:&textstr length:sizeof(textstr)];
	//NSLog(@"clearTextData: %@", [clearTextData description]);
	
	uint8_t hash[CC_SHA1_DIGEST_LENGTH] = {0};
		
	int pin = [[Pin sharedInstance] getPin];
	NSString *key = [NSString stringWithFormat: @"%@%08d", secret, pin];
	//NSLog(@"key: ..%s..%d", key.UTF8String, key.length);
	
	CCHmac(kCCHmacAlgSHA1, key.UTF8String, key.length, clearTextData.bytes, clearTextData.length, hash);

	//NSData *out = [NSData dataWithBytes:hash length:CC_SHA1_DIGEST_LENGTH];
	//NSLog(@"hash from nsdata: %@", [out description]);

	int offset = hash[sizeof(hash) - 1] & 0xf;
	
	int binary = ((hash[offset] & 0x7f) << 24)
	| ((hash[offset + 1] & 0xff) << 16)
	| ((hash[offset + 2] & 0xff) << 8)
	| (hash[offset + 3] & 0xff);
	
	int otp = binary % DIGITS_POWER[codeDigits];
	
	NSString* result = [NSString stringWithFormat:@"%0*d", codeDigits, otp];
	
	return result;
}

@end
