/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.cmd;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedCommandLine;
import net.morilib.sed.SedEngine;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedSpace;


public class SedCompositeCommand implements SedCommand {

	//
	private SedCommandLine[] commands;

	public SedCompositeCommand(Collection<SedCommandLine> commands) {
		this.commands = commands.toArray(new SedCommandLine[0]);
	}

	public SedCompositeCommand(SedCommandLine... commands) {
		this(Arrays.asList(commands));
	}

	@Override
	public String getLongDescription() {
		return "composite command";
	}

	@Override
	public char getName() {
		return '{';
	}

	@Override
	public void process(SedSpace s, SedLineBuffer rd) throws IOException {
		s.setNextLabel(SedEngine.execute(this, s, rd, commands));
	}

	public SedCommandLine[] getCommandLines() {
		SedCommandLine[] l = new SedCommandLine[commands.length];

		System.arraycopy(commands, 0, l, 0, l.length);
		return l;
	}

	public int hashCode() {
		return Arrays.hashCode(commands);
	}

	public boolean equals(Object o) {
		if(o instanceof SedACommand) {
			return Arrays.equals(
					commands, ((SedCompositeCommand)o).commands);
		}
		return false;
	}

	public String toString() {
		StringBuffer b = new StringBuffer();

		b.append("{\n");
		for(SedCommandLine s : commands) {
			b.append(s).append('\n');
		}
		return b.append('}').toString();
	}

}
