/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.cmd;

import java.io.IOException;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedQuitException;
import net.morilib.sed.SedSpace;


public class SedQCommand implements SedCommand {

	//
	private int exitCode;

	public SedQCommand(int exitCode) {
		this.exitCode = exitCode;
	}

	@Override
	public String getLongDescription() {
		return "Quit";
	}

	@Override
	public char getName() {
		return 'q';
	}

	@Override
	public void process(SedSpace s,
			SedLineBuffer rd) throws IOException {
		throw new SedQuitException(exitCode);
	}

	public int getExitCode() {
		return exitCode;
	}

	public int hashCode() {
		return exitCode;
	}

	public boolean equals(Object o) {
		if(o instanceof SedQCommand) {
			return exitCode == ((SedQCommand)o).exitCode;
		}
		return false;
	}

	public String toString() {
		return "q" + (exitCode < 0 ? "" : Integer.valueOf(exitCode));
	}

}
