/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.cmd;

import java.io.IOException;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedSpace;
import net.morilib.sed.SedSubstituteFlags;


public class SedSCommand implements SedCommand {

	private String pattern, replace;
	private SedSubstituteFlags flags;

	public SedSCommand(String pattern, String replace,
			SedSubstituteFlags flags) {
		this.pattern = pattern;
		this.replace = replace;
		this.flags   = flags;
	}

	@Override
	public String getLongDescription() {
		return "Substitute";
	}

	@Override
	public char getName() {
		return 's';
	}

	@Override
	public void process(SedSpace s, SedLineBuffer rd) throws IOException {
		s.substitute(pattern, replace, flags);
	}

	public String getPattern() {
		return pattern;
	}

	public String getReplace() {
		return replace;
	}

	public SedSubstituteFlags getFlags() {
		return flags;
	}

	public int hashCode() {
		return ((pattern.hashCode() * 17 + replace.hashCode()) * 17 +
				flags.hashCode());
	}

	public boolean equals(Object o) {
		if(o instanceof SedSCommand) {
			return (pattern.equals(((SedSCommand)o).pattern) &&
					replace.equals(((SedSCommand)o).replace) &&
					flags.equals(((SedSCommand)o).flags));
		}
		return false;
	}

	public String toString() {
		return "s/" + pattern + "/" + replace + "/" + flags;
	}

}
