/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.parser;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.List;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedCommandLine;
import net.morilib.sed.SedCommandParser;
import net.morilib.sed.SedLineOption;
import net.morilib.sed.SedParser;
import net.morilib.sed.SedSyntaxException;
import net.morilib.sed.cmd.SedCompositeCommand;


public class SedCompositeParser implements SedCommandParser {

	private int skipws(PushbackReader rd) throws IOException {
		int c;

		while((c = rd.read()) >= 0 && Character.isWhitespace(c));
		return c;
	}

	@Override
	public SedCommand parse(PushbackReader rd,
			SedLineOption l) throws IOException {
		List<SedCommandLine> d = new ArrayList<SedCommandLine>();
		int c;

		while((c = skipws(rd)) != '}') {
			if(c < 0)  throw new SedSyntaxException();
			rd.unread(c);
			d.add(SedParser.parseLine(rd));
			if((c = rd.read()) == '}') {
				return new SedCompositeCommand(d);
			} else if(c != '\n' && c != ';') {
				throw new SedSyntaxException((char)c + "");
			}
		}
		return new SedCompositeCommand(d);
	}

}
