/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed;

import net.morilib.sed.Tr;
import junit.framework.TestCase;

public class TrTest extends TestCase {

	static void eqi(int x, int y) {
		assertEquals(x, y);
	}

	static void eqs(String x, String y) {
		assertEquals(x, y);
	}

	public void testLength() {
		eqi(Tr.length("abc"), 3);
		eqi(Tr.length("a-c"), 3);
		eqi(Tr.length("a-z"), 26);
		eqi(Tr.length("a-cx-z"), 6);
		eqi(Tr.length("x-za-c"), 6);
		eqi(Tr.length("abcx-z"), 6);
	}

	public void testIndexOf() {
		eqi(Tr.indexOf("abc", 'a'), 0);
		eqi(Tr.indexOf("abc", 'b'), 1);
		eqi(Tr.indexOf("abc", 'c'), 2);
		eqi(Tr.indexOf("a-c", 'a'), 0);
		eqi(Tr.indexOf("a-c", 'b'), 1);
		eqi(Tr.indexOf("a-c", 'c'), 2);
		eqi(Tr.indexOf("a-z", 'a'), 0);
		eqi(Tr.indexOf("a-z", 'z'), 25);
		eqi(Tr.indexOf("a-cx-z", 'x'), 3);
		eqi(Tr.indexOf("x-za-c", 'a'), 3);
		eqi(Tr.indexOf("abcx-z", 'z'), 5);
	}

	public void testCodePointAt() {
		eqi(Tr.codePointAt("abc", 0), 'a');
		eqi(Tr.codePointAt("abc", 1), 'b');
		eqi(Tr.codePointAt("abc", 2), 'c');
		eqi(Tr.codePointAt("a-c", 0), 'a');
		eqi(Tr.codePointAt("a-c", 1), 'b');
		eqi(Tr.codePointAt("a-c", 2), 'c');
		eqi(Tr.codePointAt("a-z", 0), 'a');
		eqi(Tr.codePointAt("a-z", 25), 'z');
		eqi(Tr.codePointAt("a-cx-z", 3), 'x');
		eqi(Tr.codePointAt("x-za-c", 3), 'a');
		eqi(Tr.codePointAt("abcx-z", 5), 'z');
	}

	public void testTrI() {
		eqi(Tr.tr("abc", "xyz", 'a'), 'x');
		eqi(Tr.tr("abc", "xyz", 'b'), 'y');
		eqi(Tr.tr("abc", "xyz", 'c'), 'z');
		eqi(Tr.tr("abc", "xyz", 'd'), 'd');
		eqi(Tr.tr("a-c", "x-z", 'a'), 'x');
		eqi(Tr.tr("a-c", "x-z", 'b'), 'y');
		eqi(Tr.tr("a-c", "x-z", 'c'), 'z');
		eqi(Tr.tr("a-c", "x-z", 'd'), 'd');
	}

	public void testTrS() {
		eqs(Tr.tr("a-zA-Z", "A-Za-z",
				"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0"),
				"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0");
		eqs(Tr.tr("a-zA-X", "A-Za-z",
				"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0"),
				"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxYZ0");
		eqs(Tr.tr("a-zA-Z", "A-Za-x",
				"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0"),
				"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxxx0");
	}

}
