﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

#include <string>

namespace bearmini
{
    ///
    ///  [ファイル名別動作] の情報を保持する構造体
    ///
    struct BehaviorSetting
    {
        /// ポップアップメニューに表示する説明文字列
        std::wstring caption;

        /// 実行するコマンドライン
        std::wstring command_line;

        /// 自動実行するかどうか
        bool auto_exec;

        BehaviorSetting() :
            caption(L""),
            command_line(L""),
            auto_exec(false)
        {
        }

        BehaviorSetting(const std::wstring& caption, const std::wstring& command_line, bool auto_exec) :
            caption(caption),
            command_line(command_line),
            auto_exec(auto_exec)
        {
        }
    };

}