﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

#include "Foundation.h"
#include "Program.h"

namespace bearmini
{
    // MessageBox.Show() の戻り値
    enum DialogResult
    {
        DialogResult_Abort = IDABORT,
        DialogResult_Cancel = IDCANCEL,
        DialogResult_Continue = IDCONTINUE,
        DialogResult_Ignore = IDIGNORE,
        DialogResult_No = IDNO,
        DialogResult_OK = IDOK,
        DialogResult_Retry = IDRETRY,
        DialogResult_TryAgain = IDTRYAGAIN,
        DialogResult_Yes = IDYES,
    };

    // MessageBox の種別
    enum MessageBoxType
    {
        //MB_ABORTRETRYIGNORE
        //MB_CANCELTRYCONTINUE
        //MB_HELP
        MessageBoxType_OK = MB_OK,
        MessageBoxType_OKCancel = MB_OKCANCEL,
        //MB_RETRYCANCEL
        MessageBoxType_YesNo = MB_YESNO,
        MessageBoxType_YesNoCancel = MB_YESNOCANCEL,

        //MB_ICONEXCLAMATION
        //MB_ICONWARNING
        //MB_ICONINFORMATION
        //MB_ICONASTERISK
        //MB_ICONQUESTION
        //MB_ICONSTOP
        //MB_ICONERROR
        //MB_ICONHAND
        //MB_DEFBUTTON1
        //MB_DEFBUTTON2
        //MB_DEFBUTTON3
        //MB_DEFBUTTON4
        //MB_APPLMODAL
        //MB_SYSTEMMODAL
        //MB_TASKMODAL
        //MB_DEFAULT_DESKTOP_ONLY
        //MB_RIGHT
        //MB_RTLREADING
        //MB_SETFOREGROUND
        //MB_TOPMOST
        //MB_SERVICE_NOTIFICATION
        //MB_SERVICE_NOTIFICATION_NT3X
    };

    class MessageBox
    {
    public:
        static void Show(const std::string& message);
        static void Show(const std::wstring& message);
        static void Show(const Program* p, const std::wstring& message);
        static DialogResult Show(const Program* p, const std::wstring& message, const MessageBoxType type);

    private:
        MessageBox() {};
        ~MessageBox() {};
    };

}