/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/
#pragma once

#include "Foundation.h"


class PrevilegeChecker
{
public:

    static bool IsAdminProcess(HANDLE hProcess)
    {
        ::PSID m_pAdministratorsGroupSid = 0;
        ::SID_IDENTIFIER_AUTHORITY authority = SECURITY_NT_AUTHORITY;
        ::HANDLE hToken = 0;
        ::HANDLE hTokenDup = 0;
        ::BOOL isMember = FALSE;

        try
        {
            ::BOOL ok = ::AllocateAndInitializeSid(&authority, 2, SECURITY_BUILTIN_DOMAIN_RID, DOMAIN_ALIAS_RID_ADMINS, 0, 0, 0, 0, 0, 0, &m_pAdministratorsGroupSid); 
            if (!ok)
            {
                throw std::exception();
            }

            ok = ::OpenProcessToken(hProcess, TOKEN_QUERY|TOKEN_DUPLICATE|TOKEN_ASSIGN_PRIMARY, &hToken);
            if (!ok)
            {
                throw std::exception();
            }
            
            ok = ::DuplicateTokenEx(hToken, 0, 0, SecurityImpersonation, TokenImpersonation, &hTokenDup);
            if (!ok)
            {
                throw std::exception();
            }

            ok = ::CheckTokenMembership(hTokenDup, m_pAdministratorsGroupSid, &isMember);
            if (!ok) 
            {
                throw std::exception();
            }
        }
        catch (...)
        {
            ::CloseHandle(hTokenDup);
            ::CloseHandle(hToken);
            ::FreeSid(m_pAdministratorsGroupSid); 
            throw;
        }
        
        ::CloseHandle(hTokenDup);
        ::CloseHandle(hToken);
        ::FreeSid(m_pAdministratorsGroupSid); 

        return BOOL2bool(isMember);
    }

};

