﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

#include "Foundation.h"


namespace bearmini
{
    ///
    ///  ポップアップメニューを表示するためのクラスです。
    ///
    class PopupMenu
    {
    public:
        explicit PopupMenu(::HWND hwndParent);
        virtual ~PopupMenu() throw();

        void AppendItem(int id, const std::wstring& caption);
        void AppendCheckedItem(int id, const std::wstring& caption);
        void AppendItem(int id, const std::wstring& caption, ::HBITMAP hbmp);
        int Show();

    private:
        int PopupMenu::GetItemCount();

    private:
        ::HWND  m_hwndParent;
        ::HMENU m_hMenu;

    };

}
