/*
  Copyright 2007,2008 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#include "RegistryKey.h"

#include "FixedLengthArray.h"


namespace bearmini
{
    ///
    ///  RXgN^
    ///  w肳ꂽÕL[J܂B
    ///
    RegistryKey::RegistryKey(::HKEY rootKey, const std::wstring& subKeyName, ::REGSAM desiredAccess) :
        m_hKey(0)
    {
        ::LONG result = ::RegOpenKeyEx(rootKey, subKeyName.c_str(), 0, desiredAccess, &m_hKey);
        if (result != ERROR_SUCCESS)
        {
            ::DWORD errorCode = ::GetLastError();
            std::stringstream ss;
            ss << "RegOpenKeyEx() failed." << std::endl << "Error Code: " << errorCode;
            throw std::domain_error(ss.str().c_str());
        }
    }


    ///
    ///  fXgN^
    ///  RXgN^ŊJL[̃nh܂B
    ///
    RegistryKey::~RegistryKey() throw()
    {
        ::RegCloseKey(m_hKey);
    }

    
    ///
    ///  ̃WXgL[Aw肳ꂽO̒l擾܂Bi^j
    ///
    std::wstring RegistryKey::GetValueString(const std::wstring& valueName) const
    {
        ::DWORD type = 0;
        ::DWORD size = 0;

        ::LONG result = ::RegQueryValueExW(m_hKey, valueName.c_str(), 0, &type, 0, &size);
        if (result != ERROR_SUCCESS)
        {
            throw std::domain_error("RegQueryValueEx() (to query size of the value) failed.");
        }

        FixedLengthArray<wchar_t> buf(size + 1, L'\0');

        result = ::RegQueryValueExW(m_hKey, valueName.c_str(), 0, &type, (LPBYTE)buf.get(), &size);
        if (result != ERROR_SUCCESS)
        {
            throw std::domain_error("RegQueryValueEx() (to query the value) failed.");
        }

        if (type != REG_SZ)
        {
            throw std::domain_error("Invalid registry subkey type.");
        }

        return buf.get();
    }

}
