﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

// private headers
#include "BehaviorSettingsCollection.h"
#include "Foundation.h"


namespace bearmini
{
    ///
    ///  設定情報を INI ファイルからロードして保持しておくためのクラスです。
    ///
    class SettingRepository
    {
    public:
        static std::wstring GetCmdExeOption() { return m_strCmdExeOption; }
        static std::wstring GetCygwinRootDir() { return m_strCygwinRootDir; }
        static std::wstring GetCygwinLauncher() { return m_strCygwinLauncher; }
        static std::wstring GetCygwinChangeDirCommand() { return m_strCygwinChangeDirCommand; }
        static BehaviorSettingsCollection GetBehaviorSettings() { return m_allBehaviorSettings; };

        static unsigned int GetMaxSimultaneous() { return m_nMaxSimultaneous; }
    

        static void Load();

    private:
        static void loadBehaviorSettings();
        static BehaviorSettingsForPattern getBehaviorSettingsForPattern(const std::wstring& pattern);
        static BehaviorSetting getOneBehaviorSetting(const std::wstring& sectionName, const std::wstring& pattern);
        static bool isSectionReference(const std::wstring& str);
        static std::wstring SettingRepository::unbracket(const std::wstring& str);

    private:
        static std::wstring m_strCmdExeOption;
        static std::wstring m_strCygwinRootDir;
        static std::wstring m_strCygwinLauncher;
        static std::wstring m_strCygwinChangeDirCommand;
        
        static BehaviorSettingsCollection m_allBehaviorSettings;

        static unsigned int m_nMaxSimultaneous;
    };

}
