/*
 * Copyright(C) 2008 Tetsuro IKEDA <ikdttr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

/**
 * senna.log management
 */
public class SennaLogger {
    /**
     * <pre>
     *  open log file with below values.
     *  path: senna.log
     *  level: sen_log_notice
     * </pre>
     *
     * @throws SennaException
     */
    public static void open() throws SennaException {
	open("senna.log", Senna.SEN_LOG_NOTICE);
    }

    /**
     * open log file.
     *
     * @param path log file path
     * @param level log level
     * @throws SennaException
     */
    public static native void open(String path, int level) throws SennaException;

    /**
     * close log file.
     *
     * @throws SennaException
     */
    public static native void close() throws SennaException;

    /**
     * get current log level.
     *
     * @return current log level
     * @throws SennaException
     */
    public static native int getLevel() throws SennaException;

    /**
     * set log level.
     *
     * @param level log level
     * @throws SennaException
     */
    public static native void setLevel(int level) throws SennaException;

    /**
     * write log with level.
     *
     * @param level log level
     * @param message log message
     * @throws SennaException
     */
    public static native void write(int level, String message) throws SennaException;
}
