package noguchi.SentenceLearner;

import java.util.List;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class QuestionListAdapter extends ArrayAdapter<QuestionItem>{
	private LayoutInflater mInflater;
	private TextView mQuestion;
	private TextView mSound;
	private TextView mQuestionStartTime;
	private TextView mAnswerStartTime;
	private TextView mEndTime;
	
	private QuestionListListener questionListListener;
		
	public QuestionListAdapter(Context context, List<QuestionItem> objects, QuestionListListener questionListListener) {
		super(context, 0, objects);
		mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		this.questionListListener = questionListListener;
	}
	public View getView(final int position, View convertView, ViewGroup parent) {
				
		if (convertView == null) {
			convertView = mInflater.inflate(R.layout.questionlistrow, null);
		}
		
		final QuestionItem item = this.getItem(position);
		
		if(item != null){
			mQuestion = (TextView)convertView.findViewById(R.id.QuestionName);
			mSound = (TextView)convertView.findViewById(R.id.SoundName);
			mQuestionStartTime = (TextView)convertView.findViewById(R.id.QuestionStartTime);
			mAnswerStartTime = (TextView)convertView.findViewById(R.id.AnswerStartTime);
			mEndTime = (TextView)convertView.findViewById(R.id.EndTime);

			mQuestion.setText(item.getName());
			String s = item.getSoundName();
			if (s.length() > 10)
			{
				s = s.substring(0,10) + "...";
			}
			mSound.setText(s);
			
			mQuestionStartTime.setText(QuestionItem.GetTimeString(item.getQuestionStartTime()));
			mAnswerStartTime.setText(QuestionItem.GetTimeString(item.getAnswerStartTime()));
			mEndTime.setText(QuestionItem.GetTimeString(item.getEndTime()));

			mQuestion.setOnClickListener(new QuestionSelectedListener(item, questionListListener));
		}
		return convertView;
	}
}

class QuestionSelectedListener implements OnClickListener
{
	private QuestionListListener questionListListener;
	private QuestionItem item;

	public QuestionSelectedListener(QuestionItem item, QuestionListListener questionListListener){
		this.item = item;
		this.questionListListener = questionListListener;
	}
	@Override
	public void onClick(View v) {
		questionListListener.OnQuestionListClick(item);
	}
}
