package noguchi.SentenceLearner;

import java.util.ArrayList;
import java.util.List;
import android.app.Activity;
import android.content.ContentResolver;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.provider.MediaStore;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.ListView;
import android.widget.Toast;
import android.widget.ViewFlipper;

public class SoundSelector extends Activity 
	implements CheckedListListener {

	AlbumItem selectedAlbum;
	boolean selectAllSounds = false;
	boolean selectAllAlbums = false;
	
	// DB object
	private DatabaseHelper helper;
	private SQLiteDatabase db;
	
	// GUI components
	private ViewFlipper viewFlipper;
	private ListView soundList;
	private ListView albumList;
	private Button toggleAllAlbum;
	private Button toggleAllSound;
	private Button importAlbum;
	private Button importSound;
	
	// For Animation 
	private static final Animation inFromLeft = AnimationHelper.inFromLeftAnimation();
	private static final Animation outToRight = AnimationHelper.outToRightAnimation();
	private static final Animation inFromRight = AnimationHelper.inFromRightAnimation();
	private static final Animation outToLeft = AnimationHelper.outToLeftAnimation();
	private boolean isSoundScreen = false;
		
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.soundselector);
		
		// Initialize database object
		helper = new DatabaseHelper(this);
		db = helper.getReadableDatabase();
		
		// Create GUI component objects
		viewFlipper = (ViewFlipper)findViewById(R.id.ViewFlipper);
		albumList = (ListView)findViewById(R.id.AlbumListView);
		soundList = (ListView)findViewById(R.id.SoundListView);
		
		toggleAllAlbum = (Button)findViewById(R.id.btn1);
		toggleAllSound = (Button)findViewById(R.id.btn3);
		importAlbum = (Button)findViewById(R.id.btn2);
		importSound = (Button)findViewById(R.id.btn4);
				
		generateAlbumList();
		
		// Register listener
		toggleAllAlbum.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View v) {
				selectAllAlbums = (selectAllAlbums == false);
				generateAlbumList();
			}
		});
		toggleAllSound.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View v) {
				selectAllSounds = (selectAllSounds == false);
				generateSoundList(selectedAlbum);
			}
		});
		importAlbum.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				selectSoundsInAlbum();
			}
			
		});
		importSound.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View arg0) {
				selectSounds();
			}
		});
	}
		
	public void moveBackToAlbumScreen(){
		viewFlipper.setInAnimation(inFromLeft);
		viewFlipper.setOutAnimation(outToRight);
		viewFlipper.showPrevious();	
		isSoundScreen = false;
	}
	
	private void generateSoundList(AlbumItem album){
		try {
			List<ListItem> list = new ArrayList<ListItem>();
			
			ContentResolver resolver = getApplicationContext().getContentResolver();
			Cursor managedCursor = resolver.query(
					MediaStore.Audio.Media.EXTERNAL_CONTENT_URI
					,null
					,MediaStore.Audio.Albums.ALBUM_ID + "=?"
					,new String[]{album.getAlbumId()}
					,null
			);
			
			if (managedCursor != null){
		        while( managedCursor.moveToNext() ){
		        	
		        	SoundItem item = new SoundItem();
		        	
		        	int soundNameIndex = managedCursor.getColumnIndexOrThrow(MediaStore.Audio.Media.TITLE);
		        	String soundName = managedCursor.getString(soundNameIndex);
		        	item.setName(soundName);
		        	
		        	int fileNameIndex = managedCursor.getColumnIndexOrThrow(MediaStore.Audio.Media.DATA);
		        	String fileName = managedCursor.getString(fileNameIndex);
		        	item.setFileName(fileName);
		        	
		        	list.add(item);
		        }
			}
			
			CheckedListAdapter sounds = new CheckedListAdapter(getApplicationContext(),list, selectAllSounds, this);
			soundList.setAdapter(sounds);	
		}
		catch (Exception ex)
		{
			Toast.makeText(SoundSelector.this, getResources().getString(R.string.getSoundFailed), Toast.LENGTH_SHORT).show();			
		}		
	}
	
	private void generateAlbumList()
	{
		try {
		
			List<ListItem> list = new ArrayList<ListItem>();
			
			ContentResolver resolver = getApplicationContext().getContentResolver();
			Cursor managedCursor = resolver.query(
					MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI
					,null
					,null
					,null
					,null
			);
			
			if (managedCursor != null){
		        while( managedCursor.moveToNext() ){
		        	
		        	AlbumItem item = new AlbumItem();
		        	
		        	int albumIdIndex = managedCursor.getColumnIndexOrThrow(MediaStore.Audio.Media._ID);
		        	String albumId = managedCursor.getString(albumIdIndex);
		        	item.setAlbumId(albumId);
		        	
		        	int albumIndex = managedCursor.getColumnIndexOrThrow(MediaStore.Audio.Media.ALBUM);
		        	String albumName = managedCursor.getString(albumIndex);
		        	item.setName(albumName);
		        	
		        	list.add(item);
		        }
			}
	
			CheckedListAdapter albums = new CheckedListAdapter(getApplicationContext(),list, selectAllAlbums, this);
			albumList.setAdapter(albums);
		}
		catch (Exception ex)
		{
			Toast.makeText(SoundSelector.this, getResources().getString(R.string.getAlbumFailed), Toast.LENGTH_SHORT).show();
		}
	}
	
	private void selectSounds()
	{
		List<SoundItem> list = new ArrayList<SoundItem>();
		
		try {
			for (int i = 0 ; i < soundList.getCount() ; i++)
			{
				SoundItem item = (SoundItem)soundList.getItemAtPosition(i);
				if (item.isChecked())
				{
					//Log.d("TEST",item.getName());
					list.add(item);
				}
			}
			helper.insertSounds(list, db);
			setResult(RESULT_OK);
			finish();
		}
		catch (Exception ex){
			Toast.makeText(SoundSelector.this, getResources().getString(R.string.getSoundFailed), Toast.LENGTH_SHORT).show();
			finish();
		}
	}
		
	private void selectSoundsInAlbum()
	{
		try {

			List<SoundItem> list = new ArrayList<SoundItem>();

			for (int i = 0 ; i < albumList.getCount() ; i++)
			{
				AlbumItem album = (AlbumItem)albumList.getItemAtPosition(i);
				if (album.isChecked())
				{
					ContentResolver resolver = getApplicationContext().getContentResolver();
					Cursor managedCursor = resolver.query(
							MediaStore.Audio.Media.EXTERNAL_CONTENT_URI
							,null
							,MediaStore.Audio.Albums.ALBUM_ID + "=? "
							,new String[]{album.getAlbumId()}
							,null
					);

					if (managedCursor != null){
						while( managedCursor.moveToNext() ){

							SoundItem item = new SoundItem();

							int soundNameIndex = managedCursor.getColumnIndexOrThrow(MediaStore.Audio.Media.TITLE);
							String soundName = managedCursor.getString(soundNameIndex);
							item.setName(soundName);

							int fileNameIndex = managedCursor.getColumnIndexOrThrow(MediaStore.Audio.Media.DATA);
							String fileName = managedCursor.getString(fileNameIndex);
							item.setFileName(fileName);

							list.add(item);
							//Log.d("TEST",item.getName());
						}
					}
				}
			}
			helper.insertSounds(list, db);
			setResult(RESULT_OK);
			finish();
		}
		catch (Exception ex){
			Toast.makeText(SoundSelector.this, getResources().getString(R.string.getSoundFailed), Toast.LENGTH_SHORT).show();
			finish();
		}
	}
	
	@Override
	public boolean dispatchKeyEvent(KeyEvent e){
		if (e.getKeyCode() == KeyEvent.KEYCODE_BACK && isSoundScreen){
			if (e.getAction() == KeyEvent.ACTION_DOWN){
				moveBackToAlbumScreen();
				return false;
			}
			return true;
		}
		return super.dispatchKeyEvent(e);
	}

	@Override
	public void OnCheckedListClick(ListItem item) {
		
		// TODO Identify if the ListItem is AlbumItem or not
		//if (typeof(item) == class.AlbumItem)
		//
		{
			selectedAlbum = (AlbumItem)item;
			selectAllSounds = false;
	    	generateSoundList((AlbumItem)item);    	
			viewFlipper.setInAnimation(inFromRight);
			viewFlipper.setOutAnimation(outToLeft);
			viewFlipper.showNext();
			isSoundScreen = true;
		}
	}
}



