#include "stdafx.h"

#include "CommOpenFileName.h"

#include <vector>

HRESULT CommonDialogUtil::CommOpenFileName(BOOL bOpenFileMode, VARIANT defaultName, VARIANT filter, VARIANT defaultDir, VARIANT *pSelectedFilePath) throw()
{
	if (!pSelectedFilePath) {
		return E_POINTER;
	}
	VariantInit(pSelectedFilePath);
	pSelectedFilePath->vt = VT_NULL;

	// ftHgw肳Ăꍇ
	CComBSTR strDefaultName;
	if (!IsNullOrError(&defaultName)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &defaultName, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		strDefaultName.Attach(tmp.bstrVal);
	}

	// tB^w肳Ăꍇ
	CComBSTR joinedFilter;
	CComBSTR baseFilter;
	if (!IsNullOrError(&filter)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &filter, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		baseFilter.Attach(tmp.bstrVal);
	}

	// uׂẴt@Cvp̃tB^
	CComBSTR filterAllFilter;
	filterAllFilter.LoadString(IDS_FILTER_ALLFILES);

	int lenBaseFilter = baseFilter.Length();
	int lenAllFilter = filterAllFilter.Length();

	std::vector<OLECHAR> buf(lenBaseFilter + lenAllFilter + 3); // uׂāv̐ڑp؂ƃ_ukI[p+3
	OLECHAR *p = &buf[0];

	if (lenBaseFilter > 0) {
		for (int idx = 0; idx < lenBaseFilter; idx++) {
			OLECHAR c = baseFilter[idx];
			if (c == '|') {
				c = 0;
			}
			*p++ = c;
		}
		*p++ = 0;
	}
	if (lenAllFilter > 0) {
		for (int idx = 0; idx < lenAllFilter; idx++) {
			OLECHAR c = filterAllFilter[idx];
			if (c == '|') {
				c = 0;
			}
			*p++ = c;
		}
	}
	*p++ = 0;
	*p++ = 0;

	joinedFilter.Attach(SysAllocStringLen(&buf[0], static_cast<int>(buf.size())));

	// ftHggqAtB^̍ŏ̊gq瓾
	CComBSTR defExt;
	if (joinedFilter.Length() > 0) {
		LPCWSTR p = joinedFilter;
		while (*p++);
		if (*p) {
			while (*p && *p != '.') p++;
			if (*p == '.') {
				if (wcschr(p, '*') == NULL && wcschr(p, '?') == NULL && wcschr(p, ';') == NULL) {
					// PꊎgqɃChJ[h܂܂ĂȂꍇ̂݃ftHgƂėL
					defExt = p + 1;
				}
			}
		}
	}

	// ftHgfBNgw肳Ăꍇ
	CComBSTR strDefaultDir;
	if (!IsNullOrError(&defaultDir)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &defaultDir, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		strDefaultDir.Attach(tmp.bstrVal);
	}

	TCHAR name[MAX_PATH] = {0};
	if (strDefaultName.Length() > 0) {
		lstrcpy(name, strDefaultName);
	}

	OPENFILENAME ofn = {0};
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = ::GetActiveWindow();
	if (joinedFilter.Length() > 0) {
		ofn.lpstrFilter = joinedFilter;
	}
	ofn.lpstrFile = name;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_ENABLESIZING | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	if (defExt.Length() > 0) {
		ofn.lpstrDefExt = defExt;
	}
	if (strDefaultDir.Length() > 0) {
		ofn.lpstrInitialDir = strDefaultDir;
	}

	BOOL ret;
	if (bOpenFileMode) {
		ret = ::GetOpenFileName(&ofn);
	} else {
		ret = ::GetSaveFileName(&ofn);
	}

	if (ret) {
		pSelectedFilePath->vt = VT_BSTR;
		pSelectedFilePath->bstrVal = SysAllocString(ofn.lpstrFile);
		return S_OK;
	}
	return S_FALSE;
}

namespace // O(̃\[X̂ݗL)
{
	// tH_I_CAÕR[obN֐
	int CALLBACK BrowseCallbackProc(HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
	{
		switch(uMsg)
		{
		case BFFM_INITIALIZED :
			if (lpData) {
				SendMessage(hwnd, BFFM_SETSELECTION, TRUE, lpData);
			}
			break;

		case BFFM_SELCHANGED :
			{
				LPITEMIDLIST pidl = reinterpret_cast<LPITEMIDLIST>(lParam);
				BOOL enabled = FALSE;
				if (pidl) {
					TCHAR tmp[MAX_PATH];
					if (SHGetPathFromIDList(pidl, tmp)) {
						enabled = TRUE;
					}
				}
				SendMessage(hwnd, BFFM_ENABLEOK, 0, enabled);
			}
			break;

		case BFFM_VALIDATEFAILED :
			break;

		default:
			break;
		}

		return 0;
	}
}

HRESULT CommonDialogUtil::BrowseForFolder(VARIANT initdir, VARIANT* pSelectedDir) throw()
{
	if (!pSelectedDir) {
		return E_POINTER;
	}
	VariantInit(pSelectedDir);
	pSelectedDir->vt = VT_NULL;

	// IfBNg̎w
	CComBSTR strInitDir;
	if (!IsNullOrError(&initdir)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &initdir, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		strInitDir.Attach(tmp.bstrVal);
	}
	if (strInitDir.Length() == 0) {
		// wȂƂ̓JgfBNgƂ
		TCHAR curdir[MAX_PATH];
		GetCurrentDirectory(MAX_PATH, curdir);
		strInitDir = curdir;
	}

	// VF̃AP[^
	CComPtr<IMalloc> pMalloc(NULL);
	HRESULT hr;
	if (FAILED(hr = SHGetMalloc(&pMalloc))) {
		return hr;
	}

	// tH_I_CAO

	TCHAR buf[MAX_PATH];
	BROWSEINFO binfo = {0};
	binfo.hwndOwner = NULL;
	binfo.pidlRoot = NULL;
	binfo.pszDisplayName = buf;
	binfo.lpszTitle = NULL;
	binfo.ulFlags = BIF_RETURNONLYFSDIRS | BIF_NEWDIALOGSTYLE | BIF_SHAREABLE;
	binfo.lpfn = BrowseCallbackProc;
	binfo.lParam = reinterpret_cast<LPARAM>(static_cast<LPCWSTR>(strInitDir));

	CComBSTR seldir;
	LPITEMIDLIST pidlist = SHBrowseForFolder(&binfo);
	if (pidlist) {
		TCHAR path[MAX_PATH];
		if (SHGetPathFromIDList(pidlist, path)) {
			seldir = path;
		}
		pMalloc->Free(pidlist);
	}


	if (seldir.Length() > 0) {
		pSelectedDir->vt = VT_BSTR;
		pSelectedDir->bstrVal = seldir.Detach();
		return S_OK;
	}

	return S_FALSE;
}
