#pragma once

#include "resource.h"       // C V{

#include <atlhost.h>

#include "SeraphyScriptDialog_i.h"


// qRg[̊NX
// ͉̎܂B(͈͊ÕCfbNXw肵ꍇ̓)

class ControlComponent
{
private:

	// Rg[ID
	SHORT m_ctrlId;

protected:

	/**
	 * ׂẴR|[lg͊eNX̐ÓI\bhCreate
	 * \zȂ΂Ȃ܂B
	 */
	ControlComponent()
		: m_ctrlId(-1)
	{
	}

public:

	/**
	 * R|[lgj܂B
	 * ComposeŃEBhE\zꍇ́A
	 * ĂяoODestroyŃEBhEjKv܂B
	 */
	virtual ~ControlComponent() throw() = 0
	{
	}

	/**
	 * EBhEKvł΍\z܂B
	 * łɍ\zς݂łĂ͂Ȃ܂B
	 * ۂɔzu邽߂ɂ͎DoLayouťĂяoKvłB
	 * ʎqꍇAZĂ߂܂B
	 * ʎqȂꍇAnChildId͕ύXɖ߂܂B
	 * @param nChildId [in/out] qEBhEɐݒ肷ID
	 * @param hParent eEBhE
	 */
	virtual HRESULT Compose(WORD &nChildId, HWND hParent) throw() = 0;

	/**
	 * EBhEj܂B
	 * EBhE쐬ĂȂꍇ͉܂B
	 * EBhE\ĂꍇAjOɏԂۑ܂B
	 */
	virtual HRESULT Destroy(void) throw() = 0;

	/** 
	 * Composeɐݒ肵qEBhEʂIDLĂ邩肵܂B
	 * @param pChildId ʎq
	 * @return HRESULT S_OKȂ珊LAS_FALSEȂ珊LĂȂ
	 */
	virtual HRESULT HasChildId(WORD childId) throw() = 0;

	/** 
	 * Cxgꍇ̓CxgIDƁAʂS_OKB
	 * CxgȂꍇID0AʂS_FALSEԂ܂B
	 * @param bModal tH[[_[hH
	 * @param notifyCode ʒmR[h
	 * @param childId ʎq
	 * @param pEventId CxgID̊i[
	 * @return HRESULT CxgꍇS_OKAȂꍇS_FALSE
	 */
	virtual HRESULT IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw() = 0;

	/**
	 * EBhEKvƂsԂ܂B
	 * EBhEsvł0B
	 * @return s
	 */
	virtual UINT GetLineCount() throw() = 0;

	/**
	 * EBhE\zƎۂɐeEBhEɔzu܂B
	 * EBhEKvȂΉ܂B
	 * Compose\bȟĂяoɂȂ΂Ȃ܂B
	 * @param hParent zuEBhE
	 * @param baseHeight 1s̍
	 * @param rect zułGA
	 * @return HRESULT
	 */
	virtual HRESULT DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw() = 0;

	/**
	 * R|[lg̒l擾܂B
	 * EBhE\ĂԂł́ȀԂ擾A
	 * Ԃۑ̂AꂪԂ܂B
	 * @param pValue ۑ
	 * @return HRESULT
	 */
	virtual HRESULT get_Value(BSTR *pValue) throw() = 0;

	/**
	 * R|[lg̒lݒ肵܂B
	 * EBhE\ĂԂł́AԂf܂B
	 * @param value l
	 * @return HRESULT
	 */
	virtual HRESULT put_Value(BSTR value) throw() = 0;

	/**
	 * l͒l̐ݒAUIɂēeύXĂ邩
	 * 肵܂B
	 * @param pResult ʂ̊i[
	 * @return HRESULT
	 */
	virtual HRESULT get_IsModified(VARIANT_BOOL *pResult) throw() = 0;

	/**
	 * Rg[LȄԂ擾܂B
	 * @param pEnabled ۑ
	 * @return HRESULT
	 */
	virtual HRESULT get_Enable(VARIANT_BOOL *pEnabled) throw() = 0;

	/**
	 * Rg[̗LȄԂݒ肵܂B
	 * @param pEnabled ݒl
	 * @return HRESULT
	 */
	virtual HRESULT put_Enable(VARIANT_BOOL enabled) throw() = 0;

	/**
	 * Rg[ID擾܂
	 */
	virtual SHORT GetCtrlId() const throw()
	{
		return m_ctrlId;
	}

	/**
	* Rg[IDݒ肵܂
	*/
	virtual void SetCtrlId(SHORT ctrlId) throw()
	{
		m_ctrlId = ctrlId;
	}

private:
	ControlComponent& operator=(const ControlComponent&); // ȂARs[s
	ControlComponent(const ControlComponent&); // ȂARs[s
};


// _~[Rg[p
class DummyControlComponent
	: public ControlComponent
{
protected:
	DummyControlComponent();

public:

	virtual ~DummyControlComponent() throw();

	virtual HRESULT Compose(WORD &nChildId, HWND hParent) throw();

	virtual HRESULT Destroy(void) throw();

	virtual HRESULT HasChildId(WORD childId) throw();

	virtual HRESULT IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw();

	virtual UINT GetLineCount() throw();

	virtual HRESULT DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw();

	virtual HRESULT get_Value(BSTR *pValue) throw();

	virtual HRESULT put_Value(BSTR value) throw();

	virtual HRESULT get_IsModified(VARIANT_BOOL *pResult) throw();

	virtual HRESULT get_Enable(VARIANT_BOOL *pEnabled) throw();

	virtual HRESULT put_Enable(VARIANT_BOOL enabled) throw();

	/**
	 * R|[lg\z܂B
	 * @param ppComponent i[|C^
	 * @return HRESULT
	 */
	static HRESULT Create(ControlComponent **ppComponent) throw();

};




// xp
class LabelControlComponent
	: public ControlComponent
{
private:

	// \zς݂ȂHWNDAłȂNULL
	HWND m_hWnd;

	// xeLXg
	CComBSTR m_text;

	// L
	VARIANT_BOOL m_enabled;

protected:

	LabelControlComponent();

public:

	virtual ~LabelControlComponent() throw();

	static HRESULT Create(BSTR text, ControlComponent** ppCompo) throw();

	virtual UINT GetLineCount() throw();

	virtual HRESULT Compose(WORD &nChildId, HWND hParent) throw();

	virtual HRESULT HasChildId(WORD childId) throw();

	virtual HRESULT IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw();

	virtual HRESULT Destroy(void) throw();

	virtual HRESULT DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw();

	virtual HRESULT get_Value(BSTR *pValue) throw();

	virtual HRESULT put_Value(BSTR value);

	virtual HRESULT get_IsModified(VARIANT_BOOL *pResult) throw();

	virtual HRESULT get_Enable(VARIANT_BOOL *pEnabled) throw();

	virtual HRESULT put_Enable(VARIANT_BOOL enabled) throw();

};

// GfBbg{bNXp
class MultiEditControlComponent
	: public ControlComponent
{
private:

	// xpEBhEnhAȂNULL
	HWND m_hLabelWnd;

	// GfBbg{bNXpEBhEnhAȂNULL
	HWND m_hEditWnd;

	// xeLXg
	CComBSTR m_label;

	// GfBbg{bNX̏e/ݒl
	CComBSTR m_initValue;

	// GfBbg{bNX͓̓e
	CComBSTR m_value;

	// s
	UINT m_lineCount;

	// L
	VARIANT_BOOL m_enabled;

protected:

	MultiEditControlComponent();

	HRESULT InitInstance(VARIANT title, VARIANT initValue, VARIANT multiline) throw();

public:

	virtual ~MultiEditControlComponent() throw();

	static HRESULT Create(VARIANT title, VARIANT initValue, VARIANT multiline, ControlComponent** ppCompo) throw();

	virtual UINT GetLineCount() throw();

	virtual HRESULT Compose(WORD& nChildId, HWND hParent) throw();

	virtual HRESULT HasChildId(WORD childId) throw();

	virtual HRESULT IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw();

	virtual HRESULT Destroy(void) throw();

	virtual HRESULT DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw();

	virtual HRESULT get_Value(BSTR *pValue) throw();

	virtual HRESULT put_Value(BSTR value) throw();

	virtual HRESULT get_IsModified(VARIANT_BOOL *pResult) throw();

	virtual HRESULT get_Enable(VARIANT_BOOL *pEnabled) throw();

	virtual HRESULT put_Enable(VARIANT_BOOL enabled) throw();

protected:

	/**
	 * GfBbg{bNX\ł΁Ae擾S_OKԂ܂B
	 * e̎擾Ɏsꍇ̓G[R[hԂ܂B
	 * GfBbg{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	HRESULT GetUIValue() throw();

	/**
	 * GfBbg{bNX\ł΁Aeݒ肵S_OKԂ܂B
	 * e̐ݒɎsꍇ̓G[R[hԂ܂B
	 * GfBbg{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	HRESULT SetUIValue() throw();

};




// vbV{^E`FbN{bNXEWI{^̋ʃNX

template <class CHILDHWND>
class AbstractButtonControlComponent
	: public ControlComponent
{
protected:

	// R}h{^ERg[̃EBhEnh̔z
	// CHILDHWND̃oƂāA
	// { HWND hWnd;
	//   CComBSTR caption; }
	// KvłB
	// \zɌ肵܂B
	CAutoPtrArray<CHILDHWND> m_buttons;

	// czu[hB
	// ftHg͐zułB
	// \zɌ肵܂B
	bool m_vertical;

	// L
	VARIANT_BOOL m_enabled;

	AbstractButtonControlComponent()
		: ControlComponent()
		, m_enabled(VARIANT_TRUE)
		, m_vertical(false)
	{
	}

	/**
	 * VARIANT琂zu[h擾CX^Xɐݒ肵܂B
	 * ftHg͐zułB
	 * @param mode [h
	 */
	void SetVerticalMode(VARIANT mode) throw()
	{
		bool vertical = false;
		if (!IsNullOrError(&mode)) {
			VARIANT tmp;
			VariantInit(&tmp);
			if (SUCCEEDED(VariantChangeType(&tmp, &mode, VARIANT_NOUSEROVERRIDE, VT_I2))) {
				ATLASSERT(tmp.vt == VT_I2);
				vertical = tmp.iVal ? true : false;
			}
		}
		m_vertical = vertical;
	}

public:

	virtual ~AbstractButtonControlComponent() = 0
	{
		Destroy();
		m_buttons.RemoveAll();
	}

	virtual UINT GetLineCount() throw()
	{
		if (!m_vertical) {
			// c[hłȂ1ŝ
			return 1;
		}
		// {^s
		return static_cast<UINT>(m_buttons.GetCount());
	}

	virtual HRESULT Compose(WORD& refChildId, HWND hParent) throw()
	{
		ATLASSERT(::IsWindow(hParent));

		WORD offset = 0;
		try {
			CWindow wndDialog(hParent);

			size_t mx = m_buttons.GetCount();
			for (size_t idx = 0; idx < mx; idx++) {
				ATLASSERT(m_buttons.GetAt(idx)->hWnd == NULL);

				CAutoPtr<CHILDHWND> &pCmdBtn = m_buttons.GetAt(idx);

				// {^̍\z
				HWND hWnd = CreateButton(hParent, pCmdBtn->caption, refChildId, offset);
				if (hWnd == NULL) {
					AtlThrowLastWin32();
				}

				// tHg̐ݒ
				CWindow btnWnd(hWnd);
				btnWnd.SetFont(wndDialog.GetFont());

				// o^
				pCmdBtn->hWnd = hWnd;
				offset++;
			}

			// l̐ݒ
			HRESULT hr = SetUIValue();
			if (FAILED(hr)) {
				AtlThrow(hr);
			}

			// LEԂ̐ݒ
			EnableButtons(m_enabled);

		} catch (CAtlException &ex) {
			
			Destroy();

			return ex.m_hr;
		}

		refChildId += offset;

		return S_OK;
	}

	HRESULT DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw()
	{
		ATLASSERT(::IsWindow(hParent));

		LONG width = rect.right - rect.left;
		LONG height = rect.bottom - rect.top;

		size_t mx = m_buttons.GetCount();
		ATLASSERT(mx > 0);

		if (m_vertical) {
			// zu
			LONG pos = 0;
			for (size_t idx = 0; idx < mx; idx++) {
				HWND hCmdWnd = m_buttons.GetAt(idx)->hWnd;
				ATLASSERT(::IsWindow(hCmdWnd));

				SetWindowPos(hCmdWnd, NULL,
					rect.left, rect.top + pos, width, baseHeight,
					SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);

				pos += baseHeight;
			}

		} else {
			// zu
			double standardSize = width / 4.; // EBhE1/4{Ƃ
			
			double btnWidth = width / static_cast<double>(mx); // ~ό덷}邽ߕ_Ƃ
			if (btnWidth < 5) {
				btnWidth = 5.; // 5px菬ȂB
			}

			LONG leftMargin = 0;

			if (btnWidth > standardSize) {
				// {LȀꍇ͍ɋ󔒂B
				btnWidth = standardSize;
				leftMargin = static_cast<LONG>(width - btnWidth * static_cast<double>(mx));
			}

			double pos = leftMargin;
			for (size_t idx = 0; idx < mx; idx++) {
				HWND hCmdWnd = m_buttons.GetAt(idx)->hWnd;
				ATLASSERT(::IsWindow(hCmdWnd));

				SetWindowPos(hCmdWnd, NULL,
					static_cast<LONG>(rect.left + pos), rect.top, static_cast<LONG>(btnWidth), height,
					SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);

				pos += btnWidth;
			}
		}

		return S_OK;
	}

	virtual HRESULT HasChildId(WORD childId) throw()
	{
		size_t mx = m_buttons.GetCount();
		for (size_t idx = 0; idx < mx; idx++) {
			CWindow wnd(m_buttons.GetAt(idx)->hWnd);
			if (wnd.IsWindow()) {
				if (wnd.GetWindowLong(GWL_ID) == childId) {
					return S_OK;
				}
			}
		}
		return S_FALSE;
	}

	virtual HRESULT IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw()
	{
		if (!pEventId) {
			return E_POINTER;
		}

		// ł́A[hXŃ{^O[vɊYꍇ̓Cxg𔭐B
		// [_̏ꍇ̓Cxg͔ȂB
		if (!bModal && HasChildId(childId) == S_OK) {
			*pEventId = GetCtrlId();
			return S_OK;
		}

		*pEventId = 0;
		return S_FALSE;
	}

	virtual HRESULT Destroy(void) throw()
	{
		// ʂ\Ă΁ȀԂ擾ĕۑB
		HRESULT hr = GetUIValue();
		if (SUCCEEDED(hr)) {
			// EBhE1ȏjꂽ̂ȂS_OKB
			// EBhEƂƂȂ̂łS_FALSEԂ߁B
			hr = S_FALSE;
		}

		// GetUIValuesĂEBhE̔js

		size_t mx = m_buttons.GetCount();
		for (size_t idx = 0; idx < mx; idx++) {
			CAutoPtr<CHILDHWND> &pCmdWnd = m_buttons.GetAt(idx);
			CWindow wnd(pCmdWnd->hWnd);
			if (wnd.IsWindow()) {
				wnd.DestroyWindow();
				if (SUCCEEDED(hr)) { // G[R[h͏㏑ȂB
					hr = S_OK;
				}
			}
			pCmdWnd->hWnd = NULL;
		}

		return hr;
	}

	virtual HRESULT get_Enable(VARIANT_BOOL *pEnabled) throw()
	{
		if (!pEnabled) {
			return E_POINTER;
		}

		*pEnabled = m_enabled;

		return S_OK;
	}

	virtual HRESULT put_Enable(VARIANT_BOOL enabled) throw()
	{
		m_enabled = enabled;

		EnableButtons(m_enabled);

		return S_OK;
	}

protected:

	/**
	 * vbV{^E`FbN{bNXEWI{^ȂǁA{^Rg[
	 * ۂɍ\zĕԂ܂B\złȂꍇNULLԂAGetLastError()
	 * Win32APĨG[R[h擾ł悤ɂKv܂B
	 * nStartChildId + offsetEBhEʎqƂĎgp܂B
	 * O[vɕ̃Rg[ꍇAoffsetŏԂcł܂B
	 * @param caption LvV
	 * @param nStartChildId qEBhE̎ʎq̃x[X
	 * @param offset qEBhE̎ʎq̃ItZbg
	 */
	virtual HWND CreateButton(HWND hParent, LPCTSTR caption, WORD nStartChildId, WORD offset) throw() = 0;

	/**
	 * {^sɑ΂ĈꊇėLEs܂B
	 * @param enabled LE
	 */
	virtual void EnableButtons(VARIANT_BOOL enabled) throw()
	{
		// R}h{^̗LÉA1sɕ̃{^ꍇłꊇčsB
		// Ƃƌʂ̎w̓T|[gĂȂB

		size_t mx = m_buttons.GetCount();
		for (size_t idx = 0; idx < mx; idx++) {
			CAutoPtr<CHILDHWND> &pCmdBtn = m_buttons.GetAt(idx);
			CWindow btnWnd(pCmdBtn->hWnd);
			if (btnWnd.IsWindow()) {
				btnWnd.EnableWindow(enabled ? TRUE : FALSE);
			}
		}
	}

	/** 
	 * {^Ԃꍇ(CHECKBOX/RADIO)ɁȀԂUIɔf܂B
	 * Rg[܂\zĂȂꍇ͉S_FALSEԂ܂B
	 * fꂽꍇS_OKԂ܂B
	 * fɎsꍇ̓G[R[hԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT SetUIValue() throw()
	{
		return S_FALSE;
	}

	/**
	 * {^ԂꍇȀԂ擾܂B
	 * Rg[܂\zĂȂꍇ͉S_FALSEԂ܂B
	 * 擾ꂽꍇS_OKԂ܂B
	 * 擾Ɏsꍇ̓G[R[hԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT GetUIValue() throw()
	{
		return S_FALSE;
	}
};


// X̃R}h{^Ƃ̒`
class CommandButtonInfo
{
public:

	CommandButtonInfo()
		: eventId(0)
		, hWnd(0)
	{
	}

	// \eLXg
	CComBSTR caption;

	// EBhEnh
	HWND hWnd;

	// CxgID
	SHORT eventId;

private:

	CommandButtonInfo(const CommandButtonInfo&); // Ȃ
	CommandButtonInfo& operator=(const CommandButtonInfo&); // Ȃ
};

// R}h{^sp
class CommandButtonControlComponent
	: public AbstractButtonControlComponent<CommandButtonInfo>
{
protected:

	CommandButtonControlComponent();

	virtual HWND CreateButton(HWND hParent, LPCTSTR caption, WORD nStartChildId, WORD offset);

	HRESULT InitInstance(BSTR title, SHORT startEventCode) throw();

public:

	virtual ~CommandButtonControlComponent() throw();

	static HRESULT Create(BSTR title, SHORT startEventCode, ControlComponent** ppCompo) throw();

	virtual HRESULT IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw();

	virtual HRESULT get_Value(BSTR *pValue) throw();

	virtual HRESULT put_Value(BSTR value) throw();

	virtual HRESULT get_IsModified(VARIANT_BOOL *pResult) throw();

};


// X̃`FbN{bNXƂ̒`
class CheckboxInfo
{
public:

	CheckboxInfo()
		: hWnd(0)
	{
	}

	// \eLXg
	CComBSTR caption;

	// EBhEnh
	HWND hWnd;

private:
	
	CheckboxInfo(const CheckboxInfo&); // Ȃ
	CheckboxInfo& operator=(const CheckboxInfo&); // Ȃ
};

// `FbN{bNXsp
class CheckButtonControlComponent
	: public AbstractButtonControlComponent<CheckboxInfo>
{
private:

	CComBSTR m_initValue;

	CComBSTR m_value;

protected:

	CheckButtonControlComponent();

	HRESULT InitInstance(BSTR title, VARIANT initValue, VARIANT mode) throw();

	virtual HWND CreateButton(HWND hParent, LPCTSTR caption, WORD nStartChildId, WORD offset);

public:

	virtual ~CheckButtonControlComponent() throw();

	static HRESULT Create(BSTR title, VARIANT initValue, VARIANT mode, ControlComponent** ppCompo) throw();

	virtual HRESULT get_Value(BSTR *pValue) throw();

	virtual HRESULT put_Value(BSTR value) throw();

	virtual HRESULT get_IsModified(VARIANT_BOOL *pResult) throw();

protected:

	virtual HRESULT GetUIValue() throw();

	virtual HRESULT SetUIValue() throw();
};



// X̃WI{bNXƂ̒`
class RadioInfo
{
public:

	RadioInfo()
		: hWnd(0)
	{
	}

	// \eLXg
	CComBSTR caption;

	// EBhEnh
	HWND hWnd;

private:
	
	RadioInfo(const RadioInfo&); // Ȃ
	RadioInfo& operator=(const RadioInfo&); // Ȃ
};

// WI{bNXsp
class RadioButtonControlComponent
	: public AbstractButtonControlComponent<RadioInfo>
{
private:

	SHORT m_initValue;

	SHORT m_value;

protected:

	RadioButtonControlComponent();

	HRESULT InitInstance(BSTR title, VARIANT initValue, VARIANT mode) throw();

	virtual HWND CreateButton(HWND hParent, LPCTSTR caption, WORD nStartChildId, WORD offset);

public:

	virtual ~RadioButtonControlComponent() throw();

	static HRESULT Create(BSTR title, VARIANT initValue, VARIANT mode, ControlComponent** ppCompo) throw();

	virtual HRESULT get_Value(BSTR *pValue) throw();

	virtual HRESULT put_Value(BSTR value) throw();

	virtual HRESULT get_IsModified(VARIANT_BOOL *pResult) throw();

protected:

	virtual HRESULT GetUIValue() throw();

	virtual HRESULT SetUIValue() throw();
};



// Xg{bNXp
class ListboxControlComponent
	: public ControlComponent
{
private:

	// Xg{bNXpEBhEnhAȂNULL
	HWND m_hListWnd;

	// Xg{bNX̕\e
	CAtlArray<CAtlStringW> m_items;

	// GfBbg{bNX̏e/ݒl
	CComBSTR m_initValue;

	// GfBbg{bNX͓̓e
	CComBSTR m_value;

	// s
	UINT m_lineCount;

	// I[h
	bool m_multiSelMode;

	// L
	VARIANT_BOOL m_enabled;

protected:

	ListboxControlComponent();

	HRESULT InitInstance(VARIANT listValues, VARIANT initValues, VARIANT numberOfLines, VARIANT multiSelMode) throw();

public:

	virtual ~ListboxControlComponent() throw();

	static HRESULT Create(VARIANT listValues, VARIANT initValues, VARIANT numberOfLines, VARIANT multiSelMode, ControlComponent** ppCompo) throw();

	virtual UINT GetLineCount() throw();

	virtual HRESULT Compose(WORD& nChildId, HWND hParent) throw();

	virtual HRESULT HasChildId(WORD childId) throw();

	virtual HRESULT IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw();

	virtual HRESULT Destroy(void) throw();

	virtual HRESULT DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw();

	virtual HRESULT get_Value(BSTR *pValue) throw();

	virtual HRESULT put_Value(BSTR value) throw();

	virtual HRESULT get_IsModified(VARIANT_BOOL *pResult) throw();

	virtual HRESULT get_Enable(VARIANT_BOOL *pEnabled) throw();

	virtual HRESULT put_Enable(VARIANT_BOOL enabled) throw();

protected:

	/**
	 * Xg̕\e擾܂B
	 * @param varList Xg̕\e
	 * @return HRESULT
	 */
	HRESULT InitItems(VARIANT varList) throw();

	/**
	 * Z~R؂蕶Ŏw肳Ă鐔lCfbNXƂ
	 * pMapzTRUE/FALSEݒ肵ĕԂ܂B
	 * 0llenthȏ̐l͖܂B
	 * lȊȌꍇ܂B
	 * @param pSrc Z~R؂蕶
	 * @param onlyLastToken Ō̃g[N擾ꍇ
	 * @param pMap z
	 * @param length z̃TCY
	 */
	void GetMarkedMap(LPCWSTR pSrc, bool onlyLastToken, BOOL *pMap, size_t length) throw();

	/**
	 * Xg{bNX\ł΁AeGUI擾S_OKԂ܂B
	 * e̎擾Ɏsꍇ̓G[R[hԂ܂B
	 * Xg{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT GetUIValue() throw();

	/**
	 * Xg{bNX\ł΁AeGUIɔf܂B
	 * ݒɎsꍇ̓G[R[hԂ܂B
	 * Xg{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT SetUIValue() throw();

};

// R{^hbv_EXg{bNXʗp
class AbstractComboboxControlComponent
	: public ControlComponent
{
protected:

	// xpEBhEnhAȂNULL
	HWND m_hLabelWnd;

	// R{{bNXpEBhEnhAȂNULL
	HWND m_hComboWnd;

	// xeLXg
	CComBSTR m_label;

	// R{{bNX̃hbv_EXg̓e
	CAtlArray<CAtlStringW> m_listItems;

	// L
	VARIANT_BOOL m_enabled;

	AbstractComboboxControlComponent();

	HRESULT InitInstance(VARIANT title, VARIANT listValues) throw();

public:

	virtual ~AbstractComboboxControlComponent() throw() = 0;

	virtual UINT GetLineCount() throw();

	virtual HRESULT Compose(WORD& nChildId, HWND hParent) throw();

	virtual HRESULT HasChildId(WORD childId) throw();

	virtual HRESULT IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw();

	virtual HRESULT Destroy(void) throw();

	virtual HRESULT DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw();

	virtual HRESULT get_Enable(VARIANT_BOOL *pEnabled) throw();

	virtual HRESULT put_Enable(VARIANT_BOOL enabled) throw();

protected:

	/**
	 * R{{bNX̍\z̃X^CԂ܂B
	 * hNXɂăI[o[ChA̒lCompose\bȟĂяoOA
	 * ܂A\z(Create)Ɋm肵ĂȂ΂Ȃ܂B
	 */
	virtual DWORD GetComboStyle() throw() = 0;

	/**
	 * R{{bNX\ł΁AeGUI擾S_OKԂ܂B
	 * e̎擾Ɏsꍇ̓G[R[hԂ܂B
	 * R{{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT GetUIValue() throw() = 0;

	/**
	 * R{{bNX\ł΁AeGUIɔf܂B
	 * ݒɎsꍇ̓G[R[hԂ܂B
	 * R{{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT SetUIValue() throw() = 0;

};

// R{{bNXp
class ComboboxControlComponent
	: public AbstractComboboxControlComponent
{
	// R{{bNX̏e/ݒl
	CComBSTR m_initValue;

	// GfBbg{bNX͓̓e
	CComBSTR m_value;

protected:

	ComboboxControlComponent();

	HRESULT InitInstance(VARIANT titles, VARIANT initValues, VARIANT listValues) throw();

public:

	virtual ~ComboboxControlComponent() throw();

	static HRESULT Create(VARIANT title, VARIANT initValue, VARIANT listValues, ControlComponent** ppCompo) throw();

	virtual HRESULT get_Value(BSTR *pValue) throw();

	virtual HRESULT put_Value(BSTR value) throw();

	virtual HRESULT get_IsModified(VARIANT_BOOL *pResult) throw();

protected:

	/**
	 * R{{bNX̍\z̃X^CԂ܂B
	 * hNXɂăI[o[ChA̒lCompose\bȟĂяoOA
	 * ܂A\z(Create)Ɋm肵ĂȂ΂Ȃ܂B
	 */
	virtual DWORD GetComboStyle() throw();

	/**
	 * R{{bNX\ł΁AeGUI擾S_OKԂ܂B
	 * e̎擾Ɏsꍇ̓G[R[hԂ܂B
	 * Xg{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT GetUIValue() throw();

	/**
	 * R{{bNX\ł΁AeGUIɔf܂B
	 * ݒɎsꍇ̓G[R[hԂ܂B
	 * Xg{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT SetUIValue() throw();

};


// hbv_EXgp
class DropdownListControlComponent
	: public AbstractComboboxControlComponent
{
private:

	// R{{bNX̏e/ݒl
	SHORT m_initValue;

	// GfBbg{bNX͓̓e
	SHORT m_value;

protected:

	DropdownListControlComponent();

	HRESULT InitInstance(VARIANT title, VARIANT initValues, VARIANT listValues) throw();

public:

	virtual ~DropdownListControlComponent() throw();

	static HRESULT Create(VARIANT title, VARIANT initValue, VARIANT listValues, ControlComponent** ppCompo) throw();

	virtual HRESULT get_Value(BSTR *pValue) throw();

	virtual HRESULT put_Value(BSTR value) throw();

	virtual HRESULT get_IsModified(VARIANT_BOOL *pResult) throw();

protected:

	/**
	 * 񂩂SHORT̐l擾܂B
	 * s󔒂͖܂B
	 * lł邩ANULL܂͋̏ꍇ-1Ԃ܂B
	 * `Ă郊Xg傫ȏꍇ-1ɐݒ肳܂B
	 * (InitInstanceŃXgm肵ĂȂΌĂяoƂ͂ł܂B)
	 */
	HRESULT GetValue(LPCWSTR pStr, SHORT *pValue) throw();	

	/**
	 * R{{bNX̍\z̃X^CԂ܂B
	 * hNXɂăI[o[ChA̒lCompose\bȟĂяoOA
	 * ܂A\z(Create)Ɋm肵ĂȂ΂Ȃ܂B
	 */
	virtual DWORD GetComboStyle() throw();

	/**
	 * R{{bNX\ł΁AeGUI擾S_OKԂ܂B
	 * e̎擾Ɏsꍇ̓G[R[hԂ܂B
	 * Xg{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT GetUIValue() throw();

	/**
	 * R{{bNX\ł΁AeGUIɔf܂B
	 * ݒɎsꍇ̓G[R[hԂ܂B
	 * Xg{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT SetUIValue() throw();

};


// GfCbg+{^̋ʃNX
class AbstractEditButtonControlComponent
	: public ControlComponent
{
protected:

	// xpEBhEnhAȂNULL
	HWND m_hLabelWnd;

	// GfBbg{bNXpEBhEnhAȂNULL
	HWND m_hEditWnd;

	// {^pEBhEnhAȂNULL
	HWND m_hButtonWnd;

	// xeLXg
	CComBSTR m_label;

	// {^peLXg
	CComBSTR m_btnLabel;

	// GfBbg{bNX̏e
	CComBSTR m_initValue;

	// GfBbg{bNX̓e
	CComBSTR m_value;

	// L
	VARIANT_BOOL m_enabled;

	AbstractEditButtonControlComponent();

	HRESULT InitInstance(VARIANT title, VARIANT initValue, VARIANT btnTitle) throw();

public:

	virtual ~AbstractEditButtonControlComponent() throw() = 0;

	virtual UINT GetLineCount() throw();

	virtual HRESULT Compose(WORD& nChildId, HWND hParent) throw();

	virtual HRESULT HasChildId(WORD childId) throw();

	virtual HRESULT Destroy(void) throw();

	virtual HRESULT DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw();

	virtual HRESULT get_Value(BSTR *pValue) throw();

	virtual HRESULT put_Value(BSTR value) throw();

	virtual HRESULT get_IsModified(VARIANT_BOOL *pResult) throw();

	virtual HRESULT get_Enable(VARIANT_BOOL *pEnabled) throw();

	virtual HRESULT put_Enable(VARIANT_BOOL enabled) throw();

protected:

	/**
	 * GfBbg{bNX\ł΁AeGUI擾S_OKԂ܂B
	 * e̎擾Ɏsꍇ̓G[R[hԂ܂B
	 * GfBbg{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT GetUIValue() throw();

	/**
	 * GfBbg{bNX\ł΁AeGUIɔf܂B
	 * ݒɎsꍇ̓G[R[hԂ܂B
	 * GfBbg{bNX\ĂȂꍇ͉S_FALSEԂ܂B
	 * @return HRESULT
	 */
	virtual HRESULT SetUIValue() throw();

};

// GfBbg + R}h{^̒`
class EditButtonControlComponent
	: public AbstractEditButtonControlComponent
{
private:

	// CxgID
	SHORT m_eventId;

protected:

	EditButtonControlComponent();

	HRESULT InitInstance(VARIANT title, VARIANT initValue, VARIANT btnTitle, SHORT eventId) throw();

public:

	static HRESULT Create(VARIANT title, VARIANT initValue, VARIANT btnTitle, SHORT eventId, ControlComponent** ppCompo) throw();

	virtual ~EditButtonControlComponent() throw();

	virtual HRESULT IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw();

};

// GfBbg + t@CI{^̒`
class FileEditButtonControlComponent
	: public AbstractEditButtonControlComponent
{
private:

	/**
	 * OPEN[hBTRUEȂ΁ut@CJv_CAOB
	 */
	BOOL m_openMode;

	/**
	 * t@C_CAÕtB^
	 */
	CComVariant m_filter;

protected:

	FileEditButtonControlComponent();

	HRESULT InitInstance(VARIANT title, VARIANT initValue, VARIANT btnTitle, VARIANT openSaveMode, VARIANT filter) throw();

public:

	static HRESULT Create(VARIANT title, VARIANT initValue, VARIANT btnTitle,  VARIANT openSaveMode, VARIANT filter, ControlComponent** ppCompo) throw();

	virtual HRESULT Compose(WORD& nChildId, HWND hParent) throw();

	virtual ~FileEditButtonControlComponent() throw();

	virtual HRESULT IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw();

};

// GfBbg + tH_I{^̒`
class FolderEditButtonControlComponent
	: public AbstractEditButtonControlComponent
{
protected:

	FolderEditButtonControlComponent();

public:

	static HRESULT Create(VARIANT title, VARIANT initValue, VARIANT btnTitle, ControlComponent** ppCompo) throw();

	virtual HRESULT Compose(WORD& nChildId, HWND hParent) throw();

	virtual ~FolderEditButtonControlComponent() throw();

	virtual HRESULT IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw();

};
