// ScrDlgRoot.cpp : CScrDlgRoot ̎

#include "stdafx.h"
#include "ScrDlgRoot.h"

#include <VersionHelpers.h>

#include <vector>
#include <math.h>

#include "VarArray.h"
#include "OutputWindow.h"
#include "UserForm.h"

#include "ArrayUtil.h"
#include "CommOpenFileName.h"


// CScrDlgRoot

HRESULT CScrDlgRoot::FinalConstruct()
{
	// 
	m_defaultFS = m_defaultIS = 0;
	m_defaultTolerance = 0;

	//ݒt@C̃pX̃ftHglݒ肷
	try {
		HRESULT hr;

		TCHAR curdir[MAX_PATH];
		GetCurrentDirectory(MAX_PATH, curdir);
		CComBSTR tmp(curdir);
		if (tmp[tmp.Length() - 1] != '\\') {
			if (FAILED(hr = tmp.Append(_T("\\")))) {
				// sƂ?
				AtlThrow(hr);
			}
		}

		CComBSTR defaultPreferenceName;
		defaultPreferenceName.LoadString(IDS_DEFAULT_PREFERENCENAME);
		if (FAILED(hr = tmp.Append(defaultPreferenceName))) {
			// sƂ?
			AtlThrow(hr);
		}
		m_profilePath = tmp;

		return S_OK;
	
	} catch (CAtlException &ex) {
		return ex.m_hr;
	}
}

STDMETHODIMP CScrDlgRoot::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IScrDlgRoot
	};

	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CScrDlgRoot::get_DefaultFS(SHORT* pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	*pVal = m_defaultFS;
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::put_DefaultFS(SHORT newVal)
{
	m_defaultFS = newVal;
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::get_DefaultIS(SHORT* pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	*pVal = m_defaultIS;
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::put_DefaultIS(SHORT newVal)
{
	m_defaultIS = newVal;
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::get_DefaultTolerance(DOUBLE* pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	*pVal = m_defaultTolerance;
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::put_DefaultTolerance(DOUBLE newVal)
{
	m_defaultTolerance = newVal;
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::get_ProfilePath(BSTR* pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	return m_profilePath.CopyTo(pVal);
}

STDMETHODIMP CScrDlgRoot::put_ProfilePath(BSTR newVal)
{
	m_profilePath = newVal;
	return S_OK;
}


STDMETHODIMP CScrDlgRoot::get_TickCount(DOUBLE* pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	DWORD tc = ::GetTickCount();
	*pVal = ((double) tc) / 1000.0L; // bPʂɕϊ
	return S_OK;

	// *NOTE* ̃\bh́AƂ蓮삹wvɂLڂȂB
	// GetTickCount API47𒴂ƃI[o[t[0ɖ߂̂ŒӂKvB
}

STDMETHODIMP CScrDlgRoot::About(DOUBLE* pVersion)
{
	//DebugBreak();
	// ̃W[̃o[W擾
	// 擾łȂꍇ́uunknownvƕ\
	TCHAR strVersion[64] = {0};
	double dblVersion = 0;
	_tcscpy_s(strVersion, 64, _T("unknown"));

	TCHAR modulePath[MAX_PATH];
	if (GetModuleFileName(_AtlBaseModule.GetModuleInstance(), modulePath, MAX_PATH) <= MAX_PATH) {
		DWORD dwHandle = 0; // gpȂ
		DWORD siz = GetFileVersionInfoSize(modulePath, &dwHandle);
		if (siz > 0) {
			std::vector<BYTE> buf(siz);
			if (GetFileVersionInfo(modulePath, dwHandle, siz, &buf[0])) {
				VS_FIXEDFILEINFO *pFixedFileInfo = 0;
				UINT len = 0;
				if (VerQueryValue(&buf[0], _T("\\"), reinterpret_cast<LPVOID *>(&pFixedFileInfo), &len)) {
					int v1 = (pFixedFileInfo->dwProductVersionMS >> 16) & 0xffff;
					int v2 = pFixedFileInfo->dwProductVersionMS & 0xffff;
					int v3 = (pFixedFileInfo->dwProductVersionLS >> 16) & 0xffff;
					int v4 = pFixedFileInfo->dwProductVersionLS & 0xffff;
					_stprintf_s(strVersion, 64, _T("%d.%d.%d.%d"), v1, v2, v3, v4);
					dblVersion = _tstof(strVersion);
				}
			}
		}
	}

	// bZ[WtH[}bg
	CComBSTR fmt, appName;
	appName.LoadString(IDS_PROJNAME);
	fmt.LoadString(IDS_ABOUTMESSAGE);

	TCHAR bitsiz[16];
	_stprintf_s(bitsiz, 16, _T("%d"), sizeof(void*) * 8); // |C^̑傫32/64rbgRpC𔻒

	const DWORD messz = static_cast<DWORD>(fmt.ByteLength() + _tcslen(strVersion) + _tcslen(bitsiz) + 1);
	std::vector<TCHAR> mes(messz); // tH[}bg̕i[obt@

	if (!FormatMessage(&mes[0], messz, fmt, strVersion, bitsiz)) {
		return HRESULT_FROM_WIN32(GetLastError());
	}

	// _CAO\
	::MessageBox(::GetActiveWindow(), &mes[0], appName, MB_ICONINFORMATION | MB_OK);

	if (pVersion) {
		*pVersion = dblVersion;
	}
	return S_OK;
}

DWORD WINAPI CScrDlgRoot::FormatMessage(LPTSTR buf, DWORD len, LPCTSTR fmt, ...)
{
	va_list args;
	va_start(args, fmt);

	return ::FormatMessage(
		FORMAT_MESSAGE_FROM_STRING,
		fmt,
		0, // ignore
		0, // ignore
		buf,
		len,
		&args);
}

/////////////////////////////////////////////////////////////////////////////
// t@CJEۑ_CAO֘A

STDMETHODIMP CScrDlgRoot::GetOpenFileName(VARIANT defaultName, VARIANT filter, VARIANT defaultDir, VARIANT *pSelectedFilePath)
{
	return CommonDialogUtil::CommOpenFileName(TRUE, defaultName, filter, defaultDir, pSelectedFilePath);
}

STDMETHODIMP CScrDlgRoot::GetSaveFileName(VARIANT defaultName, VARIANT filter, VARIANT defaultDir, VARIANT *pSelectedFilePath)
{
	return CommonDialogUtil::CommOpenFileName(FALSE, defaultName, filter, defaultDir, pSelectedFilePath);
}

STDMETHODIMP CScrDlgRoot::ShellExecute(VARIANT varVerb, VARIANT varPath, VARIANT varParam, VARIANT varDirectory, VARIANT varShow, VARIANT varWait, SHORT *pRetcode)
{
	if (!pRetcode) {
		return E_POINTER;
	}

	// Verb
	CComBSTR verb(L"OPEN");
	if (!IsNullOrError(&varVerb)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varVerb, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		verb.Attach(tmp.bstrVal);
	}

	// Path
	CComBSTR path;
	if (!IsNullOrError(&varPath)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varPath, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		path.Attach(tmp.bstrVal);
	}

	// Param
	CComBSTR param;
	if (!IsNullOrError(&varParam)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varParam, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		param.Attach(tmp.bstrVal);
	}
	
	// Directory
	CComBSTR directory;
	if (!IsNullOrError(&varDirectory)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varDirectory, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		directory.Attach(tmp.bstrVal);
	}

	// ShowWindow
	int nShowCmd = SW_SHOWNORMAL;
	if (!IsNullOrError(&varShow)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varShow, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_I2);

		// EBhE\@w肷
		switch(tmp.iVal) {
			case 0:
				nShowCmd = SW_HIDE;
				break;

			case 1:
				nShowCmd = SW_SHOWNORMAL;
				break;

			case 2:
				nShowCmd = SW_SHOWMAXIMIZED;
				break;

			case 3:
				nShowCmd = SW_SHOWMINIMIZED;
				break;

			case 4:
				nShowCmd = SW_SHOWMINNOACTIVE;
				break;

			default:
				nShowCmd = SW_SHOWNORMAL;
				break;
		}
	}

	// s҂
	DWORD waittime = 0; // ~bP
	if (!IsNullOrError(&varWait)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varWait, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_I2);
		if (tmp.iVal < 0) {
			// 
			waittime = INFINITE;
		} else {
			// 100~bPʂ̎w肩~b
			waittime = tmp.iVal * 100;
		}
	}

	// SHELL EXECUTEpf[^
	SHELLEXECUTEINFO execinfo = {0};
	execinfo.cbSize = sizeof(SHELLEXECUTEINFO);
	execinfo.fMask  = SEE_MASK_DOENVSUBST | SEE_MASK_NOCLOSEPROCESS;
	execinfo.hwnd   = NULL;

	execinfo.lpVerb = verb;
	execinfo.lpFile = path;
	execinfo.lpParameters = param;
	execinfo.lpDirectory  = directory;
	execinfo.nShow = nShowCmd;

	// s
	SHORT retCode = -1; // EXEC FAILED
	if (ShellExecuteEx(&execinfo)) {

		if (waittime != 0) {
			if (execinfo.hProcess == NULL) {
				// vZX͐VɋNĂȂ
				retCode = 2;

			} else {
				// vZXIҋ@
				DWORD reason = WaitForSingleObject(execinfo.hProcess, waittime);
				if (reason == WAIT_TIMEOUT) {
					// ^CAEg
					retCode = 1;

				} else {
					// vZXI
					retCode = 0;
				}
			}

		} else {
			// vZXI͊֒m
			retCode = 1;
		}

		if (execinfo.hProcess != NULL) {
			CloseHandle(execinfo.hProcess);
		}
	}
	
	*pRetcode = retCode;

	return (retCode >= 0) ? S_OK : S_FALSE;
}

STDMETHODIMP CScrDlgRoot::GetASyncKeyState(VIRTUALKEYCODE vk, SHORT *pKeyState)
{
	if (!pKeyState) {
		return E_POINTER;
	}

	if (vk <= 0) {
		switch(vk) {
			case -1:
				vk = static_cast<VIRTUALKEYCODE>(VK_PAUSE);
				break;

			case -2:
				vk = static_cast<VIRTUALKEYCODE>(VK_SCROLL);
				break;

			case 0:	
			default:
				vk = static_cast<VIRTUALKEYCODE>(VK_F10);
				break;
		}
	}
	
	*pKeyState = GetAsyncKeyState(vk);

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::BrowseForFolder(VARIANT initdir, VARIANT* pSelectedDir)
{
	return CommonDialogUtil::BrowseForFolder(initdir, pSelectedDir);
}

STDMETHODIMP CScrDlgRoot::CreateForm(IUserForm** ppForm)
{
	if (!ppForm) {
		return E_POINTER;
	}

	CComObject<CUserForm> *pUserFormObj = NULL;
	HRESULT hr = CComObject<CUserForm>::CreateInstance(&pUserFormObj);
	if (FAILED(hr)){
		return hr;
	}
	CComPtr<IUserForm> pUserForm;
	hr = pUserFormObj->QueryInterface(IID_IUserForm, reinterpret_cast<void**>(&pUserForm));
	if (FAILED(hr)){
		return hr;
	}
	
	CComPtr<IMessageLoopImpl> pMessageLoopImpl;
	if (FAILED(hr = QueryInterface(IID_IMessageLoopImpl, reinterpret_cast<void**>(&pMessageLoopImpl)))) {
		return hr;
	}
	pUserFormObj->SetMessageLoopImpl(pMessageLoopImpl);

	*ppForm = pUserForm.Detach();
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::VersionCheck(BSTR path, SHORT v1, SHORT v2, SHORT v3, SHORT v4, SHORT *pRetcode)
{
	if (!pRetcode) {
		return E_POINTER;
	}

	SHORT ret = -1;

	DWORD attr = ::GetFileAttributes(path);
	if(attr == -1){
		// t@C݂ȂBCXg[KvB
		ret = 0;

	} else if(attr & FILE_ATTRIBUTE_DIRECTORY){
		// fBNgƂđ݂邽ߎgps\
		ret = -1;

	} else {
		DWORD dwHandle = 0; // gpȂ
		DWORD siz = GetFileVersionInfoSize(path, &dwHandle);
		if (siz > 0) {
			std::vector<BYTE> buf(siz);
			if (GetFileVersionInfo(path, dwHandle, siz, &buf[0])) {
				VS_FIXEDFILEINFO *pFixedFileInfo = 0;
				UINT len = 0;
				if (VerQueryValue(&buf[0], _T("\\"), reinterpret_cast<LPVOID *>(&pFixedFileInfo), &len)) {
					DWORD versionMS = MAKELONG(v2, v1);
					DWORD versionLS = MAKELONG(v4, v3);
					if (pFixedFileInfo->dwFileVersionMS >= versionMS ||
						((pFixedFileInfo->dwFileVersionMS == versionMS) && 
						 (pFixedFileInfo->dwFileVersionLS >= versionLS))) {
							// o[WAVt@C݂ꍇ
							ret = 1;
					} else {
						// Âꍇ
						ret = 0;
					}
				}
			}
		}
	}

	*pRetcode = ret;

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::CreateDirectory(BSTR path, VARIANT_BOOL *pRetcode)
{
	if (!pRetcode) {
		return E_POINTER;
	}

	DWORD attr = ::GetFileAttributes(path);
	if (attr != -1 && (attr & FILE_ATTRIBUTE_DIRECTORY) != 0) {
		// łɃtH_݂
		*pRetcode = VARIANT_TRUE;
		return S_FALSE;
	}

	int ret = SHCreateDirectory(NULL, path);
	if (ret == ERROR_SUCCESS) {
		// fBNg쐬ɐ
		*pRetcode = VARIANT_TRUE;
		return S_OK;
	}

	*pRetcode = VARIANT_FALSE;
	return S_FALSE;
}

STDMETHODIMP CScrDlgRoot::GetFileVersion(BSTR path, LONG *pFileVersion)
{
	if (!pFileVersion) {
		return E_POINTER;
	}

	DWORD version = 0;

	DWORD attr = ::GetFileAttributes(path);
	if (attr != -1 && (attr & FILE_ATTRIBUTE_DIRECTORY) != 0) {
		// pX݂AAfBNgłȂꍇ
		DWORD dwHandle = 0; // gpȂ
		DWORD siz = GetFileVersionInfoSize(path, &dwHandle);
		if (siz > 0) {
			std::vector<TCHAR> buf(siz);
			if (GetFileVersionInfo(path, dwHandle, siz, &buf[0])) {
				VS_FIXEDFILEINFO *pFixedFileInfo = 0;
				UINT len = 0;
				if (VerQueryValue(&buf[0], _T("\\"), reinterpret_cast<LPVOID *>(&pFixedFileInfo), &len)) {
					version = MAKELONG(pFixedFileInfo->dwFileVersionLS, pFixedFileInfo->dwFileVersionMS);
				}
			}
		}
	}

	*pFileVersion = version;

	return (version != 0) ? S_OK : S_FALSE;
}

/**
 * Vbg_ELɂB
 * ̂ƃVbg_En܂͂Ȃ̂Ŗɂ@\͂ȂB
 */
HRESULT CScrDlgRoot::PrivilegeShutdown()
{
	try {
		CAccessToken accToken;
		if (!accToken.GetProcessToken(TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY)) {
			AtlThrowLastWin32();
		}

		bool errNotAllAssigned = false;
		if (!accToken.EnablePrivilege(SE_SHUTDOWN_NAME, NULL, &errNotAllAssigned) || errNotAllAssigned) {
			return Error(IDS_NO_SHUTDOWN_PRIVILEGE);
		}

	} catch (CAtlException &) {
		// LɂłȂꍇ̓G[ʒm
		return Error(IDS_NO_SHUTDOWN_PRIVILEGE);
	}

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::ExitWindows(SHORT mode, VARIANT_BOOL *pRetcode)
{
	if (!pRetcode) {
		return E_POINTER;
	}

	// Vbg_ER
	DWORD dwReason =  SHTDN_REASON_MAJOR_APPLICATION
					| SHTDN_REASON_MINOR_MAINTENANCE
					| SHTDN_REASON_FLAG_PLANNED;

	UINT flg = EWX_LOGOFF;
	switch (mode & 0x0f) {
		case 0:
		default:
			flg = EWX_LOGOFF;
			dwReason = 0; // OItɂ͗R͂ȂB
			break;

		case 1:
			flg = EWX_POWEROFF;
			break;

		case 2:
			{
				if (IsWindowsVistaOrGreater()) {
					// Vistaȍ~ (ver2Œǉ)
#ifndef EWX_RESTARTAPPS
#define EWX_RESTARTAPPS     0x00000040
#endif /* _WIN32_WINNT >= 0x0600 */
					flg = EWX_RESTARTAPPS;
				} else {
					// VistaȑO(2000/XP)
					flg = EWX_REBOOT;
				}
			}
			break;

		case 3:
			// PCœdOFF𐧌łȂ̖cB
			// XPSP1ȍ~A}VœdfłꍇEWX_POWEROFFƓB
			flg = EWX_SHUTDOWN;
			break;
	}

	if (mode > 0x0f) {
		flg |= EWX_FORCEIFHUNG; // Ver2EWX_FORCEύXB
	}

	// WindowsXPȍ~APOWEROFF/REBOOT/SHUTDOWN̏ꍇALɂKvB
	// Ver2ŒǉB
	if (mode & EWX_POWEROFF || mode & EWX_REBOOT || mode & EWX_SHUTDOWN) {
		HRESULT hr;
		if (FAILED(hr = PrivilegeShutdown())) {
			// Vbg_EsgłB
			return hr;
		}
	}
	
	// ScriptScriptDialog͑Θb[hŎĝ InitiateSystemShutdownEx ł͂ȂB
	if (!ExitWindowsEx(flg, dwReason)) {
		return HRESULT_FROM_WIN32(GetLastError());
	}

	*pRetcode = VARIANT_TRUE; // ver1ł͐̉ۂԂĂAVer2ł̓G[ƂB

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::GetSpecialFolderPath(SPECIALFOLDERTYPE folderId, VARIANT *pResult)
{
	if (!pResult) {
		return E_POINTER;
	}

	// 
	VariantInit(pResult);
	pResult->vt = VT_NULL;

	// VF̃AP[^擾
	HRESULT hr;
	CComPtr<IMalloc> pMalloc(NULL);
	if (FAILED(hr = SHGetMalloc(&pMalloc))) {
		return hr;
	}

	// tH_̃pX擾
	hr = S_FALSE;
	LPITEMIDLIST pidlist;
	if (SUCCEEDED(SHGetSpecialFolderLocation(NULL, folderId, &pidlist))) {
		TCHAR path[MAX_PATH];
		if (SHGetPathFromIDList(pidlist, path)) {
			// pX擾łꍇ
			pResult->vt = VT_BSTR;
			pResult->bstrVal = SysAllocString(path);
			hr = S_OK;
		}
		pMalloc->Free(pidlist);
	}

	return hr;
}

STDMETHODIMP CScrDlgRoot::CreateOutputWindow(IOutputWindow **ppOutputWindow)
{
	if (!ppOutputWindow) {
		return E_POINTER;
	}

	CComObject<COutputWindow> *pOutputWindow = NULL;
	HRESULT hr = CComObject<COutputWindow>::CreateInstance(&pOutputWindow);
	if (FAILED(hr)){
		return hr;
	}

	*ppOutputWindow = NULL;
	return pOutputWindow->QueryInterface(IID_IOutputWindow, reinterpret_cast<void**>(ppOutputWindow));
}

STDMETHODIMP CScrDlgRoot::DoEvents(VARIANT timeout, SHORT *pEventcode)
{
	if (!pEventcode) {
		return E_POINTER;
	}

	// Ver2ҋ@Ԃݒ\ƂBIvVB
	DWORD dwTimeout = 0;
	if (!IsNullOrError(&timeout)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &timeout, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_I2);
		if (tmp.iVal < 0) {
			dwTimeout = 0;
		} else {
			dwTimeout = tmp.iVal * 10; // 10mSecPʂmSecɕ␳ACUserForm::WaitEventƂ킹B
		}
	}

	// bZ[W邩A^CAEg܂őҋ@
	DWORD reason = MsgWaitForMultipleObjects(0, NULL, FALSE, dwTimeout, QS_ALLINPUT);
	ATLASSERT(reason != 0xffffffff);

	// ^CAEgǂɊւ炸bZ[W[vĂ
	HRESULT hr = DoMessageLoop();

	// ߂l͏0
	*pEventcode = 0;

	return hr;
}

STDMETHODIMP CScrDlgRoot::Sleep(SHORT tim)
{
	::Sleep(tim);
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::GetTempPath(BSTR *pTempPath)
{
	if (!pTempPath) {
		return E_POINTER;
	}

	TCHAR tempPath[MAX_PATH];
	if (!::GetTempPath(MAX_PATH, tempPath)) {
		// ꎞfBNg̎擾Ɏsꍇ
		DWORD errcode = GetLastError();
		return HRESULT_FROM_WIN32(errcode);
	}

	*pTempPath = SysAllocString(tempPath);

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::GetTempFileName(VARIANT varTempDir, VARIANT varTempPrefix, VARIANT *pTempFileName)
{
	if (!pTempFileName) {
		return E_POINTER;
	}
	VariantInit(pTempFileName);
	pTempFileName->vt = VT_NULL;

	// e|fBNg̎w擾
	CComBSTR tempDir;
	if (!IsNullOrError(&varTempDir)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varTempDir, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		tempDir.Attach(tmp.bstrVal);
	}
	if (tempDir.Length() == 0) {
		// Ȃ΃Jg
		tempDir = L".";
	}

	// ꎞt@C̃vtBbNXw擾B
	CComBSTR tempPrefix;
	if (!IsNullOrError(&varTempPrefix)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varTempPrefix, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		tempPrefix.Attach(tmp.bstrVal);
	}
	if (tempPrefix.Length() == 0) {
		// Ȃ΁utmpvvtBbNXƂ
		tempPrefix = L"tmp";
	}

	// ꎞt@C̍쐬
	TCHAR tempFileName[MAX_PATH];
	if (!::GetTempFileName(tempDir, tempPrefix, 0, tempFileName)) {
		// ꎞt@C̍쐬Ɏsꍇ
		DWORD errcode = GetLastError();
		return HRESULT_FROM_WIN32(errcode);
	}

	pTempFileName->vt = VT_BSTR;
	pTempFileName->bstrVal = SysAllocString(tempFileName);
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::GetFileAttributes(BSTR path, LONG *pAttributes)
{
	if (!pAttributes) {
		return E_POINTER;
	}

	*pAttributes = ::GetFileAttributes(path);

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::GetFileLastWriteTime(BSTR path, VARIANT *pFileTime)
{
	if (!pFileTime) {
		return E_POINTER;
	}
	VariantInit(pFileTime);
	pFileTime->vt = VT_NULL;

	HANDLE handle = CreateFile(path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (handle != INVALID_HANDLE_VALUE) {
		COleDateTime fileTime;
		FILETIME ftWrite, ftCreation, ftLastAccess;
		if (GetFileTime(handle, &ftCreation, &ftLastAccess, &ftWrite)) {
			fileTime = ftLastAccess;
			pFileTime->vt = VT_DATE;
			pFileTime->date = fileTime.m_dt;
		}
		CloseHandle(handle);
	}

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::GetFileCreationTime(BSTR path, VARIANT *pFileTime)
{
	if (!pFileTime) {
		return E_POINTER;
	}
	VariantInit(pFileTime);
	pFileTime->vt = VT_NULL;

	HANDLE handle = CreateFile(path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (handle != INVALID_HANDLE_VALUE) {
		COleDateTime fileTime;
		FILETIME ftWrite, ftCreation, ftLastAccess;
		if (GetFileTime(handle, &ftCreation, &ftLastAccess, &ftWrite)) {
			fileTime = ftCreation;
			pFileTime->vt = VT_DATE;
			pFileTime->date = fileTime.m_dt;
		}
		CloseHandle(handle);
	}

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::MessageBox(BSTR mes, VARIANT varTitle, VARIANT varMode, SHORT *pRetcode)
{
	if (!pRetcode) {
		return E_POINTER;
	}

	CComBSTR title;
	if (!IsNullOrError(&varTitle)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varTitle, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		title.Attach(tmp.bstrVal);
	}
	if (title.Length() == 0) {
		title.LoadString(IDS_MESSAGEBOXDEFAULTTITLE);
	}

	DWORD mode = MB_OK | MB_ICONERROR; // ftHg
	if (!IsNullOrError(&varMode)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varMode, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		int btn = tmp.iVal % 10;
		int icn = tmp.iVal / 10;
		switch (btn) {
			case MESSAGEBOXMODE_OK:
				mode = MB_OK;
				break;

			case MESSAGEBOXMODE_OKCANCEL:
				mode = MB_OKCANCEL;
				break;

			case MESSAGEBOXMODE_YESNO:
				mode = MB_YESNO;
				break;

			case MESSAGEBOXMODE_YESNOCANCEL:
				mode = MB_YESNOCANCEL;
				break;

			case MESSAGEBOXMODE_RETRYCANCEL:
				mode = MB_RETRYCANCEL;
				break;

			case MESSAGEBOXMODE_ABORTRETRYIGNORE:
				mode = MB_ABORTRETRYIGNORE;
				break;

			default:
				mode = MB_OK;
				break;
		}
		switch (icn * 10) {
			case MESSAGEBOXICON_ERROR:
				mode |= MB_ICONERROR;
				break;

			case MESSAGEBOXICON_INFORMATION:
				mode |= MB_ICONINFORMATION;
				break;

			case MESSAGEBOXICON_QUESTION:
				mode |= MB_ICONQUESTION;
				break;

			case MESSAGEBOXICON_NORMAL:
			default:
				break;
		}
	}
	mode |= MB_TASKMODAL | MB_SETFOREGROUND;

	int retcode = ::MessageBox(::GetActiveWindow(), mes, title, mode);
	
	int result = -1;

	if (retcode == IDOK || retcode == IDYES || retcode ==IDRETRY) {
		result = 1;
	}
	
	if (retcode == IDNO || retcode == IDIGNORE) {
		result = 0;
	}
	
	*pRetcode = retcode;
	return result == 1 ? S_OK : S_FALSE;
}

STDMETHODIMP CScrDlgRoot::FloatS(double value, VARIANT varLen, BSTR *pRet)
{
	if (!pRet) {
		return E_POINTER;
	}

	int nLen = m_defaultFS;
	if (!IsNullOrError(&varLen)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varLen, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_I2);
		nLen = tmp.iVal;
	}

	if (nLen < 0) {
		// w茅ʒuVtĝA_ȉ͔\ƂB
		nLen = -nLen;
		double xb = pow((double) 10, (double) nLen);
		const int bufsiz = nLen + 64;
		std::vector<TCHAR> buf(bufsiz); // ͍őł64ɂȂƑz
		_stprintf_s(&buf[0], bufsiz, _T("%.0lf"), value * xb);
		*pRet = SysAllocString(&buf[0]);

	} else {
		// w
		const int fmtsiz = 64;
		TCHAR fmt[fmtsiz];
		_stprintf_s(fmt, fmtsiz, _T("%%.%dlf"), nLen);
		const int bufsiz = nLen + 32;
		std::vector<TCHAR> buf(bufsiz); // ͍őł32ɂȂƑz
		_stprintf_s(&buf[0], bufsiz, fmt, value);
		*pRet = SysAllocString(&buf[0]);
	}

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::IntS(long value, VARIANT varLen, BSTR *pRet)
{
	if (!pRet) {
		return E_POINTER;
	}

	int nLen = m_defaultIS;
	if (!IsNullOrError(&varLen)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varLen, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_I2);
		nLen = tmp.iVal;
	}

	// tB[h̕擾
	int width;
	if (nLen < 0) {
		width = -nLen;
	} else {
		width = nLen;
	}

	// obt@̊m
	std::vector<TCHAR> fmt(64);
	std::vector<TCHAR> buf(width + 16); // ͍őł16ɂȂƑzB

	if (nLen < 0) {
		// 󔒋l
		_stprintf_s(&fmt[0], fmt.size(), _T("%%%dld"), width);
	} else {
		// [
		_stprintf_s(&fmt[0], fmt.size(), _T("%%0%dld"), width);
	}

	_stprintf_s(&buf[0], buf.size(), &fmt[0], value);

	*pRet = SysAllocString(&buf[0]);

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::IsEqual(double val1, double val2, VARIANT varTolerance, VARIANT_BOOL *pResult)
{
	if (!pResult) {
		return E_POINTER;
	}

	double tolerance = m_defaultTolerance;
	if (!IsNullOrError(&varTolerance)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varTolerance, VARIANT_NOUSEROVERRIDE, VT_R8);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_R8);
		tolerance = tmp.dblVal;
	}

	*pResult = (abs(val1 - val2) <= tolerance) ? VARIANT_TRUE : VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::IsPointEqual(double x1, double y1, double x2, double y2, VARIANT varTolerance, VARIANT_BOOL *pResult)
{
	if (!pResult) {
		return E_POINTER;
	}

	double tolerance = m_defaultTolerance;
	if (!IsNullOrError(&varTolerance)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &varTolerance, VARIANT_NOUSEROVERRIDE, VT_R8);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_R8);
		tolerance = tmp.dblVal;
	}

	double len = sqrt(pow((x1 - x2), 2) + pow((y1 - y2), 2));
	*pResult = (len <= tolerance) ? VARIANT_TRUE : VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::CreateList(IVarArray **ppCreatedList)
{
	if (!ppCreatedList) {
		return E_POINTER;
	}

	CComObject<CVarArray> *pList = NULL;
	HRESULT hr = CComObject<CVarArray>::CreateInstance(&pList);
	if (FAILED(hr)){
		return hr;
	}

	*ppCreatedList = NULL;
	return pList->QueryInterface(IID_IVarArray, reinterpret_cast<void**>(ppCreatedList));
}

STDMETHODIMP CScrDlgRoot::ChangeExtensionName(BSTR path, BSTR newExtentionName, BSTR *pNewPath)
{
	if (!pNewPath) {
		return E_POINTER;
	}

	int len1 = SysStringLen(path);
	int len2 = SysStringLen(newExtentionName);

	std::vector<OLECHAR> buf(len1 + len2 + 2); // gqǉ̃hbgP[XƏI[܂
	LPOLESTR pBuf = &buf[0];
	memcpy(pBuf, path, sizeof(OLECHAR) * len1);

	LPOLESTR p = pBuf; // obt@̐擪

	while (*p) p++; // I[݂
	LPOLESTR pEnd = p;

	// pX؂̖[ɂŌ̃hbg擾B
	LPOLESTR pDot = NULL;
	while (p > pBuf) {
		if (*p == '.') {
			// hbg𔭌
			pDot = p;
			break;
		}
		if (*p == '/' || *p == '\\') {
			// [łȂȂ̂Œ~
			break;
		}
		p--;
	}

	if (pDot != NULL) {
		// ̊gq
		if (len2 == 0) {
			// V炵gqȂ
			*pDot = 0;
		} else {
			// V炵gqɒu
			memcpy(pDot + 1, newExtentionName, sizeof(OLECHAR) * (len2 + 1));
		}
	} else {
		// ̊gqȂ
		if (len2 == 0) {
			// VgqȂ -> 
		} else {
			// gq邽߁AhbgĊgqAB
			memcpy(pEnd, L".", sizeof(OLECHAR) * 1);
			memcpy(pEnd + 1, newExtentionName, sizeof(OLECHAR) * (len2 + 1));
		}
	}

	*pNewPath = SysAllocString(pBuf);

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::get_ProfileValue(BSTR name, VARIANT section, BSTR *pValue)
{
	if (m_profilePath.Length() == 0) {
		// ݒt@Cւ̃pXwł
		return HRESULT_FROM_WIN32(ERROR_INVALID_STATE);
	}

	if (SysStringLen(name) == 0) {
		// ݒ薼͕K{
		return E_INVALIDARG;
	}

	// ߂l̏
	if (!pValue) {
		return E_POINTER;
	}

	// ZNVw肳ĂΎoBȂ΃ftHgpB
	CComBSTR sect;
	if (!IsNullOrError(&section)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &section, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		sect.Attach(tmp.bstrVal);
	}
	if (sect.Length() == 0) {
		sect.LoadString(IDS_PROFILESECTIONNAME);
	}

	const size_t bufsiz = 4096;
	TCHAR buf[bufsiz] = {0};
	
	DWORD ret = GetPrivateProfileString(sect, name, _T(""), buf, bufsiz, m_profilePath);
	*pValue = SysAllocString(buf);

	// ǂݍ݂ɎsĂG[Ƃ͂ȂB
	return ret ? S_OK : S_FALSE;
}

STDMETHODIMP CScrDlgRoot::put_ProfileValue(BSTR name, VARIANT section, BSTR newValue)
{
	if (m_profilePath.Length() == 0) {
		// ݒt@Cւ̃pXwł
		return HRESULT_FROM_WIN32(ERROR_INVALID_STATE);
	}

	if (SysStringLen(name) == 0) {
		// ݒ薼͕K{
		return E_INVALIDARG;
	}

	// ZNVw肳ĂΎoBȂ΃ftHgpB
	CComBSTR sect;
	if (!IsNullOrError(&section)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &section, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		sect.Attach(tmp.bstrVal);
	}
	if (sect.Length() == 0) {
		sect.LoadString(IDS_PROFILESECTIONNAME);
	}

	// NULL͋󕶎ƌȂB
	LPCWSTR lpszNewValue;
	if (newValue == NULL) {
		lpszNewValue = L"";
	} else {
		lpszNewValue = newValue;
	}

	if (::WritePrivateProfileString(sect, name, lpszNewValue, m_profilePath)) {
		return S_OK;
	}

	// ݂ɎsĂG[Ƃ͂ȂB
	return S_FALSE;
}

STDMETHODIMP CScrDlgRoot::CopyFile(BSTR src, BSTR dist, VARIANT overwrite, VARIANT_BOOL *pResult)
{
	if (!pResult) {
		return E_POINTER;
	}
	if (src == NULL || dist == NULL) {
		return E_INVALIDARG;
	}

	BOOL bOverwrite = FALSE;
	if (!IsNullOrError(&overwrite)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &overwrite, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_I2);
		bOverwrite = tmp.iVal ? TRUE : FALSE;
		VariantClear(&tmp);
	}
	
	VARIANT_BOOL ret = ::CopyFile(src, dist, bOverwrite) ? VARIANT_TRUE : VARIANT_FALSE;

	*pResult = ret;
	return ret ? S_OK : S_FALSE;
}

STDMETHODIMP CScrDlgRoot::MoveFile(BSTR src, BSTR dist, VARIANT overwrite, VARIANT_BOOL *pResult)
{
	HRESULT hr = CopyFile(src, dist, overwrite, pResult);
	if (SUCCEEDED(hr) && *pResult) {
		// ߂l|C^LRs[̏ꍇ̂
		::DeleteFile(src);
	}
	return hr;
}

STDMETHODIMP CScrDlgRoot::WaitCursor(SHORT enableWaitCursor)
{
	HCURSOR hWait;
	if (enableWaitCursor) {
		hWait = LoadCursor(NULL, IDC_WAIT);
	} else {
		hWait = LoadCursor(NULL, IDC_ARROW);
	}

	::SetCursor(hWait);

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::GetLocalPathName(BSTR orgPath, VARIANT *pNewPath)
{
	if (!pNewPath) {
		return E_POINTER;
	}
	VariantInit(pNewPath);
	pNewPath->vt = VT_NULL;

	if (SysStringLen(orgPath) == 0) {
		// Ȃ̂ŕϊ
		return S_FALSE;
	}

	// fileXL[}`?
	if (UrlIsFileUrl(orgPath)) {
		TCHAR pathBuf[MAX_PATH];
		DWORD siz = MAX_PATH;
		if (SUCCEEDED(PathCreateFromUrl(orgPath, pathBuf, &siz, NULL))) {
			// pX擾
			pNewPath->vt = VT_BSTR;
			pNewPath->bstrVal = SysAllocString(pathBuf);
			return S_OK;
		}
		// 擾Ɏs
		return S_FALSE;
	}

	// UNC`?
	if (PathIsUNC(orgPath)) {
		pNewPath->vt = VT_BSTR;
		pNewPath->bstrVal = SysAllocString(orgPath);
		return S_OK;
	}

	// ΃pX`?
	if (SysStringLen(orgPath) > 2) {
		if (orgPath[1] == ':') {
			// 2ڂhCu^[Ȃ΃pXƌȂOKƂB
			pNewPath->vt = VT_BSTR;
			pNewPath->bstrVal = SysAllocString(orgPath);
			return S_OK;
		}
	}

	// ȊO͂߁B
	return S_FALSE;
}

STDMETHODIMP CScrDlgRoot::FindWindow(BSTR clsname, BSTR caption, VARIANT *pWndHandle)
{
	// *NOTE* ̃\bh͂ƂƃwvɋLڂȂB

	if (!pWndHandle) {
		return E_POINTER;
	}

	VariantInit(pWndHandle);
	pWndHandle->vt = VT_NULL;

	if (caption && !caption[0]) {
		caption = NULL;
	}

	HWND hWnd = ::FindWindow(clsname, caption);
	if (hWnd) {
		pWndHandle->vt = VT_I4;
		pWndHandle->lVal = reinterpret_cast<LONG>(hWnd);
		return S_OK;
	}

	return S_FALSE;
}

STDMETHODIMP CScrDlgRoot::GetFileURL(BSTR orgPath, VARIANT *pFileURL)
{
	// ̃\bh̓eXg˂Ver2Œǉ܂B
	// GetLocalPathNameƑ΂ɂȂ܂B

	if (!pFileURL) {
		return E_POINTER;
	}

	VariantInit(pFileURL);
	pFileURL->vt = VT_NULL;

	TCHAR fileUrlBuf[4096];
	DWORD fileUrlBufSiz = 4096;
	if (SUCCEEDED(UrlCreateFromPath(orgPath, fileUrlBuf, &fileUrlBufSiz, NULL))) {
		pFileURL->vt = VT_BSTR;
		pFileURL->bstrVal = SysAllocString(fileUrlBuf);
		return S_OK;
	}
	
	return S_FALSE;
}


// IMessageLoopImpl

STDMETHODIMP CScrDlgRoot::DoMessageLoop()
{
	MSG msg = {0};

loopHead:
	while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {

		// _CAObZ[W
		POSITION pos = m_lstChkDialog.GetHeadPosition();
		while (pos) {
			HRESULT hr = m_lstChkDialog.GetNext(pos)->DoDialogMessage(&msg);
			if (hr == S_OK) {
				// _CAObZ[Wꍇ
				goto loopHead;
			}
		}

		// _CAObZ[WłȂꍇ
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return S_OK;
}

STDMETHODIMP CScrDlgRoot::RegisterDialog(ICheckDialogMessage *pDlg)
{
	if (!pDlg) {
		return E_INVALIDARG;
	}

	m_lstChkDialog.AddHead(pDlg);

	return S_OK;
}

STDMETHODIMP CScrDlgRoot::UnregisterDialog(ICheckDialogMessage *pDlg)
{
	if (!pDlg) {
		return E_INVALIDARG;
	}

	bool removed = false;
	POSITION pos = m_lstChkDialog.GetHeadPosition();
	while (pos) {
		POSITION oldpos = pos;
		if (m_lstChkDialog.GetNext(pos) == pDlg) {
			m_lstChkDialog.RemoveAt(oldpos);
			removed = true; // ꉞAS̍ڂĂ܂B
		}
	}

	return removed ? S_OK : S_FALSE;
}

/**
 * ؂蕶ŕʂVBScriptpSafeArrayzԂ܂B
 * 񂪋̏ꍇ1̋̕񂪊i[ꂽz񂪕Ԃ܂B
 * NULL/EMPTY/ERROȐꍇ́Au̔zvԂ܂B
 * @param varText ؂蕶ŋ؂ꂽANULL/ERROR/EMPTY
 * @param varDelimiter ؂蕶Aȗ́u;vB󕶎w肵ꍇ͋؂蕶Ȃ
 * @param pArray SAFEARRAYi[VARIANTւ̃|C^
 * @return HRESULT
 */
STDMETHODIMP CScrDlgRoot::ConvertStringToArray(VARIANT varText, VARIANT varDelimiter, VARIANT *pArray)
{
	if (!pArray) {
		return E_POINTER;
	}

	HRESULT hr;

	// Ώە̎擾

	if (IsNullOrError(&varText)) {
		// Null܂Errorl̏ꍇA̔zԂB
		VariantInit(pArray);
		pArray->vt = VT_ARRAY | VT_VARIANT;
		pArray->parray = SafeArrayCreateVector(VT_VARIANT, 0, 0);
		return S_OK;
	}

	CComVariant text;
	hr = VariantChangeType(&text, &varText, VARIANT_NOUSEROVERRIDE, VT_BSTR);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(text.vt == VT_BSTR);

	// ؂蕶̎擾
	WCHAR delimiter = ';'; 
	hr = GetDelimiterChar(varDelimiter, &delimiter);
	if (FAILED(hr)) {
		return hr;
	}

	return ArrayUtil::DelimitedStringToSafeArray(text.bstrVal, delimiter, pArray);
}

STDMETHODIMP CScrDlgRoot::ConvertArrayToString(VARIANT arr, VARIANT varDelimiter, VARIANT *pRet)
{
	if (!pRet) {
		return E_POINTER;
	}
	VariantInit(pRet);
	pRet->vt = VT_NULL;

	HRESULT hr;

	SAFEARRAY *pSafeArray = NULL;
	hr = ArrayUtil::GetSafeArrayFromVariant(&arr, &pSafeArray);
	if (hr == S_FALSE || FAILED(hr)) {
		// NULL/ERROR/EMPTYł邩A
		// SAFEARRAYȊOi[Ăꍇ
		return hr;
	}

	// SAFEARRAY̊i[^擾
	VARTYPE vt = VT_NULL;
	hr = SafeArrayGetVartype(pSafeArray, &vt);
	if (FAILED(hr)) {
		return hr;
	}
	if (vt != VT_VARIANT && vt != VT_BSTR) {
		// VARIANTzSTRINGẑ݃T|[g
		return E_INVALIDARG;
	}

	// z̎擾
	UINT numOfDim = SafeArrayGetDim(pSafeArray);
	if (numOfDim != 1) {
		// ꎟẑ݃T|[g
		return E_INVALIDARG;
	}

	// vf̎擾
	LONG lBound = 0, uBound = 0, numOfElements = 0;
	hr = SafeArrayGetLBound(pSafeArray, 1, &lBound);
	if (FAILED(hr)) {
		return hr;
	}
	hr = SafeArrayGetUBound(pSafeArray, 1, &uBound);
	if (FAILED(hr)) {
		return hr;
	}
	numOfElements = uBound - lBound + 1;
	
	// vf̏ꍇ
	if (numOfElements == 0) {
		// NULLԂB
		return S_OK;
	}

	// ؂蕶̎擾
	WCHAR delimiter = ';'; 
	hr = GetDelimiterChar(varDelimiter, &delimiter);
	if (FAILED(hr)) {
		return hr;
	}

	// zǂݎ蕶ɕϊ

	CComBSTR result;

	for (LONG idx = lBound; idx <= uBound; idx++) {
		ATLASSERT(vt == VT_VARIANT || vt == VT_BSTR);

		CComBSTR itemVal;
		long indices[] = {idx};

		if (vt == VT_VARIANT) {
			CComVariant tmp;
			hr = SafeArrayGetElement(pSafeArray, &indices[0], reinterpret_cast<void*>(&tmp));
			if (FAILED(hr)) {
				return hr;
			}
			hr = tmp.ChangeType(VT_BSTR);
			if (FAILED(hr)) {
				return hr;
			}
			ATLASSERT(tmp.vt == VT_BSTR);

			tmp.vt = VT_EMPTY; // detach
			itemVal.Attach(tmp.bstrVal);

		} else if (vt == VT_BSTR) {
			hr = SafeArrayGetElement(pSafeArray, &indices[0], reinterpret_cast<void*>(&itemVal));
			if (FAILED(hr)) {
				return hr;
			}
		}

		if (idx != lBound && delimiter != 0) {
			result.Append(delimiter);
		}

		if (itemVal.Length() > 0) {
			result.Append(itemVal);
		}
	}

	BSTR ret = result.Detach();
	if (ret) {
		pRet->vt = VT_BSTR;
		pRet->bstrVal = ret;
	} else {
		pRet->vt = VT_BSTR;
		pRet->bstrVal = SysAllocString(L"");
	}
	
	return S_OK;
}

HRESULT CScrDlgRoot::GetDelimiterChar(const VARIANT &varDelimiter, WCHAR *pDelimiter) throw()
{
	if (!pDelimiter) {
		return E_POINTER;
	}

	// ؂蕶̎擾
	if (IsNullOrError(&varDelimiter)) {
		return S_FALSE;
	}

	CComVariant tmp;
	HRESULT hr = VariantChangeType(&tmp, &varDelimiter, VARIANT_NOUSEROVERRIDE, VT_BSTR);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(tmp.vt == VT_BSTR);

	WCHAR delimiter;
	if (SysStringLen(tmp.bstrVal) > 0) {
		if (IS_HIGH_SURROGATE(tmp.bstrVal[0])) {
			// TQ[gyA̓T|[gȂ
			return Error(IDS_UNSUPPORTED_SEPARATE_CHAR);
		}
		delimiter = tmp.bstrVal[0];

	} else {
		// 󕶎̏ꍇA؂蕶͂ȂƓB
		delimiter = 0;
	}

	*pDelimiter = delimiter;

	return S_OK;
}
