#include "stdafx.h"

#include "ControlComponent.h"

#include "ArrayUtil.h"
#include "CommOpenFileName.h"

#include <vector>


// _~[Rg[p
DummyControlComponent::DummyControlComponent()
	: ControlComponent()
{
}

DummyControlComponent::~DummyControlComponent() throw()
{
}

HRESULT DummyControlComponent::Compose(WORD &nChildId, HWND hParent) throw()
{
	return S_OK;
}

HRESULT DummyControlComponent::Destroy(void) throw()
{
	return S_OK;
}

HRESULT DummyControlComponent::HasChildId(WORD childId) throw()
{
	return S_FALSE;
}

HRESULT DummyControlComponent::IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw()
{
	if (!pEventId) {
		return E_POINTER;
	}

	*pEventId = 0;

	return S_FALSE;
}

UINT DummyControlComponent::GetLineCount() throw()
{
	return 0;
}

HRESULT DummyControlComponent::DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw()
{
	return S_FALSE;
}

HRESULT DummyControlComponent::get_Value(BSTR *pValue) throw()
{
	if (!pValue) {
		return E_POINTER;
	}

	*pValue = SysAllocStringLen(NULL, 0);

	return S_FALSE;
}

HRESULT DummyControlComponent::put_Value(BSTR value) throw()
{
	return S_FALSE;
}

HRESULT DummyControlComponent::get_IsModified(VARIANT_BOOL *pResult) throw()
{
	if (!pResult) {
		return E_POINTER;
	}

	*pResult = VARIANT_FALSE;

	return S_FALSE;
}

HRESULT DummyControlComponent::get_Enable(VARIANT_BOOL *pEnabled) throw()
{
	if (!pEnabled) {
		return E_POINTER;
	}

	*pEnabled = VARIANT_TRUE;

	return S_FALSE;
}

HRESULT DummyControlComponent::put_Enable(VARIANT_BOOL enabled) throw()
{
	return S_FALSE;
}

/**
 * R|[lg\z܂B
 * @param ppComponent i[|C^
 * @return HRESULT
 */
HRESULT DummyControlComponent::Create(ControlComponent **ppComponent) throw()
{
	if (!ppComponent) {
		return E_POINTER;
	}
	ATLASSERT(!*ppComponent);

	*ppComponent = new DummyControlComponent();

	return S_OK;
}




// xp
LabelControlComponent::LabelControlComponent()

: ControlComponent()
	, m_hWnd(NULL)
	, m_enabled(VARIANT_TRUE)
{
}

LabelControlComponent::~LabelControlComponent() throw()
{
	ATLASSERT(m_hWnd == NULL);
}

HRESULT LabelControlComponent::Create(BSTR text, ControlComponent** ppCompo) throw()
{
	if (!ppCompo) {
		return E_POINTER;
	}

	CAutoPtr<LabelControlComponent> pLabel(new LabelControlComponent());

	HRESULT hr;
	if (FAILED(hr = pLabel->put_Value(text))) {
		return hr;
	}

	ATLASSERT(!*ppCompo);
	*ppCompo = pLabel.Detach();

	return S_OK;
}

UINT LabelControlComponent::GetLineCount() throw()
{
	// 1s
	return 1;
}

HRESULT LabelControlComponent::Compose(WORD &nChildId, HWND hParent) throw()
{
	ATLASSERT(::IsWindow(hParent));
	ATLASSERT(m_hWnd == NULL);
	ATLASSERT(nChildId > 0);

	try {

		LPCTSTR caption;
		if (m_text) {
			caption = m_text;
		} else {
			caption = _T("");
		}

		m_hWnd = CreateWindow(_T("STATIC"), caption,
			WS_VISIBLE | WS_CHILD | WS_GROUP | SS_CENTERIMAGE,
			0, 0, 0, 0,
			hParent, reinterpret_cast<HMENU>(nChildId), NULL, NULL);

		if (m_hWnd == NULL) {
			AtlThrowLastWin32();
		}
		
		// tHg̐ݒ
		CWindow wndStatic(m_hWnd);
		CWindow wndDialog(hParent);

		wndStatic.SetFont(wndDialog.GetFont());

		// LE
		wndStatic.EnableWindow(m_enabled ? TRUE : FALSE);

	} catch (CAtlException &ex) {
		Destroy();
		return ex.m_hr;
	}

	nChildId++;
	return S_OK;
}

HRESULT LabelControlComponent::Destroy(void) throw()
{
	if (!::IsWindow(m_hWnd)) {
		return S_FALSE;
	}

	DestroyWindow(m_hWnd);
	m_hWnd = NULL;

	return S_OK;
}

HRESULT LabelControlComponent::IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw()
{
	if (!pEventId) {
		return E_POINTER;
	}

	ATLASSERT(HasChildId(childId) == S_OK);

	*pEventId = 0;

	return S_FALSE;
}

HRESULT LabelControlComponent::HasChildId(WORD childId) throw()
{
	CWindow labelWnd(m_hWnd);
	if (labelWnd.IsWindow()) {
		if (childId == labelWnd.GetWindowLong(GWL_ID)) {
			return S_OK;
		}
	}
	return S_FALSE;
}

HRESULT LabelControlComponent::DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw()
{
	ATLASSERT(::IsWindow(hParent));
	ATLASSERT(::IsWindow(m_hWnd));

	SetWindowPos(m_hWnd, NULL,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);

	return S_OK;
}

HRESULT LabelControlComponent::get_Value(BSTR *pValue) throw()
{
	return m_text.CopyTo(pValue);
}

HRESULT LabelControlComponent::put_Value(BSTR value)
{
	m_text = value;

	// \̏ꍇAXVB
	if (::IsWindow(m_hWnd)) {
		if (value) {
			::SetWindowText(m_hWnd, value);
		} else {
			::SetWindowText(m_hWnd, _T(""));
		}
	}

	return S_OK;
}

HRESULT LabelControlComponent::get_IsModified(VARIANT_BOOL *pResult) throw()
{
	if (!pResult) {
		return E_POINTER;
	}

	// xGUIŕύXȂ̂ŏFALSEƂB
	*pResult = VARIANT_FALSE;

	return S_FALSE;
}

HRESULT LabelControlComponent::get_Enable(VARIANT_BOOL *pEnabled) throw()
{
	if (!pEnabled) {
		return E_POINTER;
	}

	*pEnabled = m_enabled;

	return S_OK;
}

HRESULT LabelControlComponent::put_Enable(VARIANT_BOOL enabled) throw()
{
	m_enabled = enabled;

	if (::IsWindow(m_hWnd)) {
		CWindow wndStatic(m_hWnd);
		wndStatic.EnableWindow(m_enabled ? TRUE : FALSE);
	}

	return S_OK;
}


// GfBbg{bNXp

MultiEditControlComponent::MultiEditControlComponent()
	: ControlComponent()
	, m_hLabelWnd(NULL)
	, m_hEditWnd(NULL)
	, m_lineCount(1)
	, m_enabled(VARIANT_TRUE)
{
}

MultiEditControlComponent::~MultiEditControlComponent() throw()
{
	ATLASSERT(m_hEditWnd == NULL);
	ATLASSERT(m_hLabelWnd == NULL);
}

HRESULT MultiEditControlComponent::InitInstance(VARIANT title, VARIANT initValue, VARIANT multiline) throw()
{
	// ^Cg̎擾
	m_label.Empty();
	if (!IsNullOrError(&title)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &title, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		m_label.Attach(tmp.bstrVal);
	}

	// l̎擾
	m_value.Empty();
	if (!IsNullOrError(&initValue)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &initValue, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		m_value.Attach(tmp.bstrVal);
	}
	m_initValue = m_value;

	// s̎擾
	m_lineCount = 1; // 1s
	if (!IsNullOrError(&multiline)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &multiline, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_I2);
		if (tmp.iVal > 1) {
			// 1ȉ1Ƃ݂ȂBȏ̏ꍇ̂݃Zbg
			m_lineCount = tmp.iVal;
		}
	}

	return S_OK;
}

HRESULT MultiEditControlComponent::Create(VARIANT title, VARIANT initValue, VARIANT multiline, ControlComponent** ppCompo) throw()
{
	if (!ppCompo) {
		return E_POINTER;
	}

	CAutoPtr<MultiEditControlComponent> pEditCompo(new MultiEditControlComponent());

	HRESULT hr = pEditCompo->InitInstance(title, initValue, multiline);
	if (FAILED(hr)) {
		return hr;
	}

	ATLASSERT(!*ppCompo);
	*ppCompo = pEditCompo.Detach();

	return S_OK;
}

UINT MultiEditControlComponent::GetLineCount() throw()
{
	return m_lineCount;
}

HRESULT MultiEditControlComponent::Compose(WORD &nChildId, HWND hParent) throw()
{
	ATLASSERT(::IsWindow(hParent));
	ATLASSERT(m_hLabelWnd == NULL);
	ATLASSERT(m_hEditWnd == NULL);

	WORD tempChildId = nChildId;
	try {
		// x񂪋܂NULLłȂ΃x̍\z
		if (m_label.Length() > 0) {
			m_hLabelWnd = CreateWindow(_T("STATIC"), m_label,
				WS_VISIBLE | WS_GROUP | WS_CHILD | SS_RIGHT | SS_CENTERIMAGE,
				0, 0, 0, 0,
				hParent, reinterpret_cast<HMENU>(tempChildId), NULL, NULL);

			if (m_hLabelWnd == NULL) {
				AtlThrowLastWin32();
			}
			tempChildId++;
		}

		// GfBbg{bNX̃^Cv
		DWORD dwEditStyle;
		if (m_lineCount > 1) {
			// s
			dwEditStyle = ES_MULTILINE | ES_AUTOVSCROLL | ES_WANTRETURN;
		} else {
			// Ps
			dwEditStyle = 0;
		}
		dwEditStyle |= ES_AUTOHSCROLL | WS_TABSTOP | WS_CHILD | WS_VISIBLE;

		// xȂEDITɃO[vJnw
		if (!::IsWindow(m_hLabelWnd)) {
			dwEditStyle |= WS_GROUP;
		}
		
		// GfBbg{bNX̍\z
		m_hEditWnd = CreateWindowEx(WS_EX_CLIENTEDGE, _T("EDIT"), // Ver1łWS_EX_OVERLAPPEDWINDOWw肳Ă
			_T(""), dwEditStyle,
			0, 0, 0, 0,
			hParent, reinterpret_cast<HMENU>(tempChildId), NULL, NULL);
		if (m_hEditWnd == NULL) {
			AtlThrowLastWin32();
		}
		tempChildId++;

		// eLXg̐ݒ
		HRESULT hr = SetUIValue();
		if (FAILED(hr)) {
			AtlThrow(hr);
		}

		// tHg̐ݒ

		CWindow wndDialog(hParent);

		if (::IsWindow(m_hLabelWnd)) {
			CWindow wndLabel(m_hLabelWnd);
			wndLabel.SetFont(wndDialog.GetFont());
		}

		CWindow wndEdit(m_hEditWnd);
		wndEdit.SetFont(wndDialog.GetFont());

		// LE̐ݒ

		if (::IsWindow(m_hLabelWnd)) {
			CWindow wndLabel(m_hLabelWnd);
			wndLabel.EnableWindow(m_enabled ? TRUE : FALSE);
		}
		wndEdit.EnableWindow(m_enabled ? TRUE : FALSE);

	} catch (CAtlException &ex) {

		Destroy();

		return ex.m_hr;
	}

	nChildId = tempChildId;
	return S_OK;
}

HRESULT MultiEditControlComponent::IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw()
{
	if (!pEventId) {
		return E_POINTER;
	}

	ATLASSERT(HasChildId(childId) == S_OK);

	*pEventId = 0;

	return S_FALSE;
}

HRESULT MultiEditControlComponent::HasChildId(WORD childId) throw()
{
	CWindow labelWnd(m_hLabelWnd);
	if (labelWnd.IsWindow()) {
		if (childId == labelWnd.GetWindowLong(GWL_ID)) {
			return S_OK;
		}
	}

	CWindow editWnd(m_hEditWnd);
	if (editWnd.IsWindow()) {
		if (childId == editWnd.GetWindowLong(GWL_ID)) {
			return S_OK;
		}
	}

	return S_FALSE;
}

HRESULT MultiEditControlComponent::Destroy(void) throw()
{
	if (!m_hLabelWnd && !m_hEditWnd) {
		return S_FALSE;
	}

	if (m_hLabelWnd) {
		DestroyWindow(m_hLabelWnd);
		m_hLabelWnd = NULL;
	}

	if (m_hEditWnd) {
		// jOɃeLXg擾
		// (ĵ߁A擾ɎsĂG[ɂ͂ȂB)
		GetUIValue();

		// j
		DestroyWindow(m_hEditWnd);
		m_hEditWnd = NULL;
	}

	ATLASSERT(m_hEditWnd == NULL);
	ATLASSERT(m_hLabelWnd == NULL);

	return S_OK;
}

HRESULT MultiEditControlComponent::DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw()
{
	ATLASSERT(::IsWindow(hParent));
	ATLASSERT(::IsWindow(m_hEditWnd));

	LONG width = rect.right - rect.left;
	LONG height = rect.bottom - rect.top;

	LONG labelWidth = 0;
	if (::IsWindow(m_hLabelWnd)) {
		// x̓EBhE1/4̃TCYƂ
		labelWidth = width / 4;

		SetWindowPos(m_hLabelWnd, NULL,
			rect.left, rect.top, labelWidth, height,
			SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);
	}

	// GfBbg{bNX̓̕xc
	LONG editWidth = width - labelWidth;
	SetWindowPos(m_hEditWnd, NULL,
		rect.left + labelWidth, rect.top, editWidth, height,
		SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);

	return S_OK;
}

HRESULT MultiEditControlComponent::get_Value(BSTR *pValue) throw()
{
	// \̏ꍇ͎擾B
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	return m_value.CopyTo(pValue);
}

HRESULT MultiEditControlComponent::put_Value(BSTR value) throw()
{
	m_value = value;
	m_initValue = value;

	// \̏ꍇAXVB
	HRESULT hr = SetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	return S_OK;
}

HRESULT MultiEditControlComponent::get_IsModified(VARIANT_BOOL *pResult) throw()
{
	if (!pResult) {
		return E_POINTER;
	}

	// \̏ꍇ͉ʂ̓e擾B
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	*pResult = (m_value != m_initValue) ? VARIANT_TRUE : VARIANT_FALSE;

	return S_OK;
}

HRESULT MultiEditControlComponent::get_Enable(VARIANT_BOOL *pEnabled) throw()
{
	if (!pEnabled) {
		return E_POINTER;
	}

	*pEnabled = m_enabled;

	return S_FALSE;
}

HRESULT MultiEditControlComponent::put_Enable(VARIANT_BOOL enabled) throw()
{
	m_enabled = enabled;

	// \̏ꍇAXVB
	if (::IsWindow(m_hEditWnd)) {
		CWindow editWnd(m_hEditWnd);
		editWnd.EnableWindow(m_enabled ? TRUE : FALSE);
	}
	if (::IsWindow(m_hLabelWnd)) {
		CWindow labelWnd(m_hLabelWnd);
		labelWnd.EnableWindow(m_enabled ? TRUE : FALSE);
	}

	return S_OK;
}


HRESULT MultiEditControlComponent::SetUIValue() throw()
{
	CWindow editWnd(m_hEditWnd);

	if (!editWnd.IsWindow()) {
		// \ĂȂ̂ŔfȂB
		return S_FALSE;
	}

	if (m_value) {
		if (!editWnd.SetWindowText(m_value)) {
			return HRESULT_FROM_WIN32(GetLastError());
		}
	} else {
		if (!editWnd.SetWindowText(L"")) {
			return HRESULT_FROM_WIN32(GetLastError());
		}
	}

	return S_OK;
}

HRESULT MultiEditControlComponent::GetUIValue() throw()
{
	CWindow editWnd(m_hEditWnd);

	if (!editWnd.IsWindow()) {
		// \ĂȂ̂Ŏ擾Ȃ
		return S_FALSE;
	}
	
	ATL::CString newValue; // BSTRɂƂCWindow::GetWindowTextɋP[XŃoO
	editWnd.GetWindowText(newValue);

	m_value = newValue;

	return S_OK;
}


// R}h{^p

CommandButtonControlComponent::CommandButtonControlComponent()
{
}

CommandButtonControlComponent::~CommandButtonControlComponent() throw()
{
}

HRESULT CommandButtonControlComponent::InitInstance(BSTR title, SHORT startEventCode) throw()
{
	LPCWSTR p = title;
	if (p == NULL) {
		p = L"";
	}

	SHORT eventCode = startEventCode;

	m_buttons.RemoveAll();
	while (p) {
		CAutoPtr<CommandButtonInfo> pCmdBtn(new CommandButtonInfo());

		p = ArrayUtil::GetNextToken(p, ';', &pCmdBtn->caption);

		pCmdBtn->eventId = eventCode++;
		pCmdBtn->hWnd = NULL;

		m_buttons.Add(pCmdBtn);
	}

	ATLASSERT(m_buttons.GetCount() > 0);

	return S_OK;
}

HRESULT CommandButtonControlComponent::Create(BSTR title, SHORT startEventCode, ControlComponent** ppCompo) throw()
{
	if (!ppCompo) {
		return E_POINTER;
	}

	CAutoPtr<CommandButtonControlComponent> pCommandButton(new CommandButtonControlComponent());

	HRESULT hr;
	if (FAILED(hr = pCommandButton->InitInstance(title, startEventCode))) {
		return hr;
	}

	ATLASSERT(!*ppCompo);
	*ppCompo = pCommandButton.Detach();

	return S_OK;
}

HWND CommandButtonControlComponent::CreateButton(HWND hParent, LPCTSTR caption, WORD nStartChildId, WORD offset) throw()
{
	DWORD dwStyle = 0;
	if (offset == 0) {
		dwStyle |= WS_GROUP;
	}
	HWND hWnd = ::CreateWindow(_T("BUTTON"), 
		caption,
		BS_PUSHBUTTON | WS_TABSTOP | WS_CHILD | WS_VISIBLE | dwStyle,
		0, 0, 0, 0,
		hParent, reinterpret_cast<HMENU>(nStartChildId + offset), NULL, NULL);
	return hWnd;
}

HRESULT CommandButtonControlComponent::IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw()
{
	if (!pEventId) {
		return E_POINTER;
	}

	ATLASSERT(HasChildId(childId) == S_OK);

	if (notifyCode == BN_CLICKED) {
		size_t mx = m_buttons.GetCount();
		for (size_t idx = 0; idx < mx; idx++) {
			CWindow wnd(m_buttons.GetAt(idx)->hWnd);
			if (wnd.IsWindow()) {
				if (wnd.GetWindowLong(GWL_ID) == childId) {
					*pEventId = m_buttons.GetAt(idx)->eventId;
					return S_OK;
				}
			}
		}
	}

	*pEventId = 0;
	return S_FALSE;
}

HRESULT CommandButtonControlComponent::get_Value(BSTR *pValue) throw()
{
	if (!pValue) {
		return E_POINTER;
	}

	// {^ɂ͒l͂Ȃ̂ŏɋԂB
	*pValue = SysAllocStringLen(NULL, 0);

	return S_OK;
}

HRESULT CommandButtonControlComponent::put_Value(BSTR value) throw()
{
	// {^ɂ͒l͂Ȃ̂ŏɖB
	return S_FALSE;
}

HRESULT CommandButtonControlComponent::get_IsModified(VARIANT_BOOL *pResult) throw()
{
	if (!pResult) {
		return E_POINTER;
	}

	// R}h{^͏ɁuύXȂvԂB
	*pResult = VARIANT_FALSE;

	return S_FALSE;
}


// `FbN{bNXp

CheckButtonControlComponent::CheckButtonControlComponent()
{
}

CheckButtonControlComponent::~CheckButtonControlComponent() throw()
{
}

HRESULT CheckButtonControlComponent::InitInstance(BSTR title, VARIANT initValue, VARIANT mode) throw()
{
	// [h̔
	SetVerticalMode(mode);

	// {^̍\z

	LPCWSTR p = title;
	if (p == NULL) {
		p = L"";
	}

	m_buttons.RemoveAll();
	while (p) {
		CAutoPtr<CheckboxInfo> pCmdBtn(new CheckboxInfo());

		p = ArrayUtil::GetNextToken(p, ';', &pCmdBtn->caption);

		pCmdBtn->hWnd = NULL;

		m_buttons.Add(pCmdBtn);
	}

	ATLASSERT(m_buttons.GetCount() > 0);


	// 

	if (!IsNullOrError(&initValue)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &initValue, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		m_initValue.Attach(tmp.bstrVal);
		m_value = m_initValue;

	} else {
		// ȗ͋B
		m_initValue.Empty();
		m_value.Empty();
	}

	return S_OK;
}

HRESULT CheckButtonControlComponent::Create(BSTR title, VARIANT initValue, VARIANT mode, ControlComponent** ppCompo) throw()
{
	if (!ppCompo) {
		return E_POINTER;
	}

	CAutoPtr<CheckButtonControlComponent> pCheckboxButton(new CheckButtonControlComponent());

	HRESULT hr;
	if (FAILED(hr = pCheckboxButton->InitInstance(title, initValue, mode))) {
		return hr;
	}

	// m
	ATLASSERT(!*ppCompo);
	*ppCompo = pCheckboxButton.Detach();

	return S_OK;
}

HWND CheckButtonControlComponent::CreateButton(HWND hParent, LPCTSTR caption, WORD nStartChildId, WORD offset) throw()
{
	// : Eɂ\zX^CقȂ̂
	// m_verticaltOtrue/falsêꂩɐݒ肳ĂKvB
	DWORD dwStyle = 0;
	if (!m_vertical) {
		dwStyle |= BS_PUSHLIKE;
	}
	if (offset == 0) {
		dwStyle |= WS_GROUP;
	}

	HWND hWnd = ::CreateWindow(_T("BUTTON"), 
		caption,
		BS_AUTOCHECKBOX | WS_TABSTOP | WS_TABSTOP | WS_CHILD | WS_VISIBLE | dwStyle,
		0, 0, 0, 0,
		hParent, reinterpret_cast<HMENU>(nStartChildId + offset), NULL, NULL);
	return hWnd;
}

HRESULT CheckButtonControlComponent::get_Value(BSTR *pValue) throw()
{
	// `FbNԂ擾
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	return m_value.CopyTo(pValue);
}

HRESULT CheckButtonControlComponent::put_Value(BSTR value) throw()
{
	m_value = value;
	m_initValue = value;

	// \̏ꍇAXVB
	HRESULT hr = SetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	return S_OK;
}

HRESULT CheckButtonControlComponent::get_IsModified(VARIANT_BOOL *pResult) throw()
{
	if (!pResult) {
		return E_POINTER;
	}

	// \̏ꍇ͉ʂ̓e擾B
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	// l͏ȗ\łAߕs肦B
	// ʕ\ɃXe[^X擾ꍇɂ
	// ݒl(m_value)̂قKߕsȂԂɂȂ邽߁Am_value쓮ƂB
	// Ver1ł͒Pɏlƌݒl̕rĂ
	// ԂӖĂĂύXƌȂƂB

	UINT mx = m_value.Length();
	UINT len = m_initValue.Length();
	VARIANT_BOOL modified = VARIANT_FALSE;

	for (UINT idx = 0; idx < mx; idx++) {
		WCHAR c1 = m_value[idx];
		if (c1 < '0' || c1 > '2') {
			// 0,1,2ȊO̒l0ƌȂ
			c1 = '0';
		}
		if (c1 == '2') {
			// BST_INDETERMINATE̓T|[gĂȂ̂ŁB
			c1 = '1';
		}
		WCHAR c2 = '0'; // s0Ƃ݂ȂB
		if (idx < len) {
			c2 = m_initValue[idx];
			if (c2 < '0' || c2 > '2') {
				// 0,1,2ȊO̒l0ƌȂ
				c2 = '0';
			}
		}
		if (c2 == '2') {
			// BST_INDETERMINATE̓T|[gĂȂ̂ŁB
			c2 = '1';
		}
		if (c1 != c2) {
			modified = VARIANT_TRUE;
			break;
		}
	}

	*pResult = modified;

	return S_OK;
}

HRESULT CheckButtonControlComponent::GetUIValue() throw()
{
	size_t mx = m_buttons.GetCount();
	ATLASSERT(mx > 0);

	std::vector<WCHAR> status(mx + 1); // I[̃[܂

	try {
		for (size_t idx = 0; idx < mx; idx++) {
			CAutoPtr<CheckboxInfo> &pCheckboxInfo = m_buttons.GetAt(idx);

			CWindow checkbox(pCheckboxInfo->hWnd);
			if (!checkbox.IsWindow()) {
				// EBhE\ĂȂꍇ͉S_FALSEԂB
				return S_FALSE;
			}

			// `FbNԂ₢킹
			LRESULT ret = checkbox.SendMessage(BM_GETCHECK);
			WCHAR ch;
			if (ret == BST_UNCHECKED) {
				ch = '0';
			} else if (ret == BST_CHECKED) {
				ch = '1';
			} else if (ret == BST_INDETERMINATE) {
				// : ݂̓T|[gĂȂB
				ch = '2';
			} else {
				// G[(0)̏ꍇ
				AtlThrow(E_FAIL);
			}

			status[idx] = ch;
		}
		status[mx] = 0;

		// BSTRɕϊĊi[B
		HRESULT hr;
		m_value.Empty();
		if (FAILED(hr = m_value.Append(&status[0], static_cast<int>(mx)))) {
			// s?
			AtlThrow(hr);
		}

		return S_OK;

	} catch (CAtlException &ex) {
		return ex.m_hr;
	}
}

HRESULT CheckButtonControlComponent::SetUIValue() throw()
{
	size_t mx = m_buttons.GetCount();
	ATLASSERT(mx > 0);

	size_t len = m_value.Length();

	try {
		for (size_t idx = 0; idx < mx; idx++) {
			
			// eݒl̓ǂݎ
			// `FbN{bNX̌ݒlsĂꍇA
			// ͐l͈̔͂0`2͈̔͂ɂȂꍇ0Ƃ݂ȂB
			WPARAM state = BST_UNCHECKED;
			if (idx < len) {
				WCHAR ch = m_value[idx];
				if (ch == '0') {
					state = BST_UNCHECKED;
				} else if (ch == '1' || ch == '2') {
					// BST_INDETERMINATE(2)̓T|[gĂ炸ABST_CHECKEDƓB
					// Ver1ł́A1܂2w肷邱ƂŎICHECKEDƂȂĂ߁B
					state = BST_CHECKED;
				}
			}

			CAutoPtr<CheckboxInfo> &pCheckboxInfo = m_buttons.GetAt(idx);

			CWindow checkbox(pCheckboxInfo->hWnd);
			if (checkbox.IsWindow()) {
				// `FbNԂݒ肷B
				checkbox.SendMessage(BM_SETCHECK, state);
			}
		}

		return S_OK;

	} catch (CAtlException &ex) {
		return ex.m_hr;
	}
}



// WI{bNXp

RadioButtonControlComponent::RadioButtonControlComponent()
	: m_initValue(-1)
	, m_value(-1)
{
}

RadioButtonControlComponent::~RadioButtonControlComponent() throw()
{
}

HRESULT RadioButtonControlComponent::InitInstance(BSTR title, VARIANT initValue, VARIANT mode) throw()
{
	// [h̔
	SetVerticalMode(mode);

	// {^̍\z

	LPCWSTR p = title;
	if (p == NULL) {
		p = L"";
	}

	m_buttons.RemoveAll();
	while (p) {
		CAutoPtr<RadioInfo> pCmdBtn(new RadioInfo());

		p = ArrayUtil::GetNextToken(p, ';', &pCmdBtn->caption);

		pCmdBtn->hWnd = NULL;

		m_buttons.Add(pCmdBtn);
	}

	ATLASSERT(m_buttons.GetCount() > 0);


	// 

	SHORT selectIdx = -1; // w莞͖I
	if (!IsNullOrError(&initValue)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &initValue, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_I2);
		selectIdx = tmp.iVal;
	}

	// {^͈̔͊Ȍꍇ͖IƂB
	if (m_buttons.GetCount() <= static_cast<size_t>(selectIdx) || selectIdx < 0) {
		selectIdx = -1;
	}

	m_initValue = selectIdx;
	m_value = selectIdx;

	return S_OK;
}

HRESULT RadioButtonControlComponent::Create(BSTR title, VARIANT initValue, VARIANT mode, ControlComponent** ppCompo) throw()
{
	if (!ppCompo) {
		return E_POINTER;
	}

	CAutoPtr<RadioButtonControlComponent> pRadioButton(new RadioButtonControlComponent());

	HRESULT hr;
	if (FAILED(hr = pRadioButton->InitInstance(title, initValue, mode))) {
		return hr;
	}

	// m
	ATLASSERT(!*ppCompo);
	*ppCompo = pRadioButton.Detach();

	return S_OK;
}

HWND RadioButtonControlComponent::CreateButton(HWND hParent, LPCTSTR caption, WORD nStartChildId, WORD offset)
{
	// : Eɂ\zX^CقȂ̂
	// m_verticaltOtrue/falsêꂩɐݒ肳ĂKvB
	DWORD dwStyle = 0;
	if (!m_vertical) {
		dwStyle |= BS_PUSHLIKE;
	}
	if (offset == 0) {
		dwStyle |= WS_GROUP;
	}

	HWND hWnd = ::CreateWindow(_T("BUTTON"), 
		caption,
		BS_AUTORADIOBUTTON | WS_TABSTOP | WS_TABSTOP | WS_CHILD | WS_VISIBLE | dwStyle,
		0, 0, 0, 0,
		hParent, reinterpret_cast<HMENU>(nStartChildId + offset), NULL, NULL);
	return hWnd;
}

HRESULT RadioButtonControlComponent::get_Value(BSTR *pValue) throw()
{
	// `FbNԂ擾
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	if (!pValue) {
		return E_POINTER;
	}

	return VarBstrFromI2(m_value, LOCALE_SYSTEM_DEFAULT, 0, pValue);
}

HRESULT RadioButtonControlComponent::put_Value(BSTR value) throw()
{
	SHORT selectIdx = 0;
	if (::SysStringLen(value) == 0 || FAILED(VarI2FromStr(value, LOCALE_SYSTEM_DEFAULT, LOCALE_NOUSEROVERRIDE, &selectIdx))) {
		selectIdx = -1;
	}

	size_t mx = m_buttons.GetCount();
	if (mx <= static_cast<size_t>(selectIdx) || selectIdx < 0) {
		selectIdx = -1;
	}

	m_value = selectIdx;
	m_initValue = selectIdx;

	// \̏ꍇAXVB
	HRESULT hr = SetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	return S_OK;
}

HRESULT RadioButtonControlComponent::get_IsModified(VARIANT_BOOL *pResult) throw()
{
	if (!pResult) {
		return E_POINTER;
	}

	// `FbNԂ擾
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}
	
	// ver1ł́uύXȂꍇTruevƋtɂȂĂB
	// ܂ɂvIȂ̂Ō݊ȂCB
	*pResult = (m_initValue != m_value) ? VARIANT_TRUE : VARIANT_FALSE;

	return S_OK;
}

HRESULT RadioButtonControlComponent::GetUIValue() throw()
{
	bool notComposed = false;

	SHORT selectedIdx = -1; // ǂɂ`FbNȂꍇ-1

	size_t mx = m_buttons.GetCount();
	for (size_t idx = 0; idx < mx; idx++) {
		CAutoPtr<RadioInfo> &pRadioInfo = m_buttons.GetAt(idx);
		if (!::IsWindow(pRadioInfo->hWnd)) {
			notComposed = true;
			break;
		}
		if (::SendMessage(pRadioInfo->hWnd, BM_GETCHECK, 0, 0)) {
			// ŏɌ`FbNĂ{^IƂ݂ȂB
			selectedIdx = static_cast<SHORT>(idx);
			break;
		}
	}

	if (notComposed) {
		// EBhE\zĂȂ(̂)
		return S_FALSE;
	}

	m_value = selectedIdx;

	return S_OK;
}

HRESULT RadioButtonControlComponent::SetUIValue() throw()
{
	bool notComposed = false;

	size_t mx = m_buttons.GetCount();
	for (size_t idx = 0; idx < mx; idx++) {
		CAutoPtr<RadioInfo> &pRadioInfo = m_buttons.GetAt(idx);
		if (!::IsWindow(pRadioInfo->hWnd)) {
			notComposed = true;
		} else {
			WPARAM chk = (m_value == idx) ? BST_CHECKED : BST_UNCHECKED;
			::SendMessage(pRadioInfo->hWnd, BM_SETCHECK, chk, 0);
		}
	}

	return notComposed ? S_FALSE : S_OK;
}



// Xg{bNXp

ListboxControlComponent::ListboxControlComponent()
	: ControlComponent()
	, m_hListWnd(NULL)
	, m_lineCount(1)
	, m_enabled(VARIANT_TRUE)
{
}

ListboxControlComponent::~ListboxControlComponent() throw()
{
	ATLASSERT(m_hListWnd == NULL);
}

HRESULT ListboxControlComponent::InitInstance(VARIANT listValues, VARIANT initValues, VARIANT numberOfLines, VARIANT multiSelMode) throw()
{
	HRESULT hr;

	// \e̎擾
	hr = InitItems(listValues);
	if (FAILED(hr)) {
		return hr;
	}

	// l̎擾
	m_initValue.Empty();
	m_value.Empty();
	if (!IsNullOrError(&initValues)) {
		VARIANT tmp;
		VariantInit(&tmp);
		hr = VariantChangeType(&tmp, &initValues, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		m_initValue.Attach(tmp.bstrVal);
		m_value = m_initValue;
	}

	// \s̎擾
	UINT lineCount = 1; // ̍s1
	if (!IsNullOrError(&numberOfLines)) {
		CComVariant tmp;
		hr = VariantChangeType(&tmp, &numberOfLines, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		if (tmp.iVal > 0) { // Œ1s͕KvB
			lineCount = tmp.iVal;
		}
	}
	m_lineCount = lineCount;

	// I[h̎擾
	bool msd = false;
	if (!IsNullOrError(&multiSelMode)) {
		CComVariant tmp;
		hr = VariantChangeType(&tmp, &multiSelMode, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		msd = tmp.iVal ? true : false;
	}
	m_multiSelMode = msd;

	return S_OK;
}

HRESULT ListboxControlComponent::Create(VARIANT listValues, VARIANT initValue, VARIANT numberOfLines, VARIANT multiSelMode, ControlComponent** ppCompo) throw()
{
	if (!ppCompo) {
		return E_POINTER;
	}

	CAutoPtr<ListboxControlComponent> pRadioButton(new ListboxControlComponent());

	HRESULT hr;
	hr = pRadioButton->InitInstance(listValues, initValue, numberOfLines, multiSelMode);
	if (FAILED(hr)) {
		return hr;
	}

	// m
	ATLASSERT(!*ppCompo);
	*ppCompo = pRadioButton.Detach();

	return S_OK;
}

UINT ListboxControlComponent::GetLineCount() throw()
{
	return m_lineCount;
}

HRESULT ListboxControlComponent::Compose(WORD& nChildId, HWND hParent) throw()
{
	ATLASSERT(::IsWindow(hParent));
	ATLASSERT(m_hListWnd == NULL);

	WORD tempChildId = nChildId;
	try {


		DWORD dwStyle = 0;
		if (m_multiSelMode) {
			dwStyle |= LBS_EXTENDEDSEL;
		}

		m_hListWnd = CreateWindow(_T("LISTBOX"), _T(""),
			LBS_USETABSTOPS | WS_VSCROLL | WS_BORDER | WS_TABSTOP | WS_GROUP |
			LBS_NOINTEGRALHEIGHT | LBS_NOTIFY | WS_VISIBLE | WS_CHILD | dwStyle,
			0, 0, 0, 0,
			hParent, reinterpret_cast<HMENU>(tempChildId), NULL, NULL);

		if (m_hListWnd == NULL) {
			AtlThrowLastWin32();
		}
		tempChildId++;

		// tHg̐ݒ

		CWindow wndDialog(hParent);
		CWindow wndList(m_hListWnd);
		wndList.SetFont(wndDialog.GetFont());

		// l̐ݒ
		size_t mx = m_items.GetCount();
		for (size_t idx = 0; idx < mx; idx++) {
			CAtlStringW item = m_items.GetAt(idx);

			// Xg{bNX̃eLXgsǉ
			LRESULT pos = wndList.SendMessage(LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(static_cast<LPCTSTR>(item)));
			if (pos == LB_ERR || pos == LB_ERRSPACE) {
				// G[̓s
				return E_FAIL;
			}
		}

		// IԂ̐ݒ
		HRESULT hr = SetUIValue();
		if (FAILED(hr)) {
			AtlThrow(hr);
		}

		// Xgɕ\Ăgbvs擪sɂ킹
		if (mx > 0) {
			wndList.SendMessage(LB_SETTOPINDEX, 0);
		}

		// LE̐ݒ

		wndList.EnableWindow(m_enabled ? TRUE : FALSE);

	} catch (CAtlException &ex) {

		Destroy();

		return ex.m_hr;
	}

	nChildId = tempChildId;
	return S_OK;
}

HRESULT ListboxControlComponent::HasChildId(WORD childId) throw()
{
	CWindow wndList(m_hListWnd);
	if (wndList.IsWindow()) {
		if (childId == wndList.GetWindowLong(GWL_ID)) {
			return S_OK;
		}
	}
	return S_FALSE;
}

HRESULT ListboxControlComponent::IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw()
{
	if (!pEventId) {
		return E_POINTER;
	}

	ATLASSERT(HasChildId(childId) == S_OK);

	if (!bModal && notifyCode == LBN_SELCHANGE) {
		// [hX̏ꍇŃXg{bNX̑IύXꍇ
		*pEventId = GetCtrlId();
		return S_OK;
	}

	*pEventId = 0;

	return S_FALSE;
}

HRESULT ListboxControlComponent::Destroy(void) throw()
{
	if (!m_hListWnd) {
		return S_FALSE;
	}

	if (m_hListWnd) {
		// jOɑIԂ擾
		// (ĵ߁A擾ɎsĂG[ɂ͂ȂB)
		GetUIValue();

		// j
		DestroyWindow(m_hListWnd);
		m_hListWnd = NULL;
	}

	ATLASSERT(m_hListWnd == NULL);

	return S_OK;
}

HRESULT ListboxControlComponent::DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw()
{
	ATLASSERT(::IsWindow(hParent));
	ATLASSERT(::IsWindow(m_hListWnd));

	SetWindowPos(m_hListWnd, NULL,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);

	return S_OK;
}

HRESULT ListboxControlComponent::get_Value(BSTR *pValue) throw()
{
	// IԂ擾
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	return m_value.CopyTo(pValue);
}

HRESULT ListboxControlComponent::put_Value(BSTR value) throw()
{
	m_value = value;
	m_initValue = value;

	// \̏ꍇAXVB
	HRESULT hr = SetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	return S_OK;
}

HRESULT ListboxControlComponent::get_IsModified(VARIANT_BOOL *pResult) throw()
{
	if (!pResult) {
		return E_POINTER;
	}

	// \̏ꍇ͉ʂ̓e擾B
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	// IԂ̃CfbNXZ~R؂ŕƂė񋓂`ł
	// CfbNX̏͏sł悭AA͈͊ÕCfbNX͖B
	// ėLȔ͈͂̃CfbNX̏Ԃ`FbN邽߂Ɉ[}bv`
	// WJĔrB

	size_t mx = m_items.GetCount();

	if (mx == 0) {
		// \ełΏl͖Ӗł邽ߔrsvB
		*pResult = VARIANT_FALSE;
		return S_OK;
	}

	std::vector<BOOL> initValMap(mx);
	std::vector<BOOL> valMap(mx);

	GetMarkedMap(m_initValue, !m_multiSelMode, &initValMap[0], mx); // TCY0̃obt@̃AhX͂肦Ȃ̂Œ
	GetMarkedMap(m_value, false, &valMap[0], mx);

	bool modified = (memcmp(&initValMap[0], &valMap[0], sizeof(BOOL) * mx) != 0);

	*pResult = modified ? VARIANT_TRUE : VARIANT_FALSE;

	return S_OK;
}

HRESULT ListboxControlComponent::get_Enable(VARIANT_BOOL *pEnabled) throw()
{
	if (!pEnabled) {
		return E_POINTER;
	}

	*pEnabled = m_enabled;

	return S_FALSE;
}

HRESULT ListboxControlComponent::put_Enable(VARIANT_BOOL enabled) throw()
{
	m_enabled = enabled;

	if (::IsWindow(m_hListWnd)) {
		CWindow wndList(m_hListWnd);
		wndList.EnableWindow(m_enabled ? TRUE : FALSE);
	}

	return S_OK;
}

HRESULT ListboxControlComponent::GetUIValue() throw()
{
	CWindow wndList(m_hListWnd);

	if (!wndList.IsWindow()) {
		// \ĂȂ̂ŔfȂB
		return S_FALSE;
	}

	size_t mx = m_items.GetCount();

	CComBSTR strIndexes;

	int selectedCount = 0;
	for (size_t idx = 0; idx < mx; idx++) {
		LRESULT res = wndList.SendMessage(LB_GETSEL, idx);
		ATLASSERT(res != LB_ERR);
		if (res == LB_ERR) {
			return E_FAIL;
		}
		if (res > 0) {
			selectedCount++;

			CComBSTR tmp;
			HRESULT hr = VarBstrFromI4(static_cast<LONG>(idx), LOCALE_SYSTEM_DEFAULT, 0, &tmp);
			ATLASSERT(SUCCEEDED(hr));
			if (FAILED(hr)) {
				// BSTR蓖ẴsƂ?
				return hr;
			}

			if (selectedCount > 1) {
				strIndexes.Append(L";");
			}
			strIndexes.Append(tmp);
		}
	}
	
	if (strIndexes.Length() == 0) {
		ATLASSERT(selectedCount == 0);
		strIndexes = L"-1";
	}

	m_value.Attach(strIndexes.Detach());

	return S_OK;
}

HRESULT ListboxControlComponent::SetUIValue() throw()
{
	CWindow wndList(m_hListWnd);

	if (!wndList.IsWindow()) {
		// \ĂȂ̂ŔfȂB
		return S_FALSE;
	}


	// \Ă(͂)̌擾B
	size_t mx = m_items.GetCount();

	if (mx == 0) {
		// (ACe[Ȃ̂ŁAIĂ͂͂Ȃ)
		if (!m_multiSelMode) {
			// PI[h̏ꍇ
			LRESULT res = wndList.SendMessage(LB_SETCURSEL, -1); // set to have no selection.
			ATLASSERT(res != LB_ERR);

		} else {
			// I[h̏ꍇ
			LRESULT res = wndList.SendMessage(LB_SETSEL, FALSE, -1); // remove selection from all.
			ATLASSERT(res != LB_ERR);
		}
		return S_OK;
	}

	// IԂƂCfbNX}bv
	std::vector<BOOL> map(mx);
	GetMarkedMap(m_value, !m_multiSelMode, &map[0], mx);

	// CfbNX}bv𑖍đION/OFFݒ肷B
	for (size_t idx = 0; idx < mx; idx++) {
		if (!m_multiSelMode) {
			// PI[h̏ꍇ
			if (map[idx]) {
				LRESULT res = wndList.SendMessage(LB_SETCURSEL, idx);
				ATLASSERT(res != LB_ERR);
			}

		} else {
			// I[h̏ꍇ
			LRESULT res = wndList.SendMessage(LB_SETSEL, map[idx], idx);
			ATLASSERT(res != LB_ERR);
		}
	}

	return S_OK;
}

HRESULT ListboxControlComponent::InitItems(VARIANT varList) throw()
{
	m_items.RemoveAll();
	
	if (IsNullOrError(&varList)) {
		// Xg͋łB
		return S_FALSE;
	}

	HRESULT hr;

	CComVariant arg;
	hr = VariantChangeType(&arg, &varList, VARIANT_NOUSEROVERRIDE, VT_BSTR);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(arg.vt == VT_BSTR);

	LPCWSTR p = arg.bstrVal;
	if (p == NULL) {
		p = L"";
	}

	while (p && *p) { // *ṕA󕶎̏ꍇ̓ACeȂƌȂ߁B
		CComBSTR itemVal;
		p = ArrayUtil::GetNextToken(p, ';', &itemVal);

		// Xgɓo^
		if (itemVal.Length() > 0) {
			m_items.Add(itemVal);
		} else {
			m_items.Add(L"");
		}
	}

	return S_OK;
}

void ListboxControlComponent::GetMarkedMap(LPCWSTR pSrc, bool onlyLastToken, BOOL *pMap, size_t length) throw()
{
	// [̏ꍇ͉ȂA|C^ӖȂB([͂肦P[X)
	if (length == 0) {
		return;
	}

	// 
	ATLASSERT(pMap);
	memset(pMap, 0, sizeof(BOOL) * length);

	// Z~Rؕ񂩂X̃CfbNX߂ĔzɃtOĂ
	if (pSrc == NULL) {
		pSrc = L"";
	}
	while (pSrc && *pSrc) {
		CComBSTR strIndex;
		pSrc = ArrayUtil::GetNextToken(pSrc, ';', &strIndex);
		if (!onlyLastToken || !pSrc) { // Ō̃g[Nł邩AŌ̃g[NȊOLłꍇ
			if (strIndex.Length() > 0) {
				LONG markedIndex = 0;
				if (SUCCEEDED(VarI4FromStr(strIndex, LOCALE_SYSTEM_DEFAULT, LOCALE_NOUSEROVERRIDE, &markedIndex))) {
					if (markedIndex >= 0 && static_cast<size_t>(markedIndex) < length) {
						pMap[markedIndex] = TRUE;
					}
				}
			}
		}
	}
}


/// R{^hbv_EXg{bNX̋ʕ

AbstractComboboxControlComponent::AbstractComboboxControlComponent()
	: ControlComponent()
	, m_hLabelWnd(NULL)
	, m_hComboWnd(NULL)
	, m_enabled(VARIANT_TRUE)
{
}

AbstractComboboxControlComponent::~AbstractComboboxControlComponent() throw()
{
	ATLASSERT(m_hLabelWnd == NULL);
	ATLASSERT(m_hComboWnd == NULL);
}

HRESULT AbstractComboboxControlComponent::InitInstance(VARIANT title, VARIANT listValues) throw()
{
	// xLvV擾
	m_label.Empty();
	if (!IsNullOrError(&title)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &title, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		m_label.Attach(tmp.bstrVal);
	}

	// Xg̎擾
	m_listItems.RemoveAll();
	if (!IsNullOrError(&listValues)) {
		CComVariant tmp;
		HRESULT hr = VariantChangeType(&tmp, &listValues, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);

		LPCWSTR pSrc = tmp.bstrVal;
		if (pSrc == NULL) {
			pSrc = L"";
		}

		while (pSrc && *pSrc) { // 󕶎̓ACeȂƌȂ
			CComBSTR itemVal;
			pSrc = ArrayUtil::GetNextToken(pSrc, ';', &itemVal);
			if (itemVal.Length() > 0) {
				m_listItems.Add(itemVal);
			} else {
				m_listItems.Add(L"");
			}
		}
	}

	return S_OK;
}

UINT AbstractComboboxControlComponent::GetLineCount() throw()
{
	// R{{bNX͏1ŝ
	return 1;
}

HRESULT AbstractComboboxControlComponent::Compose(WORD& nChildId, HWND hParent) throw()
{
	ATLASSERT(hParent);
	ATLASSERT(m_hLabelWnd == NULL);
	ATLASSERT(m_hComboWnd == NULL);

	WORD tempChildId = nChildId;
	try {
		// x񂪋܂NULLłȂ΃x̍\z
		if (m_label.Length() > 0) {
			m_hLabelWnd = CreateWindow(_T("STATIC"), m_label,
				WS_VISIBLE | WS_GROUP | WS_CHILD | SS_RIGHT | SS_CENTERIMAGE,
				0, 0, 0, 0,
				hParent, reinterpret_cast<HMENU>(tempChildId), NULL, NULL);

			if (m_hLabelWnd == NULL) {
				AtlThrowLastWin32();
			}
			tempChildId++;
		}

		// R{{bNX̃^Cv
		DWORD dwComboStyle = CBS_AUTOHSCROLL | WS_TABSTOP | WS_CHILD | WS_VISIBLE;

		// hbv_EXg^R{{bNXŗL̃X^C̒ǉ
		dwComboStyle |= GetComboStyle();

		// xȂEDITɃO[vJnw
		if (!::IsWindow(m_hLabelWnd)) {
			dwComboStyle |= WS_GROUP;
		}
		
		// R{{bNX̍\z
		m_hComboWnd = CreateWindowEx(WS_EX_CLIENTEDGE, _T("COMBOBOX"),
			_T(""), dwComboStyle,
			0, 0, 0, 0,
			hParent, reinterpret_cast<HMENU>(tempChildId), NULL, NULL);
		if (m_hComboWnd == NULL) {
			AtlThrowLastWin32();
		}
		tempChildId++;

		CWindow wndCombobox(m_hComboWnd);

		// Xg̐ݒ
		size_t mx = m_listItems.GetCount();
		for (size_t idx = 0; idx < mx; idx++) {
			CAtlStringW listItem = m_listItems.GetAt(idx);
			
			LRESULT res = wndCombobox.SendMessage(CB_INSERTSTRING,
				idx, reinterpret_cast<LPARAM>(static_cast<LPCTSTR>(listItem)));
			ATLASSERT(res >= 0);
			if (res < 0) {
				// CB_ERR or CB_ERRSPACE
				return E_FAIL;
			}
		}

		// eLXg̐ݒ
		HRESULT hr = SetUIValue();
		if (FAILED(hr)) {
			AtlThrow(hr);
		}

		// tHg̐ݒ

		CWindow wndDialog(hParent);

		if (::IsWindow(m_hLabelWnd)) {
			CWindow wndLabel(m_hLabelWnd);
			wndLabel.SetFont(wndDialog.GetFont());
		}

		wndCombobox.SetFont(wndDialog.GetFont());

		// LE̐ݒ

		if (::IsWindow(m_hLabelWnd)) {
			CWindow wndLabel(m_hLabelWnd);
			wndLabel.EnableWindow(m_enabled ? TRUE : FALSE);
		}
		wndCombobox.EnableWindow(m_enabled ? TRUE : FALSE);

	} catch (CAtlException &ex) {

		Destroy();

		return ex.m_hr;
	}

	nChildId = tempChildId;
	return S_OK;
}

HRESULT AbstractComboboxControlComponent::HasChildId(WORD childId) throw()
{
	CWindow labelWnd(m_hLabelWnd);
	if (labelWnd.IsWindow()) {
		if (childId == labelWnd.GetWindowLong(GWL_ID)) {
			return S_OK;
		}
	}

	CWindow comboboxWnd(m_hComboWnd);
	if (comboboxWnd.IsWindow()) {
		if (childId == comboboxWnd.GetWindowLong(GWL_ID)) {
			return S_OK;
		}
	}

	return S_FALSE;
}

HRESULT AbstractComboboxControlComponent::IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw()
{
	if (!pEventId) {
		return E_POINTER;
	}

	ATLASSERT(HasChildId(childId) == S_OK);

	if (!bModal && notifyCode == CBN_SELCHANGE) {
		// [hX̏ꍇŃR{{bNX̑IύXꍇ
		*pEventId = GetCtrlId();
		return S_OK;
	}

	*pEventId = 0;

	return S_FALSE;
}

HRESULT AbstractComboboxControlComponent::Destroy(void) throw()
{
	if (!m_hLabelWnd && !m_hComboWnd) {
		return S_FALSE;
	}

	if (m_hLabelWnd) {
		DestroyWindow(m_hLabelWnd);
		m_hLabelWnd = NULL;
	}

	if (m_hComboWnd) {
		// jOɃeLXg擾
		// (ĵ߁A擾ɎsĂG[ɂ͂ȂB)
		GetUIValue();

		// j
		DestroyWindow(m_hComboWnd);
		m_hComboWnd = NULL;
	}

	ATLASSERT(m_hComboWnd == NULL);
	ATLASSERT(m_hLabelWnd == NULL);

	return S_OK;
}

HRESULT AbstractComboboxControlComponent::DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw()
{
	ATLASSERT(::IsWindow(hParent));
	ATLASSERT(::IsWindow(m_hComboWnd));

	LONG width = rect.right - rect.left;
	LONG height = rect.bottom - rect.top;

	LONG labelWidth = 0;
	if (::IsWindow(m_hLabelWnd)) {
		// x̓EBhE1/4̃TCYƂ
		labelWidth = width / 4;

		SetWindowPos(m_hLabelWnd, NULL,
			rect.left, rect.top, labelWidth, height,
			SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);
	}

	// R{{bNX̓̕xc
	LONG editWidth = width - labelWidth;
	SetWindowPos(m_hComboWnd, NULL,
		rect.left + labelWidth, rect.top, editWidth, height,
		SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);

	return S_OK;
}

HRESULT AbstractComboboxControlComponent::get_Enable(VARIANT_BOOL *pEnabled) throw()
{
	if (!pEnabled) {
		return E_POINTER;
	}

	*pEnabled = m_enabled;

	return S_FALSE;
}

HRESULT AbstractComboboxControlComponent::put_Enable(VARIANT_BOOL enabled) throw()
{
	m_enabled = enabled;

	// \̏ꍇAXVB
	if (::IsWindow(m_hComboWnd)) {
		CWindow comboboxWnd(m_hComboWnd);
		comboboxWnd.EnableWindow(m_enabled ? TRUE : FALSE);
	}
	if (::IsWindow(m_hLabelWnd)) {
		CWindow labelWnd(m_hLabelWnd);
		labelWnd.EnableWindow(m_enabled ? TRUE : FALSE);
	}

	return S_OK;
}

/// R{{bNX

ComboboxControlComponent::ComboboxControlComponent()
	: AbstractComboboxControlComponent()
{
}

ComboboxControlComponent::~ComboboxControlComponent() throw()
{
}

HRESULT ComboboxControlComponent::InitInstance(VARIANT title, VARIANT initValue, VARIANT listValues) throw()
{
	HRESULT hr;

	hr = AbstractComboboxControlComponent::InitInstance(title, listValues);
	if (FAILED(hr)) {
		return hr;
	}

	// l̎擾
	m_initValue.Empty();
	if (!IsNullOrError(&initValue)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &initValue, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		m_initValue.Attach(tmp.bstrVal);
	}
	m_value = m_initValue;

	return S_OK;
}

HRESULT ComboboxControlComponent::Create(VARIANT title, VARIANT initValues, VARIANT listValues, ControlComponent** ppCompo) throw()
{
	if (!ppCompo) {
		return E_POINTER;
	}

	CAutoPtr<ComboboxControlComponent> pCombobox(new ComboboxControlComponent());

	HRESULT hr;
	hr = pCombobox->InitInstance(title, initValues, listValues);
	if (FAILED(hr)) {
		return hr;
	}

	// m
	ATLASSERT(!*ppCompo);
	*ppCompo = pCombobox.Detach();

	return S_OK;
}

HRESULT ComboboxControlComponent::get_Value(BSTR *pValue) throw()
{
	if (!pValue) {
		return E_POINTER;
	}

	// ʂ\ȂUIl擾B
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	return m_value.CopyTo(pValue);
}

HRESULT ComboboxControlComponent::put_Value(BSTR value) throw()
{
	m_initValue = value;
	m_value = value;

	HRESULT hr = SetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	return S_OK;
}

HRESULT ComboboxControlComponent::get_IsModified(VARIANT_BOOL *pResult) throw()
{
	if (!pResult) {
		return E_POINTER;
	}

	// ʂ\ȂUIl擾B
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	bool modified = (m_initValue != m_value);

	*pResult = modified ? VARIANT_TRUE : VARIANT_FALSE;

	return S_OK;
}

DWORD ComboboxControlComponent::GetComboStyle() throw()
{
	return CBS_DROPDOWN;
}

HRESULT ComboboxControlComponent::GetUIValue() throw()
{
	CWindow wndCombobox(m_hComboWnd);

	if (!wndCombobox.IsWindow()) {
		return S_FALSE;
	}

	ATL::CString newValue; // BSTRɂƂCWindow::GetWindowTextɋP[XŃoO
	wndCombobox.GetWindowText(newValue);

	m_value = newValue;

	return S_OK;
}

HRESULT ComboboxControlComponent::SetUIValue() throw()
{
	CWindow wndCombobox(m_hComboWnd);

	if (!wndCombobox.IsWindow()) {
		return S_FALSE;
	}

	if (m_value.Length() == 0) {
		wndCombobox.SetWindowText(L"");
	} else {
		wndCombobox.SetWindowText(m_value);
	}

	return S_OK;
}


/// hbv_EXg

DropdownListControlComponent::DropdownListControlComponent()
	: AbstractComboboxControlComponent()
{
}

DropdownListControlComponent::~DropdownListControlComponent() throw()
{
}

HRESULT DropdownListControlComponent::InitInstance(VARIANT title, VARIANT initValue, VARIANT listValues) throw()
{
	HRESULT hr;

	hr = AbstractComboboxControlComponent::InitInstance(title, listValues);
	if (FAILED(hr)) {
		return hr;
	}

	// l擾B

	m_value = -1;
	if (!IsNullOrError(&initValue)) {
		CComVariant tmp;
		hr = VariantChangeType(&tmp, &initValue, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);

		hr = GetValue(tmp.bstrVal, &m_value);
		if (FAILED(hr)) {
			return hr;
		}
	}
	m_initValue = m_value;

	return S_OK;
}

HRESULT DropdownListControlComponent::Create(VARIANT titles, VARIANT initValue, VARIANT listValues, ControlComponent** ppCompo) throw()
{
	if (!ppCompo) {
		return E_POINTER;
	}

	CAutoPtr<DropdownListControlComponent> pDropdown(new DropdownListControlComponent());

	HRESULT hr;
	hr = pDropdown->InitInstance(titles, initValue, listValues);
	if (FAILED(hr)) {
		return hr;
	}

	// m
	ATLASSERT(!*ppCompo);
	*ppCompo = pDropdown.Detach();

	return S_OK;
}

HRESULT DropdownListControlComponent::get_Value(BSTR *pValue) throw()
{
	if (!pValue) {
		return E_POINTER;
	}

	// ʂ\ȂUI擾B
	HRESULT hr;
	hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	// 擾l𕶎ƂĕԂB
	CComBSTR tmp;
	hr = VarBstrFromI2(m_value, LOCALE_SYSTEM_DEFAULT, LOCALE_NOUSEROVERRIDE, &tmp);
	if (FAILED(hr)) {
		return hr;
	}

	*pValue = tmp.Detach();

	return S_OK;
}

HRESULT DropdownListControlComponent::GetValue(LPCWSTR pStr, SHORT *pValue) throw()
{
	// s󔒂͓ǂݔ΂
	while (pStr && *pStr == ' ') {
		pStr++;
	}
	// NULL܂͋󕶎̏ꍇ-1ԂB
	if (!pStr || !*pStr) {
		*pValue = -1;
		return S_OK;
	}

	// 񂩂琔l擾B
	SHORT tmp;
	HRESULT hr;
	hr = VarI2FromStr(pStr, LOCALE_SYSTEM_DEFAULT, LOCALE_NOUSEROVERRIDE, &tmp);
	if (FAILED(hr)) {
		return hr;
	}

	// ̒l-1낦B
	if (tmp < 0) {
		tmp = -1;
	}

	// Xg傫Ȓl͖`Ȃ̂őIsƂB
	size_t mx = m_listItems.GetCount();
	if (static_cast<size_t>(tmp) >= mx) {
		tmp = -1;
	}

	ATLASSERT(pValue);
	*pValue = tmp;

	return S_OK;
}

HRESULT DropdownListControlComponent::put_Value(BSTR value) throw()
{
	return GetValue(value, &m_value);
}

HRESULT DropdownListControlComponent::get_IsModified(VARIANT_BOOL *pResult) throw()
{
	if (!pResult) {
		return E_POINTER;
	}

	// ʂ\ȂUIl擾B
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	bool modified = false;
	if (m_initValue < 0 || m_value < 0) {
		// ꂩ̏ꍇAoƂłȂΕύX
		modified = !(m_initValue < 0 && m_value < 0);
	} else {
		// łꍇA̒lȂΕύX
		modified = (m_initValue != m_value);
	}

	*pResult = modified ? VARIANT_TRUE : VARIANT_FALSE;

	return S_OK;
}

DWORD DropdownListControlComponent::GetComboStyle() throw()
{
	return CBS_DROPDOWNLIST;
}

HRESULT DropdownListControlComponent::GetUIValue() throw()
{
	CWindow wndCombobox(m_hComboWnd);

	if (!wndCombobox.IsWindow()) {
		return S_FALSE;
	}

	LRESULT res = wndCombobox.SendMessage(CB_GETCURSEL);

	if (res < 0) {
		// no item is selected.
		m_value = -1;

	} else {
		m_value = static_cast<SHORT>(res);
	}

	return S_OK;
}

HRESULT DropdownListControlComponent::SetUIValue() throw()
{
	CWindow wndCombobox(m_hComboWnd);

	if (!wndCombobox.IsWindow()) {
		return S_FALSE;
	}

	if (m_value < 0) {
		// remove section and clear edit control
		wndCombobox.SendMessage(CB_SETCURSEL, -1);

	} else {
		wndCombobox.SendMessage(CB_SETCURSEL, m_value);
	}

	return S_OK;
}


/// GfCbg+{^̋ʃNX

AbstractEditButtonControlComponent::AbstractEditButtonControlComponent()
	: ControlComponent()
	, m_hLabelWnd(NULL)
	, m_hEditWnd(NULL)
	, m_hButtonWnd(NULL)
	, m_enabled(VARIANT_TRUE)
{
}

AbstractEditButtonControlComponent::~AbstractEditButtonControlComponent() throw()
{
	ATLASSERT(m_hLabelWnd == NULL);
	ATLASSERT(m_hEditWnd == NULL);
	ATLASSERT(m_hButtonWnd == NULL);
}

HRESULT AbstractEditButtonControlComponent::InitInstance(VARIANT title, VARIANT initValue, VARIANT btnTitle) throw()
{
	// x^Cg̎擾
	m_label.Empty();
	if (!IsNullOrError(&title)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &title, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		m_label.Attach(tmp.bstrVal);
	}

	// l̎擾
	m_initValue.Empty();
	if (!IsNullOrError(&initValue)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &initValue, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		m_initValue.Attach(tmp.bstrVal);
	}
	m_value = m_initValue;

	// {^^Cg̎擾
	m_btnLabel.Empty();
	if (!IsNullOrError(&btnTitle)) {
		VARIANT tmp;
		VariantInit(&tmp);
		HRESULT hr = VariantChangeType(&tmp, &btnTitle, VARIANT_NOUSEROVERRIDE, VT_BSTR);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_BSTR);
		m_btnLabel.Attach(tmp.bstrVal);
	}

	return S_OK;
}

UINT AbstractEditButtonControlComponent::GetLineCount() throw()
{
	// Ɉs
	return 1;
}

HRESULT AbstractEditButtonControlComponent::Compose(WORD& nChildId, HWND hParent) throw()
{
	ATLASSERT(::IsWindow(hParent));
	ATLASSERT(m_hLabelWnd == NULL);
	ATLASSERT(m_hEditWnd == NULL);
	ATLASSERT(m_hButtonWnd == NULL);

	WORD tempChildId = nChildId;
	try {
		// x񂪋܂NULLłȂ΃x̍\z
		if (m_label.Length() > 0) {
			m_hLabelWnd = CreateWindow(_T("STATIC"), m_label,
				WS_VISIBLE | WS_GROUP | WS_CHILD | SS_RIGHT | SS_CENTERIMAGE,
				0, 0, 0, 0,
				hParent, reinterpret_cast<HMENU>(tempChildId), NULL, NULL);

			if (m_hLabelWnd == NULL) {
				AtlThrowLastWin32();
			}
			tempChildId++;
		}

		// xȂEDITɃO[vJnw
		DWORD dwEditStyle = 0;
		if (!::IsWindow(m_hLabelWnd)) {
			dwEditStyle |= WS_GROUP;
		}
		
		// GfBbg{bNX̍\z
		m_hEditWnd = CreateWindowEx(WS_EX_CLIENTEDGE, _T("EDIT"), // Ver1łWS_EX_OVERLAPPEDWINDOWw肳Ă
			_T(""), ES_AUTOHSCROLL | WS_TABSTOP | WS_CHILD | WS_VISIBLE | dwEditStyle,
			0, 0, 0, 0,
			hParent, reinterpret_cast<HMENU>(tempChildId), NULL, NULL);
		if (m_hEditWnd == NULL) {
			AtlThrowLastWin32();
		}
		tempChildId++;

		// {^̍\z
		LPCTSTR btnCaption;
		if (m_btnLabel.Length() > 0) {
			btnCaption = m_btnLabel;
		} else {
			btnCaption = _T("");
		}
		m_hButtonWnd = ::CreateWindow(_T("BUTTON"), 
			btnCaption,
			BS_PUSHBUTTON | WS_TABSTOP | WS_CHILD | WS_VISIBLE,
			0, 0, 0, 0,
			hParent, reinterpret_cast<HMENU>(tempChildId), NULL, NULL);
		if (m_hButtonWnd == NULL) {
			AtlThrowLastWin32();
		}
		tempChildId++;

		// GfBbg{bNXɃeLXg̐ݒ
		HRESULT hr = SetUIValue();
		if (FAILED(hr)) {
			AtlThrow(hr);
		}

		// tHg̐ݒ

		CWindow wndDialog(hParent);

		CWindow wndLabel(m_hLabelWnd);
		if (wndLabel.IsWindow()) {
			wndLabel.SetFont(wndDialog.GetFont());
		}

		CWindow wndEdit(m_hEditWnd);
		wndEdit.SetFont(wndDialog.GetFont());

		CWindow wndButton(m_hButtonWnd);
		wndButton.SetFont(wndDialog.GetFont());

		// LE̐ݒ

		if (wndLabel.IsWindow()) {
			wndLabel.EnableWindow(m_enabled ? TRUE : FALSE);
		}
		wndEdit.EnableWindow(m_enabled ? TRUE : FALSE);
		wndButton.EnableWindow(m_enabled ? TRUE : FALSE);

	} catch (CAtlException &ex) {

		Destroy();

		return ex.m_hr;
	}

	nChildId = tempChildId;
	return S_OK;
}

HRESULT AbstractEditButtonControlComponent::HasChildId(WORD childId) throw()
{
	HWND wnds[] = {m_hLabelWnd, m_hEditWnd, m_hButtonWnd};

	for (int idx = 0; idx < 3; idx++) {
		CWindow wnd(wnds[idx]);
		if (wnd.IsWindow()) {
			if (wnd.GetWindowLong(GWL_ID) == childId) {
				return S_OK;
			}
		}
	}

	return S_FALSE;
}

HRESULT AbstractEditButtonControlComponent::Destroy(void) throw()
{
	bool destroyed = false;

	if (m_hLabelWnd) {
		DestroyWindow(m_hLabelWnd);
		m_hLabelWnd = NULL;
		destroyed = true;
	}

	if (m_hButtonWnd) {
		DestroyWindow(m_hButtonWnd);
		m_hButtonWnd = NULL;
		destroyed = true;
	}

	if (m_hEditWnd) {
		// jOɑIԂ擾
		// (ĵ߁A擾ɎsĂG[ɂ͂ȂB)
		GetUIValue();

		// j
		DestroyWindow(m_hEditWnd);
		m_hEditWnd = NULL;
		destroyed = true;
	}

	ATLASSERT(m_hEditWnd == NULL);
	ATLASSERT(m_hLabelWnd == NULL);
	ATLASSERT(m_hButtonWnd == NULL);

	return destroyed ? S_OK : S_FALSE;
}

HRESULT AbstractEditButtonControlComponent::DoLayout(HWND hParent, int baseHeight, const RECT &rect) throw()
{
	ATLASSERT(::IsWindow(hParent));
	ATLASSERT(::IsWindow(m_hEditWnd));
	ATLASSERT(::IsWindow(m_hButtonWnd));

	LONG width = rect.right - rect.left;
	LONG height = rect.bottom - rect.top;

	LONG labelWidth = 0;
	if (::IsWindow(m_hLabelWnd)) {
		// x̓EBhE1/4̃TCYƂ
		labelWidth = width / 4;

		SetWindowPos(m_hLabelWnd, NULL,
			rect.left, rect.top, labelWidth, height,
			SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);
	}

	// {^̓EBhE1/5̃TCYƂB
	LONG buttonWidth = width / 5;

	// GfBbg{bNX̓̕xƃ{^c
	LONG editWidth = width - labelWidth - buttonWidth;
	SetWindowPos(m_hEditWnd, NULL,
		rect.left + labelWidth, rect.top, editWidth, height,
		SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);

	// {^̔zu
	SetWindowPos(m_hButtonWnd, NULL,
		rect.left + labelWidth + editWidth, rect.top, buttonWidth, height,
		SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);

	return S_OK;
}

HRESULT AbstractEditButtonControlComponent::get_Value(BSTR *pValue) throw()
{
	if (!pValue) {
		return E_POINTER;
	}

	// \̏ꍇA擾B
	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	return m_value.CopyTo(pValue);
}

HRESULT AbstractEditButtonControlComponent::put_Value(BSTR value) throw()
{
	m_initValue = value;
	m_value = value;

	// \̏ꍇAXVB
	HRESULT hr = SetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	return S_OK;
}

HRESULT AbstractEditButtonControlComponent::get_IsModified(VARIANT_BOOL *pResult) throw()
{
	if (!pResult) {
		return E_POINTER;
	}

	HRESULT hr = GetUIValue();
	if (FAILED(hr)) {
		return hr;
	}

	bool modified = (m_initValue != m_value);	

	*pResult = modified ? VARIANT_TRUE : VARIANT_FALSE;

	return S_OK;
}

HRESULT AbstractEditButtonControlComponent::get_Enable(VARIANT_BOOL *pEnabled) throw()
{
	if (!pEnabled) {
		return E_POINTER;
	}

	*pEnabled = m_enabled;

	return S_FALSE;
}

HRESULT AbstractEditButtonControlComponent::put_Enable(VARIANT_BOOL enabled) throw()
{
	m_enabled = enabled;

	// \̏ꍇAXVB
	CWindow labelWnd(m_hLabelWnd);
	CWindow editWnd(m_hEditWnd);
	CWindow btnWnd(m_hButtonWnd);

	if (editWnd.IsWindow()) {
		editWnd.EnableWindow(m_enabled ? TRUE : FALSE);
	}
	if (labelWnd.IsWindow()) {
		labelWnd.EnableWindow(m_enabled ? TRUE : FALSE);
	}
	if (btnWnd.IsWindow()) {
		btnWnd.EnableWindow(m_enabled ? TRUE : FALSE);
	}

	return S_OK;
}

HRESULT AbstractEditButtonControlComponent::GetUIValue() throw()
{
	CWindow editWnd(m_hEditWnd);
	if (!editWnd.IsWindow()) {
		return S_FALSE;
	}
	
	ATL::CString newValue; // BSTRɂƂCWindow::GetWindowTextɋP[XŃoO
	editWnd.GetWindowText(newValue);

	m_value = newValue;

	return S_OK;
}

HRESULT AbstractEditButtonControlComponent::SetUIValue() throw()
{
	CWindow editWnd(m_hEditWnd);
	if (!editWnd.IsWindow()) {
		return S_FALSE;
	}

	if (m_value.Length() > 0) {
		editWnd.SetWindowText(m_value);	
	} else {
		editWnd.SetWindowText(L"");
	}

	return S_OK;
}


// GfBbg + R}h{^̒`

EditButtonControlComponent::EditButtonControlComponent()
{
}

HRESULT EditButtonControlComponent::InitInstance(VARIANT title, VARIANT initValue, VARIANT btnTitle, SHORT eventId) throw()
{
	HRESULT hr;
	
	hr = AbstractEditButtonControlComponent::InitInstance(title, initValue, btnTitle);
	if (FAILED(hr)) {
		return hr;
	}

	m_eventId = eventId;

	return S_OK;
}

HRESULT EditButtonControlComponent::Create(VARIANT title, VARIANT initValue, VARIANT btnTitle, SHORT eventId, ControlComponent** ppCompo) throw()
{
	if (!ppCompo) {
		return E_POINTER;
	}

	CAutoPtr<EditButtonControlComponent> pCommandButton(new EditButtonControlComponent());

	HRESULT hr;
	if (FAILED(hr = pCommandButton->InitInstance(title, initValue, btnTitle, eventId))) {
		return hr;
	}

	ATLASSERT(!*ppCompo);
	*ppCompo = pCommandButton.Detach();

	return S_OK;
}

EditButtonControlComponent::~EditButtonControlComponent() throw()
{
}

HRESULT EditButtonControlComponent::IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw()
{
	if (!pEventId) {
		return E_POINTER;
	}

	ATLASSERT(HasChildId(childId) == S_OK);

	if (notifyCode == BN_CLICKED) {
		CWindow wndBtn(m_hButtonWnd);
		if (wndBtn.IsWindow()) {
			if (wndBtn.GetWindowLong(GWL_ID) == childId) {
				*pEventId = m_eventId;
				return S_OK;
			}
		}
	}

	*pEventId = 0;

	return S_FALSE;
}


// GfBbg + t@CI{^̒`

FileEditButtonControlComponent::FileEditButtonControlComponent()
{
}

FileEditButtonControlComponent::~FileEditButtonControlComponent() throw()
{
}

HRESULT FileEditButtonControlComponent::InitInstance(VARIANT title, VARIANT initValue, VARIANT btnTitle, VARIANT openSaveMode, VARIANT filter) throw()
{
	HRESULT hr;

	hr = AbstractEditButtonControlComponent::InitInstance(title, initValue, btnTitle);
	if (FAILED(hr)) {
		return hr;
	}

	// tB^̐ݒ
	m_filter = filter;

	// J(0)Eۑ(1)̎擾
	BOOL openMode = TRUE; // ftHǵuJv
	if (!IsNullOrError(&openSaveMode)) {
		CComVariant tmp;
		hr = VariantChangeType(&tmp, &openSaveMode, VARIANT_NOUSEROVERRIDE, VT_I2);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(tmp.vt == VT_I2);
		openMode = (tmp.iVal == 0) ? TRUE : FALSE; // 0ȂΊJA0ȊO(1)ȂΕۑ
	}

	m_openMode = openMode;

	return S_OK;
}

HRESULT FileEditButtonControlComponent::Create(VARIANT title, VARIANT initValue, VARIANT btnTitle,  VARIANT openSaveMode, VARIANT filter, ControlComponent** ppCompo) throw()
{
	if (!ppCompo) {
		return E_POINTER;
	}

	CAutoPtr<FileEditButtonControlComponent> pCommandButton(new FileEditButtonControlComponent());

	HRESULT hr;
	if (FAILED(hr = pCommandButton->InitInstance(title, initValue, btnTitle, openSaveMode, filter))) {
		return hr;
	}

	ATLASSERT(!*ppCompo);
	*ppCompo = pCommandButton.Detach();

	return S_OK;
}

HRESULT FileEditButtonControlComponent::Compose(WORD& nChildId, HWND hParent) throw()
{
	HRESULT hr = AbstractEditButtonControlComponent::Compose(nChildId, hParent);
	if (SUCCEEDED(hr)) {
		// t@CVXẽI[gRv[gɂB
		ATLASSERT(::IsWindow(m_hEditWnd));
		SHAutoComplete(m_hEditWnd, SHACF_DEFAULT); // sĂČp
	}
	return hr;
}

HRESULT FileEditButtonControlComponent::IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw()
{
	if (!pEventId) {
		return E_POINTER;
	}

	ATLASSERT(HasChildId(childId) == S_OK);

	CWindow wndBtn(m_hButtonWnd);
	if (wndBtn.IsWindow() && notifyCode == BN_CLICKED) {
		if (wndBtn.GetWindowLong(GWL_ID) == childId) {

			HRESULT hr;

			// \ĂȂΒl擾B
			hr = GetUIValue();
			if (FAILED(hr)) {
				return hr;
			}

			// _CAOJ

			CComVariant selectedFilePath;
			CComVariant defaultDir; // ftHgfBNg͖w(EMPTY)
			CComVariant defaultName(m_value); // ftHg̓{bNX̒l
			hr = CommonDialogUtil::CommOpenFileName(m_openMode, defaultName, m_filter, defaultDir, &selectedFilePath);
			if (FAILED(hr)) {
				return hr;
			}
			if (hr == S_OK) {
				ATLASSERT(selectedFilePath.vt == VT_BSTR);
				m_value = selectedFilePath.bstrVal;

				// \ĂȂΒlXV
				hr = SetUIValue();
				if (FAILED(hr)) {
					return hr;
				}
			}
		}
	}

	// ɃCxg͔ȂB

	*pEventId = 0;

	return S_FALSE;
}

// GfBbg + tH_I{^̒`

FolderEditButtonControlComponent::FolderEditButtonControlComponent()
{
}

FolderEditButtonControlComponent::~FolderEditButtonControlComponent() throw()
{
}

HRESULT FolderEditButtonControlComponent::Create(VARIANT title, VARIANT initValue, VARIANT btnTitle, ControlComponent** ppCompo) throw()
{
	if (!ppCompo) {
		return E_POINTER;
	}

	CAutoPtr<FolderEditButtonControlComponent> pCommandButton(new FolderEditButtonControlComponent());

	HRESULT hr;
	if (FAILED(hr = pCommandButton->InitInstance(title, initValue, btnTitle))) {
		return hr;
	}

	ATLASSERT(!*ppCompo);
	*ppCompo = pCommandButton.Detach();

	return S_OK;
}

HRESULT FolderEditButtonControlComponent::Compose(WORD& nChildId, HWND hParent) throw()
{
	HRESULT hr = AbstractEditButtonControlComponent::Compose(nChildId, hParent);
	if (SUCCEEDED(hr)) {
		// t@CVXe(fBNĝ)̃I[gRv[gɂB
		ATLASSERT(::IsWindow(m_hEditWnd));
		SHAutoComplete(m_hEditWnd, SHACF_FILESYS_DIRS); // sĂČp
	}
	return hr;
}

HRESULT FolderEditButtonControlComponent::IsEventGenerated(bool bModal, WORD notifyCode, WORD childId, SHORT *pEventId) throw()
{
	if (!pEventId) {
		return E_POINTER;
	}

	ATLASSERT(HasChildId(childId) == S_OK);

	CWindow wndBtn(m_hButtonWnd);
	if (wndBtn.IsWindow() && notifyCode == BN_CLICKED) {
		if (wndBtn.GetWindowLong(GWL_ID) == childId) {

			HRESULT hr;

			// \ĂȂΒl擾B
			hr = GetUIValue();
			if (FAILED(hr)) {
				return hr;
			}

			// _CAOJ

			CComVariant selectedDir;
			CComVariant initdir(m_value); // ftHg̓{bNX̒l
			hr = CommonDialogUtil::BrowseForFolder(initdir, &selectedDir);
			if (FAILED(hr)) {
				return hr;
			}
			if (hr == S_OK) {
				ATLASSERT(selectedDir.vt == VT_BSTR);
				m_value = selectedDir.bstrVal;

				// \ĂȂΒlXV
				hr = SetUIValue();
				if (FAILED(hr)) {
					return hr;
				}
			}
		}
	}

	// ɃCxg͔ȂB

	*pEventId = 0;

	return S_FALSE;
}
