// CCommDialog.cpp : CCCommDialog ̃Cve[V

#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "CommDialog.h"
#include "generic.h"
#include "ObjectVector.h"

/////////////////////////////////////////////////////////////////////////////
// CCommDialog

void CCommDialog::CommFileDialog(VARIANT *pvarReturn, VARIANT varPathName, VARIANT varFilter, BOOL bMode, DWORD flag)
{
	::VariantInit(pvarReturn);

	// t@CJEۑ_CAOʃ[`

	ATL::CString szPathName;
	{
		CComVariant path;
		if (SUCCEEDED(path.ChangeType(VT_BSTR, &varPathName))) {
			// t@C̎o
			szPathName = path.bstrVal;
		}
	}

	ATL::CString szFilter;
	{
		CComVariant filter;
		if (SUCCEEDED(filter.ChangeType(VT_BSTR, &varFilter))) {
			// tB^w肪
			szFilter = filter.bstrVal;
		}
	}

	ATL::CString szDefExtention;
	if (!szFilter.IsEmpty()) {
		LPTSTR p = szFilter.GetBuffer();
		LPTSTR pExt = NULL;
		while (*p) {
			if (*p == '|') {
				*p++ = 0; // ؂ŏI[
				if (!pExt) {
					// ŏ̋؂}[Nŏ̊gq}[Nł낤B
					pExt = p;
				}
			}
			p = CharNext(p);
		}

		// gqtB^ł΍ŏ̊gq̂ݎo
		if (pExt) {
			szDefExtention = pExt;
		}
		pExt = szDefExtention.GetBuffer();
		while (*pExt) {
			if (*pExt == ';') {
				*pExt = 0; // ŏ̊gqŏI
				break;
			}
			pExt = CharNext(pExt);
		}
	}

	ATL::CString szInitialDir;
	if (m_bstr_InitialDir.length() > 0) {
		// fBNg
		szInitialDir = (LPCWSTR)m_bstr_InitialDir;
	}

	ATL::CString strFile(szPathName);
	const int MAXBUFSIZ = MAX_PATH * 10;
	LPTSTR pStrFileBuf = strFile.GetBufferSetLength(MAXBUFSIZ + 1);

	OPENFILENAME ofn = { 0 };
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.lpstrFilter = szFilter;
	ofn.lpstrFile = pStrFileBuf;
	ofn.nMaxFile = MAXBUFSIZ;
	ofn.lpstrDefExt = szDefExtention;
	ofn.Flags = flag;
	ofn.hwndOwner = GetMainWindow();

	if (!szInitialDir.IsEmpty()) {
		ofn.lpstrInitialDir = szInitialDir;
	}

	if (m_bNoDereferenceLinks) {
		// V[gJbgÂ܂܎B
		ofn.Flags |= OFN_NODEREFERENCELINKS;
	}

	ATL::CString szCaption;
	BOOL result = false;
	if (bMode) {
		// J_CAO
		ofn.Flags |= (m_bReadonly) ? OFN_READONLY : 0;
		if (m_bstr_OpenFileCaption.length() > 0) {
			szCaption = (LPCWSTR)m_bstr_OpenFileCaption;
			ofn.lpstrTitle = szCaption;
		}
		result = GetOpenFileName(&ofn);
		if (result) {
			m_bReadonly = (ofn.Flags & OFN_READONLY) ? true : false;
		}
	}
	else {
		// ۑ_CAO
		if (m_bstr_SaveFileCaption.length() > 0) {
			szCaption = (LPCWSTR)m_bstr_SaveFileCaption;
			ofn.lpstrTitle = szCaption;
		}
		result = GetSaveFileName(&ofn);
	}

	if (result) {
		if (!(ofn.Flags & OFN_ALLOWMULTISELECT)) {
			// Pt@CI
			CComVariant retpath;
			retpath = ofn.lpstrFile;
			retpath.Detach(pvarReturn);
		}
		else {
			// t@CI(_ukI[)
			// Ԃꂽt@Cv
			int cnt = 0;
			LPCTSTR p = ofn.lpstrFile;
			while (*p) {
				cnt++;
				while (*p++);
			}

			// VO܂̓}`
			SAFEARRAY *pArray = NULL;
			if (cnt == 1) {
				// 1ȂtpXԂĂ
				CComVariant tmp(ofn.lpstrFile);
				pArray = SafeArrayCreateVector(VT_VARIANT, 0, 1);
				long indx = 0;
				SafeArrayPutElement(pArray, &indx, &tmp);
			}
			else if (cnt > 1) {
				// SAFEARRAY̍쐬
				pArray = SafeArrayCreateVector(VT_VARIANT, 0, cnt - 1);

				// ȂŏfBNgA2Ԗڈȍ~t@C
				p = ofn.lpstrFile;
				_bstr_t dirname = p;

				// tH_vCXIĂȂΒǉ
				LPCWSTR wp = dirname;
				while (*wp) wp++;
				if (wp - 1 > (LPCWSTR)dirname && *(wp - 1) != '\\') {
					dirname += L"\\";
				}

				while (*p++);
				// 2Ԗڈȍ~̎擾
				long indx = 0;
				while (*p) {
					_bstr_t name = p;
					_bstr_t path = dirname + name;

					CComVariant tmp((LPCWSTR)path);
					SafeArrayPutElement(pArray, &indx, &tmp);
					while (*p++);
					indx++;
				}
			}

			// SAFEARRAY쐬Ă
			if (pArray) {
				pvarReturn->vt = VT_ARRAY | VT_VARIANT;
				pvarReturn->parray = pArray;
			}
		}// Single or Multi
	}// if result is ok
}

/////////////////////////////////
// C^[tFCX

STDMETHODIMP CCommDialog::OpenFileDialog(VARIANT varPathName, VARIANT varFilter, VARIANT* pvarReturn)
{
	DWORD flags = (m_bEnableCreatePrompt ? OFN_CREATEPROMPT : OFN_FILEMUSTEXIST)
		+ (m_bEnableReadonly ? 0 : OFN_HIDEREADONLY);
	CommFileDialog(pvarReturn, varPathName, varFilter, true, flags | OFN_ENABLESIZING);
	return S_OK;
}

STDMETHODIMP CCommDialog::SaveFileDialog(VARIANT varPathName, VARIANT varFilter, VARIANT* pvarReturn)
{
	CommFileDialog(pvarReturn, varPathName, varFilter, false, OFN_ENABLESIZING | OFN_OVERWRITEPROMPT);
	return S_OK;
}


STDMETHODIMP CCommDialog::MultiOpenFileDialog(VARIANT varMulti, VARIANT varFilter, VARIANT* pvarReturn)
{
	DWORD flags = (m_bEnableCreatePrompt ? OFN_CREATEPROMPT : OFN_FILEMUSTEXIST)
		+ (m_bEnableReadonly ? 0 : OFN_HIDEREADONLY);
	CommFileDialog(pvarReturn, varMulti, varFilter, true, flags | OFN_ALLOWMULTISELECT | OFN_EXPLORER | OFN_ENABLESIZING);
	return S_OK;
}

STDMETHODIMP CCommDialog::get_OpenFileCaption(BSTR *pVal)
{
	*pVal = m_bstr_OpenFileCaption.copy();
	return S_OK;
}

STDMETHODIMP CCommDialog::put_OpenFileCaption(BSTR newVal)
{
	m_bstr_OpenFileCaption = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_SaveFileCaption(BSTR *pVal)
{
	*pVal = m_bstr_SaveFileCaption.copy();
	return S_OK;
}

STDMETHODIMP CCommDialog::put_SaveFileCaption(BSTR newVal)
{
	m_bstr_SaveFileCaption = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_EnableCreatePrompt(BOOL *pVal)
{
	*pVal = m_bEnableCreatePrompt ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CCommDialog::put_EnableCreatePrompt(BOOL newVal)
{
	m_bEnableCreatePrompt = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_EnableReadOnly(BOOL *pVal)
{
	*pVal = m_bEnableReadonly ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CCommDialog::put_EnableReadOnly(BOOL newVal)
{
	m_bEnableReadonly = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_ReadOnly(BOOL *pVal)
{
	*pVal = m_bReadonly ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CCommDialog::put_ReadOnly(BOOL newVal)
{
	m_bReadonly = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_NoDereferenceLinks(BOOL *pVal)
{
	*pVal = m_bNoDereferenceLinks;
	return S_OK;
}

STDMETHODIMP CCommDialog::put_NoDereferenceLinks(BOOL newVal)
{
	m_bNoDereferenceLinks = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_InitialDir(BSTR *pVal)
{
	*pVal = m_bstr_InitialDir.copy();
	return S_OK;
}

STDMETHODIMP CCommDialog::put_InitialDir(BSTR newVal)
{
	m_bstr_InitialDir = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_HWND(long *pVal)
{
	*pVal = (long)m_hStaticMainWindow;
	return S_OK;
}

STDMETHODIMP CCommDialog::put_HWND(long newVal)
{
	m_hStaticMainWindow = (HWND)newVal;
	if (m_pMainWindow) {
		m_pMainWindow->Release();
		m_pMainWindow = NULL;
	}
	return S_OK;
}

STDMETHODIMP CCommDialog::get_BrowseForFolderCaption(BSTR *pVal)
{
	*pVal = m_bstr_BrowseForFolderCaption.copy();
	return S_OK;
}

STDMETHODIMP CCommDialog::put_BrowseForFolderCaption(BSTR newVal)
{
	m_bstr_BrowseForFolderCaption = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::BrowseForFolder(VARIANT varCaption, VARIANT varDir, VARIANT varMode, VARIANT* pvarReturn)
{
	::VariantInit(pvarReturn);

	// LvV̐ݒ
	CComVariant caption;
	if (varCaption.vt != VT_ERROR && varCaption.vt != VT_NULL && varCaption.vt != VT_EMPTY &&
		SUCCEEDED(caption.ChangeType(VT_BSTR, &varCaption))) {
		put_BrowseForFolderCaption(caption.bstrVal);
	}

	ATL::CString szTitle;
	{
		if (m_bstr_BrowseForFolderCaption.length() > 0) {
			szTitle = (LPCWSTR)m_bstr_BrowseForFolderCaption;
		}
	}

	ATL::CString szDirName;
	{
		CComVariant path;
		if (SUCCEEDED(path.ChangeType(VT_BSTR, &varDir))) {
			// t@C̎o
			szDirName = path.bstrVal;
		}
	}

	CComBSTR strInitDir(szDirName);

	BROWSEINFO binfo = { 0 };
	binfo.hwndOwner = GetMainWindow();
	binfo.pidlRoot = NULL;
	binfo.lpszTitle = szTitle.IsEmpty() ? NULL : szTitle;
	binfo.ulFlags = BIF_RETURNONLYFSDIRS | BIF_NEWDIALOGSTYLE | BIF_SHAREABLE;
	// KMAX_PATH̃obt@mۂ
	binfo.pszDisplayName = szDirName.GetBufferSetLength(MAX_PATH);

	int mode = 0;
	CComVariant varTmp;
	if (SUCCEEDED(varTmp.ChangeType(VT_I4, &varMode))) {
		mode = varTmp.lVal;
	}

	binfo.ulFlags = 0;//BIF_NEWDIALOGSTYLE; // BIF_USENEWUI
	switch (mode & 0x0f) {
	case 0:
	default:
		binfo.ulFlags |= BIF_RETURNONLYFSDIRS | BIF_NEWDIALOGSTYLE;
		binfo.lpfn = BrowseCallbackProc;
		// BFFM_SETSELECTIONŏtH_w肷ꍇAp[^͏UNICODEł.
		binfo.lParam = reinterpret_cast<LPARAM>(static_cast<LPCWSTR>(strInitDir));
		break;

	case 1:
		binfo.ulFlags |= BIF_BROWSEFORCOMPUTER;
		break;

	case 2:
		binfo.ulFlags |= BIF_BROWSEFORPRINTER;
		break;

	case 3:
		binfo.ulFlags |= BIF_RETURNFSANCESTORS;
		break;
	}

	if (mode & 0x10) {
		binfo.ulFlags |= BIF_BROWSEINCLUDEFILES;
	}
	if (mode & 0x20) {
		binfo.ulFlags |= BIF_BROWSEINCLUDEURLS;
	}
	if (mode & 0x40) {
		binfo.ulFlags |= BIF_DONTGOBELOWDOMAIN;
	}

	// VF̃AP[^
	CComPtr<IMalloc> pMalloc(NULL);
	HRESULT hr;
	if (FAILED(hr = SHGetMalloc(&pMalloc))) {
		return hr;
	}

	// tH_̃uEY
	LPITEMIDLIST idlst = NULL;
	if ((idlst = SHBrowseForFolder(&binfo)) != NULL) {

		// ʃpX̎擾
		CComVariant tmp(_TEXT("")); // 擾łȂꍇ͋󕶎
		ATL::CString ret;
		TCHAR path[MAX_PATH] = { 0 };
		if (SHGetPathFromIDList(idlst, path)) {
			tmp = path;
		}

		pMalloc->Free(idlst);
		return tmp.Detach(pvarReturn);
	}
	return S_OK;
}


int CALLBACK CCommDialog::BrowseCallbackProc(HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	switch (uMsg) {
	case BFFM_INITIALIZED:
		if (lpData) {
			SendMessage(hwnd, BFFM_SETSELECTION, true, lpData);
		}
		break;

	case BFFM_SELCHANGED:
		{
			LPITEMIDLIST pidl = reinterpret_cast<LPITEMIDLIST>(lParam);
			BOOL enabled = FALSE;
			if (pidl) {
				TCHAR tmp[MAX_PATH];
				if (SHGetPathFromIDList(pidl, tmp)) {
					enabled = TRUE;
				}
			}
			SendMessage(hwnd, BFFM_ENABLEOK, 0, enabled);
		}
		break;

	case BFFM_VALIDATEFAILED:
		break;
	}
	return 0;
}

HWND CCommDialog::GetMainWindow()
{
	HWND hWnd = m_hStaticMainWindow;
	if (m_pMainWindow) {
		m_pMainWindow->get_HWND((long*)&hWnd);
	}
	return hWnd;
}

STDMETHODIMP CCommDialog::SetMainWindow(VARIANT varUnk)
{
	// ̃C^[tFCX̉
	if (m_pMainWindow) {
		m_pMainWindow->Release();
		m_pMainWindow = NULL;
	}
	// C^[tFCX̎擾
	CComVariant tmp;
	HRESULT hr;
	if (FAILED(hr = tmp.ChangeType(VT_UNKNOWN, &varUnk))) {
		return hr;
	}
	return tmp.punkVal->QueryInterface(&m_pMainWindow);
}

STDMETHODIMP CCommDialog::MessageBox(VARIANT mes, VARIANT typ, VARIANT icon, VARIANT* pRet)
{
	CComVariant ret;

	ATL::CString msg;
	CComVariant varMes;
	if (SUCCEEDED(varMes.ChangeType(VT_BSTR, &mes))) {
		msg = varMes.bstrVal;
	}

	UINT mode = MB_OK;
	CComVariant varType, varIcon;
	if (SUCCEEDED(varType.ChangeType(VT_I2, &typ))) {
		if (varType.iVal / 10) {
			mode = MB_DEFBUTTON2;
		}

		switch (varType.iVal % 10) {
		case 0:
		default:
			mode |= MB_OK;
			break;

		case 1:
			mode |= MB_OKCANCEL;
			break;

		case 2:
			mode |= MB_YESNO;
			break;

		case 3:
			mode |= MB_YESNOCANCEL;
			break;

		case 4:
			mode |= MB_RETRYCANCEL;
			break;

		case 5:
			mode |= MB_ABORTRETRYIGNORE;
			break;
		}
	}

	if (SUCCEEDED(varIcon.ChangeType(VT_I2, &icon))) {
		switch (varIcon.iVal) {
		case 0:
		default:
			break;

		case 1:
			mode |= MB_ICONERROR;
			break;

		case 2:
			mode |= MB_ICONWARNING;
			break;

		case 3:
			mode |= MB_ICONINFORMATION;
			break;

		case 4:
			mode |= MB_ICONQUESTION;
			break;
		}
	}

	int md = ::MessageBox(GetMainWindow(), msg, GetMainCaption(), mode);
	switch (md) {
	case IDOK:
	case IDYES:
	case IDRETRY:
		ret = (short)1;
		break;
	case IDCANCEL:
	case IDABORT:
		ret = (short)-1;
		break;
	case IDNO:
	case IDIGNORE:
		ret = (short)0;
		break;
	}
	*pRet = ret;
	return S_OK;
}

ATL::CString CCommDialog::GetMainCaption()
{
	ATL::CString szCaption;
	if (m_bstr_MessageCaption.Length() == 0 && m_pMainWindow) {
		// LvVw肳ĂȂȂ擾
		CComBSTR bstrCaption;
		if (SUCCEEDED(m_pMainWindow->get_Caption(&bstrCaption))) {
			szCaption = bstrCaption;
		}
	}
	return szCaption;
}

STDMETHODIMP CCommDialog::get_MessageCaption(BSTR *pVal)
{
	*pVal = m_bstr_MessageCaption.Copy();
	return S_OK;
}

STDMETHODIMP CCommDialog::put_MessageCaption(BSTR newVal)
{
	m_bstr_MessageCaption = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::ColorDialog(VARIANT *pcolorVal)
{
	::VariantInit(pcolorVal);
	m_color.hwndOwner = GetMainWindow();
	if (ChooseColor(&m_color)) {
		pcolorVal->vt = VT_I4;
		pcolorVal->lVal = (long)m_color.rgbResult;
	}
	return S_OK;
}
