// ObjectVector.cpp : CObjectVector ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "ObjectVector.h"
#include "generic.h"
#include "CComEnumDynaVARIANT.h"

/////////////////////////////////////////////////////////////////////////////
// CObjectVector

STDMETHODIMP CObjectVector::CreateVector(IUnknown **punkVal)
{
	if (!punkVal) {
		return E_POINTER;
	}
	*punkVal = NULL;

	CComObject<CObjectVector>* pVct = NULL;
	HRESULT hr;
	if (FAILED(hr = CComObject<CObjectVector>::CreateInstance(&pVct))) {
		return hr;
	}

	if (FAILED(hr = pVct->QueryInterface(punkVal))) {
		delete pVct;
		return hr;
	}
	return S_OK;
}

STDMETHODIMP CObjectVector::Duplicate(VARIANT idx, VARIANT count, IUnknown **punkVal)
{
	if (!punkVal) {
		return E_POINTER;
	}
	*punkVal = NULL;

	CComObject<CObjectVector>* pVct = NULL;
	HRESULT hr;
	if (FAILED(hr = CComObject<CObjectVector>::CreateInstance(&pVct))) {
		return hr;
	}
	if (FAILED(hr = pVct->QueryInterface(punkVal))) {
		delete pVct;
		return hr;
	}

	if (!m_vctVariant.empty()) {
		// wʒuw萔̕
		CComVariant varIdx, varCount;
		long nIdx = 0;
		if (SUCCEEDED(varIdx.ChangeType(VT_I4, &idx))) {
			nIdx = varIdx.lVal;
		}

		long nCount = -1; // 0w肷Ɩ܂ł̃JEgvZ
		if (SUCCEEDED(varCount.ChangeType(VT_I4, &count))) {
			nCount = varCount.lVal;
		}

		long mx = m_vctVariant.size();
		if (nCount < 0 || nIdx + nCount >= mx) {
			nCount = mx - nIdx;
		}

		if (nIdx < 0) {
			nIdx = 0;
		}

		if (nIdx < mx) {
			for (long i = 0; i < nCount; i++) {
				pVct->m_vctVariant.push_back(m_vctVariant[nIdx + i]);
			}
		}
	}
	return S_OK;
}

STDMETHODIMP CObjectVector::Clear()
{
	//VARIANT̃NAƘAzz̉
	VariantVector::iterator p = m_vctVariant.begin();
	while (p != m_vctVariant.end()) {
		p->Clear();
		p++;
	}
	m_vctVariant.clear();
	return S_OK;
}

STDMETHODIMP CObjectVector::Erase(VARIANT idx, VARIANT count)
{
	// wʒuw萔̍폜
	CComVariant varIdx, varCount;
	long nIdx = 0;
	if (SUCCEEDED(varIdx.ChangeType(VT_I4, &idx))) {
		nIdx = varIdx.lVal;
	}

	long nCount = 1;
	if (SUCCEEDED(varCount.ChangeType(VT_I4, &count))) {
		nCount = varCount.lVal;
	}

	long mx = m_vctVariant.size();
	if (nCount < 0 || nIdx + nCount >= mx) {
		nCount = mx - nIdx;
	}
	if (nIdx < 0 || nIdx >= mx || nCount < 0) {
		return DISP_E_BADINDEX;
	}

	m_vctVariant.erase(m_vctVariant.begin() + nIdx, m_vctVariant.begin() + nIdx + nCount);
	return S_OK;
}

STDMETHODIMP CObjectVector::Push(VARIANT newVal)
{
	HRESULT hr;

	CComVariant tmp;
	if (FAILED(hr = VariantCopyByVal(&tmp, &newVal))) {
		return hr;
	}

	// ɒǉ
	m_vctVariant.push_back(tmp);
	return S_OK;
}

STDMETHODIMP CObjectVector::Pop(VARIANT *pVal)
{
	// o
	::VariantInit(pVal);
	if (!m_vctVariant.empty()) {
		long mx = m_vctVariant.size();
		::VariantInit(pVal);
		::VariantCopy(pVal, &m_vctVariant[mx - 1]);
		m_vctVariant.pop_back();
	}
	return S_OK;
}

STDMETHODIMP CObjectVector::Insert(VARIANT idx, VARIANT newVal)
{
	// wʒuɑ}
	CComVariant varIdx;
	long nIdx = 0;
	if (SUCCEEDED(varIdx.ChangeType(VT_I4, &idx))) {
		nIdx = varIdx.lVal;
	}

	long mx = m_vctVariant.size();
	if (nIdx < 0 || nIdx >= mx) {
		return DISP_E_BADINDEX;
	}

	HRESULT hr;

	CComVariant tmp;
	if (FAILED(hr = VariantCopyByVal(&tmp, &newVal))) {
		return hr;
	}

	m_vctVariant.insert(m_vctVariant.begin() + nIdx, tmp);
	return S_OK;
}

STDMETHODIMP CObjectVector::get_Value(VARIANT idx, VARIANT *pVal)
{
	::VariantInit(pVal);

	long nIdx = 0;
	CComVariant varIdx;
	if (SUCCEEDED(varIdx.ChangeType(VT_I4, &idx))) {
		nIdx = varIdx.lVal;
	}

	if (nIdx < 0) {
		return DISP_E_BADINDEX;
	}

	long mx = m_vctVariant.size();
	if (nIdx < mx) {
		// xN^[͈͓̔Ȃl擾
		return ::VariantCopy(pVal, &m_vctVariant[nIdx]);
	}
	return S_FALSE;
}

STDMETHODIMP CObjectVector::put_Value(VARIANT idx, VARIANT newVal)
{
	long nIdx = 0;
	CComVariant varIdx;
	if (SUCCEEDED(varIdx.ChangeType(VT_I4, &idx))) {
		nIdx = varIdx.lVal;
	}
	if (nIdx < 0) {
		return DISP_E_BADINDEX;
	}

	long mx = m_vctVariant.size();
	if (nIdx >= mx) {
		// xN^[͈̔͂𒴂ĂΊgAꂽVARIANTŖ߂
		VARIANT tmp;
		::VariantInit(&tmp);
		while (mx <= nIdx) {
			m_vctVariant.push_back(tmp);
			mx++;
		}
	}

	HRESULT hr;

	CComVariant tmp;
	if (FAILED(hr = VariantCopyByVal(&tmp, &newVal))) {
		return hr;
	}

	// xN^[͈͓̔ȂlĐݒ肷
	if (FAILED(hr = ::VariantClear(&m_vctVariant.at(nIdx)))) {
		return hr;
	}

	return ::VariantCopy(&m_vctVariant.at(nIdx), &tmp);
}

STDMETHODIMP CObjectVector::get_Count(long *pVal)
{
	*pVal = m_vctVariant.size();
	return S_OK;
}

STDMETHODIMP CObjectVector::get__NewEnum(IUnknown **pVal)
{
	typedef CComEnumDynaVARIANT<CObjectVector> CComEnumDynaVector;
	CComObject<CComEnumDynaVector>* pDyna = NULL;
	HRESULT hr;
	if (FAILED(hr = CComObject<CComEnumDynaVector>::CreateInstance(&pDyna))) {
		return hr;
	}
	pDyna->Init(this, 0);
	return pDyna->QueryInterface(IID_IEnumVARIANT, (void**)pVal);
}

STDMETHODIMP CObjectVector::Merge(VARIANT unkVal)
{
	HRESULT hr;

	CComVariant varUnk;
	if (SUCCEEDED(varUnk.ChangeType(VT_UNKNOWN, &unkVal))) {
		// C^[tFCX̏ꍇ
		CComPtr<IObjectVector> pVect;
		if (FAILED(hr = varUnk.punkVal->QueryInterface(&pVect))) {
			// wÕC^[tFCXł
			return hr;
		}

		long mx;
		pVect->get_Count(&mx);

		long i;
		for (i = 0; i < mx; i++) {
			CComVariant idx((long)i);
			VARIANT ret;
			::VariantInit(&ret);
			pVect->get_Value(idx, &ret);
			m_vctVariant.push_back(ret);
		}
		pVect.Release();
		return S_OK;
	}

	VARTYPE vt = VT_EMPTY;
	SAFEARRAY* pArray = GetArrayFromVariant(unkVal, &vt);
	if (!pArray || vt != VT_VARIANT) {
		return S_FALSE;
	}

	long lb = 0;
	long ub = 0;
	int dm = SafeArrayGetDim(pArray);
	SafeArrayGetLBound(pArray, 1, &lb); // ̓Y
	SafeArrayGetUBound(pArray, 1, &ub);
	if (dm == 1 && lb == 0 && vt == VT_VARIANT) {
		// 1zŁA0x[X̃oAgzł
		int cnt;
		long dim[1];
		for (cnt = 0; cnt <= ub; cnt++) {
			// VARIANT̔zł
			VARIANT tmp;
			::VariantInit(&tmp);
			dim[0] = cnt;
			SafeArrayGetElement(pArray, dim, &tmp);
			m_vctVariant.push_back(tmp);
		}//next(z̃[v)
	}
	return S_OK;
}

STDMETHODIMP CObjectVector::MakeArray(VARIANT *pVal)
{
	long mx = m_vctVariant.size();
	SAFEARRAY* pArray = SafeArrayCreateVector(VT_VARIANT, 0, mx);
	if (!pArray) {
		return E_OUTOFMEMORY;
	}

	HRESULT hr;

	VARIANT* pvars;
	if (FAILED(hr = SafeArrayAccessData(pArray, (void**)&pvars))) {
		SafeArrayDestroy(pArray);
		return hr;
	}

	long cnt = 0;
	for (cnt = 0; cnt < mx; cnt++) {
		VariantInit(&pvars[cnt]);
		VariantCopy(&pvars[cnt], &m_vctVariant.at(cnt));
	}
	SafeArrayUnaccessData(pArray);

	pArray->fFeatures |= FADF_HAVEVARTYPE;
	pVal->vt = VT_ARRAY | VT_VARIANT;
	pVal->parray = pArray;
	return S_OK;
}
