// TreeItem.h : CTreeItem ̐錾

#pragma once

#include "resource.h"       // C V{
#include "generic.h"

/////////////////////////////////////////////////////////////////////////////
// CTreeItem
class ATL_NO_VTABLE CTreeItem :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CTreeItem, &CLSID_TreeItem>,
	public ISupportErrorInfoImpl<&IID_ITreeItem>,
	public IDispatchImpl<ITreeItem, &IID_ITreeItem, &LIBID_SERAPHYSCRIPTTOOLSLib>
{
public:
	CTreeItem()
		: m_hWnd(NULL)
		, m_hItem(NULL)
	{
	}

	//DECLARE_REGISTRY_RESOURCEID(IDR_TREEITEM)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	BEGIN_COM_MAP(CTreeItem)
		COM_INTERFACE_ENTRY(ITreeItem)
		COM_INTERFACE_ENTRY(IDispatch)
		COM_INTERFACE_ENTRY(ISupportErrorInfo)
	END_COM_MAP()

	// ITreeItem
public:
	STDMETHOD(IsValid)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(Sort)();
	STDMETHOD(Expand)();
	STDMETHOD(Select)();
	STDMETHOD(Erase)();
	STDMETHOD(Create)(/*[in]*/VARIANT text,/*[out,retval]*/IUnknown** punkVal);
	STDMETHOD(get_Object)(/*[in,optional]*/VARIANT idx, /*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(get_Text)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Text)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_PrevItem)(/*[out, retval]*/ IUnknown* *pVal);
	STDMETHOD(get_NextItem)(/*[out, retval]*/ IUnknown* *pVal);
	STDMETHOD(get_ChildItem)(/*[out, retval]*/ IUnknown* *pVal);
	STDMETHOD(get_Parent)(/*[out, retval]*/ IUnknown* *pVal);

	//
	static BOOL DeleteTreeItemWithData(HWND hWnd, HTREEITEM hItem);
	static HRESULT CreateTreeItem(HWND hWnd, HTREEITEM hParent, LPCTSTR text, IUnknown** punkVal);
	HRESULT InitialCheck();
	void SetParam(HWND hWnd, HTREEITEM hItem);

protected:
	HWND m_hWnd;
	HTREEITEM m_hItem;
};
