// Control.cpp : CControl ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "Control.h"
#include "treeitem.h"
#include "generic.h"
#include "objectmap.h"
#include <list>
using namespace std;

/////////////////////////////////////////////////////////////////////////////
// CControl

STDMETHODIMP CControl::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IControl
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (IsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CControl::get_Text(BSTR *pVal)
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	DWORD siz = ::GetWindowTextLength(m_hWnd);
	LPSTR pMes = new CHAR[siz+1];
	GetWindowText(m_hWnd,pMes,siz+1);
	_bstr_t tmp = (LPCSTR)pMes;
	*pVal = tmp.copy();
	delete[]pMes;
	return S_OK;
}

STDMETHODIMP CControl::put_Text(BSTR newVal)
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	_bstr_t tmp(newVal,true);
	::SetWindowText(m_hWnd,(LPCSTR)tmp);
	return S_OK;
}

STDMETHODIMP CControl::get_ID(short *pVal)
{
	if(m_hWnd){
		m_nID = (int)GetWindowLong(m_hWnd,GWL_ID);
	}
	*pVal = m_nID;
	return S_OK;
}

STDMETHODIMP CControl::put_ID(short newVal)
{
	m_nID = newVal;
	if(m_hWnd){
		SetWindowLong(m_hWnd,GWL_ID,newVal);
		if((m_nID == IDOK) && !lstrcmp(m_classname,"BUTTON")){
			// IDOKȂ|bV{^^fBtHg{^ɕω
			DWORD m_style = ::GetWindowLong(m_hWnd,GWL_STYLE);
			m_style |=  BS_DEFPUSHBUTTON;
			::SetWindowLong(m_hWnd,GWL_STYLE,m_style);
		}
	}
	return S_OK;
}

STDMETHODIMP CControl::get_Visibility(BOOL *pVal)
{
	if(!m_hParent || !m_hWnd){
		*pVal = 0;
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	WINDOWPLACEMENT pls = {0};
	pls.length = sizeof(WINDOWPLACEMENT);
	::GetWindowPlacement(m_hWnd,&pls);
	*pVal = (pls.showCmd != SW_HIDE)?true:false;
	return S_OK;
}

STDMETHODIMP CControl::put_Visibility(BOOL newVal)
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	::ShowWindow(m_hWnd,newVal?SW_SHOWNORMAL:SW_HIDE);
	return S_OK;
}

STDMETHODIMP CControl::get_Enable(BOOL *pVal)
{
	if(!m_hParent || !m_hWnd){
		*pVal = 0;
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	*pVal = ::IsWindowEnabled(m_hWnd);
	return S_OK;
}

STDMETHODIMP CControl::put_Enable(BOOL newVal)
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	::EnableWindow(m_hWnd,newVal);
	return S_OK;
}

STDMETHODIMP CControl::get_CheckState(short *pVal)
{
	if(m_hWnd){
		m_bChecked = (short)::SendMessage(m_hWnd,BM_GETCHECK,0,0);
	}
	*pVal = m_bChecked;
	return S_OK;
}

STDMETHODIMP CControl::put_CheckState(short newVal)
{
	m_bChecked = newVal;
	if(m_hWnd && newVal >= 0 && newVal <= 2){
		// 0:Unchecked 1:Checked 2:interminate
		::SendMessage(m_hWnd,BM_SETCHECK,newVal,0);
	}
	return S_OK;
}

BOOL CControl::Create(HWND hParent)
{
	// << fBtHg̃vbV{^ɕωNp >>
	if((m_nID == IDOK) && !lstrcmp(m_classname,"BUTTON")){
		// IDOKȂύX
		m_style |=  BS_DEFPUSHBUTTON;
	}

	//@Rg[̐
	ATLASSERT(m_hParent == NULL);
	m_hParent = hParent;
	m_hWnd = ::CreateWindowEx(m_exstyle,m_classname,m_caption
		,m_style | WS_VISIBLE | WS_CHILD | WS_CLIPSIBLINGS
		,m_x,m_y,m_w,m_h
		,hParent
		,NULL
		,_Module.m_hInst
		,NULL);
	::SetWindowLong(m_hWnd, GWL_ID, m_nID);
	::SetWindowLong(m_hWnd, GWL_USERDATA,(LPARAM)this);
	::SetWindowText(m_hWnd,m_caption);

	// efBZ[uȂqfBZ[uԂō쐬
	if(!::IsWindowEnabled(m_hParent)){
		::EnableWindow(m_hWnd,false);
	}

	//////////////////////////
	// OԂ̐ݒ
	if(!lstrcmp(m_classname,"BUTTON")){
		// {^Ȃ`FbNԂ̃Zbg
		if(m_bChecked){
			::SendMessage(m_hWnd,BM_SETCHECK,1,0);
		}
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[ȂJ̐ݒs
		TCHAR szColumn[MAX_PATH];
		LPCSTR p = m_caption;
		m_nColumnCount = 0;
		// EBhELvV񌩏o쐬
		while(*p){
			LPCSTR d = p;
			while(*p && *p != ',' && *p != ':'){
				p = CharNext(p);
			}
			int sz = p - d;
			if(sz >= MAX_PATH) sz = MAX_PATH - 1;
			CopyMemory(szColumn,d,p - d);
			szColumn[p-d] = 0;
			LVCOLUMN col = {0};
			col.mask    = LVCF_TEXT | LVCF_WIDTH;
			col.pszText = szColumn;
			col.cx      = ListView_GetStringWidth(m_hWnd,szColumn) + 16;
			ListView_InsertColumn(m_hWnd,m_nColumnCount,&col);
			if(*p == ',' || *p == ':') p++;
			m_nColumnCount++;
		}
		if(m_afterstyle){
			ListView_SetExtendedListViewStyle(m_hWnd,m_afterstyle);
		}
	}
	else if(!lstrcmp(m_classname,WC_TREEVIEW)){
		TreeView_SetImageList(m_hWnd,NULL,TVSIL_NORMAL);
	}
	return true;
}

void CControl::Destroy()
{
	DeleteAllItems();
	if(m_hWnd){
		// EBhEj
		// EBhE̔jƃC^[tFCX̔j͈vȂB
		::DestroyWindow(m_hWnd);
		m_hWnd    = NULL;
	}
}

STDMETHODIMP CControl::get_Width(short *pVal)
{
	if(m_hWnd){
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd,&pls);
		m_w = (short)(pls.rcNormalPosition.right - pls.rcNormalPosition.left);
	}
	*pVal = m_w;
	return S_OK;
}

STDMETHODIMP CControl::put_Width(short newVal)
{
	m_w = newVal;
	if(m_hWnd){
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd,&pls);
		::SetWindowPos(m_hWnd,NULL,0,0,m_w,pls.rcNormalPosition.right - pls.rcNormalPosition.left,SWP_NOZORDER|SWP_NOMOVE);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_Height(short *pVal)
{
	if(m_hWnd){
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd,&pls);
		m_h = (short)(pls.rcNormalPosition.bottom - pls.rcNormalPosition.top);
	}
	*pVal = m_h;
	return S_OK;
}

STDMETHODIMP CControl::put_Height(short newVal)
{
	m_h = newVal;
	if(m_hWnd){
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd,&pls);
		::SetWindowPos(m_hWnd,NULL,0,0,m_h,pls.rcNormalPosition.right - pls.rcNormalPosition.left,SWP_NOZORDER|SWP_NOMOVE);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_PosX(short *pVal)
{
	if(m_hWnd){
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd,&pls);
		m_x = (short)pls.rcNormalPosition.left;
	}
	*pVal = m_x;
	return S_OK;
}

STDMETHODIMP CControl::put_PosX(short newVal)
{
	m_x = newVal;
	if(m_hWnd){
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd,&pls);
		::SetWindowPos(m_hWnd,NULL,m_x,pls.rcNormalPosition.top,0,0,SWP_NOZORDER|SWP_NOSIZE);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_PosY(short *pVal)
{
	if(m_hWnd){
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd,&pls);
		m_y = (short)pls.rcNormalPosition.top;
	}
	*pVal = m_y;
	return S_OK;
}

STDMETHODIMP CControl::put_PosY(short newVal)
{
	m_y = newVal;
	if(m_hWnd){
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd,&pls);
		::SetWindowPos(m_hWnd,NULL,pls.rcNormalPosition.left,m_y,0,0,SWP_NOZORDER|SWP_NOSIZE);
	}
	return S_OK;
}

STDMETHODIMP CControl::SetPlacement(VARIANT x, VARIANT y, VARIANT w, VARIANT h, VARIANT *pvarUnk)
{
	// TCYύX
	CComVariant varX,varY,varW,varH;
	if((x.vt != VT_EMPTY && x.vt != VT_NULL && x.vt != VT_ERROR) && varX.ChangeType(VT_I2,&x) == S_OK){
		m_x = varX.iVal;
	}
	if((y.vt != VT_EMPTY && y.vt != VT_NULL && y.vt != VT_ERROR) && varY.ChangeType(VT_I2,&y) == S_OK){
		m_y = varY.iVal;
	}
	if((h.vt != VT_EMPTY && h.vt != VT_NULL && h.vt != VT_ERROR) && varH.ChangeType(VT_I2,&h) == S_OK){
		m_h = varH.iVal;
	}
	if((w.vt != VT_EMPTY && w.vt != VT_NULL && w.vt != VT_ERROR) && varW.ChangeType(VT_I2,&w) == S_OK){
		m_w = varW.iVal;
	}
	// EBhE\Ă΂ɔf
	if(m_hWnd){
		::SetWindowPos(m_hWnd,NULL,m_x,m_y,m_w,m_h,SWP_NOZORDER);
	}
	GetThisInterface(pvarUnk);
	return S_OK;
}

STDMETHODIMP CControl::SetCheck(VARIANT *pvarUnk)
{
	// Ƀ`FbN
	put_CheckState(true);
	GetThisInterface(pvarUnk);
	return S_OK;
}

STDMETHODIMP CControl::SetID(VARIANT varID, VARIANT *pvarUnk)
{
	// ID蓖Ă
	CComVariant tmp;
	if(varID.vt != VT_EMPTY && varID.vt != VT_EMPTY && varID.vt != VT_EMPTY
		&& (tmp.ChangeType(VT_I2,&varID) == S_OK)){
		if(tmp.iVal > 0){
			put_ID(tmp.iVal);
		}
	}
	GetThisInterface(pvarUnk);
	return S_OK;
}

void CControl::GetThisInterface(VARIANT *pvarUnk)
{
	// ̃C^[tFCXԂ
	::VariantInit(pvarUnk);
	IUnknown* pUnk = NULL;
	if(QueryInterface(IID_IUnknown,(void**)&pUnk) == S_OK){
		pvarUnk->vt       = VT_UNKNOWN;
		pvarUnk->punkVal = pUnk;
	}
}

int CControl::GetID()
{
	return m_nID;
}

STDMETHODIMP CControl::get_Style(long *pVal)
{
	if(m_hWnd){
		m_style = ::GetWindowLong(m_hWnd,GWL_STYLE);
	}
	*pVal = m_style;
	return S_OK;
}

STDMETHODIMP CControl::put_Style(long newVal)
{
	m_style = newVal;
	if(m_hWnd){
		::SetWindowLong(m_hWnd,GWL_STYLE,m_style);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_Exstyle(long *pVal)
{
	if(m_hWnd){
		m_exstyle = ::GetWindowLong(m_hWnd,GWL_EXSTYLE);
	}
	*pVal = m_exstyle;
	return S_OK;
}

STDMETHODIMP CControl::put_Exstyle(long newVal)
{
	m_exstyle = newVal;
	if(m_hWnd){
		::SetWindowLong(m_hWnd,GWL_EXSTYLE,m_exstyle);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_ClassName(BSTR *pVal)
{
	WCHAR wmes[MAX_PATH];
	MultiByteToWideChar(GetACP(),0,m_classname,-1,wmes,MAX_PATH);
	*pVal = SysAllocString(wmes);
	return S_OK;
}

STDMETHODIMP CControl::Refresh()
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	::SetWindowPos(m_hWnd,NULL,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOZORDER|SWP_DRAWFRAME|SWP_FRAMECHANGED|SWP_NOCOPYBITS);
	return S_OK;
}

STDMETHODIMP CControl::get_HWND(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}

LPSTR CControl::ConvertVariantToString(VARIANT text)
{
	CComVariant varText;
	if(varText.ChangeType(VT_BSTR,&text) != S_OK){
		// ɕϊłȂΉȂ
		return NULL;
	}
	int sz = WideCharToMultiByte(GetACP(),0,varText.bstrVal,-1,NULL,0,NULL,NULL);
	LPSTR pBuf = new CHAR[sz+1];
	WideCharToMultiByte(GetACP(),0,varText.bstrVal,-1,pBuf,sz,NULL,NULL);
	pBuf[sz] = 0;
	return pBuf;
}

STDMETHODIMP CControl::AddString(VARIANT text,VARIANT* pRet)
{
	CComVariant ret;
	::VariantInit(pRet);
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	LPSTR pBuf;
	if(!(pBuf = ConvertVariantToString(text))){
		return DISP_E_TYPEMISMATCH;
	}

	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,"COMBOBOX")){
		// R{{bNXɕǉ
		ret = (short)SendMessage(m_hWnd,CB_ADDSTRING,0,(LPARAM)pBuf);
	}
	else if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg{bNXɕǉ
		int nIdx = SendMessage(m_hWnd,LB_ADDSTRING,0,(LPARAM)pBuf);
		// AzzIuWFNgoCh
		CComObject<CObjectMap>* pMap = NULL;
		IUnknown* pUnk = NULL;
		if(pMap->CreateInstance(&pMap) == S_OK){
			pMap->QueryInterface(IID_IUnknown,(void**)&pUnk);
		}
		::SendMessage(m_hWnd,LB_SETITEMDATA,nIdx,(LPARAM)pUnk);
		ret = (short)nIdx;
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[ɕǉ
		int cnt = ListView_GetItemCount(m_hWnd);
		LVITEM item = {0};
		item.mask    = LVIF_TEXT;
		item.pszText = pBuf;
		item.iItem   = cnt;
		int nIdx = ListView_InsertItem(m_hWnd,&item);
		// TuJ͋󕶂𖄂߂
		int i;
		for(i = 1 ; i<m_nColumnCount ; i++){
			ListView_SetItemText(m_hWnd,nIdx,i,"");
		}
		// AzzIuWFNgoCh
		CComObject<CObjectMap>* pMap = NULL;
		IUnknown* pUnk = NULL;
		if(pMap->CreateInstance(&pMap) == S_OK){
			pMap->QueryInterface(IID_IUnknown,(void**)&pUnk);
		}
		LVITEM itm = {0};
		itm.iItem  = nIdx;
		itm.mask   = LVIF_PARAM;
		itm.lParam = (LPARAM)pUnk;
		ListView_SetItem(m_hWnd,&itm);
		ret = (short)nIdx;
	}
	else if(!lstrcmp(m_classname,WC_TREEVIEW)){
		// c[r[̃[gɃACe쐬
		IUnknown* pUnk = NULL;
		CTreeItem::CreateTreeItem(m_hWnd,TVI_ROOT,pBuf,&pUnk);
		if(pUnk != NULL){
			ret = (IUnknown*)pUnk;
		}
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	ret.Detach(pRet);
	delete[]pBuf;
	return retcode;
}

STDMETHODIMP CControl::SetColumnText(VARIANT item, VARIANT col, VARIANT text)
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}

	int nIdx = -1;
	int nCol = -1;
	CComVariant varIdx,varCol;
	if(varIdx.ChangeType(VT_I2,&item) == S_OK){
		nIdx = varIdx.iVal;
	}
	if(varCol.ChangeType(VT_I2,&col) == S_OK){
		nCol = varCol.iVal;
	}
	if(nIdx < 0 || nCol < 0){
		// sE擾łȂꍇ
		return DISP_E_TYPEMISMATCH;
	}

	LPSTR pBuf;
	if(!(pBuf = ConvertVariantToString(text))){
		return DISP_E_TYPEMISMATCH;
	}

	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,WC_LISTVIEW)){
		int mx = ListView_GetItemCount(m_hWnd);
		if(nIdx >= mx || nCol >= m_nColumnCount){
			// s܂͌I[o[Ăꍇ
			ErrorInfo(IDS_ERR_RANDEOUT);
			retcode = DISP_E_EXCEPTION;
		}
		else{
			// Xgr[ɕǉ
			ListView_SetItemText(m_hWnd,nIdx,nCol,pBuf);
		}
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	delete[]pBuf;
	return retcode;
}

STDMETHODIMP CControl::GetColumnText(VARIANT idx, VARIANT col, VARIANT *pText)
{
	CComVariant ret;
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}

	int nIdx = -1;
	int nCol = -1;
	CComVariant varIdx,varCol;
	if(varIdx.ChangeType(VT_I2,&idx) == S_OK){
		nIdx = varIdx.iVal;
	}
	if(varCol.ChangeType(VT_I2,&col) == S_OK){
		nCol = varCol.iVal;
	}
	if(nIdx < 0 || nCol < 0){
		return DISP_E_TYPEMISMATCH;
	}
	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// CfbNX𒲍
		int mx = ListView_GetItemCount(m_hWnd);
		if(nIdx >= mx || nCol >= m_nColumnCount){
			ErrorInfo(IDS_ERR_RANDEOUT);
			return DISP_E_EXCEPTION;
		}
		// Xgr[當擾
		LPSTR pBuf = new CHAR[MAX_PATH+1];
		ListView_GetItemText(m_hWnd,nIdx,nCol,pBuf,MAX_PATH);
		ret = pBuf;
		delete[]pBuf;
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	ret.Detach(pText);
	return retcode;
}

STDMETHODIMP CControl::get_ItemObject(VARIANT idx, VARIANT *pVal)
{
	::VariantInit(pVal);
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}

	int nIdx = -1;
	CComVariant varIdx;
	if(varIdx.ChangeType(VT_I2,&idx) == S_OK){
		nIdx = varIdx.iVal;
	}
	if(nIdx < 0 ){
		return DISP_E_TYPEMISMATCH;
	}

	IUnknown* pUnk = NULL;
	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg{bNXAzzIuWFNg擾
		int mx = ::SendMessage(m_hWnd,LB_GETCOUNT,0,0);
		if(nIdx >= mx){
			ErrorInfo(IDS_ERR_RANDEOUT);
			return DISP_E_EXCEPTION;
		}
		DWORD data = ::SendMessage(m_hWnd,LB_GETITEMDATA ,nIdx,0);
		if(data != LB_ERR && data){
			pUnk = (IUnknown*)data;
		}
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[AzzIuWFNg擾
		int mx = ListView_GetItemCount(m_hWnd);
		if(nIdx >= mx){
			ErrorInfo(IDS_ERR_RANDEOUT);
			return DISP_E_EXCEPTION;
		}
		LVITEM itm = {0};
		itm.mask   = LVIF_PARAM;
		itm.iItem  = nIdx;
		if(ListView_GetItem(m_hWnd,&itm)){
			if(itm.lParam){
				pUnk = (IUnknown*)itm.lParam;
			}
		}
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	if(pUnk){
		pUnk->AddRef();
		pVal->vt      = VT_UNKNOWN;
		pVal->punkVal = pUnk;
	}
	return retcode;
}

STDMETHODIMP CControl::DeleteAllItems()
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	// Rg[̓ACeɊ֘AtĂAzzIuWFNg
	if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg̉
		int mx = ::SendMessage(m_hWnd,CB_GETCOUNT,0,0);
		int i;
		for(i=0;i<mx;i++){
			DWORD data = ::SendMessage(m_hWnd,LB_GETITEMDATA ,i ,0);
			if(data != LB_ERR && data){
				((IUnknown*)data)->Release();
			}
		}
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[̘Azz̉
		int mx = ListView_GetItemCount(m_hWnd);
		LVITEM itm = {0};
		int i;
		for(i=0;i<mx;i++){
			itm.mask   = LVIF_PARAM;
			itm.iItem  = i;
			if(ListView_GetItem(m_hWnd,&itm)){
				if(itm.lParam){
					((IUnknown*)itm.lParam)->Release();
				}
			}
		}
	}
	else if(!lstrcmp(m_classname,WC_TREEVIEW)){
		// c[r[̘Azz̉
		HTREEITEM hItem = TreeView_GetRoot(m_hWnd);
		while(hItem){
			HTREEITEM hNextItem = TreeView_GetNextSibling(m_hWnd,hItem);
			CTreeItem::DeleteTreeItemWithData(m_hWnd,hItem);
			hItem = hNextItem;
		}
	}
	// AzzȂRg[̏
	else if(!lstrcmp(m_classname,"COMBOBOX")){
		// COMBOBOX
		int cnt = ::SendMessage(m_hWnd,CB_GETCOUNT,0,0);
		while(cnt > 0){
			::SendMessage(m_hWnd,CB_DELETESTRING,0,0);
			cnt--;
		}
	}
	else if(!lstrcmp(m_classname,"EDIT")){
		// EditB
		CComVariant dmy(L"");
		put_Text(dmy.bstrVal);
	}
	return S_OK;
}
STDMETHODIMP CControl::DeleteString(VARIANT idx, VARIANT *pRet)
{
	CComVariant ret;
	::VariantInit(pRet);
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}

	int nIdx = -1;
	CComVariant varIdx;
	if(varIdx.ChangeType(VT_I2,&idx) == S_OK){
		nIdx = varIdx.iVal;
	}
	if(nIdx < 0 ){
		return DISP_E_TYPEMISMATCH;
	}

	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,"COMBOBOX")){
		// R{{bNX當폜
		int mx = ::SendMessage(m_hWnd,CB_GETCOUNT,0,0);
		if(nIdx >= mx){
			ErrorInfo(IDS_ERR_RANDEOUT);
			return DISP_E_EXCEPTION;
		}
		int result = ::SendMessage(m_hWnd,CB_DELETESTRING,nIdx,0);
		ret = (bool)(result != LB_ERR);
	}
	else if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg{bNX當폜
		int mx = ::SendMessage(m_hWnd,LB_GETCOUNT,0,0);
		if(nIdx >= mx){
			ErrorInfo(IDS_ERR_RANDEOUT);
			return DISP_E_EXCEPTION;
		}
		// AzzIuWFNgj
		DWORD data = ::SendMessage(m_hWnd,LB_GETITEMDATA ,nIdx,0);
		if(data != LB_ERR && data){
			((IUnknown*)data)->Release();
		}
		// 폜
		int result = ::SendMessage(m_hWnd,LB_DELETESTRING,nIdx,0);
		ret = (bool)(result != LB_ERR);
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[當폜
		int mx = ListView_GetItemCount(m_hWnd);
		if(nIdx >= mx){
			ErrorInfo(IDS_ERR_RANDEOUT);
			return DISP_E_EXCEPTION;
		}
		// AzzIuWFNgj
		LVITEM itm = {0};
		itm.mask   = LVIF_PARAM;
		itm.iItem  = nIdx;
		if(ListView_GetItem(m_hWnd,&itm)){
			if(itm.lParam){
				((IUnknown*)itm.lParam)->Release();
			}
		}
		// 폜
		ret = (bool)(ListView_DeleteItem(m_hWnd,nIdx)?true:false);
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	*pRet = ret;
	return retcode;
}

STDMETHODIMP CControl::GetCount(VARIANT *pRet)
{
	CComVariant ret;
	::VariantInit(pRet);
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}

	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,"COMBOBOX")){
		// Xg{bNX̃JEg
		int mx = ::SendMessage(m_hWnd,CB_GETCOUNT,0,0);
		if(mx == LB_ERR) mx = 0;
		ret = (short)mx;
	}
	else if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg{bNX̃JEg
		int mx = ::SendMessage(m_hWnd,LB_GETCOUNT,0,0);
		if(mx == LB_ERR) mx = 0;
		ret = (short)mx;
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[̃JEg
		ret = (short)ListView_GetItemCount(m_hWnd);
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	ret.Detach(pRet);
	return retcode;
}

STDMETHODIMP CControl::get_CurrentSelectedItem(VARIANT *pVal)
{
	::VariantInit(pVal);
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}

	CComVariant ret;
	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,"COMBOBOX")){
		// R{{bNX݂̌̑IԂ
		ret = (long)::SendMessage(m_hWnd,CB_GETCURSEL,0,0);
	}
	else if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg{bNX݂̌̑IACeԂ
		if(!(m_style & LBS_MULTIPLESEL)){
			// VOZNg̏ꍇ
			ret = (long)::SendMessage(m_hWnd,LB_GETCURSEL,0,0);
		}
		else{
			// }`ZNg̏ꍇ͍ŏ̑IACeԂ
			ret = (long)-1;
			int mx = ::SendMessage(m_hWnd,LB_GETCOUNT,0,0);
			if(mx > 0){
				long* pBuf = new long[mx+1];
				int cnt = ::SendMessage(m_hWnd,LB_GETSELITEMS,mx,(LPARAM)pBuf);
				if(cnt != LB_ERR && cnt > 0){
					ret = (long)pBuf[0];
				}
				delete[]pBuf;
			}
		}
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[̍ŏ̑IACeT
		ret = (long)ListView_GetNextItem(m_hWnd,-1,LVNI_SELECTED);
	}
	else if(!lstrcmp(m_classname,WC_TREEVIEW)){
		// c[r[̎wACȇ𒲂ׂ
		HTREEITEM hItem = TreeView_GetSelection(m_hWnd);
		if(hItem){
			CComObject<CTreeItem>* pItem = NULL;
			if(pItem->CreateInstance(&pItem) == S_OK){
				pItem->AddRef();
				pItem->SetParam(m_hWnd,hItem);
				IUnknown* pUnk = NULL;
				if(pItem->QueryInterface(IID_IUnknown,(void**)&pUnk) == S_OK){
					ret = pUnk;
				}
			}
		}
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	ret.Detach(pVal);
	return retcode;
}

STDMETHODIMP CControl::put_CurrentSelectedItem(VARIANT newVal)
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}

	HRESULT retcode = S_OK;
	long nIdx = -1;
	CComVariant varIdx;
	if(varIdx.ChangeType(VT_I4,&newVal) == S_OK){
		nIdx = varIdx.lVal;
	}
	if(!lstrcmp(m_classname,"COMBOBOX")){
		// R{{bNXIw肷
		::SendMessage(m_hWnd,CB_SETCURSEL,nIdx,0);
	}
	else if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg{bNX̑I
		if(!(m_style & LBS_MULTIPLESEL)){
			// VOZNg̏ꍇ
			::SendMessage(m_hWnd,LB_SETCURSEL,nIdx,0);
		}
		else{
			// }`ZNg̏ꍇ
			int mx = ::SendMessage(m_hWnd,LB_GETCOUNT,0,0);
			int i;
			for(i=0;i<mx;i++){
				::SendMessage(m_hWnd,LB_SETSEL,false,i);
			}
			if(nIdx >= 0 && nIdx < mx){
				::SendMessage(m_hWnd,LB_SETSEL,true,nIdx);
			}
		}
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[̑I
		int mx = ListView_GetItemCount(m_hWnd);
		int i;
		for(i = 0 ; i<mx ; i++){
			ListView_SetItemState(m_hWnd,i,LVIS_SELECTED ,0);
		}
		if(nIdx >= 0 && nIdx < mx){
			ListView_SetItemState(m_hWnd,i,LVIS_SELECTED ,LVIS_SELECTED);
		}
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	return S_OK;
}

STDMETHODIMP CControl::get__NewEnum(IUnknown **pVal)
{
	*pVal = NULL;
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}

	VARIANT* pvarArray = NULL;
	int mx = 0;

	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,"COMBOBOX")){
		// R{{bNX݂̌̑IԂ
		int nIdx = ::SendMessage(m_hWnd,CB_GETCURSEL,0,0);
		mx = 1;
		pvarArray = new VARIANT[1];
		::VariantInit(&pvarArray[0]);
		pvarArray[0].vt   = VT_I2;
		pvarArray[0].iVal = nIdx;
	}
	else if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg{bNX݂̌̑IACeԂ
		if(!(m_style & LBS_MULTIPLESEL)){
			// VOZNg̏ꍇ
			int nIdx = ::SendMessage(m_hWnd,LB_GETCURSEL,0,0);
			mx = 1;
			pvarArray = new VARIANT[1];
			::VariantInit(&pvarArray[0]);
			pvarArray[0].vt   = VT_I2;
			pvarArray[0].iVal = nIdx;
		}
		else{
			// }`ZNg̏ꍇ͍ŏ̑IACeԂ
			int sz = ::SendMessage(m_hWnd,LB_GETCOUNT,0,0);
			long* pBuf = new long[sz+1];
			mx = ::SendMessage(m_hWnd,LB_GETSELITEMS,sz,(LPARAM)pBuf);
			if(mx != LB_ERR){
				// IԂꂽꍇ
				pvarArray = new VARIANT[mx+1];
				int i;
				for(i=0 ; i<mx ; i++){
					::VariantInit(&pvarArray[i]);
					pvarArray[i].vt   = VT_I2;
					pvarArray[i].iVal = (short)pBuf[i];
				}
			}
			delete[]pBuf;
		}
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[̍ŏ̑IACeT
		mx = ListView_GetSelectedCount(m_hWnd);
		pvarArray = new VARIANT[mx+1];
		int nIdx = -1;
		int i = 0;
		while((nIdx = ListView_GetNextItem(m_hWnd,nIdx,LVNI_SELECTED)) != -1
			 && i < mx){
			::VariantInit(&pvarArray[i]);
			pvarArray[i].vt   = VT_I2;
			pvarArray[i].iVal = (short)nIdx;
			i++;
		}
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}

	// 񋓃C^[tFCX̐
	CComObject<CComEnumVARIANT>* pCol = NULL;
	if(pCol->CreateInstance(&pCol) == S_OK){
		pCol->AddRef();
		pCol->Init(&pvarArray[0],&pvarArray[mx],pCol,AtlFlagCopy);
		*pVal = pCol;
	}
	delete[]pvarArray;
	return S_OK;
}


STDMETHODIMP CControl::get_ItemSelectState(VARIANT idx, VARIANT *pVal)
{
	::VariantInit(pVal);
	CComVariant ret;

	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}

	int nIdx = -1;
	CComVariant varIdx;
	if(varIdx.ChangeType(VT_I2,&idx) == S_OK){
		nIdx = idx.iVal;
	}

	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,"COMBOBOX")){
		// R{{bNX݂̌̑IԂ
		int nSel = ::SendMessage(m_hWnd,CB_GETCURSEL,0,0);
		// w肵ACeƑIvĂtrue
		ret = (bool)((nSel == nIdx)?true:false);
	}
	else if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg{bNX݂̌̑IACeԂ
		if(!(m_style & LBS_MULTIPLESEL)){
			// VOZNg̏ꍇ
			int nSel = ::SendMessage(m_hWnd,LB_GETCURSEL,0,0);
			// w肵ACeƑIvĂtrue
			ret = (bool)((nSel == nIdx)?true:false);
		}
		else{
			// }`ZNg̏ꍇ
			ret = (bool)(::SendMessage(m_hWnd,LB_GETSEL,nIdx,0)>0?true:false);
		}
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[̎wACȇ𒲂ׂ
		int mx = ListView_GetItemCount(m_hWnd);
		if(nIdx >= 0 && nIdx < mx){
			UINT state = ListView_GetItemState(m_hWnd,nIdx,LVNI_SELECTED);
			ret = (bool)((state & LVNI_SELECTED)?true:false);
		}
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	ret.Detach(pVal);
	return retcode;
}

STDMETHODIMP CControl::put_ItemSelectState(VARIANT idx, VARIANT newVal)
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}

	int nIdx = -1;
	CComVariant varIdx;
	if(varIdx.ChangeType(VT_I2,&idx) == S_OK){
		nIdx = idx.iVal;
	}
	BOOL bSelected = false;
	CComVariant varSelected;
	if(varSelected.ChangeType(VT_I2,&newVal) == S_OK){
		bSelected = newVal.iVal;
	}

	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,"COMBOBOX")){
		// R{{bNX݂̌̑IύX
		::SendMessage(m_hWnd,CB_SETCURSEL,bSelected?nIdx:-1,0);
	}
	else if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg{bNX݂̌̑IACeԂ
		if(!(m_style & LBS_MULTIPLESEL)){
			// VOZNg̏ꍇ
			::SendMessage(m_hWnd,LB_SETCURSEL,bSelected?nIdx:-1,0);
		}
		else{
			// }`ZNg
			::SendMessage(m_hWnd,LB_SETSEL,nIdx,bSelected);
		}
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[̎wACȇ𒲂ׂ
		int mx = ListView_GetItemCount(m_hWnd);
		if(nIdx >= 0 && nIdx < mx){
			ListView_SetItemState(m_hWnd,nIdx,bSelected?LVNI_SELECTED:0,LVNI_SELECTED);
		}
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	return retcode;
}

STDMETHODIMP CControl::get_SelectedCount(short *pVal)
{
	*pVal = 0;
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}

	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,"COMBOBOX")){
		// Xg{bNX̃JEg
		int nIdx = ::SendMessage(m_hWnd,CB_GETCURSEL,0,0);
		*pVal = (short)(nIdx>=0?1:0);
	}
	else if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg{bNX̃JEg
		if(!(m_style & LBS_MULTIPLESEL)){
			int nIdx = ::SendMessage(m_hWnd,LB_GETCURSEL,0,0);
			*pVal = (short)(nIdx>=0?1:0);
		}
		else{
			// }`ZNg
			*pVal = (short)::SendMessage(m_hWnd,LB_GETSELCOUNT,0,0);
		}
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[̃JEg
		*pVal = (short)ListView_GetSelectedCount(m_hWnd);
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	return retcode;
}

STDMETHODIMP CControl::get_TreeRoot(VARIANT *pVal)
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	::VariantInit(pVal);
	if(!lstrcmp(m_classname,WC_TREEVIEW)){
		HTREEITEM hItem = TreeView_GetRoot(m_hWnd);
		CComObject<CTreeItem>* pItem = NULL;
		if(pItem->CreateInstance(&pItem) == S_OK){
			pItem->AddRef();
			pItem->SetParam(m_hWnd,hItem);
			IUnknown* pUnk = NULL;
			if(pItem->QueryInterface(IID_IUnknown,(void**)&pUnk) == S_OK){
				pVal->vt      = VT_UNKNOWN;
				pVal->punkVal = pUnk;
			}
		}
	}
	return S_OK;
}

void CControl::ListSort(int column)
{
	if(!m_hParent || !m_hWnd){
		return;
	}
	// ȂJ\[gꍇ͋tƂ
	if(m_dLastSortColumn == column){
		m_bSortReverse = !m_bSortReverse;
	}
	else{
		m_bSortReverse = false;
	}
	m_dLastSortColumn = column;
	m_typCompare = VT_EMPTY;
	// \[gĂяo
	ListView_SortItems(m_hWnd,CompareFunc,(LPARAM)this);
}

int CControl::CompareFunc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	if(!lParam1 || !lParam2){
		// CM[Bf[^[Ȃ̂Ŕrs\
		return 0;
	}
	CControl* me = (CControl*)lParamSort;

	IObjectMap* pMap1 = (IObjectMap*)lParam1;
	IObjectMap* pMap2 = (IObjectMap*)lParam2;

	CHAR mes[16];
	wsprintf(mes,"SORT%d",me->m_dLastSortColumn);
	CComVariant key(mes);

	CComVariant val1,val2;
	if(!me->m_bSortReverse){
		pMap1->get_Value(key,&val1);
		pMap2->get_Value(key,&val2);
	}
	else{
		pMap1->get_Value(key,&val2);
		pMap2->get_Value(key,&val1);
	}

	if(me->m_typCompare == VT_EMPTY){
		// ܂rJnĂȂȂr^Cv肷
		me->m_typCompare = val1.vt;
		if(val1.vt != val2.vt){
			me->m_typCompare = VT_BSTR;
		}
	}

	int ret = 0;
	switch(me->m_typCompare)
	{
	case VT_UI1:
		{
			val1.ChangeType(VT_UI1);
			val2.ChangeType(VT_UI1);
			ret = val1.bVal - val2.bVal;
			break;
		}
	case VT_I2:
		{
			val1.ChangeType(VT_I2);
			val2.ChangeType(VT_I2);
			ret = val1.iVal - val2.iVal;
			break;
		}
	case VT_I4:
		{
			val1.ChangeType(VT_I4);
			val2.ChangeType(VT_I4);
			ret = val1.lVal - val2.lVal;
			break;
		}
	case VT_R4:
		{
			val1.ChangeType(VT_R4);
			val2.ChangeType(VT_R4);
			ret = val1.fltVal > val2.fltVal;
			break;
		}
	case VT_R8:
		{
			val1.ChangeType(VT_R8);
			val2.ChangeType(VT_R8);
			ret = val1.dblVal > val2.dblVal;
			break;
		}
	case VT_CY:
		{
			val1.ChangeType(VT_CY);
			val2.ChangeType(VT_CY);
			ret = (int)(val1.cyVal.int64 - val2.cyVal.int64); //UNDONE: 낵ȂBZʂӂꂵꍇAr֐j]BȂ˂΁B
			break;
		}
	case VT_DATE:
		{
			val1.ChangeType(VT_DATE);
			val2.ChangeType(VT_DATE);
			ret = val1.date > val2.date;
			break;
		}
	case VT_BSTR:
		{
			if(val1.ChangeType(VT_BSTR) == S_OK &&
			   val2.ChangeType(VT_BSTR) == S_OK){
				ret = lstrcmpW(val1.bstrVal,val2.bstrVal);
			}
			break;
		}
	default:
		break;
	}
	return ret;
}

void CControl::OnRClick()
{
	if(!m_hParent || !m_hWnd){
		return;
	}
	if(!lstrcmp(m_classname,WC_TREEVIEW)){
		// c[r[ł΃hbvnCCgIɂ
		HTREEITEM hItem = TreeView_GetDropHilight(m_hWnd);
		if(hItem){
			TreeView_SelectItem(m_hWnd,hItem);
		}
	}
}


STDMETHODIMP CControl::get_ItemCheckState(VARIANT idx, BOOL *pVal)
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	if(lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		return DISP_E_EXCEPTION;
	}
	CComVariant varIdx;
	if(varIdx.ChangeType(VT_I2,&idx) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	*pVal = VB_FALSE;
	if(m_afterstyle & LVS_EX_CHECKBOXES){
		*pVal = ListView_GetCheckState(m_hWnd,varIdx.iVal)?VB_TRUE:VB_FALSE;
	}
	return S_OK;
}

STDMETHODIMP CControl::put_ItemCheckState(VARIANT idx, BOOL newVal)
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	if(lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		return DISP_E_EXCEPTION;
	}
	CComVariant varIdx;
	if(varIdx.ChangeType(VT_I2,&idx) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	if(m_afterstyle & LVS_EX_CHECKBOXES){
		ListView_SetCheckState(m_hWnd,varIdx.iVal,newVal);
	}
	return S_OK;
}

STDMETHODIMP CControl::DeleteSelectedItem()
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg{bNX̑I폜
		CComVariant varRet,dmy;
		while(get_CurrentSelectedItem(&varRet) == S_OK && varRet.vt != VT_EMPTY){
			varRet.ChangeType(VT_I4);
			if(varRet.lVal < 0){
				break;
			}
			DeleteString(varRet,&dmy);
		}
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		// Xgr[̍폜
		int nIdx = -1;
		while((nIdx = ListView_GetNextItem(m_hWnd,nIdx,LVNI_SELECTED)) != -1){
			CComVariant varIdx((long)nIdx),dmy;
			DeleteString(varIdx,&dmy);
			nIdx = -1;
		}
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	return S_OK;
}

STDMETHODIMP CControl::get_ItemText(VARIANT idx, BSTR *pVal)
{
	_bstr_t tmp;
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	int nIdx = -1;
	CComVariant varIdx;
	if(varIdx.ChangeType(VT_I2,&idx) == S_OK){
		nIdx = varIdx.iVal;
	}
	if(nIdx < 0){
		return DISP_E_TYPEMISMATCH;
	}

	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,"COMBOBOX")){
		// Rz{bNX當擾
		int siz = ::SendMessage(m_hWnd,CB_GETLBTEXTLEN,nIdx,0);
		if(siz > 0){
			LPTSTR p = new CHAR[siz+1];
			if(::SendMessage(m_hWnd,CB_GETLBTEXT,nIdx,(LPARAM)p) > 0){
				tmp = (LPCSTR)p;
			}
			delete[]p;
		}
	}
	else if(!lstrcmp(m_classname,"LISTBOX")){
		// Xg當擾
		int siz = ::SendMessage(m_hWnd,LB_GETTEXTLEN,nIdx,0);
		if(siz > 0){
			LPTSTR p = new CHAR[siz+1];
			if(::SendMessage(m_hWnd,LB_GETTEXT,nIdx,(LPARAM)p) > 0){
				tmp = (LPCSTR)p;
			}
			delete[]p;
		}
	}
	else if(!lstrcmp(m_classname,WC_LISTVIEW)){
		CComVariant arg,ret;
		arg = (long)0;
		if((retcode = GetColumnText(idx,arg,&ret)) == S_OK){
			if(ret.ChangeType(VT_BSTR) == S_OK){
				tmp = ret.bstrVal;
			}
		}
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	*pVal = tmp.copy();
	return retcode;
}

STDMETHODIMP CControl::put_ItemText(VARIANT idx, BSTR newVal)
{
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	int nIdx = -1;
	CComVariant varIdx;
	if(varIdx.ChangeType(VT_I2,&idx) == S_OK){
		nIdx = varIdx.iVal;
	}
	if(nIdx < 0){
		return DISP_E_TYPEMISMATCH;
	}

	HRESULT retcode = S_OK;
	if(!lstrcmp(m_classname,WC_LISTVIEW)){
		CComVariant arg,text;
		arg = (long)0;
		text = (BSTR)newVal;
		retcode = SetColumnText(idx,arg,text);
	}
	else{
		// ȊO̓T|[gO
		ErrorInfo(IDS_ERR_NOTSUPPORTCONTROL);
		retcode = DISP_E_EXCEPTION;
	}
	return retcode;
}

STDMETHODIMP CControl::SetClassEvent(BSTR name,VARIANT* pvarUnk)
{
	m_bstrClassEvent = name;
	GetThisInterface(pvarUnk);
	return S_OK;
}

void CControl::GetClassEvent(BSTR *pEventName)
{
	*pEventName = m_bstrClassEvent.copy();
}

STDMETHODIMP CControl::CreateChild(VARIANT text, VARIANT varItem, VARIANT* pvarUnk)
{
	::VariantInit(pvarUnk);
	if(!m_hParent || !m_hWnd){
		ErrorInfo(IDS_ERR_DESTROYED);
		return DISP_E_EXCEPTION;
	}
	// ACě
	CComVariant tmp;
	if(tmp.ChangeType(VT_UNKNOWN,&varItem) == S_OK){
		ITreeItem * pItem = NULL;
		if(tmp.punkVal->QueryInterface(IID_ITreeItem,(void**)&pItem) != S_OK){
			return DISP_E_UNKNOWNINTERFACE;
		}
		IUnknown* pUnk = NULL;
		if(pItem->Create(text,&pUnk) == S_OK){
			pvarUnk->vt      = VT_UNKNOWN;
			pvarUnk->punkVal = pUnk;
		}
		pItem->Release();
	}
	else{
		tmp.ChangeType(VT_VARIANT,&varItem);
		if(tmp.vt == VT_ERROR || tmp.vt == VT_NULL || tmp.vt == VT_EMPTY){
			// [gɃACe쐬
			AddString(text,pvarUnk);
		}
		else{
			return DISP_E_TYPEMISMATCH;
		}
	}
	return S_OK;
}
