// Layer.cpp : CLayer ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "Layer.h"
#include "generic.h"

/////////////////////////////////////////////////////////////////////////////
// CLayer

STDMETHODIMP CLayer::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_ILayer
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (IsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

void CLayer::Draw(CDC dc)
{
	// h[COf[^[̕`
	if(m_bVisible){
		// yAuV̐ݒ
		HPEN hPen = CreatePen(PS_SOLID,0,COLORREF(m_dwColor));
		HBRUSH hBrush = CreateSolidBrush(COLORREF(m_dwFillColor));
		HPEN hOldPen = (HPEN)SelectObject(dc.m_hDC,hPen);
		HBRUSH hOldBrush = (HBRUSH)SelectObject(dc.m_hDC,hBrush);
		COLORREF oldColor = SetTextColor(dc.m_hDC,COLORREF(m_dwFontColor));
		// tHg̑I
		int fntsiz = m_nFontSize;
		if(m_bFontTextMappingMode){
			//DPtoLP(hdc,&fz,1);
			HWND hWnd = GetDesktopWindow();
			HDC hdc = GetDC(hWnd);
			long height_mm = GetDeviceCaps(hdc,VERTSIZE) * 10;
			long height_px = GetDeviceCaps(hdc,VERTRES);
			fntsiz = MulDiv(fntsiz,height_mm,height_px);
			ReleaseDC(hWnd,hdc);
		}
		HFONT hFont = CreateFont(fntsiz,0,0,0,0,false,false,false,SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,FF_DONTCARE,m_szFontName);
		HFONT hOldFont = NULL;
		if(hFont){
			hOldFont = (HFONT)SelectObject(dc.m_hDC,hFont);
		}
		// `f[^
		EnterCriticalSection(&m_objDrawingDataProtection);
		list<drawdata*>::iterator p = m_lstDraw.begin();
		while(p != m_lstDraw.end()){
			(*p)->Draw(dc);
			p++;
		}
		LeaveCriticalSection(&m_objDrawingDataProtection);
		// IuWFNg̉
		SelectObject(dc.m_hDC,hOldPen);
		SelectObject(dc.m_hDC,hOldBrush);
		DeleteObject(hPen);
		DeleteObject(hBrush);
		SetTextColor(dc.m_hDC,oldColor);
		if(hOldFont){
			SelectObject(dc.m_hDC,hOldFont);
			DeleteObject(hFont);
		}
	}
}

void CLayer::FinalRelease()
{
	ATLTRACE("CLeayer::FinalRelease\r\n");
	// `f[^[̔j
	Clear();
	// NeBJZNV̉
	DeleteCriticalSection(&m_objDrawingDataProtection);
}

STDMETHODIMP CLayer::Text(VARIANT x,VARIANT y,VARIANT text)
{
	CComVariant str;
	if(str.ChangeType(VT_BSTR,&text) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	long lx = GetMappedValue(x);
	long ly = GetMappedValue(y);
	int len = SysStringByteLen(str.bstrVal);
	LPSTR pBuf = new CHAR[len+1];
	WideCharToMultiByte(GetACP(),0,str.bstrVal,len,pBuf,len,0,0);
	pBuf[len] = 0;
	AddDrawData(new textdata(lx,ly,pBuf,m_bTextMappingMode));
	delete[]pBuf;
	return S_OK;
}

STDMETHODIMP CLayer::TextBox(VARIANT sx, VARIANT sy, VARIANT ex, VARIANT ey, VARIANT text, VARIANT fmt)
{
	CComVariant str,cfmt;
	long lsx = GetMappedValue(sx);
	long lsy = GetMappedValue(sy);
	long lex = GetMappedValue(ex);
	long ley = GetMappedValue(ey);
	UINT ufmt = 0;
	if(cfmt.ChangeType(VT_I4,&fmt) == S_OK){
		ufmt = cfmt.lVal;
	}
	if(str.ChangeType(VT_BSTR,&text) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	int len = SysStringByteLen(str.bstrVal);
	LPSTR pBuf = new CHAR[len+1];
	int cnt = WideCharToMultiByte(GetACP(),0,str.bstrVal,-1,pBuf,len,0,0);
	pBuf[cnt-1] = 0;
	AddDrawData(new textboxdata(lsx,lsy,lex,ley,pBuf,ufmt,m_bTextMappingMode));
	delete[]pBuf;
	return S_OK;
}

STDMETHODIMP CLayer::Circle(VARIANT x, VARIANT y, VARIANT radius)
{
	long lx = GetMappedValue(x);
	long ly = GetMappedValue(y);
	long lr = GetMappedValue(radius);
	AddDrawData(new circledata(lx,ly,lr,m_bTextMappingMode));
	return S_OK;
}

STDMETHODIMP CLayer::Line(VARIANT sx, VARIANT sy, VARIANT ex, VARIANT ey)
{
	long lsx = GetMappedValue(sx);
	long lsy = GetMappedValue(sy);
	long lex = GetMappedValue(ex);
	long ley = GetMappedValue(ey);
	AddDrawData(new linedata(lsx,lsy,lex,ley,m_bTextMappingMode));
	return S_OK;
}

STDMETHODIMP CLayer::Box(VARIANT sx, VARIANT sy, VARIANT ex, VARIANT ey)
{
	long lsx = GetMappedValue(sx);
	long lsy = GetMappedValue(sy);
	long lex = GetMappedValue(ex);
	long ley = GetMappedValue(ey);
	AddDrawData(new boxdata(lsx,lsy,lex,ley,m_bTextMappingMode));
	return S_OK;
}

STDMETHODIMP CLayer::Arc(VARIANT x1, VARIANT y1, VARIANT x2, VARIANT y2, VARIANT sx, VARIANT sy, VARIANT ex, VARIANT ey)
{
	long lx1 = GetMappedValue(x1);
	long ly1 = GetMappedValue(y1);
	long lx2 = GetMappedValue(x2);
	long ly2 = GetMappedValue(y2);
	long lsx = GetMappedValue(sx);
	long lsy = GetMappedValue(sy);
	long lex = GetMappedValue(ex);
	long ley = GetMappedValue(ey);
	AddDrawData(new arcdata(lx1,ly1,lx2,ly2,lsx,lsy,lex,ley,m_bTextMappingMode));
	return S_OK;
}

STDMETHODIMP CLayer::Picture(VARIANT unk, VARIANT x, VARIANT y, VARIANT w, VARIANT h)
{
	CComVariant cUnk;
	IPicture* pPicture = NULL;
	if( cUnk.ChangeType(VT_UNKNOWN,&unk) != S_OK ||
		cUnk.punkVal->QueryInterface(IID_IPicture,(void**)&pPicture) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	long lx = GetMappedValue(x);
	long ly = GetMappedValue(y);
	int width = -1;
	if(w.vt != VT_NULL && w.vt != VT_ERROR && w.vt != VT_EMPTY){
		width = GetMappedValue(w,-1);
	}
	int height = -1;
	if(h.vt != VT_NULL && h.vt != VT_ERROR && h.vt != VT_EMPTY){
		height = GetMappedValue(h,-1);
	}
	AddDrawData(new picturedata(pPicture,lx,ly,width,height,m_bTextMappingMode));
	pPicture->Release();
	return S_OK;
}

STDMETHODIMP CLayer::FillBox(VARIANT sx, VARIANT sy, VARIANT ex, VARIANT ey)
{
	long lsx = GetMappedValue(sx);
	long lsy = GetMappedValue(sy);
	long lex = GetMappedValue(ex);
	long ley = GetMappedValue(ey);
	AddDrawData(new fillboxdata(lsx,lsy,lex,ley,m_bTextMappingMode));
	return S_OK;
}

STDMETHODIMP CLayer::FillCircle(VARIANT x, VARIANT y, VARIANT radius)
{
	long lx = GetMappedValue(x);
	long ly = GetMappedValue(y);
	long lr = GetMappedValue(radius);
	AddDrawData(new fillcircledata(lx,ly,lr,m_bTextMappingMode));
	return S_OK;
}

STDMETHODIMP CLayer::FillArc(VARIANT x1, VARIANT y1, VARIANT x2, VARIANT y2, VARIANT sx, VARIANT sy, VARIANT ex, VARIANT ey)
{
	long lx1 = GetMappedValue(x1);
	long ly1 = GetMappedValue(y1);
	long lx2 = GetMappedValue(x2);
	long ly2 = GetMappedValue(y2);
	long lsx = GetMappedValue(sx);
	long lsy = GetMappedValue(sy);
	long lex = GetMappedValue(ex);
	long ley = GetMappedValue(ey);
	AddDrawData(new fillarcdata(lx1,ly1,lx2,ly2,lsx,lsy,lex,ley,m_bTextMappingMode));
	return S_OK;
}

STDMETHODIMP CLayer::FillRBox(VARIANT sx, VARIANT sy, VARIANT ex, VARIANT ey, VARIANT w, VARIANT h)
{
	long lsx = GetMappedValue(sx);
	long lsy = GetMappedValue(sy);
	long lex = GetMappedValue(ex);
	long ley = GetMappedValue(ey);
	long lw  = GetMappedValue(w);
	long lh  = GetMappedValue(h);
	AddDrawData(new fillrboxdata(lsx,lsy,lex,ley,lw,lh,m_bTextMappingMode));
	return S_OK;
}

STDMETHODIMP CLayer::Polygon(VARIANT cx, VARIANT cy, VARIANT arrayPt)
{
	long lx = GetMappedValue(cx);
	long ly = GetMappedValue(cy);
	VARTYPE vt = VT_EMPTY;
	SAFEARRAY* pArray = GetArrayFromVariant(arrayPt,&vt);
	if(!pArray || vt != VT_VARIANT){
		return DISP_E_TYPEMISMATCH;
	}
	POINT* pPt = NULL;
	long lb = 0;
	long ub = 0;
	long lb0 = 0;
	long ub0 = 0;
	int dm = SafeArrayGetDim(pArray);
	SafeArrayGetLBound(pArray,1,&lb0); // ̓Y
	SafeArrayGetUBound(pArray,1,&ub0);
	SafeArrayGetLBound(pArray,2,&lb);  // E̓Y
	SafeArrayGetUBound(pArray,2,&ub);
	if(dm == 2 && lb == 0 && lb0 == 0 && ub0 == 2 && ub > lb && ub > 2){
		// z̎A͈͂LłB
		// p`쐬邽߂ɂ͒_3ȏKvB
		pPt = new POINT[ub + 1];
		long idx[2];
		for(int cnt = 0 ; cnt <= ub ; cnt++){
			// VARIANT̔zł
			CComVariant tmpX,tmpY;
			idx[1] = cnt;
			idx[0] = 0;
			SafeArrayGetElement(pArray,idx,&tmpX);
			idx[0] = 1;
			SafeArrayGetElement(pArray,idx,&tmpY);
			pPt[cnt].x = GetMappedValue(tmpX) + lx;
			pPt[cnt].y = GetMappedValue(tmpY) + ly;
		}
	}
	if(!pPt){
		// z̎ނȂ񂾂ȂB
		ErrorInfo(IDS_ERR_NEED2DIM);
		return DISP_E_EXCEPTION;
	}
	AddDrawData(new polygondata(pPt,ub,m_bTextMappingMode));
	return S_OK;
}

STDMETHODIMP CLayer::Clear()
{
	// h[COf[^[̔j
	EnterCriticalSection(&m_objDrawingDataProtection);
	list<drawdata*>::iterator p = m_lstDraw.begin();
	while(p != m_lstDraw.end()){
		delete *p;
		p = m_lstDraw.erase(p);
	}
	LeaveCriticalSection(&m_objDrawingDataProtection);
	return S_OK;
}

void CLayer::AddDrawData(drawdata *pDrawData)
{
	// f[^[̒ǉ
	EnterCriticalSection(&m_objDrawingDataProtection);
	m_lstDraw.push_back(pDrawData);
	LeaveCriticalSection(&m_objDrawingDataProtection);
}

STDMETHODIMP CLayer::get_Color(long *pVal)
{
	*pVal = m_dwColor;
	return S_OK;
}

STDMETHODIMP CLayer::put_Color(long newVal)
{
	m_dwColor = newVal;
	return S_OK;
}


STDMETHODIMP CLayer::get_FontColor(long *pVal)
{
	*pVal = m_dwFontColor;
	return S_OK;
}

STDMETHODIMP CLayer::put_FontColor(long newVal)
{
	m_dwFontColor = newVal;
	return S_OK;
}

STDMETHODIMP CLayer::get_Visible(BOOL *pVal)
{
	*pVal = m_bVisible;
	return S_OK;
}

STDMETHODIMP CLayer::put_Visible(BOOL newVal)
{
	m_bVisible = newVal;
	return S_OK;
}

STDMETHODIMP CLayer::get_FontName(BSTR *pVal)
{
	WCHAR wmes[MAX_PATH];
	MultiByteToWideChar(GetACP(),0,m_szFontName,-1,wmes,MAX_PATH);
	*pVal = SysAllocString(wmes);
	return S_OK;
}

STDMETHODIMP CLayer::put_FontName(BSTR newVal)
{
	WideCharToMultiByte(GetACP(),0,newVal,-1,m_szFontName,MAX_PATH,NULL,NULL);
	return S_OK;
}

STDMETHODIMP CLayer::get_FillColor(long *pVal)
{
	*pVal = m_dwFillColor;
	return S_OK;
}

STDMETHODIMP CLayer::put_FillColor(long newVal)
{
	m_dwFillColor = newVal;
	return S_OK;
}

STDMETHODIMP CLayer::get_FontSize(short *pVal)
{
	*pVal = (short)m_nFontSize;
	return S_OK;
}

STDMETHODIMP CLayer::put_FontSize(short newVal)
{
	m_nFontSize = (int)newVal;
	m_bFontTextMappingMode = m_bTextMappingMode;
	return S_OK;
}


STDMETHODIMP CLayer::SetMappingMode(VARIANT mode)
{
	CComVariant varMode;
	if(varMode.ChangeType(VT_I2,&mode) == S_OK){
		m_bTextMappingMode = varMode.iVal;
	}
	return S_OK;
}

long CLayer::GetMappedValue(VARIANT var, long def)
{
	CComVariant varTmp;
	if(m_bTextMappingMode){
		// sNZPʂ̍Ww
		if(varTmp.ChangeType(VT_I4,&var) == S_OK){
			return varTmp.lVal;
		}
	}
	else{
		// ~Pʂ̍Ww (1P 0.1mm)
		if(varTmp.ChangeType(VT_R8,&var) == S_OK){
			return (long)(varTmp.dblVal * 10);
		}
	}
	return def;
}
