// ObjectVector.h : CObjectVector ̐錾

#ifndef __OBJECTVECTOR_H_
#define __OBJECTVECTOR_H_

#include "resource.h"       // C V{
#include <vector>
using namespace std;

typedef vector<VARIANT> VariantVector;

/////////////////////////////////////////////////////////////////////////////
// CObjectVector
class ATL_NO_VTABLE CObjectVector : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CObjectVector, &CLSID_ObjectVector>,
	public ISupportErrorInfo,
	public IDispatchImpl<IObjectVector, &IID_IObjectVector, &LIBID_SERAPHYSCRIPTTOOLSLib>
{
public:
	CObjectVector()
	{
		m_vctVariant.reserve(100); // Ԃ100̃obt@mۂ
	}
	void FinalRelease()
	{
		ATLTRACE("CObjectVector::FinalRelease\r\n");
		Clear();
	}

DECLARE_REGISTRY_RESOURCEID(IDR_OBJECTVECTOR)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CObjectVector)
	COM_INTERFACE_ENTRY(IObjectVector)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IObjectVector
public:
	STDMETHOD(MakeArray)(/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(Merge)(/*[in]*/VARIANT unkVal);
	STDMETHOD(get__NewEnum)(/*[out, retval]*/ IUnknown* *pVal);
	STDMETHOD(get_Count)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Value)(/*[in,optional]*/VARIANT idx, /*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Value)(/*[in,optional]*/VARIANT idx, /*[in]*/ VARIANT newVal);
	STDMETHOD(Insert)(/*[in]*/VARIANT idx,/*[in]*/VARIANT newVal);
	STDMETHOD(Pop)(/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(Push)(/*[in]*/VARIANT newVal);
	STDMETHOD(Erase)(/*[in]*/VARIANT start,/*[in,optional]*/VARIANT count);
	STDMETHOD(Clear)();
	STDMETHOD(Duplicate)(/*[in,optional]*/VARIANT idx,/*[in,optional]*/VARIANT count,/*[out,retval]*/IUnknown** punkVal);
	STDMETHOD(CreateVector)(/*[out,retval]*/IUnknown** punkVal);
protected:
	VariantVector m_vctVariant;
};

#endif //__OBJECTVECTOR_H_
