# スクリプトの書き方

## インストールスクリプト
- 基本は`sudo apt-get -y install <package>`
- `sudo apt-get update` はウィザード本体の方で行うので必要はありませんが、リポジトリを手動で追加(/etc/apt/sources.list.d/など)にした場合は行ってください。

## アンインストールスクリプト
- 基本は    
```
sudo apt-get -y purge <package> 
sudo apt-get -y autoremove --purge
```  

- インストール時に追加したリポジトリは削除してください。
- gpgキーの削除は、`python3 delkey.py KEYWORD`で行えます。

### delkey.pyの使い方
`python3 delkey.py KEWWORD`   
`apt-key list`の出力からKEYWORDと一致する文字列を検索して、それを含むキーのIDを自動で取得して削除します。
KEYWORDは、そのキー特有と思われる文字列に置き換えてください。ただし、***先頭にuidとある行から***選んでください。

ex) wineの場合（↓`apt-key list`の出力のwineの部分 ）  

> pub   rsa3072 2018-12-10 [SC] 
>       D43F 6401 4536 9C51 D786  DDEA 76F1 A20F F987 672F  
> uid           [ unknown] ***WineHQ*** packages <wine-devel@winehq.org>  
> sub   rsa3072 2018-12-10 [E] [expires: 2020-12-09]
  

この場合はKEYWORDをWineHQとして`python3 delkey.py WineHQ`と記述します。  

### スクリプト作成後
スクリプト作成後は../src/Items.pyへの追記が必要です。  
詳しくは../src/README.mdを参照してください。  


その他不明な点があれば聞いてください！
