import subprocess
import os

class Item() :

    execute_src = None
    restore_src = None

    def __init__(self, _interface) :

        self.interface = _interface
        
        self.PATH = os.path.dirname(os.path.abspath(__file__))

    def execute(self) :
        subprocess.call(self.execute_src)
        print("")

    def restore(self) :
        subprocess.call(self.restore_src)
        print("")

    def isdefault(self, _file_name=None) :

        if _file_name is None :
            _file_name = self.name

        return not os.path.exists(self.PATH + "/../data/" + _file_name)

    def first_time(self) :
        """This returns :
            True  : (task_name, task)
            None  : nothing to do
            False : back
        """
        pass

    def show(self) :
        """show the current status"""
        pass

    def change(self) :
        pass

# ---------- Do not change above this. ----------

def getItems_first_time(_interface) :

    items = list()

    items.append(Chrome(_interface))
    items.append(Firefox(_interface))
    items.append(FFmpeg(_interface))
    items.append(Blueman(_interface))
    items.append(Kdeconnect(_interface))
    items.append(Gyazo(_interface))
    items.append(Wine(_interface))
    items.append(Steam(_interface))
    items.append(VSCode(_interface))
    items.append(Fontmanager(_interface))

    return items

def getItems(_interface) :

    items = list()

    items.append(Chrome(_interface))
    items.append(Firefox(_interface))
    items.append(Chromium(_interface))
    items.append(FFmpeg(_interface))
    items.append(Blueman(_interface))
    items.append(Kdeconnect(_interface))
    items.append(Gyazo(_interface))
    items.append(Wine(_interface))
    items.append(Playonlinux(_interface))
    items.append(Winetricks(_interface))
    items.append(Steam(_interface))
    items.append(VSCode(_interface))
    items.append(Fontmanager(_interface))

    return items

# -----------------------------------------

class Chrome(Item) :
    
    def __init__(self, _interface) :
        super().__init__(_interface)

        self.name = "Google Chrome"
        self.execute_src = self.PATH + "/../scripts/chromeinstall.sh"
        self.restore_src = self.PATH + "/../scripts/chromeuninstall.sh"


    def first_time(self) :

        result =  self.interface.yesnoback("Do you want to install {}?".format(self.name))

        if result is None :
            return None

        elif result :

            chromium = Chromium(self.interface)
            cmresult = chromium.first_time()

            if cmresult is None :
                return None
            elif cmresult :
                Chromium.uninstalled = True
                return (True, ("Installing " + self.name, self.execute), cmresult)
            else :
                return ("Installing " + self.name, self.execute)

        else :
            return False

    def isdefault(self) :

        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "google-chrome-stable"])
        return super().isdefault("google-chrome-stable")


    def show(self) :

        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])


    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return

class Firefox(Item) :
    
    def __init__(self, _interface) :
        super().__init__(_interface)

        self.name = "Firefox"
        self.execute_src = self.PATH + "/../scripts/firefoxinstall.sh"
        self.restore_src = self.PATH + "/../scripts/firefoxuninstall.sh"


    def first_time(self) :

        result =  self.interface.yesnoback("Do you want to install {}?".format(self.name))

        if result is None :
            return None

        elif result :

            if not Chromium.uninstalled :
                chromium = Chromium(self.interface)
                cmresult = chromium.first_time()

            else :
                cmresult = False

            if cmresult is None :
                return None
            elif cmresult :
                return (True, ("Installing " + self.name, self.execute), cmresult)
            else :
                return ("Installing " + self.name, self.execute)

        else :
            return False

    def isdefault(self) :

        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "firefox"])
        return super().isdefault("firefox")


    def show(self) :

        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])

    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return


class Chromium(Item) :
    
    uninstalled = False
    
    def __init__(self, _interface) :
        
        super().__init__(_interface)
        self.name = "Chromium"
        self.execute_src = self.PATH + "/../scripts/chromiumuninstall.sh"
        self.restore_src = self.PATH + "/../scripts/chromiuminstall.sh"


    def first_time(self) : 

        result =  self.interface.yesnoback("Do you want to uninstall {}?".format(self.name)) 

        if result is None :
            return None
        elif result :
            return ("Uninstalling " + self.name, self.execute)
        else :
            return False

    def isdefault(self) :
        
        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "chromium-browser"])
        return not super().isdefault("chromium-browser")

    def show(self) :
       
        if self.isdefault() :
            self.interface.show([self.name, "installed"])
        else :
            self.interface.show([self.name, "not installed"])
    
    def change(self) :

        if self.isdefault() :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return



class FFmpeg(Item) :
    
    def __init__(self, _interface) :
        
        super().__init__(_interface)
        self.name = "FFmpeg"
        self.execute_src = self.PATH + "/../scripts/ffmpeginstall.sh"
        self.restore_src = self.PATH + "/../scripts/ffmpeguninstall.sh"


    def first_time(self) : 

        result =  self.interface.yesnoback("Do you want to install {}?".format(self.name)) 
        if result is None :
            return None
        elif result :
            return ("Installing " + self.name, self.execute)
        else :
            return False

    def isdefault(self) :
        
        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "ffmpeg"])
        return super().isdefault("ffmpeg")

    def show(self) :
       
        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])

    
    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return


class Blueman(Item) :
    
    def __init__(self, _interface) :
        
        super().__init__(_interface)
        self.name = "Blueman"
        self.execute_src = self.PATH + "/../scripts/bluemaninstall.sh"
        self.restore_src = self.PATH + "/../scripts/bluemanuninstall.sh"


    def first_time(self) : 

        result =  self.interface.yesnoback("Do you want to install {}?".format(self.name)) 
        if result is None :
            return None
        elif result :
            return ("Installing " + self.name, self.execute)
        else :
            return False

    def isdefault(self) :
        
        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "blueman"])
        return super().isdefault("blueman")

    def show(self) :
       
        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])

    
    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return

  
class Kdeconnect(Item) :
    
    def __init__(self, _interface) :
        
        super().__init__(_interface)
        self.name = "KDE Connect"
        self.execute_src = self.PATH + "/../scripts/kdeconnectinstall.sh"
        self.restore_src = self.PATH + "/../scripts/kdeconnectuninstall.sh"


    def first_time(self) : 

        result =  self.interface.yesnoback("Do you want to install {}?".format(self.name)) 
        if result is None :
            return None
        elif result :
            return ("Installing " + self.name, self.execute)
        else :
            return False

    def isdefault(self) :
        
        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "kdeconnect"])
        return super().isdefault("kdeconnect")

    def show(self) :
       
        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])

    
    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return


class Gyazo(Item) :
    
    def __init__(self, _interface) :
        
        super().__init__(_interface)
        self.name = "Gyazo"
        self.execute_src = self.PATH + "/../scripts/gyazoinstall.sh"
        self.restore_src = self.PATH + "/../scripts/gyazouninstall.sh"


    def first_time(self) : 

        result =  self.interface.yesnoback("Do you want to install {}?".format(self.name)) 
        if result is None :
            return None
        elif result :
            return ("Installing " + self.name, self.execute)
        else :
            return False

    def isdefault(self) :
        
        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "gyazo"])
        return super().isdefault("gyazo")

    def show(self) :
       
        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])

    
    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return


class Wine(Item) :
    
    def __init__(self, _interface) :
        
        super().__init__(_interface)
        self.name = "Wine 4.0"
        self.execute_src = self.PATH + "/../scripts/wineinstall.sh"
        self.restore_src = self.PATH + "/../scripts/wineuninstall.sh"

    def restore(self) :

        super().restore()

        while True :

            ans = self.interface.yesnoback("Do you want to remove ~/.wine directory?")

            if ans is not None :
                break

        if ans :

            subprocess.call(["rm", "-r", "{}/.wine".format(os.environ["HOME"])])


    def first_time(self) :
        
            result =  self.interface.yesnoback("Do you want to install {}?".format(self.name))

            if result is None :
                return None

            elif result :

                tasks = (Playonlinux(self.interface), Winetricks(self.interface))
                tasks_list = list()
                
                flag = False
                i = 0
                while(i < 2) :

                    res = tasks[i].first_time()

                    if res is None :
                        if i == 0 :
                            return None
                        else :
                            continue

                    elif res == False :
                        pass

                    else :
                        if not flag :
                            tasks_list.append(True)
                            tasks_list.append(("Installing " + self.name, self.execute))
                            flag = True

                        tasks_list.append(res)

                    i = i + 1
                    
                if not flag :
                        return ("Installing " + self.name, self.execute)

                return tasks_list

            else :
                return False

    def isdefault(self) :

        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "winehq-stable"])
        return super().isdefault("winehq-stable")


    def show(self) :

        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])


    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return

class Playonlinux(Item) :
    
    def __init__(self, _interface) :
        
        super().__init__(_interface)
        self.name = "PlayOnLinux"
        self.execute_src = self.PATH + "/../scripts/playonlinuxinstall.sh"
        self.restore_src = self.PATH + "/../scripts/playonlinuxuninstall.sh"


    def first_time(self) : 

        result =  self.interface.yesnoback("Do you want to install {}?".format(self.name)) 
        if result is None :
            return None
        elif result :
            return ("Installing " + self.name, self.execute)
        else :
            return False

    def isdefault(self) :
        
        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "playonlinux"])
        return super().isdefault("playonlinux")

    def show(self) :
       
        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])

    
    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return


class Winetricks(Item) :
    
    def __init__(self, _interface) :
        
        super().__init__(_interface)
        self.name = "Winetricks"
        self.execute_src = self.PATH + "/../scripts/winetricksinstall.sh"
        self.restore_src = self.PATH + "/../scripts/winetricksuninstall.sh"

        self.ans = False

    def execute(self) :

        super().execute()
        subprocess.call(["sudo", "touch", self.PATH + "/../data/winetricks"])

        if self.ans :
        
            subprocess.call(self.PATH + "/../scripts/allfonts.sh")
            
            self.ans = False

    def restore(self) :

        super().restore()
        subprocess.call(["sudo", "rm", "-f", self.PATH + "/../data/winetricks"])

    def first_time(self) : 

        result =  self.interface.yesnoback("Do you want to install {}?".format(self.name)) 

        if result is None :
            return None

        elif result :
            
            while True :

                self.ans = self.interface.yesnoback("Do you want to run 'winetricks allfonts'?")

                if self.ans is not None :
                    break

            return ("Installing " + self.name, self.execute)

        else :
            return False


    def isdefault(self) :
        
        return super().isdefault("winetricks")

    def show(self) :
       
        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])

    
    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return

            elif result :
                
                while True :

                    self.ans = self.interface.yesnoback("Do you want to run 'winetricks allfonts'?")

                    if self.ans is not None :
                        break

                self.execute()

            else :
                return


        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return

class Steam(Item) :
    
    def __init__(self, _interface) :
        
        super().__init__(_interface)
        self.name = "Steam"
        self.execute_src = self.PATH + "/../scripts/steaminstall.sh"
        self.restore_src = self.PATH + "/../scripts/steamuninstall.sh"


    def first_time(self) : 

        result =  self.interface.yesnoback("Do you want to install {}?".format(self.name)) 
        if result is None :
            return None
        elif result :
            return ("Installing " + self.name, self.execute)
        else :
            return False

    def isdefault(self) :
        
        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "steam"])
        return super().isdefault("steam")

    def show(self) :
       
        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])

    
    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return

class VSCode(Item) :
    
    def __init__(self, _interface) :
        
        super().__init__(_interface)
        self.name = "Visual Studio Code"
        self.execute_src = self.PATH + "/../scripts/vscodeinstall.sh"
        self.restore_src = self.PATH + "/../scripts/vscodeuninstall.sh"


    def first_time(self) : 

        result =  self.interface.yesnoback("Do you want to install {}?".format(self.name)) 
        if result is None :
            return None
        elif result :
            return ("Installing " + self.name, self.execute)
        else :
            return False

    def isdefault(self) :
        
        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "code"])
        return super().isdefault("code")

    def show(self) :
       
        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])

    
    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return


class Fontmanager(Item) :
    
    def __init__(self, _interface) :
        
        super().__init__(_interface)
        self.name = "Font Manager"
        self.execute_src = self.PATH + "/../scripts/font-managerinstall.sh"
        self.restore_src = self.PATH + "/../scripts/font-manageruninstall.sh"


    def first_time(self) : 

        result =  self.interface.yesnoback("Do you want to install {}?".format(self.name)) 
        if result is None :
            return None
        elif result :
            return ("Installing " + self.name, self.execute)
        else :
            return False

    def isdefault(self) :
        
        subprocess.call([self.PATH + "/../scripts/isinstalled.sh", "font-manager"])
        return super().isdefault("font-manager")

    def show(self) :
       
        if self.isdefault() :
            self.interface.show([self.name, "not installed"])
        else :
            self.interface.show([self.name, "installed"])

    
    def change(self) :

        if self.isdefault() :
            
            str = ("{} is not installed.\n".format(self.name),
                   "Do you want to install {}?".format(self.name))
            
            result = self.interface.yesnoback(str) 

            if result is None :
                return
            elif result :
                self.execute()
            else :
                return

        else :
            
            str = ("{} is installed.\n".format(self.name),
                   "Do you want to uninstall {}?".format(self.name))
            
            result = self.interface.yesnoback(str)

            if result is None :
                return
            elif result :
                self.restore()
            else :
                return
