#include "StdAfx.h"
#include ".\bufferdsocket.h"
#include <ws2tcpip.h>

#define	BUF_SIZE			32768

CBufferdSocket::CBufferdSocket(void)
{
	m_socket = INVALID_SOCKET;

	//	Cxg
	m_event.Create(TRUE,FALSE);
	m_break.Create(TRUE,FALSE);
	m_exBreakEvent = NULL;

	//	̊m
	m_recvBuf.InitBuf(BUF_SIZE);
	m_sendBuf.InitBuf(BUF_SIZE);
}


CBufferdSocket::~CBufferdSocket(void)
{
	Close();
	m_recvBuf.Close();
	m_sendBuf.Close();
}

//////////////////////////////////////////////////////////////////////////////////
//	Ȃ
//////////////////////////////////////////////////////////////////////////////////
/*!
	gpJn
*/
int CBufferdSocket::AttachSocket(SOCKET sock)
{
	//	I
	Close();

	//	\PbgubLO[h
	if(::WSAEventSelect(sock, m_event, FD_READ | FD_WRITE | FD_CLOSE))
	{
		CloseError(CBS_ERROR_OTHER,"AttachSocket");
		return(-1);
	}

	//	obt@NA
	m_recvBuf.Clear();
	m_sendBuf.Clear();

	//	ϐݒ
	m_socket = sock;
	ClearError();

	//	CxgNA
	::ResetEvent(m_event);
	::ResetEvent(m_break);

	return(0);
}


/*!
	
*/
void CBufferdSocket::Close()
{
	if(m_socket != INVALID_SOCKET)
	{
		//	\Pbgnh֘At
		::WSAEventSelect(m_socket, m_event, 0);

		//	\Pbg
		shutdown(m_socket,1);

		//	\Pbg
		closesocket(m_socket);
	}

	//	֘At
	m_socket = INVALID_SOCKET;

	//	ǂݏo\̂ŁAobt@̓IuWFNg폜܂ŊJȂ
}

//////////////////////////////////////////////////////////////////////////////////
//	fC^[tF[X
//////////////////////////////////////////////////////////////////////////////////
/*!
	f

	Abort̂݁AʃXbhĂяo	
*/
void CBufferdSocket::Abort()
{
	::SetEvent(m_break);
}


/*!
	fCxgݒ
*/
void CBufferdSocket::SetExBreakEvent(HANDLE exBreakEvent)
{
	m_exBreakEvent = exBreakEvent;
}


//////////////////////////////////////////////////////////////////////////////////
//	M(񓯊)
//////////////////////////////////////////////////////////////////////////////////
/*!
	M
*/
int CBufferdSocket::WriteBuf(char *data,int len)
{
	//	G[NA
	ClearError();

	return(m_sendBuf.WriteBuf(data,len));
}


/*!
	M
*/
int CBufferdSocket::ReadBuf(char *data,int len)
{
	//	G[NA
	ClearError();

	return(m_recvBuf.ReadBuf(data,len));
}


/*!
	M(obt@Ȃ)
*/
int CBufferdSocket::PeekBuf(char *data,int len)
{
	//	G[NA
	ClearError();

	return(m_recvBuf.PeekBuf(data,len));
}



/*!
	̃Cxg܂ő҂
	^CAEgԂw肷ƁA^CAEgŃG[ƂȂ

	߂l: 0->I, -1->G[,^CAEg
*/
int CBufferdSocket::WaitNextEvent(int waitTick)
{
	//	G[NA
	ClearError();

	//	\PbǵH
	if(IsDisconnect(FALSE))
	{
		CloseError(CBS_ERROR_CLOSE,"WaitNextEvent");
		return(-1);
	}

	//	Cxg
	HANDLE	wait[3];
	wait[0] = m_event;
	wait[1] = m_break;

	//	OfCxg̐ݒ
	int waitCount = 2;
	if(m_exBreakEvent)
	{
		wait[2] = m_exBreakEvent;
		waitCount ++;
	}

	//	Cxg҂
	switch(::WaitForMultipleObjects(waitCount,wait,FALSE,waitTick))
	{
	case WAIT_OBJECT_0:
		break;

	case WAIT_OBJECT_0 + 1:
	case WAIT_OBJECT_0 + 2:
		CloseError(CBS_ERROR_BREAK,"WaitNextEvent - f");
		return(-1);

	case WAIT_TIMEOUT:
		if(waitTick != 0)
		{
			CloseError(CBS_ERROR_TIMEOUT,"WaitNextEvent - ^CAEg");
			return(-1);
		}
		break;

	default:
		CloseError(CBS_ERROR_OTHER,"WaitNextEvent - WaitForMultipleObjects");
		return(-1);
	}

	//	Cxg
	WSANETWORKEVENTS	events;
	if(WSAEnumNetworkEvents(m_socket,m_event,&events) == SOCKET_ERROR)
	{
		CloseError(CBS_ERROR_OTHER,"WaitNextEvent - WSAEnumNetworkEvents");
		return(-1);	//	G[
	}

	//	FD_CLOSE
	if(events.lNetworkEvents & FD_CLOSE)
	{
		CloseError(CBS_ERROR_CLOSE,"WaitNextEvent - FD_CLOSE");
		return(-1);	//	G[
	}

	//	FD_READ
	if(events.lNetworkEvents & FD_READ)
	{
		switch(events.iErrorCode[FD_READ_BIT])
		{
		case 0:
			break;

		case WSAECONNRESET:
			CloseError(CBS_ERROR_CLOSE,"WaitNextEvent - FD_READ");
			return(-1);

		default:
			CloseError(CBS_ERROR_OTHER,"WaitNextEvent - FD_READ");
			return(-1);	//	G[
		}
	}

	//	FD_WRITE
	if(events.lNetworkEvents & FD_WRITE)
	{
		switch(events.iErrorCode[FD_WRITE_BIT])
		{
		case 0:
			break;

		case WSAECONNRESET:
			CloseError(CBS_ERROR_CLOSE,"WaitNextEvent - FD_WRITE");
			return(-1);

		default:
			CloseError(CBS_ERROR_OTHER,"WaitNextEvent - FD_WRITE");
			return(-1);	//	G[
		}
	}

	return(0);
}

//////////////////////////////////////////////////////////////////////////////////
//	ʐMXe[^X
//////////////////////////////////////////////////////////////////////////////////
/*!
	ؒfĂ邩擾
*/
int CBufferdSocket::IsDisconnect(int tryRecv)
{
	//	Cxg҂Ă݂
	if(tryRecv)
		WaitNextEvent();

	//	fH
	if(::WaitForSingleObject(m_break, 0) == WAIT_OBJECT_0)
		return(1);

	//	ؒfH
	if(m_socket == INVALID_SOCKET)
		return(1);
	return(0);
}

/*!
	obt@TCY擾
*/
int CBufferdSocket::GetSendRecvBufSize()
{
	return(BUF_SIZE);
}

//////////////////////////////////////////////////////////////////////////////////
//	ڑ
//////////////////////////////////////////////////////////////////////////////////
/*!
	sPC̃AhX𓾂
*/
CIPAddress CBufferdSocket::GetLocalhost()
{
	//	_~[̃\Pbg𐶐
	SOCKET sd = WSASocket(AF_INET, SOCK_DGRAM, 0, 0, 0, 0);
	if(sd == SOCKET_ERROR)
		return(0);

	INTERFACE_INFO InterfaceList[20];
	unsigned long nBytesReturned;
	if(WSAIoctl(sd, SIO_GET_INTERFACE_LIST, 0, 0, &InterfaceList,
		sizeof(InterfaceList), &nBytesReturned, 0, 0) == SOCKET_ERROR)
		return(0);

	int nNumInterfaces = nBytesReturned / sizeof(INTERFACE_INFO);
	if(nNumInterfaces <= 0)
		return(0);
	
	sockaddr_in *pAddress;
	pAddress = (sockaddr_in *) & (InterfaceList[0].iiAddress);
	return(pAddress->sin_addr);
}

/*!
	̃AhX擾
*/
CIPAddress CBufferdSocket::GetAddres()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getsockname(m_socket,(SOCKADDR*)&addr,&nSockAddrLen);
	return(addr.sin_addr);
}

/*!
	̃AhX擾
*/
CIPAddress CBufferdSocket::GetPeerAddres()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getpeername(m_socket,(SOCKADDR*)&addr,&nSockAddrLen);
	return(addr.sin_addr);
}

/*!
	̃|[g擾	
*/
int CBufferdSocket::GetPort()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getsockname(m_socket,(SOCKADDR*)&addr,&nSockAddrLen);
	return(ntohs(addr.sin_port));
}

/*!
	̃|[g擾
*/
int CBufferdSocket::GetPeerPort()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getpeername(m_socket,(SOCKADDR*)&addr,&nSockAddrLen);
	return(ntohs(addr.sin_port));
}


//////////////////////////////////////////////////////////////////////////////////
//	ʐM
//////////////////////////////////////////////////////////////////////////////////
/*!
	M

	\return	-1:G[A0:MA>0:cf[^
*/
int CBufferdSocket::BlockingSend(int timeOut)
{
	//	f[^Ȃ烋[v
	while(m_sendBuf.GetInBuf() > 0)
	{
		//	Mpobt@擾
		int		bufLen;
		char	*sendBuf = m_sendBuf.GetReadBuffer(&bufLen);

		//	MĂ݂
		int ret = send(m_socket, sendBuf, bufLen, 0);
		if(ret == SOCKET_ERROR)
		{
			//	G[̏󋵂́H
			switch(WSAGetLastError())
			{
			//	ubNꂽ
			case WSAEWOULDBLOCK:
				break;

			//	ꂽ
			case WSAECONNRESET:
				CloseError(CBS_ERROR_CLOSE,"TrySend");
				return(-1);

			//	G[
			default:
				CloseError(CBS_ERROR_OTHER,"TrySend");
				return(-1);
			}
		}
		else
		{
			//	Mf[^ʂݒ
			m_sendBuf.SetReadedLen(ret);
			return(m_sendBuf.GetInBuf());
		}

		//	Cxg҂
		if(WaitNextEvent(timeOut))
			return(-1);
	}

	return(0);
}


/*!
	M

	\return	-1:G[A0:MȂA>0:Mf[^
*/
int CBufferdSocket::BlockingRecv(int timeOut)
{
	int	firstRecv = 0;

	//	obt@Ȃ烋[v
	while(m_recvBuf.GetFreeBuf() > 0)
	{
		//	Mpobt@擾
		int		bufLen;
		char	*recvBuf = m_recvBuf.GetWriteBuffer(&bufLen);

		//	MĂ݂
		int ret = recv(m_socket, recvBuf, bufLen, 0);
		if(ret == SOCKET_ERROR)
		{
			//	G[̏󋵂́H
			switch(WSAGetLastError())
			{
			//	ubNꂽ
			case WSAEWOULDBLOCK:
				if(firstRecv)
					return(m_recvBuf.GetInBuf());	//	f[^Mς݂ȂI
				break;

			//	ꂽ
			case WSAECONNRESET:
				CloseError(CBS_ERROR_CLOSE,"TryRecv");
				return(-1);

			//	G[
			default:
				CloseError(CBS_ERROR_OTHER,"TryRecv");
				return(-1);
			}
		}
		else if(ret == 0)
		{
			CloseError(CBS_ERROR_CLOSE,"TryRecv");
			return(-1);
		}
		else
		{
			//	Mf[^ʂݒ
			m_recvBuf.SetWritedLen(ret);
			firstRecv = TRUE;
			continue;
		}

		//	Cxg҂
		if(WaitNextEvent(timeOut))
			return(-1);
	}

	return(m_recvBuf.GetInBuf());
}


//////////////////////////////////////////////////////////////////////////////////
//	G[
//////////////////////////////////////////////////////////////////////////////////
/*!
	G[ŕ
*/
void CBufferdSocket::CloseError(int code, CString debugInfo)
{
	TRACE("SocketError : %d [%s] (SocketError : %d)\n", code, debugInfo, WSAGetLastError());
	m_lastError = code;

	//	\Pbg
	if(m_socket != INVALID_SOCKET)
		Close();
}

/*!
	G[𕶎Ŏ擾
*/
CString CBufferdSocket::GetLastErrorString()
{
	return(GetErrorString(GetLastError()));
}

/*!
	G[R[h當擾
*/
CString CBufferdSocket::GetErrorString(int errorCode)
{
	switch(errorCode)
	{
	case CBS_ERROR_TIMEOUT:
		return(_T("^CAEg܂"));

	case CBS_ERROR_CLOSE:
		return(_T("ڑI܂"));

	case CBS_ERROR_BREAK:
		return(_T("f܂"));

	case CBS_ERROR_OTHER:
		return(_T("lbg[NG[ł"));


	case CBS_NO_ERROR:
	default:
		return(_T("sȃG[ł"));
	}
}
