/*!
	T[oc[C^tF[X
*/

#pragma once
#include "InterfaceTemplate.h"
#include "Workspace.h"

//!	C^[tF[X錾
class IServerTool;
class IResponseManager;
class IFilterManager;
class IPathManager;
class IMimeTypeManager;
class ILogManager;
class IServerTextManager;
DEFINE_INTERFACE_NOWRAP(IServerTool);
DEFINE_INTERFACE_NOWRAP(IResponseManager);	//	IServerToolŎgpĂ邽߁AŒ`
DEFINE_INTERFACE_NOWRAP(IFilterManager);	//	IServerToolŎgpĂ邽߁AŒ`
DEFINE_INTERFACE_NOWRAP(IPathManager);		//	IServerToolŎgpĂ邽߁AŒ`
DEFINE_INTERFACE_NOWRAP(IMimeTypeManager);	//	IServerToolŎgpĂ邽߁AŒ`
DEFINE_INTERFACE_NOWRAP(ILogManager);		//	IServerToolŎgpĂ邽߁AŒ`
DEFINE_INTERFACE_NOWRAP(IServerTextManager);//	IServerToolŎgpĂ邽߁AŒ`


//!	T[oXe[^XR[h
enum
{
	SERVER_STATUS_NORMAL		= 10,
	SERVER_STATUS_NORMAL_LOG	= 0,
	SERVER_STATUS_WARNING		= -10,
	SERVER_STATUS_ERROR			= -20,
	SERVER_STATUS_FATAL_ERROR	= -30,
};


/*!
	T[opc[
*/
class IServerTool
{
public:
	//!	fXgN^
	virtual ~IServerTool() {};

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	ݒ
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	}l[W̌ʐݒ擾
	virtual CWorkspaceAccess GetManagerSetting(CString section) = 0;

	//!	tB^̌ʐݒ擾
	virtual CWorkspaceAccess GetFilterSetting(CString section) = 0;

	//!	X|X̌ʐݒ擾
	virtual CWorkspaceAccess GetResponseSetting(CString section) = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	Xe[^XEO
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oȌ
	virtual void WriteSystemLog(CString callerName, int statusCode, CString statusInfo, int autoOffTime = -1) = 0;

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusInt(CString statusName, int status) = 0;

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusStr(CString statusName, CString status) = 0;

	//!	݂̃T[oXe[^X擾
	virtual CWorkspaceAccess GetServerStatus() = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[o[c[VKɎ擾
	virtual IServerToolPtr GetIServerTool() = 0;

	//!	X|X}l[W擾
	virtual IResponseManagerPtr GetIResponseManager() = 0;

	//!	tB^}l[W擾
	virtual IFilterManagerPtr GetIFilterManager() = 0;

	//!	pX}l[W擾
	virtual IPathManagerPtr GetIPathManager() = 0;

	//!	MimeType}l[W擾
	virtual IMimeTypeManagerPtr GetIMimeTypeManager() = 0;

	//!	O}l[W擾
	virtual ILogManagerPtr GetILogManager() = 0;

	//!	T[oeLXg}l[W擾
	virtual IServerTextManagerPtr GetIServerTextManager() = 0;
};




/*!
	T[op
*/
class IServerControl
{
public:
	//!	fXgN^
	virtual ~IServerControl() {};

	//!	T[o̊Jn
	virtual void StartServer() = 0;

	//!	T[o̒~
	virtual void StopServer() = 0;

	//!	݂̃T[oXe[^X擾
	virtual CWorkspaceAccess GetServerStatus() = 0;

	//!	݂̐ڑXe[^X擾
	virtual CWorkspaceAccess GetConnectionInfo() = 0;
};

//!	錾
DEFINE_INTERFACE_NOWRAP(IServerControl);
