#pragma once
#include "responsebase.h"
#include "CGIManager.h"
#include "CGIProcess.h"
#include "SyncObject.h"

class CCGIResponse :
	public CResponseBase
{
public:
	CCGIResponse(CICGIManagerWrap cgiManager);
	virtual ~CCGIResponse(void);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	(OցI)
	virtual void Start(CIConnectionToolWrap responseContext);

	//!	~(OցI)
	virtual void Stop(CIConnectionToolWrap responseContext);

	//!	X|X擾
	virtual LPCTSTR GetResponseName();

	//!	폜
	virtual void Delete() { delete this; };

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_ݒ
	virtual void SetRequest(CIConnectionToolWrap responseContext);

	//!	NGXg{fBݒ(JԂ)
	virtual void SetRequestBody(CIConnectionToolWrap responseContext, CBinaryData &body);

	//!	X|X
	virtual void BuildResponse(CIConnectionToolWrap responseContext);

	//!	X|Xwb_擾
	virtual void GetResponse(CIConnectionToolWrap responseContext);

	//!	X|X{fB擾
	virtual int GetResponseBody(CIConnectionToolWrap responseContext, CBinaryData &body, int blockSize);

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	c[֐
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	CGING[o
	void ThrowCGINoHeaderError();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	CGI}l[W
	CICGIManagerWrap	m_cgiManager;

	//!	CGIvZX
	CCGIProcess		m_cgiProcess;

	//!	ǂݍ݃^CAEg
	int				m_cgiReadTimeout;

	//!	݃^CAEg
	int				m_cgiWriteTimeout;

	//!	CGIwb_pobt@
	CBinaryData		m_cgiHeaderBuffer;
};



/*!
	CGI X|Xt@Ng
*/
class  CCGIResponseFactory :
	public CResponseFactoryBase
{
public:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void Start(CIServerToolWrap serverTool)
	{
		m_cgiManager = serverTool.GetICGIManager();
	};

	//!	폜
	virtual void Delete()
	{
		delete this;
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	̃ACeH
	virtual int IsYourRequest(CContext context);

	//!	X|X擾
	virtual IResponsePtr GetResponse()
	{
		return (new CCGIResponse(m_cgiManager.GetICGIManager()))->GetIResponse();
	};

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	CGI}l[W
	CICGIManagerWrap	m_cgiManager;

};
