#pragma once
#include "InterfaceWrapperMacro.h"

//	\[X
#define	HTML_RESOURCE_SERVER_RESPONSE		"ServerResponse.html"
#define	HTML_RESOURCE_DIRECTORY_LIST		"DirectoryList.html"


/*!
	T[oo͂eLXgǗ
	W̃T[oX|XȂ
*/
class IServerTextManager
{
public:
	virtual ~IServerTextManager(void) {}

	//!	T[oHTML[h
	virtual void LoadServerHtmlFile(IStringPtr html, LPCSTR name) = 0;

	//!	T[oHTML[h(\[X)
	virtual void LoadServerHtmlResource(IStringPtr html, LPCSTR resName) = 0;
};
//!	C^tF[X
typedef IServerTextManager* IServerTextManagerPtr;



/*!
	IServerTextManager̃bp
*/
class CIServerTextManagerWrap
{
public:
	//!	FX錾
	DEFINE_MANAGER_WRAPPER_CONSTRUCTOR(CIServerTextManagerWrap, IServerTextManager, 1);

	//!	T[oHTML[h
	virtual CString LoadServerHtmlFile(CString name)
	{
		CIStringWrap	html;
		m_ifPtr->LoadServerHtmlFile(&html, name);
		return(html);
	}

	//!	T[oHTML[h(\[X)
	virtual CString LoadServerHtmlResource(CString resName)
	{
		CIStringWrap	html;
		m_ifPtr->LoadServerHtmlResource(&html, resName);
		return(html);
	}
};
