/*!
	ݒ
*/
#pragma once
#include "Workspace.h"
#include "WorkspaceListAccess.h"
#include "Context.h"
#include "CGICommand.h"
#include "UserInfo.h"

/*****************************************************************************************************/
//	}l[W
/*****************************************************************************************************/
/*!
	Xbh}l[W̐ݒ
	Manager
*/
class CConnectionThreadManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CConnectionThreadManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("ConnectionThreadManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	őڑ
	DEFINE_PROPERTY_METHOD_INT(MaxConnect,			_U8("MaxConnect"),		100);

	//!	I[o[[h[h
	DEFINE_PROPERTY_METHOD_INT(OverloadModeKeepTime,	_U8("OverloadModeKeepTime"),		10 * 1000);
};


/*!
	O}l[W̐ݒ
	Manager
*/
class CLogManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CLogManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("LogManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	OXV
	DEFINE_PROPERTY_METHOD_INT(UpdateInterval,	_U8("UpdateInterval"),	1000);
};


/*!
	VXeO}l[W̐ݒ
	Manager
*/
class CSystemLogManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CSystemLogManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("SystemLogManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	VXeOpX
	DEFINE_PROPERTY_METHOD_STR(SystemLogFilePath,	_U8("SystemLogFilePath"),	_U8("%ServerRoot%Logs\\SystemLog.txt"));
};


/*!
	Xi}l[W̐ݒ
	Manager
*/
class CListenerManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CListenerManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("ListenerManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	m[}XiL
	DEFINE_PROPERTY_METHOD_INT(EnableNormalListener,	_U8("EnableNormalListener"),	TRUE);

	//!	SSLXiL
	DEFINE_PROPERTY_METHOD_INT(EnableSSLListener,		_U8("EnableSSLListener"),	FALSE);
};

/*!
	IPv4Xi̐ݒ
	Manager

	ʏ̐ڑɊւݒ˂
*/
class CIPv4ListenerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CIPv4ListenerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("IPv4Listener"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	|[gԍ
	DEFINE_PROPERTY_METHOD_STR(Port,			_U8("Port"),				_U8("80"));		//	"80, 8080, 1080"

	//!	|[gI[vG[̃gC
	DEFINE_PROPERTY_METHOD_INT(ListenErrorRetryTime,	_U8("ListenErrorRetryTime"),		10 * 1000);

	//!	ʐM^CAEg
	DEFINE_PROPERTY_METHOD_INT(ConnectionTimeoutTime,	_U8("ConnectionTimeoutTime"),	3 * 60 * 1000);
};

/*!
	SSLXi̐ݒ
	Manager

	SSLڑɊւݒ˂
*/
class CSSLListenerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CSSLListenerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("SSLListener"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	|[gԍ
	DEFINE_PROPERTY_METHOD_STR(Port,					_U8("Port"),						_U8("443"));		//	"80, 8080, 1080"

	//!	|[gI[vG[̃gC
	DEFINE_PROPERTY_METHOD_INT(ListenErrorRetryTime,	_U8("ListenErrorRetryTime"),		10 * 1000);

	//!	ʐM^CAEg
	DEFINE_PROPERTY_METHOD_INT(ConnectionTimeoutTime,	_U8("ConnectionTimeoutTime"),	3 * 60 * 1000);

	//!	閧
	DEFINE_PROPERTY_METHOD_STR(PrivateKey,				_U8("PrivateKey"),				_U8("%ServerRoot%SSLKey\\04WebServer.pem"));

	//!	閧pX[h
	DEFINE_PROPERTY_METHOD_STR(PrivateKeyPassword,		_U8("PrivateKeyPassword"),		_U8("test"));

	//!	T[oؖ
	DEFINE_PROPERTY_METHOD_STR(Certificate,				_U8("Certificate"),				_U8("%ServerRoot%SSLKey\\04WebServer.crt"));

	//!	ԏؖ
	DEFINE_PROPERTY_METHOD_STR(CertificateChain,		_U8("CertificateChain"),			_U8(""));
};


/*!
	ReLXg}l[W̐ݒ
	Manager
*/
class CContextManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CContextManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("ContextManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	O
	DEFINE_PROPERTY_METHOD_INT(MaxContextLogCount,	_U8("MaxContextLogCount"),	100);
};


/*!
	pX}l[W̐ݒ
	Manager
*/
class CPathManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CPathManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("PathManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	pXݒ擾
	CPathInfoList GetPathList() { return GetAccess(_U8("PathList")); };
};


/*!
	Mime^Cv}l[W̐ݒ
	Manager
*/
class CMimeTypeManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CMimeTypeManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("MimeTypeManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	MimeTypẽeLXgɂݒ荀
	DEFINE_PROPERTY_METHOD_STR(MimeTypeText,				_U8("MimeTypeText"),					_U8(""));

	//!	MimeTypeIcoñeLXgɂݒ荀
	DEFINE_PROPERTY_METHOD_STR(MimeTypeIcocText,			_U8("MimeTypeIconText"),					_U8(""));
};


/*!
	ڑRg[̐ݒ
	Manager
*/
class CConnectionControlSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CConnectionControlSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("ConnectionControl"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	MimeTypẽeLXgɂݒ荀
	DEFINE_PROPERTY_METHOD_INT(BlockSize,				_U8("BlockSize"),					65536);

	//!	MimeTypeIcoñeLXgɂݒ荀
	DEFINE_PROPERTY_METHOD_INT(MaxBufferingSize,		_U8("MaxBufferingSize"),				3 * 1024 * 1024);
};


/*!
	T[oeLXg}l[W̐ݒ
	Manager
*/
class CServerTextManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerTextManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("ServerTextManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	HTMLtH_
	DEFINE_PROPERTY_METHOD_STR(ServerHtmlDirectory,				_U8("ServerHtmlDirectory"),					_U8("%ServerRoot%Html\\"));
};


/*!
	T[o}l[W̐ݒ
	Manager
*/
class CServerInfoManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerInfoManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("ServerInfoManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[o
	DEFINE_PROPERTY_METHOD_STR(ServerName,	_U8("ServerName"),	_U8(""));

	//!	T[oo[W
	DEFINE_PROPERTY_METHOD_STR(ServerVersion,	_U8("ServerVersion"),	_U8(""));

	//!	VOj`
	DEFINE_PROPERTY_METHOD_STR(ServerSignature,	_U8("ServerSignature"),	_U8(""));
};



/*!
	[U[}l[W̐ݒ
	Manager
*/
class CUserManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CUserManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("UserManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	L[U[
	CUserInfoList GetEnableUserList() { return GetAccess(_U8("EnableUser")); };

	//!	[U[
	CUserInfoList GetDisableUserList() { return GetAccess(_U8("DisableUser")); };

	//!	O[vXg
	CWorkspaceStringListAccess GetGroupList() { return CWorkspaceStringListAccess(GetAccess(_U8("Group")), _U8("Group")); };
};


/*!
	CGI}l[W̐ݒ
	Manager
*/
class CCGIManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CCGIManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("CGIManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	CGIݒ胊Xg̎擾
	CCGICommandList GetCGICommandList() { return GetAccess(_U8("CGICommand")); };

	//!	CGIf[^݃^CAEgiT[oCGIj
	DEFINE_PROPERTY_METHOD_INT(CGIDataWriteTimeoutTime,	_U8("CGIDataWriteTimeoutTime"),	5 * 1000);

	//!	CGIf[^ǂݍ݃^CAEgiCGIT[oj
	DEFINE_PROPERTY_METHOD_INT(CGIDataReadTimeoutTime,	_U8("CGIDataReadTimeoutTime"),	60 * 1000);
};

/*!
	tB^}l[W̐ݒ
	Manager
*/
class CFilterManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CFilterManagerSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("FilterManager"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ׂĂ̊{tB^𖳌
	DEFINE_PROPERTY_METHOD_INT(DisableAllFilter, _U8("DisableAllFilter"), 0);


	//!	ServerInfotB^𖳌
	DEFINE_PROPERTY_METHOD_INT(DisableServerInfoFilter, _U8("DisableServerInfoFilter"), 0);

	//!	PathtB^𖳌
	DEFINE_PROPERTY_METHOD_INT(DisablePathFilter, _U8("DisablePathFilter"), 0);

	//!	IndextB^𖳌
	DEFINE_PROPERTY_METHOD_INT(DisableIndexFilter, _U8("DisableIndexFilter"), 0);

	//!	KeepAlivetB^𖳌
	DEFINE_PROPERTY_METHOD_INT(DisableKeepAliveFilter, _U8("DisableKeepAliveFilter"), 0);

	//!	AccessLogtB^𖳌
	DEFINE_PROPERTY_METHOD_INT(DisableAccessLogFilter, _U8("DisableAccessLogFilter"), 0);

};




/*****************************************************************************************************/
//	tB^
/*****************************************************************************************************/
/*!
	IndextB^̐ݒ
	Filter
*/
class CIndexFilterSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CIndexFilterSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("IndexFilter"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	^Cv
	DEFINE_PROPERTY_METHOD_INT(MoveMode,				_U8("MoveMode"),					0);

	//!	CfbNXXg
	CWorkspaceStringListAccess GetIndexList() { return CWorkspaceStringListAccess(GetAccess(_U8("IndexFileList")), _U8("IndexFile")); };
};


/*!
	OtB^̐ݒ
	Filter
*/
class CAccessLogFilterSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CAccessLogFilterSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("AccessLogFilter"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ANZXOpX
	DEFINE_PROPERTY_METHOD_STR(AccessLogFilePath,	_U8("AccessLogFilePath"),	_U8("%ServerRoot%Logs\\%Year%%Month%%Day%.txt"));

	//!	ANZXOtH[}bg
	DEFINE_PROPERTY_METHOD_STR(AccessLogFormat,		_U8("AccessLogFormat"),		_U8("[%Time%] <%ClientIP%> (%RecvSize%,%SendSize%) [%Status%] %Method% %Object%"));

	//!	OɏȂpX
	DEFINE_PROPERTY_METHOD_STR(IgnorePath,			_U8("IgnorePath"),			_U8(""));	//	/icons/*, /private/*
};

/*!
	KeepAlivetB^̐ݒ
	Filter
*/
class CKeepAliveFilterSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CKeepAliveFilterSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("KeepAliveFilter"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	KeepAliveL
	DEFINE_PROPERTY_METHOD_INT(EnableKeepAlive,			_U8("EnableKeepAlive"),	1);

	//!	KeepAlive
	DEFINE_PROPERTY_METHOD_INT(MaxKeepConnectionTime,	_U8("MaxKeepConnectionTime"),	20 * 1000);

	//!	KeepAlive
	DEFINE_PROPERTY_METHOD_INT(MaxKeepConnectionCount,	_U8("MaxKeepConnectionCount"),	2);
};



/*****************************************************************************************************/
//	X|X
/*****************************************************************************************************/
/*!
	T[oX|X̐ݒ
	Response
	T[oX|X̓X|XW[ł͂ȂAɓ
*/
class CServerResponseSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerResponseSetting);

	//!	̎擾
	CUTF8String GetSettingName() { return _U8("ServerResponse"); };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
};

