/*!
	CServerStatusManager

	T[oXe[^X}l[W
	eW[̏o͂Xe[^Xۊǂ
*/

#pragma once
#include "ServerStatus.h"
#include "ServerToolWrap.h"
#include "SyncObject.h"
#include "SystemLogManager.h"

class CServerStatusManager
{
public:
	CServerStatusManager(void);
	virtual ~CServerStatusManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

	//!	Oo
	void WriteSystemLog(CString callerName, int logType, CString logString);

	//!	T[oXe[^X̕ύX
	void SetServerStatus(CString statusName, CString status, CString statusInfo, CString statusType);

	//!	T[obZ[Wʒm
	void NotifyServerMessage(CString messageID, CString message, int messageType, int autoOffTimeSec = -1);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Xe[^X擾
	void DuplicateStatus(CWorkspace &status);

	//!	Xe[^X擾
	CServerStatus GetStatus()
	{
		return m_serverStatus;
	}


	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oXe[^X̕ύX
	void SetServerStatusInt(CString statusName, int status, CString statusInfo = "", CString statusType = "Interger")
	{
		//	
		TCHAR	str[80] = _T("");
		_itot_s(status, str, 80, 10);

		//	ݒ
		SetServerStatus(statusName, str, statusInfo, statusType);
	}

	//!	T[oXe[^X̕ύX
	void SetServerStatusStr(CString statusName, CString status, CString statusInfo = "", CString statusType = "String")
	{
		SetServerStatus(statusName, status, statusInfo, statusType);
	}

protected:
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection	m_scopeLock;

	//!	Xe[^Xێ
	CWorkspace			m_statusRoot;

	//!	T[oXe[^X
	CServerStatus		m_serverStatus;

	//!	tO
	CInterlockCounter	m_init;

	//!	VXeO
	CSystemLogManager	m_systemLog;
};
