/*!
	CSettingManager

	ݒ}l[W
	%ServerRoot% ̂݁AIɒus
*/
#include "StdAfx.h"
#include "SettingManager.h"
#include "ServerException.h"
#include "DirTools.h"

//!	̃NX̖O
#define	CLASS_NAME	_U8("SettingManager")

///////////////////////////////////////////////////////////////////////////////////////////////////
//	RXgN^
///////////////////////////////////////////////////////////////////////////////////////////////////
CSettingManager::CSettingManager(void) :
	m_settingRoot(_U8("04WebServer2"))
{
	m_serverSetting = m_settingRoot.GetAccess(_U8("Setting"));
}

CSettingManager::~CSettingManager(void)
{
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CSettingManager::Start(CIServerToolWrap serverTool)
{
	ASSERT(!m_init);
	m_init = TRUE;

	//	ݒ̃[h
	if(m_settingRoot.LoadFromXMLFile(SETTING_FILE))
		throw CServerStartErrorException(CLASS_NAME, _U16("ݒt@C [") + SETTING_FILE + _U16("] ̓ǂݍ݂Ɏs܂B"));

	//	u
	OverwriteSetting(m_serverSetting);

	//	W̎u
	EnableAutoSwapDefault(TRUE);

	//	[hI[
	m_settingRoot.SetReadOnly(TRUE);
}

/*!
	~
*/
void CSettingManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	W̎u~
	EnableAutoSwapDefault(FALSE);

}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	ݒ㏑
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	ݒ㏑(ċA)
*/
void CSettingManager::OverwriteSetting(CWorkspaceAccess overwrite)
{
	OverwriteOneSetting(overwrite);

	//	STum[h擾
	CUTF8StringArray	nodes;
	overwrite.GetAllSubNode(nodes);

	//	ʂ
	for(int i=0;i<nodes.GetCount();i++)
		OverwriteSetting(overwrite.GetAccess(nodes[i]));
}

/*!
	ݒ㏑
*/
void CSettingManager::OverwriteOneSetting(CWorkspaceAccess overwrite)
{
	//	SL[擾
	CUTF8StringArray	keys;
	overwrite.GetAllKey(keys);

	//	ׂď㏑
	for(int i=0;i<keys.GetCount();i++)
	{
		CUTF8String	data = overwrite.GetKeyStr(keys[i], _U8(""));

		//	T[o[g
		data.Replace(_U8("%ServerRoot%"), CPathTools::GetAppPath());

		//	߂
		overwrite.SetKeyStr(keys[i], data);
	}
}


/*!
	ftHgl̎L

	w肳ftHglɒu܂܂Ă̑΍
*/
void CSettingManager::EnableAutoSwapDefault(int enable)
{
	if(enable)
	{
		//	T[o[g
		m_settingSwap.AddSwap(_U8("%ServerRoot%"), CPathTools::GetAppPath());

		//	ݒ(ftHglw肳Ăꍇ̂)
		m_settingRoot.SetAutoSwapDefault(&m_settingSwap);
	}
	else
	{
		//	
		m_settingRoot.SetAutoSwapDefault(NULL);
	}
}

/*!
	ʏ̎擾
*/
CUTF8String CSettingWorkspaceSwap::GetKeyDataSwap(IWorkspace *workspace, const LPCU8STR orgKey, CUTF8String orgData)
{
	CRITICAL_SECTION_SCOPE();

	//	u
	if(orgData.Find(_U8("%")) != -1)
	{
		//	us
		for(int i=0;i<m_keyData.GetCount();i++)
			orgData.Replace(m_keyData[i].GetKey(), m_keyData[i].GetData());
	}

	return(orgData);
}

/*!
	uǉ
*/
void CSettingWorkspaceSwap::AddSwap(CUTF8String key, CUTF8String swap)
{
	CRITICAL_SECTION_SCOPE();

	m_keyData.Add(key, swap);
}
