#include "StdAfx.h"
#include "ProtocolSocket.h"

#define	DEFAULT_TIMEOUT	(3 * 60 * 1000)

CProtocolSocket::CProtocolSocket(void)
{
	SetTimeout(DEFAULT_TIMEOUT);
}

CProtocolSocket::~CProtocolSocket(void)
{
}


//////////////////////////////////////////////////////////////////////////////////
//	o()
//////////////////////////////////////////////////////////////////////////////////
/*!
	M

	SẴf[^𑗐M܂ŃubN
*/
int CProtocolSocket::Send(const char *data, int len)
{
	//	G[NA
	ClearError();

	//	M[v
	while(1)
	{
		//	Mobt@ɓ
		if(len > 0)
		{
			int ret = WriteBuf(data, len);
			data += ret;
			len -= ret;
		}
		else if(GetSendInBuf() == 0)
			return(0);

		//	M
		if(BlockingSend(m_timeoutMS) < 0)
			return(-1);
	}
}

/*!
	Mij

	SẴf[^𑗐M܂ŃubN
*/
int CProtocolSocket::SendString(const CUTF8String str)
{
	return(Send((const char *)str.GetString(), str.GetLength()));
};

/*!
	MiCBinaryDataj
*/
int CProtocolSocket::SendBinary(CBinaryData &data)
{
	return(Send(data.GetPtr(), data.GetSize()));
}


/*!
	M

	f[^M܂ŃubN	
*/
int CProtocolSocket::Recv(char *data, int len)
{
	//	G[NA
	ClearError();

	//	M̕Kv͂邩H
	if(GetRecvInBuf() == 0)
	{
		//	M
		if(BlockingRecv(m_timeoutMS) < 0)
			return(-1);
	}

	//	obt@ǂݏo
	return(ReadBuf(data, len));
}


/*!
	MiCBinaryDataj
*/
int CProtocolSocket::RecvBinary(CBinaryData &data, int maxSize)
{
	data.ReSize(maxSize);

	int ret = Recv(data.GetPtr(), maxSize);
	if(ret < 0)
		data.ReSize(0);
	else
		data.ReSize(ret);

	return(ret);
}

/*!
	M݂
*/
int CProtocolSocket::Peek(char *data, int len)
{
	return PeekBuf(data, len);
}

/*!
	M݂iCBinaryDataj
*/
int CProtocolSocket::PeekBinary(CBinaryData &data, int maxSize)
{
	data.ReSize(maxSize);

	int ret = PeekBuf(data.GetPtr(), maxSize);
	if(ret < 0)
		data.ReSize(0);
	else
		data.ReSize(ret);

	return(ret);
}

//////////////////////////////////////////////////////////////////////////////////
//	vgR
//////////////////////////////////////////////////////////////////////////////////
/*!
	NGXgM҂
	NGXgo܂ŃubN

	\return TRUE->oAFALSE->^CAEg
*/
int CProtocolSocket::WaitNextRequest(int maxWaitTime)
{
	//	G[NA
	ClearError();

	//	Mobt@`FbN
	if(GetRecvInBuf() > 0)
		return(TRUE);

	//	Jn
	DWORD	start = GetTickCount();

	//	M܂Ń[v
	while(1)
	{
		//	Mobt@`FbN
		if(GetRecvInBuf() > 0)
			return(TRUE);

		//	ؒfH
		if(IsDisconnect())
		{
			CloseError(CBS_ERROR_CLOSE, _U16("WaitNextRequest"));
			return(FALSE);
		}

		//	^CAEgH
		DWORD	now = GetTickCount();
		if(now < start || start + maxWaitTime <= now)
			return(FALSE);

		//	M݂
		if(BlockingRecv(start + maxWaitTime - now) < 0)
			return(FALSE);
	}
}

/*!
	wb_M

	wb_M܂ŃubN	
*/
int CProtocolSocket::RecvProtocolHeader(CUTF8String &head, CUTF8String endToken, int maxHeaderSize, int isPeek)
{
	//	`FbN
	ASSERT(!endToken.IsEmpty());

	//	G[NA
	ClearError();

	//	őTCY
	if(maxHeaderSize >= GetSendRecvBufSize())
		maxHeaderSize = GetSendRecvBufSize()-1;

	//	M[v
	CBinaryData	bHead;
	while(1)
	{
		//	M?
		int ret = GetHeaderFromBuf(bHead, endToken, maxHeaderSize, isPeek);
		if(ret < 0)
		{
			//	G[
			return(-1);
		}
		else if(ret > 0)
		{
			//	
			head = bHead.GetString();
			return(0);	//	
		}

		//	M݂
		if(BlockingRecv(m_timeoutMS) < 0)
			return(-1);

		//	wb_ȂɐؒfH
		if(IsDisconnect())
		{
			CloseError(CBS_ERROR_CLOSE, _U16("RecvProtocolHeader"));
			return(-1);
		}
	}
}

/*!
	wb_`FbN
*/
int CProtocolSocket::GetHeaderFromBuf(CBinaryData &head, CUTF8String endToken, int maxHeaderSize, int isPeek)
{
	//	Mf[^擾
	if(PeekBinary(head, maxHeaderSize) < 0)
		return(-1);

	//	wb_TCY`FbN
	if(head.GetSize() > maxHeaderSize)
	{
		CloseError(CPS_ERROR_RECV_HEADER_OVER_SIZE, _U16("RecvProtocolHeader"));
		return(-1);
	}

	//	Ă݂
	int index = head.SerachString(endToken);
	if(index != -1 && index <= maxHeaderSize - endToken.GetLength())
	{
		//	token܂
		index += endToken.GetLength();

		//	PeekMode?
		if(isPeek)
		{
			head.ReSize(index);
		}
		else
		{
			//	ǂݏo
			if(RecvBinary(head, index) < 0)
				return(-1);
		}

		//	ASCII`FbN
		if(CheckAllAscii(head))
			return(-1);
		return(1);	//	
	}

	return(0);	//	
}

/*!
	ׂASCIImF
*/
int CProtocolSocket::CheckAllAscii(CBinaryData &head)
{
	int	size = head.GetSize();
	unsigned char *ptr = (unsigned char *)head.GetPtr();

	//	`FbN
	for(int i=0;i<size;i++)
	{
		if(*ptr == 0 || *ptr >= 0x80)
			return(-1);
		*ptr++;
	}
	return(0);
}

//////////////////////////////////////////////////////////////////////////////////
//	G[
//////////////////////////////////////////////////////////////////////////////////
/*!
	G[R[h當擾
*/
CUTF8String CProtocolSocket::GetErrorString(int errorCode)
{
	switch(errorCode)
	{
	case CPS_ERROR_RECV_HEADER_OVER_SIZE:
		return(_U16("sȃwb_M܂"));

	default:
		return(CBufferdSocket::GetErrorString(errorCode));
	}
}
