#pragma once
#include "Context.h"
#include "../ServerException.h"

/*!
	p[TG[O
*/
class CParseRequestHeaderException : public CServerErrorExceptionBase
{
public:
	CParseRequestHeaderException() {};
	CParseRequestHeaderException(CUTF8String errorInfo)
	{
		SetCaller(_U8(""));
		SetErrorInfo(_U16("%s"), errorInfo);
		TRACE_U8(_U16("CParseRequestHeaderException: %s\n"), errorInfo);
	}
};


/*!
	HTTPwb_p[T
*/
class CHTTPHeaderParser
{
public:
	//!	wb_
	static void ParseRequestHeader(CUTF8String &header, CContextRequestInfo requestInfo);

	//!	wb_
	static CUTF8String GetResponseHeader(CContextResponseInfo responseInfo);

	//!	X|XeNƎ擾
	static CUTF8String GetResponseText(int code, CUTF8String responseText = _U8(""));
};
