#include "StdAfx.h"
#include "threadskeleton.h"
#include "BadAllocException.h"
#include <typeinfo.h>
#include <process.h>


CThreadSkeleton::CThreadSkeleton()
{
	m_hThread = NULL;
	m_dwThreadId = 0;

	//	fpCxg
	m_breakEvent.Create(TRUE,FALSE);
}

CThreadSkeleton::~CThreadSkeleton(void)
{
	//	Xbh~
	EndThread();

	//	XbhIuWFNg폜
	SAFE_CLOSE_HANDLE(m_hThread);	//	Xbhnh͗l
}

////////////////////////////////////////////////////////////////////////////////////////////
//	JnEIEf
////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Xbh̊Jn
*/
int CThreadSkeleton::StartThread()
{
	//	Cxg
	m_breakEvent.ResetEvent();

	//	Xbh
	m_hThread = (HANDLE)(ULONG_PTR)_beginthreadex(NULL, 0, &WorkThread, this, CREATE_SUSPENDED, &m_dwThreadId);
	if(m_hThread == NULL)
	{
		TRACE_U8(_U16("StartThread error :%d\n"), GetLastError());
		return(-1);
	}

	//	Xbh̎sJn
	::ResumeThread(m_hThread);

	return(0);
}


/*!
	Xbh̏IEI
*/
void CThreadSkeleton::EndThread()
{
	//	fw
	Break();

	//	XbhI܂ő҂
	if(IsRunning())
		::WaitForSingleObject(m_hThread, INFINITE);
}


/*!
	f
*/
void CThreadSkeleton::Break()
{
	//	fCxgZbg
	::SetEvent(m_breakEvent);
}


/*!
	s擾
*/
int CThreadSkeleton::IsRunning()
{
	//	NĂȂ
	if(m_hThread == NULL)
		return(0);

	//	snhmF
	return(::WaitForSingleObject(m_hThread, 0) != WAIT_OBJECT_0);
};


////////////////////////////////////////////////////////////////////////////////////////////
//	c[֐
////////////////////////////////////////////////////////////////////////////////////////////
/*!
	̃IuWFNg҂

	\return	-1:G[A0:^CAEgA1ȍ~:nh	
*/
int CThreadSkeleton::WaitForSomeObjects(int timeoutMs, HANDLE obj1, HANDLE obj2, HANDLE obj3, HANDLE obj4)
{
	HANDLE	wait[] = { obj1, obj2, obj3, obj4};
	DWORD 	count;

	//	nhJEg
	for(count=0; count<sizeof(wait)/sizeof(HANDLE); count++)
	{
		if(wait[count] == NULL)
			break;
	}

	//	҂Ă݂
	DWORD ret = ::WaitForMultipleObjects(count,wait,FALSE,timeoutMs);

	//	^CAEg
	if(ret == WAIT_TIMEOUT)
		return(0);

	//	
	if(ret >= WAIT_OBJECT_0 && ret < WAIT_OBJECT_0 + count)
		return(ret - WAIT_OBJECT_0 + 1);

	//	G[
	return(-1);
}


////////////////////////////////////////////////////////////////////////////////////////////
//	Xbh֐
////////////////////////////////////////////////////////////////////////////////////////////
/*!
	pNXThreadMainĂ
*/
void CThreadSkeleton::_ThreadMain()
{
#ifndef _DEBUG
	try
	{
#endif

		ThreadMain();

#ifndef _DEBUG
	}
	catch(BadAllocException &badAlloc)
	{
		FatalError(typeid(this).name(), "sɂAXbh~܂B");
		err->Delete();
	}
#endif

}


/*!
	s֐
*/
UINT APIENTRY WorkThread(void *pParam)
{
//	CoInitialize(NULL);
	CThreadSkeleton	*thread = (CThreadSkeleton*)pParam;

#ifndef _DEBUG
	__try
	{
#endif

		thread->_ThreadMain();

#ifndef _DEBUG
	}
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		FatalError(typeid(thread).name(), "T[o̖OɂAXbh~܂B");
	}
#endif
//	CoUninitialize();

	return(0);
}


/*!
	vIG[
*/
void CThreadSkeleton::FatalError(const char *clsName, const char *errInfo)
{
	//	܂Aۑ𐶐
	char modulePath[MAX_PATH+1];
	DWORD len = GetModuleFileNameA(NULL, modulePath, MAX_PATH);
	while ( modulePath[len--]!='\\' && len!=0 )
		;
	modulePath[len+2] = '\0';        // }[NŏI点
	strcat_s(modulePath, MAX_PATH, "FatalError.log");

	//	Oo
	FILE *errlog;
	if(fopen_s(&errlog, modulePath, "wt") == 0)
	{
		fprintf(errlog, "%s : %s\n", clsName, errInfo);
		fclose(errlog);
	}
}

