#include "StdAfx.h"
#include "Workspace.h"
#include "WorkspaceXMLReader.h"
#include "WorkspaceXMLWriter.h"
#include "WorkspaceNodeWalker.h"
#include "WorkspaceNode.h"
#include "UTF8StringConvert.h"

//	fobO⏕
#ifndef DEBUG_OUT
	#define	DEBUG_OUT	TRACE_U8
#endif

//	W
#define	DEFAULT_CLASS_TYPE	_U8("CWorkspace")

//	[hI[tOmF
#define	WRITE_FUNCTION_CHECK()	if(m_readOnly) { ASSERT(0); return; };


/***********************************************************************************
	RXgN^
***********************************************************************************/
CWorkspace::CWorkspace(CUTF8String className)
{
	if(className.IsEmpty())
		m_className = DEFAULT_CLASS_TYPE;
	else
		m_className = className;

	//	[gݒ
	m_root = new CWorkspaceNode();
	m_root->SetNodeName(m_className);

	//	ǂݍݐpł͂Ȃ
	m_readOnly = 0;
}

CWorkspace::~CWorkspace(void)
{
	m_root->Clear();
	delete m_root;
}


/***********************************************************************************
	ANZX\Ȋ֐
***********************************************************************************/
/*!
	ANZXNX擾
*/
CWorkspaceAccess CWorkspace::GetAccess(CUTF8String path)
{
	return CWorkspaceAccess(this,path);
}


/*!
	ANZXNX擾AgNA
*/
CWorkspaceAccess CWorkspace::GetCleanAccess(CUTF8String path)
{
	CWorkspaceAccess ret = CWorkspaceAccess(this, path);
	ret.Clear();
	return ret;
}


/////////////////////////////////////////////////////////////////////////////////////
//	o͂Ɋւ鏈
/////////////////////////////////////////////////////////////////////////////////////
/*!
	XMLt@C֏o
*/
int CWorkspace::SaveToXMLFile(CUTF8String filePath)
{
	CRITICAL_SECTION_SCOPE();

	//	ۑ
	CWorkspaceXMLWriter	writer;
	return(writer.SaveToFile(m_root, filePath, m_className));
}

/*!
	XMLt@C胍[h
*/
int CWorkspace::LoadFromXMLFile(CUTF8String filePath)
{
	CRITICAL_SECTION_SCOPE();

	try
	{
		//	NA
		m_root->Clear();

		//	ǂݍ
		CWorkspaceXMLReader	reader;
		reader.LoadFromFile(m_root, filePath, m_className);
	}
	catch(CXMLTextParserException err)
	{
		DEBUG_OUT(_U16("XML LoadError : %s\n"), err.GetErrorInfo());
		return(-1);
	}
	return(0);
}



/*!
	XML֏o
*/
CUTF8String CWorkspace::ToXMLString(CUTF8String savePath)
{
	CRITICAL_SECTION_SCOPE();

	//	ۑm[h̎擾
	CWorkspaceNode * node = GetSubNode(savePath);

	//	ۑ
	CWorkspaceXMLWriter	writer;
	return(writer.ToString(node, m_className));
}

/*!
	XML񂩂琶
*/
int CWorkspace::FromXMLString(CUTF8String xml)
{
	CRITICAL_SECTION_SCOPE();


	try
	{
		//	NA
		m_root->Clear();

		//	ǂݍ
		CWorkspaceXMLReader	reader;
		reader.FromString(m_root, xml, m_className);
	}
	catch(CXMLTextParserException err)
	{
		DEBUG_OUT(_U16("XML LoadError : %s\n"), err.GetErrorInfo());
		return(-1);
	}
	return(0);
}


/*!
	ʂCWorkspace𕡐
*/
void CWorkspace::Duplicate(CWorkspace &copyFrom, CUTF8String srcPath, CUTF8String destPath)
{
	CRITICAL_SECTION_SCOPE();
	WRITE_FUNCTION_CHECK();

	copyFrom.Lock();

	//	o͐擾
	CWorkspaceNode * dNode = GetSubNode(destPath);
	CWorkspaceNode * sNode = copyFrom.GetSubNode(srcPath);

	//	OȊORs[
	CUTF8String	name = dNode->GetNodeName();
	*dNode = *sNode;
	dNode->SetNodeName(name);

	copyFrom.Unlock();
}


/***********************************************************************************
	Ȃ
***********************************************************************************/
/*!
	Sf[^NA
*/
void CWorkspace::Clear(LPCU8STR _path)
{
	CRITICAL_SECTION_SCOPE();
	WRITE_FUNCTION_CHECK();

	CUTF8String path = ToNodePath(_path);
	CWorkspaceNode * node = GetSubNode(path);

	node->Clear();
}


/*!
	Rs[

	srcConfigɕʂCWorkspaceNXw肷ƁAʂ̃NXփRs[ł
*/
void CWorkspace::Copy(LPCU8STR _destPath, LPCU8STR _srcPath, IWorkspacePtr srcWorkspace)
{
	CRITICAL_SECTION_SCOPE();
	WRITE_FUNCTION_CHECK();

	CUTF8String destPath = ToNodePath(_destPath);
	CUTF8String srcPath = ToNodePath(_srcPath);

	if(srcWorkspace==NULL || srcWorkspace==this)
	{
		//	Rs[
		CWorkspaceNode * dNode = GetSubNode(destPath);
		InternalCopy(dNode,srcPath);
	}
	else
	{
		//	Ɨpobt@
		CUTF8StringArray	keys, datas;
		CIStringArrayWrap	_keys(keys), _datas(datas);

		//	o͐擾
		CWorkspaceNode * dNode = GetSubNode(destPath);

		//	ۂɃRs[
		srcWorkspace->Lock();
		ExternalCopy(srcWorkspace, srcPath, dNode, _keys, _datas);
		srcWorkspace->Unlock();
	}
}


/*!
	[hI[
*/
void CWorkspace::SetReadOnly(int readOnly)
{
	CRITICAL_SECTION_SCOPE();
	m_readOnly = readOnly;
}



/***********************************************************************************
	KeyɊւ鏈
***********************************************************************************/
/*!
	f[^̐ݒ
*/
void CWorkspace::SetKeyData(LPCU8STR path, LPCU8STR data, int noCase)
{
	CRITICAL_SECTION_SCOPE();
	WRITE_FUNCTION_CHECK();

	CUTF8String key;
	CWorkspaceNode * node = GetSubNode(path, key);

	node->SetKeyData(key, data, noCase);
}


/*!
	f[^̎擾
*/
void CWorkspace::GetKeyData(IStringPtr dest, LPCU8STR path, LPCU8STR defaultData, int noCase)
{
	CRITICAL_SECTION_SCOPE();

	CUTF8String key;
	CWorkspaceNode * node = GetSubNode(path, key);

	if(!m_autoSwap.IsEmpty())
		dest->SetString(m_autoSwap->GetKeyDataSwap(this, key, node->GetKeyData(key, defaultData, noCase)), -1);
	else
	{
		if(!m_autoSwapDefault.IsEmpty())
			dest->SetString(node->GetKeyData(key, m_autoSwapDefault->GetKeyDataSwap(this, key, defaultData), noCase), -1);
		else
			dest->SetString(node->GetKeyData(key, defaultData, noCase), -1);
	}
}



/*!
	f[^̍폜
*/
void CWorkspace::DeleteKey(LPCU8STR path)
{
	CRITICAL_SECTION_SCOPE();
	WRITE_FUNCTION_CHECK();

	CUTF8String key;
	CWorkspaceNode * node = GetSubNode(path,key);

	node->DeleteKey(key);
}


/*!
	L[擾
*/
int CWorkspace::GetKeyCount(LPCU8STR _path)
{
	CRITICAL_SECTION_SCOPE();

	//	pXm[hĂƉ肷
	CUTF8String path = ToNodePath(_path);
	CWorkspaceNode * node = GetSubNode(path);

	return(node->GetKeyCount());
}


/*!
	SẴL[𕶎ƂĎ擾
*/
int CWorkspace::GetAllKeyPair(LPCU8STR _path, IStringArrayPtr keys, IStringArrayPtr datas)
{
	CRITICAL_SECTION_SCOPE();

	//	pXm[hĂƉ肷
	CUTF8String path = ToNodePath(_path);

	//	m[h擾
	CWorkspaceNode * node = GetSubNode(path);

	//	擾
	return(node->GetAllKeyPair(keys, datas));
}


/***********************************************************************************
	Tum[hɊւ鏈
***********************************************************************************/
/*!
	m[h폜
*/
void CWorkspace::DeleteNode(LPCU8STR _path)
{
	CRITICAL_SECTION_SCOPE();
	WRITE_FUNCTION_CHECK();

	//	pXm[hĂƉ肷
	CUTF8String path = ToNodePath(_path);

	//	Ō::폜
	path = path.Mid(0,path.GetLength()-2);


	if(path.IsEmpty())
	{
		//	[g폜H
		m_root->Clear();
	}
	else
	{
		CUTF8String key;
		CWorkspaceNode * node = GetSubNode(path,key);
		node->DeleteNode(key);
	}
}


/*!
	Tum[h𓾂
*/
int CWorkspace::GetSubNodeCount(LPCU8STR _path)
{
	CRITICAL_SECTION_SCOPE();

	//	pXm[hĂƉ肷
	CUTF8String path = ToNodePath(_path);

	CWorkspaceNode * node = GetSubNode(path);

	return(node->GetSubNodeCount());
}


/*!
	SẴTum[h𕶎ƂĎ擾
*/
int CWorkspace::GetAllSubNode(LPCU8STR _path,IStringArrayPtr list)
{
	CRITICAL_SECTION_SCOPE();

	//	pXm[hĂƉ肷
	CUTF8String path = ToNodePath(_path);

	CWorkspaceNode * node = GetSubNode(path);

	return(node->GetAllSubNode(list));

}



/***********************************************************************************
	̑̏
***********************************************************************************/
/*!
 	m[hpXɕύX
 
 	@param path	pX
 	@return		pX
*/
CUTF8String CWorkspace::ToNodePath(CUTF8String path)
{
	if(path.GetLength() >= 2)
	{
		if(path.Right(2) != _U8("::"))
			path += _U8("::");
	}
	else
		path += _U8("::");

	//	"::"͕s
	if(path.Left(2) == _U8("::"))
		return path.Mid(2);
	return path;
}

/*!
	Tum[h̃|C^擾
*/
CWorkspaceNode *CWorkspace::GetSubNode(LPCU8STR path, CUTF8String &key)
{
	CRITICAL_SECTION_SCOPE();

	CWorkspaceNodeWalker	nodeWalker;
	nodeWalker.SetPath(path);

	CWorkspaceNode *node = m_root->GetSubNode(nodeWalker, key);
	ASSERT(node != NULL);

	return(node);
}


/*!
	Rs[
*/
void CWorkspace::InternalCopy(CWorkspaceNode *dest, CUTF8String srcPath)
{
	CWorkspaceNode * sNode = GetSubNode(srcPath);

	//	OȊORs[
	CUTF8String	name = dest->GetNodeName();
	*dest = *sNode;
	dest->SetNodeName(name);
}


/*!
	Rs[
*/
void CWorkspace::ExternalCopy(IWorkspace *src, CUTF8String srcPath, CWorkspaceNode *dNode, CIStringArrayWrap &tempKeys, CIStringArrayWrap &tempDatas)
{
	//
	//	SL[ƃf[^Rs[
	//
	//	NA
	dNode->Clear();

	//	L[yA擾
	src->GetAllKeyPair(srcPath, &tempKeys, &tempDatas);

	//	Ώۃm[hփL[Rs[
	dNode->ClearAndSetKeys(tempKeys.GetStringArray(), tempDatas.GetStringArray());


	//
	//	Tum[hRs[
	//
	CUTF8StringArray		nodes;
	CIStringArrayWrap	_nodes(nodes);

	//	m[hXg擾
	src->GetAllSubNode(srcPath, &_nodes);

	//	Tum[h̃Rs[
	for(int i=0;i<nodes.GetCount();i++)
	{
		//	Tum[hǉ
		CWorkspaceNode *dSubNode = dNode->GetSubNodeByName(nodes[i]);

		//	ċA
		ExternalCopy(src, srcPath + nodes[i] + _U8("::"), dSubNode, tempKeys, tempDatas);
	}
}
