#include "StdAfx.h"
#include "UTF8StringConvert.h"
#include "BinaryData.h"

//	WgTCY
#define	DEFAULT_GROW_SIZE	32768

////////////////////////////////////////////////////////////////////////////////////////
//	
////////////////////////////////////////////////////////////////////////////////////////
/*!
	W
*/
CBinaryData::CBinaryData(int allocSize)
{
	SetCoreInterface(&m_core);
	ReSize(allocSize);
}

/*!
	Rs[
*/
CBinaryData::CBinaryData(CBinaryData &other)
{
	SetCoreInterface(&m_core);
	ReSize(other.GetSize());

	memmove(GetPtr(), other.GetPtr(), other.GetSize());
}

/*!
	C^tF[Xݒ
*/
CBinaryData::CBinaryData(IBinaryDataPtr other)
{
	SetCoreInterface(other);
}

/*!
	fXgN^
*/
CBinaryData::~CBinaryData(void)
{
}


////////////////////////////////////////////////////////////////////////////////////////
//	폜
////////////////////////////////////////////////////////////////////////////////////////
/*!
	폜
*/
int CBinaryData::Remove(int start, int size)
{
	if(start < 0 || size < 0 || start + size > GetSize())
		return(-1);

	memmove(GetPtr() + start,GetPtr() + size, GetSize() - (start + size));
	ReSize(GetSize() - size);
	return(0);
}

////////////////////////////////////////////////////////////////////////////////////////
//	
////////////////////////////////////////////////////////////////////////////////////////
/*!
	㏑(KvȂ΁Aobt@ǉ)
*/
void CBinaryData::OverwriteData(int startOffset, char *data, int len)
{
	if(startOffset + len >= GetSize())
		ReSize(startOffset + len);

	memmove(GetPtr() + startOffset, data, len);
}

/*!
	ǉ
*/
void CBinaryData::Append(char *data,int size)
{
	int	oldSize = GetSize();
	ReSize(size + oldSize);

	memmove(GetPtr() + oldSize, data, size);
}


////////////////////////////////////////////////////////////////////////////////////////
//	ϊ
////////////////////////////////////////////////////////////////////////////////////////
/*!
	CUTF8String
*/
CUTF8String CBinaryData::GetString()
{
	CUTF8String ret;
	ret.SetString((LPCU8STR)GetPtr(), GetSize());

	return(ret);
}


////////////////////////////////////////////////////////////////////////////////////////
//	T[`
////////////////////////////////////////////////////////////////////////////////////////
/*!
	̈̌
*/
int CBinaryData::SerachMemBlock(const char *block, int blockLen)
{
	//	T܂łȂ
	if(blockLen <= 0 || GetSize() == 0 || blockLen > GetSize())
		return(-1);

	//	
	char	*start = GetPtr(), *find = GetPtr();
	int		left = GetSize();
	while(left >= blockLen)
	{
		//	ŏ̕T
		find = (char*)memchr(find, block[0], left - blockLen + 1);
		if(find == NULL)
			return(-1);

		//	rĂ݂
		if(memcmp(find, block, blockLen) == 0)
			return(find - GetPtr());

		//	
		find++;
		left = GetSize() - (find - start);
	}
	return(-1);
}


//////////////////////////////////////////////////////////////////////
// ۑ
//////////////////////////////////////////////////////////////////////
/*!
	t@C֕ۑ

	\param path		pX
*/
int CBinaryData::SaveToFile(CUTF8String path)
{
	FILE	*out;
	if(_wfopen_s(&out, _cnvU16(path), _U16("wb")) != 0)
		return(-1);

	fwrite(GetPtr(), GetSize(), 1, out);
	fclose(out);
	return(0);
}

/*!
	t@Cǂݏo

	\param path		pX
*/
int CBinaryData::LoadFromFile(CUTF8String path)
{
	FILE	*out;
	if(_wfopen_s(&out, _cnvU16(path), _U16("rb")) != 0)
		return(-1);
	
	fseek(out,0,SEEK_END);
	long	len = ftell(out);
	fseek(out,0,SEEK_SET);

	ReSize(len);
	fread(GetPtr(), GetSize(), 1, out);
	fclose(out);
	return(0);
}


////////////////////////////////////////////////////////////////////////////////////////
//	CBinaryDataCore
////////////////////////////////////////////////////////////////////////////////////////
CBinaryData::CBinaryDataCore::CBinaryDataCore()
{
	InitInternal();
}

CBinaryData::CBinaryDataCore::~CBinaryDataCore()
{
	if(m_buffer)
		delete m_buffer;
	InitInternal();
}

/*!
	TCYύX
*/
void CBinaryData::CBinaryDataCore::ReSize(int size)
{
	//	NA
	if(size == 0)
	{
		if(!m_noFreeEmpty)
		{
			if(m_buffer)
				delete m_buffer;
			m_buffer = NULL;
			m_bufferSize = 0;
		}

		m_usingSize = 0;
		return;
	}

	//	m
	if(m_buffer == NULL || size > m_bufferSize)
	{
		int allocSize = (size / m_growSize + 1) * m_growSize;
		char *temp = new char[allocSize];
		int	transSize = m_bufferSize;

		//	]
		if(m_buffer != NULL)
		{
			if(m_bufferSize > size)
				transSize = size;

			memmove(temp, m_buffer, transSize);
			delete m_buffer;
		}

		//	ݒ
		m_buffer = temp;
		m_bufferSize = allocSize;
	}
	m_usingSize = size;
}

/*!
	TCY擾
*/
int CBinaryData::CBinaryDataCore::GetSize()
{
	return m_usingSize;
}

/*!
	ێĂf[^|C^擾
*/
char *CBinaryData::CBinaryDataCore::GetPtr()
{
	return m_buffer;
}

/*!
	
*/
void CBinaryData::CBinaryDataCore::InitInternal()
{
	m_buffer = NULL;
	m_bufferSize = 0;
	m_usingSize = 0;
	m_noFreeEmpty = 0;
	SetGrowSize(DEFAULT_GROW_SIZE);
}
