#pragma once

#include "IFilter.h"
#include "IServerTool.h"
#include "SyncObject.h"

class CFilterArray : public CArray<IFilterIIPtr> {};
class CFilterFactoryArray : public CArray<IFilterFactoryIIPtr> {};

/*!
	tB^[}l[WC^tF[X
*/
class IFilterManager
{
public:
	virtual ~IFilterManager() {};

	//!	C^tF[X擾
	virtual IFilterManagerIIPtr GetIFilterManager() = 0;

	//!	tB^z擾
	virtual void GetFilterArray(CFilterArray &filters) = 0;
};

//!	C^tF[X`
DEFINE_INTERNAL_INTERFACE_NOWRAP(IFilterManager);


/*!
	tB^[}l[W
*/
class CFilterManager : public IFilterManager
{
public:
	CFilterManager(void);
	virtual ~CFilterManager(void);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	EI
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(IServerToolIIPtr serverTool);

	//!	~
	void Stop();

	//!	C^tF[X擾
	virtual IFilterManagerIIPtr GetIFilterManager() { return IFilterManagerRet(this, FALSE); };

	//!	tB^z擾
	virtual void GetFilterArray(CFilterArray &filters);

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tO
	CInterlockCounter	m_init;

	//!	NeBJZNV
	CCriticalSection	m_scopeLock;

	//!	T[oc[
	IServerToolIIPtr		m_serverTool;

	//!	t@Ng
	CFilterFactoryArray	m_filterFactorys;
};

