/*!
	ManagedInterfaceBasicInterfaces.h - {f[^^Cv pC^tF[X

	dlŒ肳ĂC^tF[X
	ɐ錾ĂC^tF[X́AύXȂB
*/
#pragma once

////////////////////////////////////////////////////////////////////////////////////////////////////////
//	f[^󂯓nC^tF[X
////////////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
class IString
{
public:
	//!	ݒ
	virtual void SetString(LPCSTR str) = 0;

	//!	擾
	virtual LPCSTR GetString() = 0;
};
//!	|C^^
typedef IString*	IStringPtr;


/*!
	z
*/
class IStringArray
{
public:
	//!	
	virtual void Clear() = 0;

	//!	TCYݒ
	virtual void SetSize(int size) = 0;

	//!	TCY擾
	virtual int GetSize() = 0;

	//!	ǉ
	virtual void AddString(LPCSTR str) = 0;

	//!	ێĂ镶擾
	virtual LPCSTR GetString(int index) = 0;

	//!	ێĂ镶ݒ
	virtual void SetString(int index, LPCSTR str) = 0;
};
//!	|C^^
typedef IStringArray*	IStringArrayPtr;


/*!
	oCif[^
*/
class IBinaryData
{
public:
	//!	TCYύX
	virtual void ReSize(int size) = 0;

	//!	TCY擾
	virtual int GetSize() = 0;

	//!	ێĂf[^|C^擾
	virtual char *GetPtr() = 0;
};
//!	|C^^
typedef IBinaryData*	IBinaryDataPtr;




////////////////////////////////////////////////////////////////////////////////////////////////////////
//	CWorkspaceAccess 󂯓nC^tF[X
////////////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	[NXy[Xւ̊OANZX
*/
class IWorkspace
{
public:
	/////////////////////////////////////////////////////////////////////////////////////
	//	Ȃ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Sf[^NA
	virtual void Clear(LPCSTR path) = 0;

	//!	Rs[
	virtual void Copy(LPCSTR destPath, LPCSTR srcPath, IWorkspace *srcWorkspace=NULL) = 0;

	/////////////////////////////////////////////////////////////////////////////////////
	//	r
	/////////////////////////////////////////////////////////////////////////////////////
	//!	bN
	virtual void Lock() = 0;

	//!	AbN
	virtual void Unlock() = 0;

	/////////////////////////////////////////////////////////////////////////////////////
	//	KeyɊւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	f[^̐ݒ
	virtual void SetKeyData(LPCSTR path, LPCSTR data, int noCase = FALSE) = 0;

	//!	f[^̎擾
	virtual void GetKeyData(IStringPtr dest, LPCSTR path, LPCSTR defaultData, int noCase = FALSE) = 0;

	//!	L[
	virtual int FindKeyData(LPCSTR path, LPCSTR sData, int noCase = FALSE, int pathCompare = FALSE) = 0;

	//!	f[^̍폜
	virtual void DeleteKey(LPCSTR path) = 0;

	//!	L[擾
	virtual int GetKeyCount(LPCSTR path) = 0;

	//!	SẴL[𕶎ƂĎ擾
	virtual int GetAllKey(LPCSTR path, IStringArrayPtr list) = 0;

	//!	SẴf[^𕶎ƂĎ擾
	virtual int GetAllData(LPCSTR path, IStringArrayPtr list) = 0;

	/////////////////////////////////////////////////////////////////////////////////////
	//	Tum[hɊւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	m[h폜
	virtual void DeleteNode(LPCSTR path) = 0;

	//!	Tum[h𓾂
	virtual int GetSubNodeCount(LPCSTR path) = 0;

	//!	SẴTum[h𕶎ƂĎ擾
	virtual int GetAllSubNode(LPCSTR path, IStringArrayPtr list) = 0;
};
//!	|C^^
typedef IWorkspace*	IWorkspacePtr;


/*!
	CWorkspaceAccess
*/
class IWorkspaceAccess
{
public:
	//!	
	virtual void SetWorkspaceAccess(IWorkspacePtr root, LPCSTR path) = 0;

	//!	C^[tF[X擾
	virtual IWorkspacePtr	GetIWorkspacePtr() = 0;

	//!	pX擾
	virtual LPCSTR			GetAccessPath() = 0;
};
//!	|C^^
typedef IWorkspaceAccess*	IWorkspaceAccessPtr;
