/*!
	ManagedInterfaceImplement.h - Ǘ^C^tF[X NX̃x[XNX
*/
#pragma once
#include "ManagedInterfaceMapper.h"
#include "ManagedInterfaceImplementArgStack.h"
#include "ServerException.h"

/*!
	Ǘ^C^tF[X NX̃x[XNX
*/
class CManagedInterfaceImplement :
	public IManagedInterfaceImplement
{
public:
	virtual ~CManagedInterfaceImplement(void) {}

	///////////////////////////////////////////////////////////////////
	//	C^tF[X
	///////////////////////////////////////////////////////////////////
	//!	֐݊mF
	virtual int FunctionIsExist(CString funcName)
	{
		return(Dispatch(funcName, NULL, TRUE) == 0);
	}

	//!	֐̎s
	virtual int Invoke(CString funcName, IManagedInterfaceArgStackPtr args)
	{
		//	O̒p
		try
		{
			//	s
			return(Dispatch(funcName, args, FALSE));
		}
		catch(CManagedInterfaceException err)
		{
			args->SetException(err.GetExceptionType(), NULL, NULL);
		}
		catch(CConnectionErrorException err)
		{
			args->SetException(MI_EXCEPTION_TYPE_OTHER_EXCEPTION, "CConnectionErrorException", err.m_errorInfo);
		}
		catch(CServerResponseException err)
		{
			args->SetException(MI_EXCEPTION_TYPE_OTHER_EXCEPTION, "CServerResponseException", err.m_status);
		}

		return(-1);
	}

	///////////////////////////////////////////////////////////////////
	//	I[o[Ch
	///////////////////////////////////////////////////////////////////
	//!	
	virtual int Dispatch(CString funcName, CManagedInterfaceImplementArgStack args, int checkFunctionExist) = 0;
	
	///////////////////////////////////////////////////////////////////
	//	⏕
	///////////////////////////////////////////////////////////////////
	//!	擾
	IManagedInterfaceImplementPtr GetIManagedInterfaceImplement() { return this; };
};
