#include "StdAfx.h"
#include "SSLClientConnection.h"
#include "HTTPHeaderParser.h"

#define	MAX_HEADER_SIZE	(16 * 1024)	//	16K
#define	END_HEADER		"\r\n\r\n"

CSSLClientConnection::CSSLClientConnection(SOCKET sock, SSL_CTX *sslContext, int timeout)
{
	m_sslAccepted = 0;
	m_sslContext = sslContext;
	m_socket.AttachSocket(sock);
	m_socket.SetTimeout(timeout);
}

CSSLClientConnection::~CSSLClientConnection(void)
{
	Close();
}




/////////////////////////////////////////////////////////////////////
//	IClientConnection
/////////////////////////////////////////////////////////////////////
/*!
	
*/
void CSSLClientConnection::AttacheToThread(IServerToolIIPtr serverTool, IConnectionThreadStatusIIPtr threadStatus)
{
	m_threadStatus = threadStatus;
	m_socket.SetExBreakEvent(m_threadStatus->GetBreakEvent());
}

/*!
	ؒf
*/
void CSSLClientConnection::Close()
{
	m_socket.Close();
}


/*!
	NCAg̎擾
*/
void CSSLClientConnection::GetClientInfo(CContextClientInfo info)
{
	//	NCAg
	//	zXg͎ݒ肳Ȃ
	info.SetAcceptedPort(m_socket.GetPort());
	info.SetAcceptedAddress(m_socket.GetAddres());
	info.SetClientPort(m_socket.GetPeerPort());
	info.SetClientAddress(m_socket.GetPeerAddres());
}

/*!
	̐ڑ҂

	\return TRUE->oAFALSE->^CAEg
*/
int CSSLClientConnection::WaitNextConnection(int waitTime)
{
	//	SSLJn
	if(!m_sslAccepted)
	{
		if(m_socket.SSLAccept(m_sslContext))
			throw CConnectionErrorException("HTTPwb_̎MɎs܂: " + m_socket.GetLastErrorString());
		m_sslAccepted = TRUE;
	}

	return m_socket.WaitNextRequest(waitTime);
}

/*!
	ڑ擾
*/
int CSSLClientConnection::IsConnecting()
{
	return !m_socket.IsDisconnect();
}


/////////////////////////////////////////////////////////////////////
//	IFilter
/////////////////////////////////////////////////////////////////////
/*!
	wb_M(throw)
*/
void CSSLClientConnection::RecvRequestHeader(CString &requestHeader)
{
	//	SSLJn
	if(!m_sslAccepted)
	{
		if(m_socket.SSLAccept(m_sslContext))
			throw CConnectionErrorException("HTTPwb_̎MɎs܂: " + m_socket.GetLastErrorString());
		m_sslAccepted = TRUE;
	}

	//	wb_M
	if(m_socket.RecvProtocolHeader(requestHeader, END_HEADER, MAX_HEADER_SIZE, FALSE))
		throw CConnectionErrorException("HTTPwb_̎MɎs܂: " + m_socket.GetLastErrorString());
}


/*!
	{fBM(throw)
*/
int CSSLClientConnection::RecvRequestBody(CBinaryData &body, int leftSize)
{
	//	M
	int recved = m_socket.RecvBinary(body, leftSize);
	if(m_socket.GetLastError())
		throw CConnectionErrorException("f[^̎MɎs܂: " + m_socket.GetLastErrorString());

	return(recved);
}


/*!
	wb_𑗐M(throw)
*/
void CSSLClientConnection::SendResponseHeader(CString &responseHeader)
{
	//	X|Xwb_M
	m_socket.SendString(responseHeader);
	if(m_socket.GetLastError())
		throw CConnectionErrorException("HTTPwb_̑MɎs܂: " + m_socket.GetLastErrorString());
}

/*!
	{fB𑗐M(throw)
*/
void CSSLClientConnection::SendResponseBody(CBinaryData &body)
{
	//	M
	m_socket.SendBinary(body);
	if(m_socket.GetLastError())
		throw CConnectionErrorException("f[^̑MɎs܂: " + m_socket.GetLastErrorString());
}


