#include "StdAfx.h"
#include "XMLTextParser.h"
#include "TypedBuffer.h"
#include "TextTools.h"

CXMLTextParser::CXMLTextParser(void)
{
}

CXMLTextParser::~CXMLTextParser(void)
{
}


/////////////////////////////////////////////////////////////////////////////////////
//	Jn
/////////////////////////////////////////////////////////////////////////////////////
/*!
	XL
*/
void CXMLTextParser::StartScan(CString xml)
{
	xml.Trim();
	m_xmlData = xml.GetBuffer(0);
	m_dataLen = xml.GetLength();

	while(m_xmlData.GetLength() > 0)
		GetData(GetStartTag());
}


/*!
	t@C擾
*/
CString CXMLTextParser::LoadXmlFile(CString path)
{
	//	J
	FILE	*in;
	if(_tfopen_s(&in, path, _T("rb")) != 0)
		throw CXMLTextParserException(_T("t@C̃I[vɎs܂"), 0);
	
	//	TCY擾
	fseek(in, 0, SEEK_END);
	long	len = ftell(in);
	fseek(in, 0, SEEK_SET);

	//	obt@p
	CTypedBuffer<char> buf(len + 1);

	//	ǂݍ
	fread(buf, len, 1, in);
	buf[len] = 0;
	fclose(in);

	//	ϊ
	CStringW	ret;
	int wbLen = MultiByteToWideChar(CP_UTF8, 0, buf, len, NULL, 0);
	MultiByteToWideChar(CP_UTF8, 0, buf, len, ret.GetBuffer(wbLen), wbLen);
	ret.ReleaseBufferSetLength(wbLen);

	return(CString(ret));
}


/////////////////////////////////////////////////////////////////////////////////////
//	^O
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn^O؂o
*/
int CXMLTextParser::GetStartTag()
{
	//	^O`FbN
	if(m_xmlData[0] != _T('<'))
		throw CXMLTextParserException(_T("ُȕo܂"), m_dataLen - m_xmlData.GetLength());

	//	CDATA?
	if(m_xmlData.Left(9).CompareNoCase(_T("<![CDATA[")) == 0)
		throw CXMLTextParserException(_T("CDATAZNV͔Ήł"), m_dataLen - m_xmlData.GetLength());

	//	^O؂o
	CString	tag;
	if(GetNextToken(m_xmlData, _T(">"), tag, 1))
		throw CXMLTextParserException(_T("ُȃ^Oo܂"), m_dataLen - m_xmlData.GetLength());
	tag.Trim();

	//	^O
	if(tag[0] == _T('?') || tag[0] == _T('!'))
	{
		OnSpecialTag(tag);
		return(0);
	}

	//	ُȃ^O
	if(!_istalpha(tag[0]) && tag[0] != _T('/'))
		throw CXMLTextParserException(_T("ُȃ^Oo܂"), m_dataLen - m_xmlData.GetLength());

	//	^Cvo
	if(tag[0] == _T('/'))
	{
		tag.Delete(0, 1);
		OnEndTag(tag);

		return(0);
	}
	else if(tag.Right(1) == _T("/"))
	{
		tag.Delete(tag.GetLength() - 1, 1);

		//	
		CTagOptionArray	keys;
		ParseTagOption(tag, keys);

		//	Cxg
		OnStartTag(tag, keys);
		OnEndTag(tag);

		return(0);
	}
	else
	{
		//	
		CTagOptionArray	keys;
		ParseTagOption(tag, keys);

		//	Cxg
		OnStartTag(tag, keys);

		return(1);
	}
}


/*!
	f[^؂o
*/
void CXMLTextParser::GetData(int enableEvent)
{
	//	I/
	if(m_xmlData.IsEmpty() || m_xmlData[0] == _T('<'))
		return;

	//	f[^
	CString	data;
	if(GetNextToken(m_xmlData, _T("<"), data, 0, FALSE))
		throw CXMLTextParserException(_T("ُȃf[^o܂"), m_dataLen - m_xmlData.GetLength());

	//	Cxg
	if(enableEvent)
	{
		//	ϊ
		CTextEscape	escape;
		escape.AddEscape(_T("<"), _T("&lt;"));
		escape.AddEscape(_T(">"), _T("&gt;"));
		escape.AddEscape(_T("&"), _T("&amp;"));
		data = escape.UnEscape(data);

		//	Cxg
		OnData(data);
	}
}


/*!
	^OIvV̉
*/
void CXMLTextParser::ParseTagOption(CString &tag, CTagOptionArray &keys)
{
	//	^O؂o
	CString	tagName;
	tag.Replace(_T("\t"), _T(" "));
	if(!GetNextToken(tag, _T(" "), tagName))
	{
		while(1)
		{
			//	L[
			CString	key, data;
			if(GetNextToken(tag, _T("="), key))
				break;
			key.Trim();

			//	f[^
			if(GetNextToken(tag, _T("\""), data))
				throw CXMLTextParserException(_T("ُȃ^Oo܂"), m_dataLen - m_xmlData.GetLength());
			if(GetNextToken(tag, _T("\""), data))
				throw CXMLTextParserException(_T("ُȃ^Oo܂"), m_dataLen - m_xmlData.GetLength());

			//	ǉ
			keys.Add(CTagOption(key, data));
		}
	}

	tag = tagName;
}


/////////////////////////////////////////////////////////////////////////////////////
//	c[
/////////////////////////////////////////////////////////////////////////////////////
/*!
	w肵܂ł؂o
	w肵͐؂oɊ܂܂Ȃ

	w肵Ȃꍇ́A-1߂
*/
int CXMLTextParser::GetNextToken(CString &src, CString find, CString &token, int tokenStart, int removeToken)
{
	//	
	int tokenEnd = src.Find(find, tokenStart);
	if(tokenEnd == -1)
		return(-1);

	//	؂o
	token = src.Mid(tokenStart, tokenEnd - tokenStart);

	//	폜
	if(removeToken)
		src.Delete(0, tokenEnd + find.GetLength());
	else
		src.Delete(0, tokenEnd);

	return(0);
}
