/*!
	CConnectionThread

	PڑXbh̎
	ڑI܂Ő邽߁AKeepAliveɂ蕡̃NGXg\
*/

#pragma once
#include "threadskeleton.h"
#include "IServerTool.h"
#include "IClientConnection.h"
#include "IConnectionThreadStatus.h"
#include "CnotextManager.h"
#include "ConnectionControl.h"
#include "IResponse.h"
#include "FilterControl.h"
#include "ResponseControl.h"

class CConnectionThread;

/*!
	Xbh}l[W̌JC^tF[X
	[JXbhp
*/
class IConnectionThreadParent
{
public:
	virtual ~IConnectionThreadParent(void)
	{
	}

	//!	XbhI
	virtual void EndConnection(CConnectionThread *connectionPtr) = 0;

	//!	I[o[[h
	virtual int InOverloadMode() = 0;
};

//!	C^[tF[X`
DEFINE_INTERFACE_NOWRAP(IConnectionThreadParent);

/*!
	[JXbh
*/
class CConnectionThread :
	public CThreadSkeleton, protected IConnectionThreadStatus
{
public:
	CConnectionThread(void);
	virtual ~CConnectionThread(void);

	/////////////////////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	int Start(	IServerToolPtr				serverTool,
				IConnectionThreadParentPtr	threadManager,
				IConetextGenePtr			contexGene,
				IClientConnectionPtr		connection,
				LONG						connectionID);

	//!	~
	void Stop();

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	Xbh֐
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Xbh
	void ThreadMain();

	//!	NGXg
	int OneRequest();

	//!	wb_M
	void RecvRequestHeader(CConnectionControl &connectionControl, CContext &context, CFilterControl &filters);

	//!	{fBM
	void RecvRequestBody(CConnectionControl &connectionControl, CContext &context, CFilterControl &filters, CResponseControl &response);

	//!	wb_M
	void SendResponseHeader(CConnectionControl &connectionControl, CContext &context, CFilterControl &filters, CResponseControl &response);

	//!	{fBM
	void SendResponseBody(CConnectionControl &connectionControl, CContext &context, CFilterControl &filters, CResponseControl &response);

	//!	T[oX|X̑M
	void SendServerResponse(CConnectionControl &connectionControl, CContext &context, CFilterControl &filter, CServerResponseException &serverResponseException);

	//!	ʐMԂ̍XV
	void UpdateTransInfo(CConnectionControl &connectionControl, CContext &context);

	/////////////////////////////////////////////////////////////////////////////////////
	//	IConnectionThreadStatus
	/////////////////////////////////////////////////////////////////////////////////////
	//!	擾
	IConnectionThreadStatusPtr GetIConnectionThreadStatus() { return IConnectionThreadStatusRet(this, FALSE); };

	//!	fCxg擾
	virtual HANDLE GetBreakEvent() { return CThreadSkeleton::GetBreakEvent(); };

	//!	f?
	virtual int GetBreak() { return CThreadSkeleton::GetBreak(); };

	//!	̃tB^ݒ肷
	virtual void SetCurrentModuleFunction(LPCTSTR moduleName, int functionID)
	{
		m_currentModuleName = moduleName;
		m_currentFunctionID = functionID;
	};

	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	T[oc[
	IServerToolPtr				m_serverTool;

	//!	Xbh}l[W
	IConnectionThreadParentPtr	m_threadManager;

	//!	ReLXg
	IConetextGenePtr			m_contexGene;

	//!	ڑ
	IClientConnectionPtr		m_connection;

	//!	ڑID
	LONG						m_connectionID;

	//!	W[
	LPCTSTR						m_currentModuleName;

	//!	֐
	int							m_currentFunctionID;
};

//!	|C^^
typedef CSimplePtr<CConnectionThread>	CConnectionThreadPtr;


