#pragma once
#include "IServerTool.h"
#include "IClientConnection.h"
#include "BinaryData.h"

class IConnectionControl;

//!	C^[tF[X`
DEFINE_INTERFACE_NOWRAP(IConnectionControl);

enum BUFFRING_MODE
{
	/*!
		X|X{fB̃TCYm肵Ăꍇ
		EX|Xf[^̃TCYIɃ`FbN
		EKeepAlive\
	*/
	BUFFRING_MODE_NONE		= 0,

	/*!
		X|X{fB̃TCYm肵ĂȂꍇ
		ẼTCY܂ŁAobt@O
		ETCYzꍇ́AXg[~O[hֈڍs
		EKeepAlive\
	*/
	BUFFRING_MODE_BUFFURING	= 10,

	/*!
		X|X{fB̃TCYm肵ĂȂꍇ
		Eobt@OꂸAContent-Lengthݒ肳Ȃ
		EKeepAlives
	*/
	BUFFRING_MODE_STREAMING	= 20,
};

/*!
	ʐMp
*/
class IConnectionControl
{
public:
	virtual ~IConnectionControl() {};

	//////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	virtual IConnectionControlPtr GetIConnectionControl() = 0;

	//////////////////////////////////////////////////////////////////////////////
	//	ʐM
	//////////////////////////////////////////////////////////////////////////////
	//!	ڑ擾
	virtual int IsConnecting() = 0;

	//!	ʐMubNTCY擾
	virtual int GetBlockSize() = 0;

	//!	ш敝Lɂ
	virtual void EnableBandWidthLimit(int sendLimit = -1, int recvLimit = -1) = 0;

	//!	Mς݃TCY擾
	virtual __int64 GetSendedSize() = 0;

	//!	Mς݃TCY擾
	virtual __int64 GetReceivedSize() = 0;

	//////////////////////////////////////////////////////////////////////////////
	//	obt@O
	//////////////////////////////////////////////////////////////////////////////
	//!	obt@O[hֈڍs
	virtual int ChangeBufferingMode(int mode) = 0;

	//!	݂̃[h擾
	virtual int GetCurrentMode() = 0;

	//!	őobt@OTCY擾
	virtual int GetMaxBufferingSize() = 0;

	//////////////////////////////////////////////////////////////////////////////
	//	KeepAlive
	//////////////////////////////////////////////////////////////////////////////
	//!	KeepAlive𖳌
	virtual void DisableReuseConnection() = 0;

	//!	KeepAliveԂZbg(DisableReuseConnectionD悳)
	virtual void SetReuseConnection(int reuse) = 0;

	//!	KeepAlive͌ݗLH
	virtual int CanReuseConnection() = 0;

	//!	őKeepAliveԂw
	virtual void SetWaitNextRequestTime(int time) = 0;

	//!	őKeepAliveԂ擾
	virtual int GetWaitNextRequestTime() = 0;
};

